/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.scene.controller;

import com.jxdinfo.crm.core.scene.dto.CrmSceneDto;
import com.jxdinfo.crm.core.scene.service.CrmSceneService;
import com.jxdinfo.crm.core.scene.vo.CrmSceneVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u573a\u666f\u7ba1\u7406"})
@RequestMapping(value={"/scene"})
public class CrmSceneController {
    @Resource
    private CrmSceneService crmSceneService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u573a\u666f", notes="\u65b0\u589e\u573a\u666f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addScene(@RequestBody @ApiParam(value="\u573a\u666f\u5b9e\u4f53") CrmSceneDto dto) {
        Long sceneId = this.crmSceneService.saveScene(dto);
        if (sceneId > 0L) {
            return ApiResponse.success((Object)sceneId);
        }
        return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u573a\u666f", notes="\u4fee\u6539\u573a\u666f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateScene(@RequestBody @ApiParam(value="\u573a\u666f\u5b9e\u4f53") CrmSceneDto dto) {
        Boolean isSuccess = this.crmSceneService.updateScene(dto);
        if (isSuccess.booleanValue()) {
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u573a\u666f", notes="\u5220\u9664\u573a\u666f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> delete(@RequestBody @ApiParam(value="\u573a\u666f\u5b9e\u4f53") CrmSceneDto dto) {
        boolean isSuccess = this.crmSceneService.removeSceneById(dto);
        if (isSuccess) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @GetMapping(value={"/info"})
    @ApiOperation(value="\u67e5\u8be2\u573a\u666f", notes="\u67e5\u8be2\u573a\u666f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CrmSceneVo> getSceneInfo(@RequestParam(value="sceneId") @ApiParam(value="\u573a\u666fid") String sceneId) {
        CrmSceneVo crmSceneVo;
        try {
            crmSceneVo = this.crmSceneService.selectById(Long.parseLong(sceneId));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success((Object)crmSceneVo);
    }

    @GetMapping(value={"/listByModule"})
    @ApiOperation(value="\u67e5\u8be2\u573a\u666f\u5217\u8868", notes="\u67e5\u8be2\u573a\u666f\u5217\u8868")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CrmSceneVo>> getSceneList(@RequestParam(value="module") @ApiParam(value="\u6a21\u7248id") String module) {
        List<CrmSceneVo> crmSceneVoList = this.crmSceneService.getSceneList(module);
        return ApiResponse.success(crmSceneVoList);
    }

    @PostMapping(value={"/updateDefault"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u573a\u666f", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u573a\u666f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> updateDefault(@RequestBody @ApiParam(value="\u573a\u666f\u5b9e\u4f53") CrmSceneDto dto) {
        return ApiResponse.success((Object)this.crmSceneService.updateDefault(dto));
    }

    @PostMapping(value={"/updateOrder"})
    @ApiOperation(value="\u4fee\u6539\u573a\u666f\u6392\u5e8f", notes="\u4fee\u6539\u573a\u666f\u6392\u5e8f")
    @AuditLog(moduleName="\u573a\u666f\u7ba1\u7406", eventDesc="\u573a\u666f\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> updateOrder(@RequestBody @ApiParam(value="\u573a\u666f\u5217\u8868") List<CrmSceneDto> dtoList) {
        return ApiResponse.success((Object)this.crmSceneService.updateOrder(dtoList));
    }
}

