/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.report.service.Impl;

import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.contact.service.IContactDataRightModuleService;
import com.jxdinfo.crm.core.api.customer.service.ICustomerDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.provincerole.dao.ProvinceRoleMapper;
import com.jxdinfo.crm.core.report.dao.ReportMapper;
import com.jxdinfo.crm.core.report.dto.ReportDto;
import com.jxdinfo.crm.core.report.service.ReportService;
import com.jxdinfo.crm.core.report.vo.AddCountVo;
import com.jxdinfo.crm.core.report.vo.CustomerStageVo;
import com.jxdinfo.crm.core.report.vo.SaleRecordVo;
import com.jxdinfo.crm.core.vehicleapplication.dao.VehicleApplicationMapper;
import com.jxdinfo.crm.core.vehicleapplication.model.User;
import com.jxdinfo.crm.core.vehicleapplication.service.VehicleApplicationService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    @Resource
    private ReportMapper reportMapper;
    @Resource
    private ProvinceRoleMapper provinceRoleMapper;
    @Resource
    private VehicleApplicationMapper vehicleApplicationMapper;
    @Resource
    private VehicleApplicationService vehicleApplicationService;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private ICustomerDataRightModuleService customerDataRightModuleService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IContactDataRightModuleService contactDataRightModuleService;

    @Override
    public ApiResponse<String> reportStatistics(ReportDto reportDto) {
        StringBuffer content = new StringBuffer("");
        User user = this.vehicleApplicationMapper.selectUserByChar1(reportDto.getUserId());
        SecurityUser securityUser = this.userBoService.selectSecurityByUserId(user.getUserId());
        SalesStatisticsDto dto = new SalesStatisticsDto();
        if ("0".equals(reportDto.getType())) {
            dto.setCurrentUserId(securityUser.getUserId());
            dto.setPermissionUserId(securityUser.getUserId());
            PermissionDto salePermissionDto = new PermissionDto();
            salePermissionDto.setCurrentUserId(user.getUserId());
            salePermissionDto.setPermissionUserId(user.getUserId());
            dto.setStartTime(reportDto.getStartTime());
            dto.setEndTime(reportDto.getEndTime());
            AddCountVo addCountWeekVo = this.reportMapper.saleReportWeek(dto, salePermissionDto, salePermissionDto, salePermissionDto);
            List<SaleRecordVo> opportunityTrack = this.reportMapper.opportunityTrack(dto);
            List<SaleRecordVo> customerTrack = this.reportMapper.customerTrack(dto);
            int opportunitySize = opportunityTrack.size();
            int customerSize = customerTrack.size();
            dto.setTimeRange("4");
            IndexUtil.getCurrentTimeRange(dto);
            AddCountVo addCountYearVo = this.reportMapper.saleReportYear(dto);
            List<CustomerStageVo> opportunityStageList = this.reportMapper.opportunityStageReport(dto);
            content.append("1\u3001\u9500\u552e\u7b80\u62a5\n");
            this.getStatisticContent(content, addCountWeekVo, addCountYearVo, opportunityStageList, opportunitySize, customerSize);
            this.getTrackContent(content, opportunityTrack, customerTrack);
        } else if ("1".equals(reportDto.getType())) {
            PermissionDto customerPermissionDto = this.customerDataRightModuleService.getUserRolePermission(securityUser);
            PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(securityUser);
            PermissionDto contactPermissionDto = this.contactDataRightModuleService.getUserRolePermission(securityUser);
            dto.setStartTime(reportDto.getStartTime());
            dto.setEndTime(reportDto.getEndTime());
            AddCountVo addCountWeekVo = this.reportMapper.saleReportWeek(dto, opportunityPermissionDto, customerPermissionDto, contactPermissionDto);
            dto.setPermissionDeptIds(opportunityPermissionDto.getPermissionDeptIds());
            List<SaleRecordVo> opportunityTrack = this.reportMapper.opportunityTrack(dto);
            dto.setPermissionDeptIds(customerPermissionDto.getPermissionDeptIds());
            List<SaleRecordVo> customerTrack = this.reportMapper.customerTrack(dto);
            int opportunitySize = opportunityTrack.size();
            int customerSize = customerTrack.size();
            dto.setTimeRange("4");
            IndexUtil.getCurrentTimeRange(dto);
            AddCountVo addCountYearVo = this.reportMapper.saleReportYear(dto);
            List<CustomerStageVo> opportunityStageList = this.reportMapper.opportunityStageReport(dto);
            content.append("1\u3001\u7701\u533a\u603b\u89c8\n");
            this.getStatisticContent(content, addCountWeekVo, addCountYearVo, opportunityStageList, opportunitySize, customerSize);
            content.append("\n2\u3001\u9500\u552e\u7b80\u62a5\n");
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(user.getUserId());
            dto.setStartTime(reportDto.getStartTime());
            dto.setEndTime(reportDto.getEndTime());
            List<SaleRecordVo> opportunityTrack2 = this.reportMapper.opportunityTrack(dto);
            List<SaleRecordVo> customerTrack2 = this.reportMapper.customerTrack(dto);
            int opportunitySize2 = opportunityTrack2.size();
            int customerSize2 = customerTrack2.size();
            PermissionDto salePermissionDto = new PermissionDto();
            salePermissionDto.setCurrentUserId(user.getUserId());
            salePermissionDto.setPermissionUserId(user.getUserId());
            AddCountVo addCountWeekVo2 = this.reportMapper.saleReportWeek(dto, salePermissionDto, salePermissionDto, salePermissionDto);
            dto.setTimeRange("4");
            IndexUtil.getCurrentTimeRange(dto);
            AddCountVo addCountYearVo2 = this.reportMapper.saleReportYear(dto);
            List<CustomerStageVo> opportunityStageList2 = this.reportMapper.opportunityStageReport(dto);
            this.getStatisticContent(content, addCountWeekVo2, addCountYearVo2, opportunityStageList2, opportunitySize2, customerSize2);
            this.getTrackContent(content, opportunityTrack2, customerTrack2);
        }
        return ApiResponse.success((Object)content.toString(), (String)"\u8bf7\u6c42\u6210\u529f");
    }

    private void getStatisticContent(StringBuffer content, AddCountVo addCountWeekVo, AddCountVo addCountYearVo, List<CustomerStageVo> opportunityStageList, int opportunitySize, int customerSize) {
        content.append("    1\uff09\u5546\u673a\u7ebf\u7d22\u7b80\u62a5\n").append("    \u672c\u671f\u65b0\u589e").append(addCountWeekVo.getAddOpportunity()).append("\u4e2a\u5546\u673a\u7ebf\u7d22\uff0c\u8d62\u5355").append(addCountWeekVo.getWinOpportunity()).append("\u4e2a\uff0c\u8ddf\u8fdb").append(opportunitySize).append("\u6b21\u3002\n");
        int totalOpportunity = opportunityStageList.stream().collect(Collectors.summingInt(CustomerStageVo::getSumOpportunity));
        int totalAmount = opportunityStageList.stream().collect(Collectors.summingInt(CustomerStageVo::getSumAmount));
        content.append("    \u672c\u5e74\u5ea6\u7d2f\u8ba1\u65b0\u589e\u603b\u6570").append(totalOpportunity).append("\u4e2a\uff0c\u7d2f\u8ba1\u91d1\u989d").append(totalAmount).append("\u4e07\u3002\n");
        for (CustomerStageVo list : opportunityStageList) {
            content.append("    \u3010").append(list.getCustomerStageName()).append("\u3011").append(list.getSumOpportunity()).append("\u4e2a\uff0c\u8ba1").append(list.getSumAmount()).append("\u4e07;\n");
        }
        content.append("    2\uff09\u5ba2\u6237\u53ca\u8054\u7cfb\u4eba\u7b80\u62a5\n").append("    \u672c\u671f\u65b0\u589e").append(addCountWeekVo.getAddCustomer()).append("\u4e2a\u5ba2\u6237\uff0c").append(addCountWeekVo.getAddContact()).append("\u4e2a\u8054\u7cfb\u4eba\uff0c\u8ddf\u8fdb").append(customerSize).append("\u6b21\u3002\n    \u672c\u5e74\u5ea6\u7d2f\u8ba1\u65b0\u589e\u5ba2\u6237\u6570").append(addCountYearVo.getTotalCustomer()).append("\u4e2a\uff0c\u8054\u7cfb\u4eba\u6570").append(addCountYearVo.getTotalContact()).append("\u4e2a\u3002\n");
    }

    private void getTrackContent(StringBuffer content, List<SaleRecordVo> opportunityTrack, List<SaleRecordVo> customerTrack) {
        content.append("    3\uff09\u672c\u671f\u8ddf\u8fdb\u60c5\u51b5\n");
        if (opportunityTrack.size() == 0 && customerTrack.size() == 0) {
            content.append("    \u6682\u65e0\u8ddf\u8fdb\n");
        } else {
            int j;
            int i = 0;
            if (opportunityTrack.size() > 0) {
                Map<Long, List<SaleRecordVo>> opportunityMap = opportunityTrack.stream().collect(Collectors.groupingBy(SaleRecordVo::getTypeId));
                for (Map.Entry<Long, List<SaleRecordVo>> key : opportunityMap.entrySet()) {
                    content.append("    \uff08").append(++i).append("\uff09").append(key.getValue().get(0).getTypeName()).append("\u3010").append(key.getValue().get(0).getStageName()).append("\u3011\uff0c").append("\u91d1\u989d").append(key.getValue().get(0).getOpportunityAmount()).append("\u4e07").append("\uff0c\u8ddf\u8fdb").append(key.getValue().size()).append("\u6b21\uff1a\n");
                    for (j = 0; j < key.getValue().size(); ++j) {
                        content.append("    ").append(key.getValue().get(j).getCreateTime()).append(key.getValue().get(j).getRecordType()).append("\uff1a").append(key.getValue().get(j).getRecordContent()).append("\n");
                        if (!StringUtil.isNotEmpty((Object)key.getValue().get(j).getNextTime())) continue;
                        content.append("    \u4e0b\u6b21\u8054\u7cfb\u65f6\u95f4\uff1a").append(key.getValue().get(j).getNextTime()).append("\u3002\n");
                    }
                }
            }
            if (customerTrack.size() > 0) {
                Map<Long, List<SaleRecordVo>> customerMap = customerTrack.stream().collect(Collectors.groupingBy(SaleRecordVo::getTypeId));
                for (Map.Entry<Long, List<SaleRecordVo>> key : customerMap.entrySet()) {
                    content.append("    \uff08").append(++i).append("\uff09").append(key.getValue().get(0).getTypeName()).append("\uff0c\u8ddf\u8fdb").append(key.getValue().size()).append("\u6b21\uff1a\n");
                    for (j = 0; j < key.getValue().size(); ++j) {
                        content.append("    ").append(key.getValue().get(j).getCreateTime()).append(key.getValue().get(j).getRecordType()).append("\uff1a").append(key.getValue().get(j).getRecordContent()).append("\n");
                        if (!StringUtil.isNotEmpty((Object)key.getValue().get(j).getNextTime())) continue;
                        content.append("\u4e0b\u6b21\u8054\u7cfb\u65f6\u95f4\uff1a").append(key.getValue().get(j).getNextTime()).append("\u3002\n");
                    }
                }
            }
        }
    }
}

