/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunityproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.dao.OpportunityProductMapper;
import com.jxdinfo.crm.core.opportunityproduct.dto.OpportunityProductDto;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunityproduct.vo.OpportunityProductVo;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.product.model.OpptyProductProfileEntity;
import com.jxdinfo.crm.product.service.IOpptyProductProfileService;
import com.jxdinfo.crm.product.service.IProductTargetProfileService;
import com.jxdinfo.crm.product.vo.OpptyTargetProfileVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityProductServiceImpl
extends ServiceImpl<OpportunityProductMapper, OpportunityProduct>
implements OpportunityProductService {
    @Resource
    private OpportunityProductMapper opportunityProductMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private ProductService productService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IProductTargetProfileService productTargetProfileService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IOpptyProductProfileService opptyProductProfileService;

    @Override
    public Page<OpportunityProduct> selectCrmOpportunityProductList(OpportunityProductDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<OpportunityProduct> list = this.opportunityProductMapper.selectCrmOpportunityProductList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public Boolean saveOpportunityProduct(List<OpportunityProduct> opportunityProductList, Boolean isPush, boolean delOriginalProduct) {
        if (CollectionUtil.isEmpty(opportunityProductList)) {
            return true;
        }
        ArrayList<Long> opportunityProductId = new ArrayList<Long>();
        for (OpportunityProduct op : opportunityProductList) {
            if (!HussarUtils.isNotEmpty((Object)op.getId())) continue;
            opportunityProductId.add(op.getId());
        }
        this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)opportunityProductList.get(0).getOpportunityId()));
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<OpportunityProduct> saveList = new ArrayList<OpportunityProduct>();
        ArrayList<OpportunityProduct> updateList = new ArrayList<OpportunityProduct>();
        List oldProductList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityProductList.get(0).getOpportunityId())).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        List productIds = oldProductList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
        List specIdList = oldProductList.stream().map(OpportunityProduct::getSpecificationId).collect(Collectors.toList());
        int repeatCount = 0;
        for (int i = 0; i < opportunityProductList.size(); ++i) {
            if (opportunityProductList.get(i).getId() == null && (!productIds.contains(opportunityProductList.get(i).getProductId()) || opportunityProductList.get(i).getSpecificationId() != null && !specIdList.contains(opportunityProductList.get(i).getSpecificationId()))) {
                opportunityProductList.get(i).setDelFlag("0");
                opportunityProductList.get(i).setCreateTime(date);
                opportunityProductList.get(i).setCreatePerson(user.getUserId());
                opportunityProductList.get(i).setCreatePersonName(user.getUserName());
                opportunityProductList.get(i).setChangeTime(date);
                opportunityProductList.get(i).setChangePerson(user.getUserId());
                opportunityProductList.get(i).setChangePersonName(user.getUserName());
                opportunityProductList.get(i).setOrderNumber(null);
                saveList.add(opportunityProductList.get(i));
                continue;
            }
            if (productIds.contains(opportunityProductList.get(i).getProductId()) && opportunityProductList.get(i).getId() != null) {
                opportunityProductList.get(i).setChangeTime(date);
                opportunityProductList.get(i).setChangePerson(user.getUserId());
                opportunityProductList.get(i).setChangePersonName(user.getUserName());
                opportunityProductList.get(i).setDelFlag("0");
                opportunityProductList.get(i).setOrderNumber(null);
                updateList.add(opportunityProductList.get(i));
                continue;
            }
            if (opportunityProductList.get(i).getId() != null || !productIds.contains(opportunityProductList.get(i).getProductId()) || opportunityProductList.get(i).getSpecificationId() != null && !specIdList.contains(opportunityProductList.get(i).getSpecificationId())) continue;
            ++repeatCount;
        }
        if (repeatCount != 0) {
            throw new BaseException("\u65b0\u589e\u4ea7\u54c1\u5df2\u5b58\u5728\u6216\u90e8\u5206\u5b58\u5728");
        }
        ArrayList<Object> delProductList = new ArrayList<Object>();
        if (delOriginalProduct) {
            List newId = opportunityProductList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
            for (Object old : oldProductList) {
                if (newId.contains(((OpportunityProduct)old).getProductId())) continue;
                delProductList.add(old);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityProductList.get(0).getOpportunityId())).set(OpportunityProduct::getDelFlag, (Object)"1"));
        }
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(opportunityProductList.get(0).getOpportunityId());
        if (ToolUtil.isNotEmpty(delProductList)) {
            StringBuilder delProductName = new StringBuilder();
            for (OpportunityProduct opportunityProduct : delProductList) {
                if (delProductName.length() > 0) {
                    delProductName.append("\u3001").append(opportunityProduct.getProductName());
                    continue;
                }
                delProductName.append(opportunityProduct.getProductName());
            }
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setRecordContent(delProductName.toString());
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_DELETE.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), opportunity.getCustomerId()));
        }
        if (ToolUtil.isNotEmpty(saveList)) {
            this.saveBatch(saveList);
            if (isPush.booleanValue()) {
                List<Long> saveProductIds = saveList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
                List<Map<String, Object>> productManagers = this.opportunityMapper.opportunityProductAndManagerList(opportunity.getOpportunityId(), "0", saveProductIds);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (CollectionUtil.isNotEmpty(productManagers)) {
                    try {
                        for (int i = 0; i < productManagers.size(); ++i) {
                            if (arrayList.contains(String.valueOf(productManagers.get(i).get("managerId")))) continue;
                            arrayList.add(String.valueOf(productManagers.get(i).get("managerId")));
                            String title = "\u3010" + productManagers.get(i).get("shortName") + "\u3011\u5546\u673a\u63d0\u9192";
                            String content = user.getDeptName() + "-" + user.getUserName() + "\u5c06\u4ea7\u54c1\u3010" + productManagers.get(i).get("shortName") + "\u3011\u5173\u8054\u5230\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011";
                            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunityProductList.get(0).getOpportunityId()), Arrays.asList(String.valueOf(productManagers.get(i).get("managerId"))));
                            AddSysMessageType addSysMessageType = new AddSysMessageType();
                            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunityProductList.get(0).getOpportunityId() + "\"";
                            String contentUnify = "\u3010\u4ea7\u54c1\u52a8\u6001\u3011" + user.getDeptName() + "-" + user.getUserName() + " \u5728\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u4e2d\uff0c\u5173\u8054\u4e86\u60a8\u7ba1\u7406\u7684\u4ea7\u54c1\u3010" + productManagers.get(i).get("shortName") + "\u3011";
                            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.valueOf(productManagers.get(i).get("managerId")), user.getUserName(), unifyWebUrl, "");
                            UnifyUtil.sendMessage(addSysMessageType);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            OperateRecordAPIVo addProductRecord = new OperateRecordAPIVo();
            addProductRecord.setDelflag("0");
            addProductRecord.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_ADD.getId());
            ArrayList recordMapList = new ArrayList();
            for (OpportunityProduct opportunityProduct : saveList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("productName", opportunityProduct.getProductName());
                if (HussarUtils.isNotEmpty((Object)opportunityProduct.getSellPrice()) && Double.parseDouble(opportunityProduct.getSellPrice()) > 0.0) {
                    map.put("price", opportunityProduct.getSellPrice());
                } else {
                    map.put("price", "0.00");
                }
                recordMapList.add(map);
            }
            addProductRecord.setRecordContent(JsonUtil.toJson(recordMapList));
            this.operateRecordAPIService.saveOperateLog(addProductRecord, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), opportunity.getCustomerId()));
        }
        if (ToolUtil.isNotEmpty(updateList)) {
            ArrayList updateMapList = new ArrayList();
            OperateRecordAPIVo updateOperateRecord = new OperateRecordAPIVo();
            updateOperateRecord.setDelflag("0");
            updateOperateRecord.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_PRODUCT_EDIT.getId());
            block8: for (OpportunityProduct op : updateList) {
                for (OpportunityProduct oldOp : oldProductList) {
                    String newPrice;
                    if (!op.getId().equals(oldOp.getId())) continue;
                    String oldPrice = ToolUtil.isEmpty((Object)oldOp.getSellPrice()) ? "0.00" : oldOp.getSellPrice();
                    if (Objects.equals(oldPrice, newPrice = ToolUtil.isEmpty((Object)op.getSellPrice()) ? "0.00" : op.getSellPrice())) continue block8;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("productName", op.getProductName());
                    map.put("oldPrice", oldPrice);
                    map.put("newPrice", newPrice);
                    updateMapList.add(map);
                    continue block8;
                }
            }
            if (CollectionUtil.isNotEmpty(updateMapList)) {
                updateOperateRecord.setRecordContent(JsonUtil.toJson(updateMapList));
                this.operateRecordAPIService.saveOperateLog(updateOperateRecord, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), opportunity.getCustomerId()));
            }
            this.saveOrUpdateBatch(updateList);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean saveOpportunityProductBatch(List<OpportunityProduct> opportunityProductList, Boolean isPush) {
        if (CollectionUtil.isEmpty(opportunityProductList)) {
            return true;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        List opportunityIds = opportunityProductList.stream().map(OpportunityProduct::getOpportunityId).collect(Collectors.toList());
        HashSet set = new HashSet(opportunityIds);
        opportunityIds = new ArrayList(set);
        List opportunityEntities = this.opportunityService.listByIds(opportunityIds);
        for (OpportunityEntity opportunityEntity : opportunityEntities) {
            opportunityEntity.setChangeTime(date);
            opportunityEntity.setChangePerson(user.getUserId());
            opportunityEntity.setChangePersonName(user.getUserName());
        }
        this.opportunityService.updateBatchById(opportunityEntities);
        ArrayList<OpportunityProduct> saveList = new ArrayList<OpportunityProduct>();
        ArrayList<OpportunityProduct> updateList = new ArrayList<OpportunityProduct>();
        List oldProductList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityProduct::getOpportunityId, opportunityIds)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        int repeatCount = 0;
        for (int i = 0; i < opportunityProductList.size(); ++i) {
            int finalI = i;
            List oldProducts = oldProductList.stream().filter(product -> product.getOpportunityId().equals(((OpportunityProduct)opportunityProductList.get(finalI)).getOpportunityId())).collect(Collectors.toList());
            List productIds = oldProducts.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
            List specIdList = oldProducts.stream().map(OpportunityProduct::getSpecificationId).collect(Collectors.toList());
            if (opportunityProductList.get(i).getId() == null && (!productIds.contains(opportunityProductList.get(i).getProductId()) || opportunityProductList.get(i).getSpecificationId() != null && !specIdList.contains(opportunityProductList.get(i).getSpecificationId()))) {
                opportunityProductList.get(i).setDelFlag("0");
                opportunityProductList.get(i).setCreateTime(date);
                opportunityProductList.get(i).setCreatePerson(user.getUserId());
                opportunityProductList.get(i).setCreatePersonName(user.getUserName());
                opportunityProductList.get(i).setChangeTime(date);
                opportunityProductList.get(i).setChangePerson(user.getUserId());
                opportunityProductList.get(i).setChangePersonName(user.getUserName());
                opportunityProductList.get(i).setOrderNumber(null);
                saveList.add(opportunityProductList.get(i));
                continue;
            }
            if (productIds.contains(opportunityProductList.get(i).getProductId()) && opportunityProductList.get(i).getId() != null) {
                opportunityProductList.get(i).setChangeTime(date);
                opportunityProductList.get(i).setChangePerson(user.getUserId());
                opportunityProductList.get(i).setChangePersonName(user.getUserName());
                opportunityProductList.get(i).setOrderNumber(null);
                updateList.add(opportunityProductList.get(i));
                continue;
            }
            if (opportunityProductList.get(i).getId() != null || !productIds.contains(opportunityProductList.get(i).getProductId()) || opportunityProductList.get(i).getSpecificationId() != null && !specIdList.contains(opportunityProductList.get(i).getSpecificationId())) continue;
            ++repeatCount;
        }
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        if (ToolUtil.isNotEmpty(saveList)) {
            this.saveBatch(saveList);
            List opportunityEntityList = this.opportunityService.listByIds(opportunityIds);
            for (int i = 0; i < saveList.size(); ++i) {
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                ArrayList recordMapList = new ArrayList();
                for (OpportunityProduct opportunityProduct : saveList) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("productName", opportunityProduct.getProductName());
                    if (HussarUtils.isNotEmpty((Object)opportunityProduct.getSellPrice()) && Double.parseDouble(opportunityProduct.getSellPrice()) > 0.0) {
                        map.put("price", opportunityProduct.getSellPrice());
                    } else {
                        map.put("price", "0.00");
                    }
                    recordMapList.add(map);
                }
                operateRecordDO.setRecordContent(JsonUtil.toJson(recordMapList));
                operateRecordDO.setDelflag("0");
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_ADD.getId());
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
                operateRecordDO.setTypeId(((OpportunityProduct)saveList.get(i)).getOpportunityId());
                operateRecordDO.setBusinessName(((OpportunityProduct)saveList.get(i)).getOpportunityName());
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
            }
            this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
        }
        if (ToolUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean deleteOpportunityProduct(OpportunityProductDto dto) {
        this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)dto.getOpportunityId()));
        LocalDateTime date = LocalDateTime.now();
        List<String> ids = dto.getIds();
        double amount = 0.0;
        dto.setDelFlag("0");
        List<OpportunityProduct> list = this.opportunityProductMapper.selectCrmOpportunityProductList(null, dto);
        Long opportunityId = list.get(0).getOpportunityId();
        OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityMapper.selectById(opportunityId);
        long count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getProductId, (Object)list.get(0).getProductId())).eq(OpportunityProduct::getDelFlag, (Object)"0")).eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).notIn(OpportunityProduct::getId, ids));
        if (count == 0L) {
            this.opptyProductProfileService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpptyProductProfileEntity::getOpportunityId, (Object)opportunityId)).eq(OpptyProductProfileEntity::getProductId, (Object)list.get(0).getProductId()));
        }
        this.opportunityProductMapper.deleteOpportunityProduct(ids, "1");
        if (ToolUtil.isNotEmpty(list)) {
            StringBuilder delProductName = new StringBuilder();
            for (OpportunityProduct opportunityProduct : list) {
                if (delProductName.length() > 0) {
                    delProductName.append("\u3001").append(opportunityProduct.getProductName());
                    continue;
                }
                delProductName.append(opportunityProduct.getProductName());
            }
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setRecordContent(delProductName.toString());
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_DELETE.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityEntity.getOpportunityId(), opportunityEntity.getOpportunityName(), date, false, Arrays.asList(opportunityEntity.getOpportunityId(), opportunityEntity.getCustomerId()));
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> getOpportunityProductList(Long opportunityId) {
        if (opportunityId == null) {
            throw new BaseException("\u5546\u673aid\u4e3a\u7a7a");
        }
        OpportunityProductDto dto = new OpportunityProductDto();
        dto.setOpportunityId(opportunityId);
        dto.setDelFlag("0");
        List<OpportunityProduct> list = this.opportunityProductMapper.selectCrmOpportunityProductList(null, dto);
        List voList = new ArrayList();
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>();
        if (CollectionUtil.isNotEmpty(list)) {
            voList = BeanUtil.copy(list, OpportunityProductVo.class);
            List profileVoList = this.productTargetProfileService.selectOpptyProfileById(opportunityId, null);
            for (OpportunityProductVo op : voList) {
                boolean allNull;
                HashMap<String, Object> map = new HashMap<String, Object>();
                ArrayList<OpptyTargetProfileVo> opptyTargetProfileVoList = new ArrayList<OpptyTargetProfileVo>();
                if ("1".equals(op.getTargetProfileSwitch())) {
                    for (OpptyTargetProfileVo vo : profileVoList) {
                        if (!Objects.equals(op.getProductId(), vo.getProductId())) continue;
                        opptyTargetProfileVoList.add(vo);
                    }
                }
                double matchingPercent = 0.0;
                if (CollectionUtil.isNotEmpty(opptyTargetProfileVoList)) {
                    List industryList = this.sysDicRefService.getDictByType("industry");
                    List attributeList = this.sysDicRefService.getDictByType("customer_type");
                    for (OpptyTargetProfileVo vo : opptyTargetProfileVoList) {
                        ArrayList<String> dictLabels;
                        String[] valueList;
                        if ("1".equals(vo.getProfileType())) {
                            valueList = vo.getProfileValue().split(",");
                            vo.setDictLabel(vo.getProfileValue());
                            dictLabels = new ArrayList<String>();
                            block3: for (String value : valueList) {
                                for (DicSingle dicSingle : industryList) {
                                    if (!dicSingle.getValue().equals(value)) continue;
                                    dictLabels.add(dicSingle.getLabel());
                                    continue block3;
                                }
                            }
                            if (!dictLabels.isEmpty()) {
                                vo.setDictLabel(StringUtils.join(dictLabels, (String)","));
                            }
                        } else if ("2".equals(vo.getProfileType())) {
                            valueList = vo.getProfileValue().split(",");
                            vo.setDictLabel(vo.getProfileValue());
                            dictLabels = new ArrayList();
                            block5: for (String value : valueList) {
                                for (DicSingle dicSingle : attributeList) {
                                    if (!dicSingle.getValue().equals(value)) continue;
                                    dictLabels.add(dicSingle.getLabel());
                                    continue block5;
                                }
                            }
                            if (!dictLabels.isEmpty()) {
                                vo.setDictLabel(StringUtils.join(dictLabels, (String)","));
                            }
                        }
                        if (!"1".equals(vo.getIsMatched())) continue;
                        matchingPercent += 1.0;
                    }
                    double percent = matchingPercent / (double)opptyTargetProfileVoList.size() * 100.0;
                    BigDecimal bd = new BigDecimal(percent).setScale(0, RoundingMode.HALF_UP);
                    op.setMatchingPercent(bd.toString() + "%");
                }
                if (allNull = opptyTargetProfileVoList.stream().map(OpptyTargetProfileVo::getIsMatched).noneMatch(Objects::nonNull)) {
                    op.setMatchingPercent("--");
                }
                map.put("opportunityProduct", op);
                map.put("oppTargetProfile", opptyTargetProfileVoList);
                resultMapList.add(map);
            }
        }
        return resultMapList;
    }

    @Override
    public List<Long> selectDuplicateId(List<Long> totalOpportunityIdList, List<Long> mergeOpportunityIdList) {
        return this.opportunityProductMapper.selectDuplicateId(totalOpportunityIdList, mergeOpportunityIdList);
    }
}

