/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunitystage1.model.CrmOpportunityStage1;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunitystage1.service.CrmOpportunityStage1Service;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageRulesMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityStageCheckDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStageRules;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityStageServiceImpl
extends ServiceImpl<OpportunityStageMapper, OpportunityStage>
implements OpportunityStageService {
    @Resource
    private OpportunityStageRulesMapper opportunityStageRulesMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    CrmOpportunityStage1Service crmOpportunityStage1Service;

    @Override
    public ApiResponse<List<Map<String, Object>>> applyRules(OpportunityStageCheckDto dto) {
        String res;
        String text = dto.getText();
        String tagList = dto.getTagList();
        Long nowStage = dto.getStage();
        List stages = new ArrayList();
        ArrayList wordTemp = new ArrayList();
        List<OpportunityStageRules> rules = this.opportunityStageRulesMapper.selectOpportunityStageRulesList(dto);
        for (OpportunityStageRules rule : rules) {
            if (rule.getRuleType() == 10 && rule.getTargetStage() > nowStage) {
                String[] ruleList;
                for (String string : ruleList = rule.getRule().split("\u3001")) {
                    HashMap<String, Object> stage = new HashMap<String, Object>();
                    stage.put("word", string);
                    stage.put("stage", rule.getTargetStage());
                    stage.put("hit", true);
                    stage.put("stageName", rule.getCustomerStageName());
                    wordTemp.add(stage);
                }
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)tagList) || !tagList.contains(rule.getRule()) || rule.getTargetStage() <= nowStage) continue;
            HashMap<String, Object> stage = new HashMap<String, Object>();
            stage.put("hit", true);
            stage.put("tag", rule.getRule());
            stage.put("stage", rule.getTargetStage());
            stage.put("stageName", rule.getCustomerStageName());
            stages.add(stage);
        }
        String requestAiApi = this.requestAiApi(text);
        if (HussarUtils.isNotEmpty((Object)requestAiApi)) {
            String output = requestAiApi.substring(3, requestAiApi.length() - 2);
            List result = Arrays.stream(output.split("\\]\\s*,\\s*\\[")).map(s -> Arrays.stream(s.split(",")).map(e -> {
                if (e.matches("-?\\d+(\\.\\d+)?")) {
                    return Double.valueOf(Double.parseDouble(e));
                }
                return e.replaceAll("^\"|\"$", "");
            }).collect(Collectors.toList())).collect(Collectors.toList());
            for (int i = 0; i < result.size() && (Double)((List)result.get(i)).get(1) > 0.8; ++i) {
                HashMap<String, Boolean> stage = null;
                for (Map map2 : wordTemp) {
                    if (!((List)result.get(i)).get(0).equals(map2.get("word"))) continue;
                    stage = new HashMap<String, Boolean>();
                    stage.put("hit", true);
                    stage.put("word", (Boolean)((List)result.get(i)).get(0));
                    stage.put("stage", (Boolean)map2.get("stage"));
                    stage.put("stageName", (Boolean)map2.get("stageName"));
                    break;
                }
                if (!HussarUtils.isNotEmpty(stage)) continue;
                stages.add(stage);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(res = this.requestAiApi2(text))) && res.contains("\u8d62\u5355")) {
            List stage1List = this.crmOpportunityStage1Service.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmOpportunityStage1::getStageProcessId, (Object)dto.getStageProcessId())).eq(CrmOpportunityStage1::getDelFlag, (Object)"0"));
            int startIndex = res.indexOf("\"") + 1;
            int endIndex = res.indexOf("\",");
            String result1 = res.substring(startIndex, endIndex);
            startIndex = endIndex + 2;
            endIndex = res.indexOf("]");
            double d = Double.parseDouble(res.substring(startIndex, endIndex));
            boolean flag = true;
            if (d > 0.15) {
                for (CrmOpportunityStage1 stage1 : stage1List) {
                    if (!stage1.getCustomerStageName().equals(result1)) continue;
                    for (int i = 0; i < stages.size(); ++i) {
                        if (((Map)stages.get(i)).get("stage") != stage1.getCustomerStageId()) continue;
                        flag = false;
                    }
                    if (!flag || stage1.getCustomerStageId() <= dto.getStage()) break;
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("stage", stage1.getCustomerStageId());
                    map2.put("word", result1);
                    map2.put("hit", true);
                    map2.put("stageName", stage1.getCustomerStageName());
                    stages.add(map2);
                    break;
                }
            }
        }
        if (HussarUtils.isEmpty((Object)res) && HussarUtils.isEmpty((Object)requestAiApi)) {
            for (int i = 0; i < wordTemp.size(); ++i) {
                if (!text.contains((String)((Map)wordTemp.get(i)).get("word"))) continue;
                stages.add(wordTemp.get(i));
            }
        }
        if (CollectionUtil.isNotEmpty(stages)) {
            stages = stages.stream().collect(Collectors.collectingAndThen(Collectors.toMap(map -> map.get("stage").toString(), map -> map, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
        }
        return ApiResponse.success(stages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestAiApi(String text) {
        String res = null;
        if (this.crmProperties.getAi().isAiEnable()) {
            String url = this.crmProperties.getAi().getRequestAiApiUrl();
            JSONObject payload = new JSONObject();
            payload.put("text", (Object)text);
            HttpURLConnection connection = null;
            StringBuilder response = new StringBuilder();
            try {
                connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                var8_9 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                res = response.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestAiApi2(String text) {
        String res = null;
        if (this.crmProperties.getAi().isAiEnable()) {
            String url = this.crmProperties.getAi().getRequestAiApi2Url();
            JSONObject payload = new JSONObject();
            payload.put("text", (Object)text);
            HttpURLConnection connection = null;
            StringBuilder response = new StringBuilder();
            try {
                connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                var8_9 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                res = response.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return res;
    }
}

