/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageGuideMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStageGuide;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageGuideService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityGuideVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityStageGuideServiceImpl
extends ServiceImpl<OpportunityStageGuideMapper, OpportunityStageGuide>
implements OpportunityStageGuideService {
    @Resource
    private OpportunityStageGuideMapper opportunityStageGuideMapper;

    @Override
    public List<OpportunityStageGuide> getGuideListByStageId(Long stageId) {
        if (stageId == null) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStageGuide::getStageId, (Object)stageId)).eq(OpportunityStageGuide::getDelFlag, (Object)"0")).orderBy(true, true, Arrays.asList(OpportunityStageGuide::getGuideType, OpportunityStageGuide::getOrderNumber)));
    }

    @Override
    public List<OpportunityGuideVo> getGuideList() {
        List guideList = this.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStageGuide::getDelFlag, (Object)"0"));
        HashMap<String, List<OpportunityStageGuide>> guideListMap = new HashMap<String, List<OpportunityStageGuide>>();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        HashSet<Long> guideIdList = new HashSet<Long>();
        ArrayList<OpportunityGuideVo> voList = new ArrayList<OpportunityGuideVo>();
        if (CollectionUtil.isNotEmpty((Collection)guideList)) {
            int i = 1;
            this.getGuideByStage(guideListMap, contentMap, guideList, guideIdList, i);
            if (CollectionUtil.isNotEmpty(guideListMap)) {
                Set keyset = guideListMap.keySet();
                for (String key : keyset) {
                    OpportunityGuideVo opportunityGuideVo = new OpportunityGuideVo();
                    opportunityGuideVo.setStageId(key);
                    opportunityGuideVo.setContent((String)contentMap.get(key));
                    opportunityGuideVo.setOpportunityStageGuideList((List)guideListMap.get(key));
                    voList.add(opportunityGuideVo);
                }
                return voList;
            }
        }
        return null;
    }

    private void getGuideByStage(Map<String, List<OpportunityStageGuide>> guideListMap, Map<String, String> contentMap, List<OpportunityStageGuide> guideList, Set<Long> guideIdList, int i) {
        int maxOrder = 0;
        for (OpportunityStageGuide guide : guideList) {
            int order = guide.getOrderNumber();
            if (order > maxOrder) {
                maxOrder = order;
            }
            String guideType = guide.getGuideType();
            String stageId = String.valueOf(guide.getStageId());
            if (i == 1 && "1".equals(guideType) && guideIdList.add(guide.getGuideId())) {
                contentMap.put(stageId, guide.getContent());
            }
            if (i <= 0 || order != i || !"2".equals(guideType) || !guideIdList.add(guide.getGuideId())) continue;
            List<OpportunityStageGuide> opportunityStageGuideList = guideListMap.get(stageId);
            if (CollectionUtil.isEmpty(opportunityStageGuideList)) {
                opportunityStageGuideList = new ArrayList<OpportunityStageGuide>();
            }
            opportunityStageGuideList.add(guide);
            guideListMap.put(stageId, opportunityStageGuideList);
        }
        if (i < maxOrder) {
            this.getGuideByStage(guideListMap, contentMap, guideList, guideIdList, ++i);
        }
    }
}

