/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityPermissionMapper;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.mongodb.lang.Nullable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityPermissionServiceImpl
implements IOpportunityPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityPermissionMapper opportunityPermissionMapper;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;

    @Override
    public List<Long> getOpportunityIdListByPermission(@Nullable Long userId) {
        SecurityUser user = userId == null ? BaseSecurityUtil.getUser() : this.userBoService.selectSecurityByUserId(userId);
        PermissionDto permissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> opportunityIdList = this.opportunityPermissionMapper.getOpportunityIdList(permissionDto, campaignPermissionDto);
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            opportunityIdList.add(-1L);
        }
        return opportunityIdList;
    }

    @Override
    public List<Long> getOpportunityIdListByPermission(@Nullable Long userId, @Nullable List<Long> productIds, @Nullable List<Long> stageIds) {
        SecurityUser user = userId == null ? BaseSecurityUtil.getUser() : this.userBoService.selectSecurityByUserId(userId);
        PermissionDto permissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> opportunityIdList = this.opportunityPermissionMapper.getOpportunityIdListByProductAndStage(permissionDto, campaignPermissionDto, productIds, stageIds);
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            opportunityIdList.add(-1L);
        }
        return opportunityIdList;
    }
}

