/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMergeMapper;
import com.jxdinfo.crm.core.opportunity.dto.CheckedPropertyOpportunityInfo;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityMergeDto;
import com.jxdinfo.crm.core.opportunity.dto.PrimaryOpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityMergeInfo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityMergeRecord;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.StageRecord;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityMergeInfoService;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityMergeRecordService;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityMergeService;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityMergeVo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityRelationInfoVo;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.PushMessageEnum;
import com.jxdinfo.crm.transaction.api.service.IQuotationApiService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityMergeServiceImpl
implements IOpportunityMergeService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ILabelService labelService;
    @Resource
    private IOpportunityMergeRecordService opportunityMergeRecordService;
    @Resource
    private OpportunityMergeMapper opportunityMergeMapper;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IOpportunityMergeInfoService opportunityMergeInfoService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private IQuotationApiService quotationApiService;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private TaskService taskService;
    @Resource
    private IStageRecordService stageRecordService;
    @Resource
    private IQuotationApiService iQuotationApiService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;

    @Override
    public List<OpportunityMergeVo> getList(String opportunityIds) {
        if (StringUtil.isBlank((CharSequence)opportunityIds)) {
            throw new HussarCoreException("\u53c2\u6570\u7f3a\u5931");
        }
        List opportunityIdList = Arrays.asList(opportunityIds.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        List opportunityList = this.opportunityService.listByIds(opportunityIdList);
        if (CollectionUtil.isEmpty((Collection)opportunityList)) {
            throw new HussarCoreException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u673a\u4fe1\u606f");
        }
        return this.toMergeVo(opportunityList);
    }

    private List<OpportunityMergeVo> toMergeVo(List<OpportunityEntity> opportunityEntityList) {
        List labelVoList;
        LinkedHashMap opportunityTypeDictMap = this.sysDicRefService.getDictMapByType("oppport_type");
        LinkedHashMap opportunityFromDictMap = this.sysDicRefService.getDictMapByType("opportunity_from");
        LinkedHashMap tradeDictMap = this.sysDicRefService.getDictMapByType("industry");
        LinkedHashMap importanceOpportunityDictMap = this.sysDicRefService.getDictMapByType("importance_oppty");
        LinkedHashMap opportunityWinRateDictMap = this.sysDicRefService.getDictMapByType("opportunity_win_rate");
        LinkedHashMap sexDictMap = this.sysDicRefService.getDictMapByType("sex");
        LinkedHashMap purchaseMethodDictMap = this.sysDicRefService.getDictMapByType("purchase_method");
        LinkedHashMap yesNoDictMap = this.sysDicRefService.getDictMapByType("yes_no");
        LinkedHashMap consultationMethodsDictMap = this.sysDicRefService.getDictMapByType("consultation_methods");
        LinkedHashMap winningElementsDictMap = this.sysDicRefService.getDictMapByType("winning_elements");
        LinkedHashMap loseTypeDictMap = this.sysDicRefService.getDictMapByType("lost_type");
        LinkedHashMap abandonReasonDictMap = this.sysDicRefService.getDictMapByType("abandon_reason");
        LinkedHashMap bidEvaluationFormDictMap = this.sysDicRefService.getDictMapByType("bid_evaluation_form");
        ArrayList<Long> opportunityIdList = new ArrayList<Long>();
        ArrayList labelIdList = new ArrayList();
        for (OpportunityEntity opportunity : opportunityEntityList) {
            String labelId = opportunity.getLabelId();
            if (StringUtil.isNotBlank((CharSequence)labelId)) {
                List labelIds = Arrays.asList(labelId.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
                labelIdList.addAll(labelIds);
            }
            opportunityIdList.add(opportunity.getOpportunityId());
        }
        List teamMeberEntityList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, opportunityIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
        Map<Object, Object> labelInfoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(labelIdList) && CollectionUtil.isNotEmpty((Collection)(labelVoList = this.labelService.listByIds(labelIdList)))) {
            labelInfoMap = labelVoList.stream().collect(Collectors.toMap(LabelVo::getLabelId, LabelVo::getLabelName));
        }
        List opportunityStageIdList = opportunityEntityList.stream().map(OpportunityEntity::getCustomerStageId).map(Long::parseLong).collect(Collectors.toList());
        List opportunityStageList = this.opportunityStageService.listByIds(opportunityStageIdList);
        ArrayList<OpportunityMergeVo> opportunityMergeVoList = new ArrayList<OpportunityMergeVo>();
        for (OpportunityEntity opportunity : opportunityEntityList) {
            OpportunityStage opportunityStage;
            StageProcessEntity stageProcess;
            Object bidEvaluationForm;
            Object isConfirmTime;
            Object isConfirmBudget;
            Object isConfirmScheme;
            Object isConfirmPerson;
            Object isConfirmBusiness;
            Object abandonReason;
            String loseTypes;
            String winningElements;
            Object consultationMethods;
            Object purchaseMethod;
            Object sex;
            Object opportunityWinRate;
            Object importanceOpportunity;
            Object trade;
            Object opportunityFrom;
            OpportunityMergeVo opportunityMergeVo = new OpportunityMergeVo();
            BeanUtil.copyProperties((Object)opportunity, (Object)opportunityMergeVo);
            String labelId = opportunity.getLabelId();
            ArrayList<Map<String, Object>> labelList = new ArrayList<Map<String, Object>>();
            if (StringUtil.isNotBlank((CharSequence)labelId)) {
                String[] labelIdArray = labelId.split(",");
                for (String labelIdStr : labelIdArray) {
                    Long labelIdLong = Long.valueOf(labelIdStr);
                    Object label = labelInfoMap.get(labelIdLong);
                    if (!ToolUtil.isNotEmpty((Object)label)) continue;
                    HashMap<String, Object> labelMap = new HashMap<String, Object>();
                    labelMap.put("label", label);
                    labelMap.put("value", labelIdStr);
                    labelList.add(labelMap);
                }
            }
            opportunityMergeVo.setLabelList(labelList);
            ArrayList<Map<String, Object>> teamMemberList = new ArrayList<Map<String, Object>>();
            for (TeamMeberEntity teamMeberEntity : teamMeberEntityList) {
                if (!teamMeberEntity.getBusinessId().equals(opportunity.getOpportunityId())) continue;
                HashMap<String, Object> teamMeberMap = new HashMap<String, Object>();
                teamMeberMap.put("value", teamMeberEntity.getTeamMeberId());
                teamMeberMap.put("label", teamMeberEntity.getTeamMeberName());
                teamMeberMap.put("departmentId", teamMeberEntity.getOwnDepartment());
                teamMeberMap.put("departmentName", teamMeberEntity.getOwnDepartmentName());
                teamMeberMap.put("modifyPower", teamMeberEntity.getModifyPower());
                teamMeberMap.put("isCharge", teamMeberEntity.getIsCharge());
                teamMeberMap.put("personId", teamMeberEntity.getPersonId());
                teamMemberList.add(teamMeberMap);
            }
            opportunityMergeVo.setTeamNumberList(teamMemberList);
            if (ToolUtil.isNotEmpty((Object)opportunity.getCustomerId())) {
                CustomerIncludePool customer = (CustomerIncludePool)this.customerIncludePoolService.getById(opportunity.getCustomerId());
                opportunityMergeVo.setCustomerReferredName(customer.getCustomerReferredName());
            }
            for (OpportunityStage opportunityStage2 : opportunityStageList) {
                if (!String.valueOf(opportunityStage2.getCustomerStageId()).equals(opportunity.getCustomerStageId())) continue;
                opportunityMergeVo.setStageType(opportunityStage2.getStageType());
            }
            Object opportunityType = opportunityTypeDictMap.get(opportunity.getOpopportunityType());
            if (opportunityType != null) {
                opportunityMergeVo.setOpopportunityTypeLabel(opportunityType.toString());
            }
            if ((opportunityFrom = opportunityFromDictMap.get(opportunity.getOpopportunityFrom())) != null) {
                opportunityMergeVo.setOpopportunityFromLabel(opportunityFrom.toString());
            }
            if ((trade = tradeDictMap.get(opportunity.getTrade())) != null) {
                opportunityMergeVo.setTradeLabel(trade.toString());
            }
            if ((importanceOpportunity = importanceOpportunityDictMap.get(opportunity.getImportance())) != null) {
                opportunityMergeVo.setImportanceLabel(importanceOpportunity.toString());
            }
            if ((opportunityWinRate = opportunityWinRateDictMap.get(opportunity.getOpportunityWinRate())) != null) {
                opportunityMergeVo.setOpportunityWinRateLabel(opportunityWinRate.toString());
            }
            if ((sex = sexDictMap.get(opportunity.getSex())) != null) {
                opportunityMergeVo.setSexLabel(sex.toString());
            }
            if ((purchaseMethod = purchaseMethodDictMap.get(opportunity.getPurchaseMethod())) != null) {
                opportunityMergeVo.setPurchaseMethodLabel(purchaseMethod.toString());
            }
            if ((consultationMethods = consultationMethodsDictMap.get(opportunity.getConsultationMethods())) != null) {
                opportunityMergeVo.setConsultationMethodsLabel(consultationMethods.toString());
            }
            if (StringUtil.isNotEmpty((Object)(winningElements = opportunity.getWinningElements()))) {
                String[] winningElementsArray = winningElements.split(",");
                String winningLabel = null;
                for (String winningElement : winningElementsArray) {
                    winningLabel = CollectionUtil.isNotEmpty(winningLabel) ? winningLabel + "," + winningElementsDictMap.get(winningElement) : winningElementsDictMap.get(winningElement).toString();
                }
                opportunityMergeVo.setWinningElementsLabel(winningLabel);
            }
            if (StringUtil.isNotEmpty((Object)(loseTypes = opportunity.getLoseReason()))) {
                String[] loseTypesArray = loseTypes.split(",");
                String loseTypeLabel = null;
                for (String loseType : loseTypesArray) {
                    loseTypeLabel = CollectionUtil.isNotEmpty(loseTypeLabel) ? loseTypeLabel + "," + loseTypeDictMap.get(loseType) : loseTypeDictMap.get(loseType).toString();
                }
                opportunityMergeVo.setLoseReasonLabel(loseTypeLabel);
            }
            if ((abandonReason = abandonReasonDictMap.get(opportunity.getAbandonedReason())) != null) {
                opportunityMergeVo.setAbandonedReasonLabel(abandonReason.toString());
            }
            if ((isConfirmBusiness = yesNoDictMap.get(opportunity.getIsConfirmBusiness())) != null) {
                opportunityMergeVo.setIsConfirmBusinessLabel(isConfirmBusiness.toString());
            }
            if ((isConfirmPerson = yesNoDictMap.get(opportunity.getIsConfirmPerson())) != null) {
                opportunityMergeVo.setIsConfirmPersonLabel(isConfirmPerson.toString());
            }
            if ((isConfirmScheme = yesNoDictMap.get(opportunity.getIsConfirmScheme())) != null) {
                opportunityMergeVo.setIsConfirmSchemeLabel(isConfirmScheme.toString());
            }
            if ((isConfirmBudget = yesNoDictMap.get(opportunity.getIsConfirmBudget())) != null) {
                opportunityMergeVo.setIsConfirmBudgetLabel(isConfirmBudget.toString());
            }
            if ((isConfirmTime = yesNoDictMap.get(opportunity.getIsConfirmTime())) != null) {
                opportunityMergeVo.setIsConfirmTimeLabel(isConfirmTime.toString());
            }
            if ((bidEvaluationForm = bidEvaluationFormDictMap.get(opportunity.getIsConfirmTime())) != null) {
                opportunityMergeVo.setBidEvaluationFormLabel(bidEvaluationForm.toString());
            }
            if (ToolUtil.isNotEmpty((Object)(stageProcess = (StageProcessEntity)this.stageProcessService.getById(opportunity.getStageProcessId())))) {
                opportunityMergeVo.setStageProcessName(stageProcess.getProcessName());
            }
            if (ToolUtil.isNotEmpty((Object)(opportunityStage = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)opportunity.getCustomerStageId()))))) {
                opportunityMergeVo.setCustomerStageName(opportunityStage.getCustomerStageName());
            }
            if (StringUtil.isNotBlank((CharSequence)opportunity.getProvince())) {
                StringBuilder sb = new StringBuilder();
                sb.append(opportunity.getProvince());
                if (StringUtil.isNotBlank((CharSequence)opportunity.getCity())) {
                    sb.append("/").append(opportunity.getCity());
                    if (StringUtil.isNotBlank((CharSequence)opportunity.getCounty())) {
                        sb.append("/").append(opportunity.getCounty());
                    }
                }
                opportunityMergeVo.setRegion(sb.toString());
            }
            opportunityMergeVoList.add(opportunityMergeVo);
        }
        return opportunityMergeVoList;
    }

    @Override
    @Transactional
    public Boolean merge(OpportunityMergeDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getPrimaryOpportunity())) {
            throw new HussarCoreException("\u53c2\u6570\u7f3a\u5931");
        }
        if (dto.getOpportunityList().size() <= 1) {
            return true;
        }
        PrimaryOpportunityDto primaryDto = dto.getPrimaryOpportunity();
        Long primaryOpportunityId = primaryDto.getPrimaryOpportunityId();
        String primaryOpportunityName = primaryDto.getPrimaryOpportunityName();
        Long checkedCustomerId = primaryDto.getCheckedCustomerId();
        OpportunityMergeRecord opportunityMergeRecord = new OpportunityMergeRecord();
        opportunityMergeRecord.setOpportunityId(primaryOpportunityId);
        opportunityMergeRecord.setOpportunityName(primaryOpportunityName);
        this.opportunityMergeRecordService.save((Object)opportunityMergeRecord);
        OpportunityEntity primaryOpportunity = (OpportunityEntity)this.opportunityService.getById(primaryOpportunityId);
        Long primaryCustomerId = primaryOpportunity.getCustomerId();
        CustomerEntity checkedCustomer = (CustomerEntity)this.customerService.getById(checkedCustomerId);
        String checkedCustomerName = null;
        if (ToolUtil.isNotEmpty(checkedCustomerName)) {
            checkedCustomerName = checkedCustomer.getCustomerName();
        }
        List<OpportunityMergeVo> opportunityMergeVoList = dto.getOpportunityList();
        List<Long> totalOpportunityIdList = opportunityMergeVoList.stream().map(OpportunityMergeVo::getOpportunityId).collect(Collectors.toList());
        ArrayList<Long> mergeOpportunityIdList = new ArrayList<Long>(totalOpportunityIdList);
        mergeOpportunityIdList.remove(primaryOpportunityId);
        HashMap<String, Object> opportunityMap = new HashMap<String, Object>();
        List<CheckedPropertyOpportunityInfo> checkedPropertyOpportunityInfoList = primaryDto.getCheckedPropertyOpportunityInfoList();
        Map<String, List<CheckedPropertyOpportunityInfo>> checkedPropertyOpportunityInfoMap = checkedPropertyOpportunityInfoList.stream().collect(Collectors.groupingBy(CheckedPropertyOpportunityInfo::getValue));
        this.putCheckedPropertyOpportunityInfo(primaryOpportunityId, checkedPropertyOpportunityInfoList, primaryOpportunity, opportunityMergeVoList, checkedPropertyOpportunityInfoMap);
        Map<String, Map<String, String>> checkPropertyMap = this.checkedPropertyToMap(checkedPropertyOpportunityInfoList, opportunityMap);
        List<Long> mergeOpportunityId = opportunityMergeVoList.stream().map(OpportunityMergeVo::getOpportunityId).collect(Collectors.toList());
        HashMap<String, List<OpportunityRelationInfoVo>> relationRecordMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationFileMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationOperationMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationTasKMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationCompetitorAnalysMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationProductMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationQuoteMap = new HashMap();
        HashMap<String, List<OpportunityRelationInfoVo>> relationContactCharacterMap = new HashMap();
        if (CollectionUtil.isNotEmpty(mergeOpportunityId)) {
            List<OpportunityRelationInfoVo> relationRecordList = this.opportunityMergeMapper.selectRelationRecord(mergeOpportunityId);
            relationRecordMap = relationRecordList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationFileList = this.opportunityMergeMapper.selectRelationFile(mergeOpportunityId);
            relationFileMap = relationFileList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationOperationList = this.opportunityMergeMapper.selectRelationOperation(mergeOpportunityId);
            relationOperationMap = relationOperationList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationTaskList = this.opportunityMergeMapper.selectRelationTask(mergeOpportunityId);
            relationTasKMap = relationTaskList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationProductList = this.opportunityMergeMapper.selectRelationProduct(mergeOpportunityId);
            relationProductMap = relationProductList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationCompetitorAnalysisList = this.opportunityMergeMapper.selectRelationCompetitorAnalysis(mergeOpportunityId);
            relationCompetitorAnalysMap = relationCompetitorAnalysisList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationQuoteList = this.opportunityMergeMapper.selectRelationQuote(mergeOpportunityId);
            relationQuoteMap = relationQuoteList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
            List<OpportunityRelationInfoVo> relationContactCharacterList = this.opportunityMergeMapper.selectRelationContactCharacter(mergeOpportunityId);
            relationContactCharacterMap = relationContactCharacterList.stream().collect(Collectors.groupingBy(OpportunityRelationInfoVo::getOpportunityId));
        }
        ArrayList<Long> deleteOpportunityIdList = new ArrayList<Long>();
        ArrayList<OpportunityMergeInfo> opportunityMergeInfoList = new ArrayList<OpportunityMergeInfo>();
        ArrayList<Map<String, Object>> checkedTeamMember = new ArrayList<Map<String, Object>>();
        HashSet<String> users = new HashSet<String>();
        Long opportunityMergeRecordId = null;
        for (OpportunityMergeVo opportunityMergeVo : opportunityMergeVoList) {
            Long opportunityId = opportunityMergeVo.getOpportunityId();
            if (!opportunityId.equals(primaryDto.getPrimaryOpportunityId())) {
                deleteOpportunityIdList.add(opportunityId);
            }
            users.add(String.valueOf(opportunityMergeVo.getChargePersonId()));
            users.addAll(opportunityMergeVo.getTeamNumberList().stream().map(teamNumber -> teamNumber.get("personId").toString()).collect(Collectors.toList()));
            OpportunityMergeInfo opportunityMergeInfo = new OpportunityMergeInfo();
            opportunityMergeInfo.setOpportunityId(opportunityId);
            opportunityMergeInfo.setOldRecordIds(this.getRelationIds(relationRecordMap, opportunityId));
            opportunityMergeInfo.setOldFileInfoIds(this.getRelationIds(relationFileMap, opportunityId));
            opportunityMergeInfo.setOldOperationIds(this.getRelationIds(relationOperationMap, opportunityId));
            opportunityMergeInfo.setOldTaskIds(this.getRelationIds(relationTasKMap, opportunityId));
            opportunityMergeInfo.setOldCompetitorIds(this.getRelationIds(relationCompetitorAnalysMap, opportunityId));
            opportunityMergeInfo.setOldProductIds(this.getRelationIds(relationProductMap, opportunityId));
            opportunityMergeInfo.setOldQuoteIds(this.getRelationIds(relationQuoteMap, opportunityId));
            opportunityMergeInfo.setOldContactIds(this.getRelationIds(relationContactCharacterMap, opportunityId));
            Map<String, String> checkedProperyByOpportunityMap = checkPropertyMap.get(String.valueOf(opportunityId));
            if (CollectionUtil.isEmpty(checkedProperyByOpportunityMap)) continue;
            try {
                opportunityMergeRecordId = opportunityMergeRecord.getMergeRecordId();
                this.makeOpportunityMergeInfo(opportunityMergeVo, checkedProperyByOpportunityMap, opportunityMergeInfo, checkedTeamMember);
                opportunityMergeInfo.setMergeRecordId(opportunityMergeRecordId);
                opportunityMergeInfoList.add(opportunityMergeInfo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.opportunityMergeInfoService.saveBatch(opportunityMergeInfoList);
        OpportunityEntity opportunity = (OpportunityEntity)JSONObject.parseObject((String)JSONObject.toJSONString(opportunityMap), OpportunityEntity.class);
        opportunity.setOpportunityId(primaryOpportunityId);
        this.opportunityService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OpportunityEntity::getEndTime, (Object)opportunity.getEndTime())).set(OpportunityEntity::getLoseDate, (Object)opportunity.getLoseDate())).set(OpportunityEntity::getSuccessDate, (Object)opportunity.getSuccessDate())).set(OpportunityEntity::getLaunchDatePlan, (Object)opportunity.getLaunchDatePlan())).set(OpportunityEntity::getTenderDate, (Object)opportunity.getTenderDate())).set(OpportunityEntity::getFindTime, (Object)opportunity.getFindTime())).set(OpportunityEntity::getNextTime, (Object)opportunity.getNextTime())).set(OpportunityEntity::getBidOpeningTime, (Object)opportunity.getBidOpeningTime())).set(OpportunityEntity::getCustomerBudget, (Object)opportunity.getCustomerBudget())).set(OpportunityEntity::getCustomerId, (Object)opportunity.getCustomerId())).set(OpportunityEntity::getCustomerName, (Object)opportunity.getCustomerName())).eq(OpportunityEntity::getOpportunityId, (Object)opportunity.getOpportunityId()));
        this.opportunityService.updateById(opportunity);
        String primaryChargePersonId = "";
        String primaryChargePerson = "";
        if (ToolUtil.isNotEmpty((Object)opportunity.getChargePersonId())) {
            primaryChargePersonId = opportunity.getChargePersonId().toString();
            primaryChargePerson = opportunity.getOwnDepartmentName() + "-" + opportunity.getChargePersonName();
        }
        this.updateTeamMemberInfo(checkedTeamMember, primaryOpportunityId, primaryChargePersonId, deleteOpportunityIdList);
        this.opportunityService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(OpportunityEntity::getOpportunityId, deleteOpportunityIdList)).set(OpportunityEntity::getDelFlag, (Object)"1"));
        this.trackRecordAPIService.mergeTrackRecord(deleteOpportunityIdList, primaryOpportunityId);
        this.fileInfoAPIService.mergeFileInfo(deleteOpportunityIdList, primaryOpportunityId);
        this.operateRecordAPIService.mergeOperateRecord(deleteOpportunityIdList, primaryOpportunityId);
        this.taskService.mergeTask(deleteOpportunityIdList, primaryOpportunityId);
        this.mergeOpportunityProduct(mergeOpportunityIdList, primaryOpportunityId, totalOpportunityIdList);
        this.mergeCompetitorAnalysis(mergeOpportunityIdList, primaryOpportunityId);
        this.mergeContactCharacter(checkedCustomerId, primaryOpportunityId, totalOpportunityIdList);
        this.mergeStageRecord(primaryOpportunityId, checkedPropertyOpportunityInfoMap);
        this.iQuotationApiService.updateOpportunityQuotation(checkedCustomerId, checkedCustomerName, primaryOpportunityId, primaryOpportunityName, mergeOpportunityIdList);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_MERGE.getId());
        operateRecordDO.setRecordContent(null);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(primaryOpportunityId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, primaryOpportunityId, primaryOpportunityName, LocalDateTime.now(), false, businessIds);
        if (CollectionUtil.isEmpty(users)) {
            return true;
        }
        String teamMemberInfo = null;
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("departmentName").toString()));
        if (CollectionUtil.isNotEmpty(checkedTeamMember)) {
            for (String departmentName : checkedTeamMemberMap.keySet()) {
                HashSet<String> teamMemberNameSet = new HashSet<String>();
                String teamMemberInfoByDepartment = null;
                List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(departmentName);
                for (Map checkedTeamMemberInfo : checkedTeamMemberList) {
                    String teamMemberName = checkedTeamMemberInfo.get("label").toString();
                    if (!StringUtil.isNotEmpty((Object)teamMemberName) || !teamMemberNameSet.add(teamMemberName)) continue;
                    if (StringUtil.isNotEmpty((Object)teamMemberInfoByDepartment)) {
                        teamMemberInfoByDepartment = teamMemberInfoByDepartment + "\u3001" + checkedTeamMemberInfo.get("label");
                        continue;
                    }
                    teamMemberInfoByDepartment = departmentName + "-" + checkedTeamMemberInfo.get("label");
                }
                if (StringUtil.isNotEmpty(teamMemberInfo)) {
                    teamMemberInfo = teamMemberInfo + ";" + teamMemberInfoByDepartment;
                    continue;
                }
                teamMemberInfo = teamMemberInfoByDepartment;
            }
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String title = "\u3010CRM\u3011\u5546\u673a\u5408\u5e76\u63d0\u9192";
        String content = user.getDeptName() + "-" + user.getUserName() + "\u5bf9\u3010" + primaryOpportunityName + "\u3011\u8fdb\u884c\u4e86\u5408\u5e76\u5904\u7406\uff0c\u5408\u5e76\u540e";
        if (StringUtil.isNotBlank((CharSequence)primaryChargePerson)) {
            content = content + "\u5546\u673a\u8d1f\u8d23\u4eba\u4e3a\uff1a" + primaryChargePerson + "\uff0c";
        }
        content = content + "\u56e2\u961f\u6210\u5458\u5305\u542b\uff1a" + teamMemberInfo;
        String userIds = null;
        ArrayList<String> userList = new ArrayList<String>(users);
        for (String userId : userList) {
            if (StringUtil.isNotEmpty(userIds)) {
                userIds = userIds + "," + userId;
                continue;
            }
            userIds = userId;
        }
        String businessId = String.valueOf(primaryOpportunityId);
        EimPushUtil.pushJqxArticleMessage(title, content, PushMessageEnum.OPPORTUNITY.getMobile(), businessId, userList);
        String contentUnify = "\u3010\u5546\u673a\u5408\u5e76\u3011" + content;
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + PushMessageEnum.OPPORTUNITY.getUnify() + "\"" + businessId + "\"";
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        LocalDateTime date = LocalDateTime.now();
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIds, user.getUserName(), unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        return true;
    }

    private Map<String, Map<String, String>> checkedPropertyToMap(List<CheckedPropertyOpportunityInfo> checkedPropertyOpportunityInfoList, Map<String, Object> opportunityMap) {
        HashMap<String, Map<String, String>> checkedPropertyMap = new HashMap<String, Map<String, String>>();
        for (CheckedPropertyOpportunityInfo checkedPropertyOpportunityInfo : checkedPropertyOpportunityInfoList) {
            String value = checkedPropertyOpportunityInfo.getValue();
            if ("labelList".equals(value) || "teamNumberList".equals(value)) {
                List<Map<String, Object>> resultList = checkedPropertyOpportunityInfo.getResult();
                for (Map<String, Object> result : resultList) {
                    String opportunityId = result.get("opportunityId").toString();
                    String valueList = result.get("value").toString();
                    HashMap<String, String> checkedPropertyOpportunityMap = (HashMap<String, String>)checkedPropertyMap.get(opportunityId);
                    if (CollectionUtil.isEmpty((Map)checkedPropertyOpportunityMap)) {
                        checkedPropertyOpportunityMap = new HashMap<String, String>();
                    }
                    checkedPropertyOpportunityMap.put(value, valueList);
                    if ("labelList".equals(value)) {
                        Object labelIdValue = opportunityMap.get("labelId");
                        if (ToolUtil.isNotEmpty((Object)labelIdValue)) {
                            valueList = labelIdValue + "," + valueList;
                        }
                        opportunityMap.put("labelId", valueList);
                        checkedPropertyOpportunityMap.put("labelId", valueList);
                    }
                    if ("teamNumberList".equals(value)) {
                        checkedPropertyOpportunityMap.put("teamMember", valueList);
                    }
                    checkedPropertyMap.put(opportunityId, checkedPropertyOpportunityMap);
                }
                continue;
            }
            String opportunityId = checkedPropertyOpportunityInfo.getOpportunityId().toString();
            HashMap<String, String> checkedPropertyByOpportunityMap = (HashMap<String, String>)checkedPropertyMap.get(opportunityId);
            if (CollectionUtil.isEmpty((Map)checkedPropertyByOpportunityMap)) {
                checkedPropertyByOpportunityMap = new HashMap<String, String>();
            }
            String label = checkedPropertyOpportunityInfo.getLabel();
            String resultValue = checkedPropertyOpportunityInfo.getResultValue();
            String resultLabel = checkedPropertyOpportunityInfo.getResultLabel();
            if (StringUtil.isNotEmpty((Object)value)) {
                checkedPropertyByOpportunityMap.put(value, resultValue);
                if ("checkedPersonId".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    opportunityMap.put(value, Long.valueOf(resultValue));
                } else if ("campaignId".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    opportunityMap.put(value, Long.valueOf(resultValue));
                } else if ("agentId".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    opportunityMap.put(value, Long.valueOf(resultValue));
                } else if ("ownDepartment".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    opportunityMap.put(value, Long.valueOf(resultValue));
                } else if ("region".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    String[] region = resultValue.split("/");
                    if (region.length > 0) {
                        opportunityMap.put("province", region[0]);
                        if (region.length > 1) {
                            opportunityMap.put("city", region[1]);
                            if (region.length > 2) {
                                opportunityMap.put("county", region[2]);
                            }
                        }
                    }
                } else {
                    opportunityMap.put(value, resultValue);
                }
            }
            if (StringUtil.isNotEmpty((Object)label)) {
                checkedPropertyByOpportunityMap.put(label, resultLabel);
                opportunityMap.put(label, resultLabel);
            }
            checkedPropertyMap.put(opportunityId, checkedPropertyByOpportunityMap);
        }
        Object labelIds = opportunityMap.get("labelId");
        if (ToolUtil.isNotEmpty((Object)labelIds)) {
            List labelIdList = Arrays.stream(String.valueOf(labelIds).split(",")).distinct().collect(Collectors.toList());
            String labelIdToString = StringUtil.join(labelIdList, (String)",");
            opportunityMap.put("labelId", labelIdToString);
        }
        return checkedPropertyMap;
    }

    private String getRelationIds(Map<String, List<OpportunityRelationInfoVo>> relationMap, Long opportunityId) {
        List<OpportunityRelationInfoVo> relationList = relationMap.get(opportunityId + "");
        if (CollectionUtil.isNotEmpty(relationList)) {
            List relationIdList = relationList.stream().map(OpportunityRelationInfoVo::getRelationId).collect(Collectors.toList());
            return JSONObject.toJSONString(relationIdList);
        }
        return null;
    }

    private void makeOpportunityMergeInfo(OpportunityMergeVo opportunityMergeVo, Map<String, String> checkedProperyByOpportunityMap, OpportunityMergeInfo opportunityMergeInfo, List<Map<String, Object>> checkedTeamMember) throws IllegalAccessException {
        Field[] fields;
        Long ownDepartment;
        Long campaignId;
        BeanUtil.copyProperties((Object)opportunityMergeVo, (Object)opportunityMergeInfo);
        Long chargePersonId = opportunityMergeVo.getChargePersonId();
        if (chargePersonId != null && chargePersonId > 0L) {
            opportunityMergeInfo.setChargePersonId(String.valueOf(chargePersonId));
        }
        if ((campaignId = opportunityMergeVo.getCampaignId()) != null && campaignId > 0L) {
            opportunityMergeInfo.setCampaignId(String.valueOf(campaignId));
        }
        if ((ownDepartment = opportunityMergeVo.getOwnDepartment()) != null && ownDepartment > 0L) {
            opportunityMergeInfo.setOwnDepartment(String.valueOf(ownDepartment));
        }
        Class<?> clazz = opportunityMergeInfo.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String value = checkedProperyByOpportunityMap.get(fieldName);
            if ("mergeInfoId".equals(fieldName) || "mergeRecordId".equals(fieldName) || "opportunityId".equals(fieldName)) continue;
            if ("labelId".equals(fieldName)) {
                List<Map<String, Object>> labelList = opportunityMergeVo.getLabelList();
                String labelValue = this.getMultipleChoiceValue(labelList, value, null);
                field.set(opportunityMergeInfo, labelValue);
                continue;
            }
            if ("teamMember".equals(fieldName)) {
                List<Map<String, Object>> teamNumberList = opportunityMergeVo.getTeamNumberList();
                String teamMemberValue = this.getMultipleChoiceValue(teamNumberList, value, checkedTeamMember);
                field.set(opportunityMergeInfo, teamMemberValue);
                continue;
            }
            HashMap<String, String> properyMap = new HashMap<String, String>();
            switch (fieldName) {
                case "trade": {
                    properyMap.put("label", opportunityMergeVo.getTradeLabel());
                    break;
                }
                case "sex": {
                    properyMap.put("label", opportunityMergeVo.getSexLabel());
                    break;
                }
                case "opopportunityType": {
                    properyMap.put("label", opportunityMergeVo.getOpopportunityTypeLabel());
                    break;
                }
                case "opopportunityFrom": {
                    properyMap.put("label", opportunityMergeVo.getOpopportunityFromLabel());
                    break;
                }
                case "importance": {
                    properyMap.put("label", opportunityMergeVo.getImportanceLabel());
                    break;
                }
                case "opportunityWinRate": {
                    properyMap.put("label", opportunityMergeVo.getOpportunityWinRateLabel());
                    break;
                }
                case "purchaseMethod": {
                    properyMap.put("label", opportunityMergeVo.getPurchaseMethodLabel());
                    break;
                }
                case "consultationMethod": {
                    properyMap.put("label", opportunityMergeVo.getConsultationMethodsLabel());
                    break;
                }
                case "winningElements": {
                    properyMap.put("label", opportunityMergeVo.getWinningElementsLabel());
                    break;
                }
                case "loseReason": {
                    properyMap.put("label", opportunityMergeVo.getLoseReasonLabel());
                    break;
                }
                case "isConfirmBusiness": {
                    properyMap.put("label", opportunityMergeVo.getIsConfirmBusinessLabel());
                    break;
                }
                case "isConfirmPerson": {
                    properyMap.put("label", opportunityMergeVo.getIsConfirmPersonLabel());
                    break;
                }
                case "isConfirmScheme": {
                    properyMap.put("label", opportunityMergeVo.getIsConfirmSchemeLabel());
                    break;
                }
                case "isConfirmBudget": {
                    properyMap.put("label", opportunityMergeVo.getIsConfirmBudgetLabel());
                }
            }
            if (checkedProperyByOpportunityMap.containsKey(fieldName)) {
                properyMap.put("value", value);
                properyMap.put("checked", "1");
            } else {
                if (fieldName.startsWith("old")) continue;
                properyMap.put("checked", "0");
                properyMap.put("value", field.get(opportunityMergeInfo) == null ? null : field.get(opportunityMergeInfo).toString());
            }
            properyMap.put("isRadio", "1");
            String propertyValue = JSONObject.toJSONString(properyMap);
            field.set(opportunityMergeInfo, propertyValue);
        }
    }

    private String getMultipleChoiceValue(List<Map<String, Object>> multipleChoiceList, String value, List<Map<String, Object>> checkedTeamMember) {
        List checkedList = null;
        if (StringUtil.isNotEmpty((Object)value)) {
            checkedList = Arrays.stream(value.split(",")).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(multipleChoiceList)) {
            for (Map<String, Object> labelMap : multipleChoiceList) {
                String multipleChoiceValue = labelMap.get("value").toString();
                if (checkedList != null && CollectionUtil.isNotEmpty(checkedList) && checkedList.contains(multipleChoiceValue)) {
                    if (checkedTeamMember != null) {
                        checkedTeamMember.add(labelMap);
                    }
                    labelMap.put("checked", "1");
                } else {
                    labelMap.put("checked", "0");
                }
                labelMap.put("isRadio", "0");
            }
        }
        return JSONObject.toJSONString(multipleChoiceList);
    }

    private void updateTeamMemberInfo(List<Map<String, Object>> checkedTeamMember, Long primaryOpportunityId, String primaryChargePersonId, List<Long> deleteOpportunityIdList) {
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("personId").toString()));
        ArrayList<Long> teamMemberIdList = new ArrayList<Long>();
        ArrayList<TeamMeberEntity> teamMemberEntityList = new ArrayList<TeamMeberEntity>();
        for (String personId : checkedTeamMemberMap.keySet()) {
            String modifyPower;
            TeamMeberEntity teamMeberEntity;
            List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(personId);
            if (personId.equals(primaryChargePersonId)) {
                teamMeberEntity = new TeamMeberEntity();
                if (CollectionUtil.isEmpty(checkedTeamMemberList)) {
                    throw new HussarCoreException("\u56e2\u961f\u6210\u5458\u4e2d\u5e94\u8be5\u5305\u542b\u8d1f\u8d23\u4eba\u4fe1\u606f");
                }
                Map chargePersonTeamMember = checkedTeamMemberList.get(0);
                if (checkedTeamMemberList.size() > 1) {
                    for (Map teamMemberMap : checkedTeamMemberList) {
                        if (!"1".equals(teamMemberMap.get("isCharge").toString())) continue;
                        chargePersonTeamMember = teamMemberMap;
                        break;
                    }
                }
                Long teamMemberId = Long.parseLong(chargePersonTeamMember.get("value").toString());
                teamMeberEntity.setTeamMeberId(teamMemberId);
                teamMeberEntity.setBusinessId(primaryOpportunityId);
                teamMemberEntityList.add(teamMeberEntity);
                teamMemberIdList.add(teamMemberId);
                continue;
            }
            teamMeberEntity = new TeamMeberEntity();
            Map teamMember2 = checkedTeamMemberList.get(0);
            try {
                modifyPower = teamMember2.get("modifyPower").toString();
            }
            catch (Exception e) {
                modifyPower = "0";
            }
            if (CollectionUtil.isNotEmpty(checkedTeamMemberList)) {
                for (Map teamMemberMap : checkedTeamMemberList) {
                    String thisModifyPower;
                    if ("1".equals(teamMemberMap.get("isCharge").toString())) {
                        teamMember2 = teamMemberMap;
                        teamMeberEntity.setModifyPower("1");
                        teamMeberEntity.setIsCharge("0");
                        teamMeberEntity.setMemberRole("6");
                        break;
                    }
                    try {
                        thisModifyPower = teamMemberMap.get("modifyPower").toString();
                    }
                    catch (Exception e) {
                        thisModifyPower = "0";
                    }
                    if (thisModifyPower.equals(modifyPower) || !"1".equals(thisModifyPower)) continue;
                    teamMember2 = teamMemberMap;
                }
            }
            Long teamMemberId = Long.parseLong(teamMember2.get("value").toString());
            teamMeberEntity.setTeamMeberId(teamMemberId);
            teamMeberEntity.setBusinessId(primaryOpportunityId);
            teamMemberEntityList.add(teamMeberEntity);
            teamMemberIdList.add(teamMemberId);
        }
        this.opportunityMergeMapper.updateTeamMemberRelationId(deleteOpportunityIdList, primaryOpportunityId);
        this.teamMeberService.updateBatchById(teamMemberEntityList);
        if (CollectionUtil.isNotEmpty(teamMemberIdList)) {
            this.opportunityMergeMapper.deleteNoCheckedTeamMember(teamMemberIdList, primaryOpportunityId);
        }
    }

    private void putCheckedPropertyOpportunityInfo(Long primaryOpportunityId, List<CheckedPropertyOpportunityInfo> checkedPropertyOpportunityInfoList, OpportunityEntity primaryOpportunity, List<OpportunityMergeVo> opportunityMergeVoList, Map<String, List<CheckedPropertyOpportunityInfo>> checkedPropertyOpportunityInfoMap) {
        List opportunityIdList = opportunityMergeVoList.stream().map(OpportunityMergeVo::getOpportunityId).collect(Collectors.toList());
        long trackRecordCount = this.trackRecordAPIService.countTrackRecordByTypeIds(opportunityIdList);
        CheckedPropertyOpportunityInfo chargeOpportunityInfo = checkedPropertyOpportunityInfoMap.get("chargePersonId").get(0);
        OpportunityEntity chargeOpportunity = primaryOpportunity;
        if (!chargeOpportunityInfo.getOpportunityId().equals(primaryOpportunityId)) {
            chargeOpportunity = (OpportunityEntity)this.opportunityService.getById(chargeOpportunityInfo.getOpportunityId());
        }
        CheckedPropertyOpportunityInfo ownUnit = new CheckedPropertyOpportunityInfo();
        ownUnit.setLabel("ownUnitName");
        ownUnit.setValue("ownUnit");
        ownUnit.setOpportunityId(chargeOpportunity.getOpportunityId());
        ownUnit.setResultLabel(chargeOpportunity.getOwnUnitName());
        ownUnit.setResultValue(String.valueOf(chargeOpportunity.getOwnUnit()));
        checkedPropertyOpportunityInfoList.add(ownUnit);
        CheckedPropertyOpportunityInfo recycleTimeInfo = new CheckedPropertyOpportunityInfo();
        recycleTimeInfo.setLabel("recycleTime");
        recycleTimeInfo.setValue("recycleTime");
        recycleTimeInfo.setOpportunityId(primaryOpportunityId);
        String recycleTimeToString = null;
        LocalDateTime recycleTime = primaryOpportunity.getRecycleTime();
        if (ToolUtil.isNotEmpty((Object)recycleTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            recycleTimeToString = recycleTime.format(formatter);
        }
        recycleTimeInfo.setResultLabel(recycleTimeToString);
        recycleTimeInfo.setResultValue(recycleTimeToString);
        checkedPropertyOpportunityInfoList.add(recycleTimeInfo);
        CheckedPropertyOpportunityInfo resourcePoolIdInfo = new CheckedPropertyOpportunityInfo();
        resourcePoolIdInfo.setLabel("resourcePoolId");
        resourcePoolIdInfo.setValue("resourcePoolId");
        resourcePoolIdInfo.setOpportunityId(primaryOpportunityId);
        resourcePoolIdInfo.setResultLabel(String.valueOf(primaryOpportunity.getResourcePoolId()));
        resourcePoolIdInfo.setResultValue(String.valueOf(primaryOpportunity.getResourcePoolId()));
        checkedPropertyOpportunityInfoList.add(resourcePoolIdInfo);
        CheckedPropertyOpportunityInfo claimPerson = new CheckedPropertyOpportunityInfo();
        claimPerson.setLabel("claimPersonName");
        claimPerson.setValue("claimPerson");
        claimPerson.setOpportunityId(primaryOpportunityId);
        claimPerson.setResultLabel(primaryOpportunity.getClaimPersonName());
        claimPerson.setResultValue(String.valueOf(primaryOpportunity.getClaimPerson()));
        checkedPropertyOpportunityInfoList.add(claimPerson);
        CheckedPropertyOpportunityInfo claimTimeInfo = new CheckedPropertyOpportunityInfo();
        claimTimeInfo.setLabel("claimTime");
        claimTimeInfo.setValue("claimTime");
        claimTimeInfo.setOpportunityId(primaryOpportunityId);
        String claimTimeToString = null;
        LocalDateTime claimTime = primaryOpportunity.getClaimTime();
        if (ToolUtil.isNotEmpty((Object)claimTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            claimTimeToString = claimTime.format(formatter);
        }
        claimTimeInfo.setResultLabel(claimTimeToString);
        claimTimeInfo.setResultValue(claimTimeToString);
        checkedPropertyOpportunityInfoList.add(claimTimeInfo);
        CheckedPropertyOpportunityInfo allocateTimeInfo = new CheckedPropertyOpportunityInfo();
        allocateTimeInfo.setLabel("allocateTime");
        allocateTimeInfo.setValue("allocateTime");
        allocateTimeInfo.setOpportunityId(primaryOpportunityId);
        String allocateTimeToString = null;
        LocalDateTime allocateTime = primaryOpportunity.getAllocateTime();
        if (ToolUtil.isNotEmpty((Object)allocateTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            allocateTimeToString = allocateTime.format(formatter);
        }
        claimTimeInfo.setResultLabel(allocateTimeToString);
        claimTimeInfo.setResultValue(allocateTimeToString);
        checkedPropertyOpportunityInfoList.add(allocateTimeInfo);
        CheckedPropertyOpportunityInfo stageOpportunityInfo = checkedPropertyOpportunityInfoMap.get("customerStageId").get(0);
        OpportunityEntity stageOpportunity = primaryOpportunity;
        if (primaryOpportunityId.equals(stageOpportunityInfo.getOpportunityId())) {
            stageOpportunity = (OpportunityEntity)this.opportunityService.getById(stageOpportunityInfo.getOpportunityId());
        }
        CheckedPropertyOpportunityInfo stageFinishTimeInfo = new CheckedPropertyOpportunityInfo();
        stageFinishTimeInfo.setLabel("stageFinishTime");
        stageFinishTimeInfo.setValue("stageFinishTime");
        stageFinishTimeInfo.setOpportunityId(stageOpportunity.getOpportunityId());
        String stageFinishTimeToString = null;
        LocalDateTime stageFinishTime = stageOpportunity.getStageFinishTime();
        if (ToolUtil.isNotEmpty((Object)stageFinishTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            stageFinishTimeToString = stageFinishTime.format(formatter);
        }
        stageFinishTimeInfo.setResultLabel(stageFinishTimeToString);
        stageFinishTimeInfo.setResultValue(stageFinishTimeToString);
        checkedPropertyOpportunityInfoList.add(stageFinishTimeInfo);
        CheckedPropertyOpportunityInfo customerStageIdInfo = checkedPropertyOpportunityInfoMap.get("customerStageId").get(0);
        OpportunityStage primaryOpportunityStage = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)customerStageIdInfo.getResultValue()));
        CheckedPropertyOpportunityInfo stateInfo = new CheckedPropertyOpportunityInfo();
        stateInfo.setLabel("stateLabel");
        stateInfo.setValue("state");
        stateInfo.setOpportunityId(primaryOpportunityId);
        if (StringUtil.isEmpty((Object)chargeOpportunityInfo.getResultValue())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_UNASSIGNED.getField());
        } else if ("20".equals(primaryOpportunityStage.getStageType())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_WIN.getField());
        } else if ("21".equals(primaryOpportunityStage.getStageType())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_LOSE.getField());
        } else if ("22".equals(primaryOpportunityStage.getStageType())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_ABANDON.getField());
        } else if ("23".equals(primaryOpportunityStage.getStageType())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_CLOSE.getField());
        } else if (primaryOpportunity.getState().equals(OpportunityEditConstant.OPPORTUNITY_STATE_PENDING.getField())) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_PENDING.getField());
        } else if (trackRecordCount > 0L) {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_FOLLOWING.getField());
        } else {
            stateInfo.setResultValue(OpportunityEditConstant.OPPORTUNITY_STATE_UNPROCESSED.getField());
        }
        checkedPropertyOpportunityInfoList.add(stateInfo);
        CheckedPropertyOpportunityInfo partnerInfo = new CheckedPropertyOpportunityInfo();
        partnerInfo.setLabel("partner");
        partnerInfo.setValue("partnerName");
        partnerInfo.setOpportunityId(primaryOpportunityId);
        partnerInfo.setResultLabel(primaryOpportunity.getPartnerName());
        String partnerId = null;
        if (ToolUtil.isNotEmpty(partnerId)) {
            partnerId = String.valueOf(primaryOpportunity.getPartner());
        }
        partnerInfo.setResultValue(partnerId);
        checkedPropertyOpportunityInfoList.add(partnerInfo);
        CheckedPropertyOpportunityInfo customerInternalStageInfo = new CheckedPropertyOpportunityInfo();
        customerInternalStageInfo.setLabel("customerInternalStage");
        customerInternalStageInfo.setValue("customerInternalStage");
        customerInternalStageInfo.setOpportunityId(primaryOpportunityId);
        customerInternalStageInfo.setResultLabel(primaryOpportunity.getCustomerInternalStage());
        customerInternalStageInfo.setResultValue(primaryOpportunity.getCustomerInternalStage());
        checkedPropertyOpportunityInfoList.add(customerInternalStageInfo);
        CheckedPropertyOpportunityInfo progressInfo = new CheckedPropertyOpportunityInfo();
        progressInfo.setLabel("progress");
        progressInfo.setValue("progress");
        progressInfo.setOpportunityId(primaryOpportunityId);
        progressInfo.setResultLabel(primaryOpportunity.getProgress());
        progressInfo.setResultValue(primaryOpportunity.getProgress());
        checkedPropertyOpportunityInfoList.add(progressInfo);
        CheckedPropertyOpportunityInfo planSignTimeInfo = new CheckedPropertyOpportunityInfo();
        planSignTimeInfo.setLabel("planSignTime");
        planSignTimeInfo.setValue("planSignTime");
        planSignTimeInfo.setOpportunityId(primaryOpportunityId);
        planSignTimeInfo.setResultLabel(primaryOpportunity.getPlanSignTime());
        planSignTimeInfo.setResultValue(primaryOpportunity.getPlanSignTime());
        checkedPropertyOpportunityInfoList.add(planSignTimeInfo);
        CheckedPropertyOpportunityInfo priceManualIdInfo = new CheckedPropertyOpportunityInfo();
        priceManualIdInfo.setLabel("priceManualId");
        priceManualIdInfo.setValue("priceManualId");
        priceManualIdInfo.setOpportunityId(primaryOpportunityId);
        priceManualIdInfo.setResultLabel(String.valueOf(primaryOpportunity.getPriceManualId()));
        priceManualIdInfo.setResultValue(String.valueOf(primaryOpportunity.getPriceManualId()));
        checkedPropertyOpportunityInfoList.add(priceManualIdInfo);
        CheckedPropertyOpportunityInfo projectSponsorInfo = new CheckedPropertyOpportunityInfo();
        projectSponsorInfo.setLabel("projectSponsor");
        projectSponsorInfo.setValue("projectSponsor");
        projectSponsorInfo.setOpportunityId(primaryOpportunityId);
        projectSponsorInfo.setResultLabel(primaryOpportunity.getProjectSponsor());
        projectSponsorInfo.setResultValue(primaryOpportunity.getProjectSponsor());
        checkedPropertyOpportunityInfoList.add(projectSponsorInfo);
        CheckedPropertyOpportunityInfo projectBackgroundInfo = new CheckedPropertyOpportunityInfo();
        projectBackgroundInfo.setLabel("projectBackground");
        projectBackgroundInfo.setValue("projectBackground");
        projectBackgroundInfo.setOpportunityId(primaryOpportunityId);
        projectBackgroundInfo.setResultLabel(primaryOpportunity.getProjectBackground());
        projectBackgroundInfo.setResultValue(primaryOpportunity.getProjectBackground());
        checkedPropertyOpportunityInfoList.add(projectBackgroundInfo);
        CheckedPropertyOpportunityInfo decisionProcessInfo = new CheckedPropertyOpportunityInfo();
        decisionProcessInfo.setLabel("decisionProcess");
        decisionProcessInfo.setValue("decisionProcess");
        decisionProcessInfo.setOpportunityId(primaryOpportunityId);
        decisionProcessInfo.setResultLabel(primaryOpportunity.getDecisionProcess());
        decisionProcessInfo.setResultValue(primaryOpportunity.getDecisionProcess());
        checkedPropertyOpportunityInfoList.add(decisionProcessInfo);
        CheckedPropertyOpportunityInfo isNeedTenderInfo = new CheckedPropertyOpportunityInfo();
        isNeedTenderInfo.setLabel("isNeedTenderLabel");
        isNeedTenderInfo.setValue("isNeedTender");
        isNeedTenderInfo.setOpportunityId(primaryOpportunityId);
        isNeedTenderInfo.setResultLabel(primaryOpportunity.getIsNeedTenderLabel());
        isNeedTenderInfo.setResultValue(primaryOpportunity.getIsNeedTender());
        checkedPropertyOpportunityInfoList.add(isNeedTenderInfo);
        CheckedPropertyOpportunityInfo competitorInfo = new CheckedPropertyOpportunityInfo();
        competitorInfo.setLabel("competitorName");
        competitorInfo.setValue("competitorId");
        competitorInfo.setOpportunityId(primaryOpportunityId);
        competitorInfo.setResultLabel(primaryOpportunity.getCompetitorName());
        competitorInfo.setResultValue(String.valueOf(primaryOpportunity.getCompetitorId()));
        checkedPropertyOpportunityInfoList.add(competitorInfo);
        CheckedPropertyOpportunityInfo suspendReasonInfo = new CheckedPropertyOpportunityInfo();
        suspendReasonInfo.setLabel("suspendReason");
        suspendReasonInfo.setValue("suspendReason");
        suspendReasonInfo.setOpportunityId(primaryOpportunityId);
        suspendReasonInfo.setResultLabel(primaryOpportunity.getSuspendReason());
        suspendReasonInfo.setResultValue(primaryOpportunity.getSuspendReason());
        checkedPropertyOpportunityInfoList.add(suspendReasonInfo);
        CheckedPropertyOpportunityInfo orderNumberInfo = new CheckedPropertyOpportunityInfo();
        orderNumberInfo.setLabel("orderNumber");
        orderNumberInfo.setValue("orderNumber");
        orderNumberInfo.setOpportunityId(primaryOpportunityId);
        orderNumberInfo.setResultLabel(String.valueOf(primaryOpportunity.getOrderNumber()));
        orderNumberInfo.setResultValue(String.valueOf(primaryOpportunity.getOrderNumber()));
        checkedPropertyOpportunityInfoList.add(orderNumberInfo);
        CheckedPropertyOpportunityInfo synQuoteInfo = new CheckedPropertyOpportunityInfo();
        synQuoteInfo.setLabel("synQuote");
        synQuoteInfo.setValue("synQuote");
        synQuoteInfo.setOpportunityId(primaryOpportunityId);
        synQuoteInfo.setResultLabel(String.valueOf(primaryOpportunity.getSynQuote()));
        synQuoteInfo.setResultValue(String.valueOf(primaryOpportunity.getSynQuote()));
        checkedPropertyOpportunityInfoList.add(synQuoteInfo);
        CheckedPropertyOpportunityInfo originLeadsInfo = new CheckedPropertyOpportunityInfo();
        originLeadsInfo.setLabel("originLeadsName");
        originLeadsInfo.setValue("originLeads");
        originLeadsInfo.setOpportunityId(primaryOpportunityId);
        originLeadsInfo.setResultLabel(primaryOpportunity.getOriginLeadsName());
        originLeadsInfo.setResultValue(String.valueOf(primaryOpportunity.getOriginLeads()));
        checkedPropertyOpportunityInfoList.add(originLeadsInfo);
        CheckedPropertyOpportunityInfo productInfo = new CheckedPropertyOpportunityInfo();
        productInfo.setLabel("productName");
        productInfo.setValue("productId");
        productInfo.setOpportunityId(primaryOpportunityId);
        productInfo.setResultLabel(primaryOpportunity.getProductName());
        String productIdToString = null;
        if (ToolUtil.isNotEmpty((Object)primaryOpportunity.getProductId())) {
            productIdToString = String.valueOf(primaryOpportunity.getProductId());
        }
        productInfo.setResultValue(productIdToString);
        checkedPropertyOpportunityInfoList.add(productInfo);
        CheckedPropertyOpportunityInfo trackPersonInfo = new CheckedPropertyOpportunityInfo();
        trackPersonInfo.setLabel("trackPersonName");
        trackPersonInfo.setValue("trackPerson");
        trackPersonInfo.setOpportunityId(primaryOpportunityId);
        trackPersonInfo.setResultLabel(primaryOpportunity.getTrackPersonName());
        trackPersonInfo.setResultValue(String.valueOf(primaryOpportunity.getTrackPerson()));
        checkedPropertyOpportunityInfoList.add(trackPersonInfo);
        CheckedPropertyOpportunityInfo companyNameInfo = new CheckedPropertyOpportunityInfo();
        companyNameInfo.setLabel("companyName");
        companyNameInfo.setValue("companyName");
        companyNameInfo.setOpportunityId(primaryOpportunityId);
        companyNameInfo.setResultLabel(primaryOpportunity.getCompanyName());
        companyNameInfo.setResultValue(primaryOpportunity.getCompanyName());
        checkedPropertyOpportunityInfoList.add(companyNameInfo);
        CheckedPropertyOpportunityInfo isUnassignedInfo = new CheckedPropertyOpportunityInfo();
        isUnassignedInfo.setLabel("isUnassigned");
        isUnassignedInfo.setValue("isUnassigned");
        isUnassignedInfo.setOpportunityId(primaryOpportunityId);
        isUnassignedInfo.setResultLabel(primaryOpportunity.getIsUnassigned());
        isUnassignedInfo.setResultValue(primaryOpportunity.getIsUnassigned());
        checkedPropertyOpportunityInfoList.add(isUnassignedInfo);
        CheckedPropertyOpportunityInfo processStateInfo = new CheckedPropertyOpportunityInfo();
        processStateInfo.setLabel("processState");
        processStateInfo.setValue("processState");
        processStateInfo.setOpportunityId(primaryOpportunityId);
        processStateInfo.setResultLabel(primaryOpportunity.getProcessState());
        processStateInfo.setResultValue(primaryOpportunity.getProcessState());
        checkedPropertyOpportunityInfoList.add(processStateInfo);
        CheckedPropertyOpportunityInfo processKeyInfo = new CheckedPropertyOpportunityInfo();
        processKeyInfo.setLabel("processKey");
        processKeyInfo.setValue("processKey");
        processKeyInfo.setOpportunityId(primaryOpportunityId);
        processKeyInfo.setResultLabel(primaryOpportunity.getProcessKey());
        processKeyInfo.setResultValue(primaryOpportunity.getProcessKey());
        checkedPropertyOpportunityInfoList.add(processKeyInfo);
        CheckedPropertyOpportunityInfo processNodeInfo = new CheckedPropertyOpportunityInfo();
        processNodeInfo.setLabel("processNode");
        processNodeInfo.setValue("processNode");
        processNodeInfo.setOpportunityId(primaryOpportunityId);
        processNodeInfo.setResultLabel(primaryOpportunity.getProcessNode());
        processNodeInfo.setResultValue(primaryOpportunity.getProcessNode());
        checkedPropertyOpportunityInfoList.add(processNodeInfo);
        CheckedPropertyOpportunityInfo processInstIdInfo = new CheckedPropertyOpportunityInfo();
        processInstIdInfo.setLabel("processInstId");
        processInstIdInfo.setValue("processInstId");
        processInstIdInfo.setOpportunityId(primaryOpportunityId);
        processInstIdInfo.setResultLabel(String.valueOf(primaryOpportunity.getProcessInstId()));
        processInstIdInfo.setResultValue(String.valueOf(primaryOpportunity.getProcessInstId()));
        checkedPropertyOpportunityInfoList.add(processInstIdInfo);
        CheckedPropertyOpportunityInfo startTimeInfo = new CheckedPropertyOpportunityInfo();
        startTimeInfo.setLabel("startTime");
        startTimeInfo.setValue("startTime");
        startTimeInfo.setOpportunityId(primaryOpportunityId);
        String startTimeToString = null;
        LocalDateTime startTime = primaryOpportunity.getAllocateTime();
        if (ToolUtil.isNotEmpty((Object)startTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            startTimeToString = startTime.format(formatter);
        }
        startTimeInfo.setResultLabel(startTimeToString);
        startTimeInfo.setResultValue(startTimeToString);
        checkedPropertyOpportunityInfoList.add(startTimeInfo);
        CheckedPropertyOpportunityInfo finishTimeInfo = new CheckedPropertyOpportunityInfo();
        finishTimeInfo.setLabel("finishTime");
        finishTimeInfo.setValue("finishTime");
        finishTimeInfo.setOpportunityId(primaryOpportunityId);
        String finishTimeToString = null;
        LocalDateTime finishTime = primaryOpportunity.getFinishTime();
        if (ToolUtil.isNotEmpty((Object)finishTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            finishTimeToString = finishTime.format(formatter);
        }
        finishTimeInfo.setResultLabel(finishTimeToString);
        finishTimeInfo.setResultValue(finishTimeToString);
        checkedPropertyOpportunityInfoList.add(finishTimeInfo);
        CheckedPropertyOpportunityInfo processCreatorInfo = new CheckedPropertyOpportunityInfo();
        processCreatorInfo.setLabel("processCreator");
        processCreatorInfo.setValue("processCreator");
        processCreatorInfo.setOpportunityId(primaryOpportunityId);
        String processCreatorToString = null;
        if (ToolUtil.isNotEmpty((Object)primaryOpportunity.getProcessCreator())) {
            processCreatorToString = String.valueOf(primaryOpportunity.getProcessCreator());
        }
        processCreatorInfo.setResultLabel(processCreatorToString);
        processCreatorInfo.setResultValue(processCreatorToString);
        checkedPropertyOpportunityInfoList.add(processCreatorInfo);
        CheckedPropertyOpportunityInfo processCreateTimeInfo = new CheckedPropertyOpportunityInfo();
        processCreateTimeInfo.setLabel("processCreateTime");
        processCreateTimeInfo.setValue("processCreateTime");
        processCreateTimeInfo.setOpportunityId(primaryOpportunityId);
        String processCreateTimeToString = null;
        LocalDateTime processCreateTime = primaryOpportunity.getProcessCreateTime();
        if (ToolUtil.isNotEmpty((Object)processCreateTime)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            processCreateTimeToString = processCreateTime.format(formatter);
        }
        processCreateTimeInfo.setResultLabel(processCreateTimeToString);
        processCreateTimeInfo.setResultValue(processCreateTimeToString);
        checkedPropertyOpportunityInfoList.add(processCreateTimeInfo);
        CheckedPropertyOpportunityInfo winPossibilityInfo = new CheckedPropertyOpportunityInfo();
        winPossibilityInfo.setLabel("winPossibility");
        winPossibilityInfo.setValue("winPossibility");
        winPossibilityInfo.setOpportunityId(primaryOpportunityId);
        winPossibilityInfo.setResultLabel(primaryOpportunity.getProcessNode());
        winPossibilityInfo.setResultValue(primaryOpportunity.getProcessNode());
        checkedPropertyOpportunityInfoList.add(winPossibilityInfo);
    }

    private void mergeOpportunityProduct(List<Long> mergeOpportunityIdList, Long primaryOpportunityId, List<Long> totalOpportunityIdList) {
        List<Long> opportunityProductIdList = this.opportunityProductService.selectDuplicateId(totalOpportunityIdList, mergeOpportunityIdList);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.set(OpportunityProduct::getOpportunityId, (Object)primaryOpportunityId)).in(OpportunityProduct::getOpportunityId, mergeOpportunityIdList);
        if (CollectionUtil.isNotEmpty(opportunityProductIdList)) {
            this.opportunityProductService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OpportunityProduct::getDelFlag, (Object)"1")).in(OpportunityProduct::getId, opportunityProductIdList));
            lambdaUpdateWrapper.notIn(OpportunityProduct::getId, opportunityProductIdList);
        }
        this.opportunityProductService.update((Wrapper)lambdaUpdateWrapper);
    }

    private void mergeCompetitorAnalysis(List<Long> mergeOpportunityIdList, Long primaryOpportunityId) {
        List primaryCompetitorIdList = this.competitorAnalysisService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CompetitorAnalysis::getCompetitorId}).eq(CompetitorAnalysis::getOpportunityId, (Object)primaryOpportunityId)).eq(CompetitorAnalysis::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        if (CollectionUtil.isNotEmpty((Collection)primaryCompetitorIdList)) {
            this.competitorAnalysisService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CompetitorAnalysis::getDelFlag, (Object)"1")).in(CompetitorAnalysis::getOpportunityId, mergeOpportunityIdList)).in(CompetitorAnalysis::getCompetitorId, (Collection)primaryCompetitorIdList));
            this.competitorAnalysisService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CompetitorAnalysis::getOpportunityId, (Object)primaryOpportunityId)).in(CompetitorAnalysis::getOpportunityId, mergeOpportunityIdList)).notIn(CompetitorAnalysis::getCompetitorId, (Collection)primaryCompetitorIdList));
        } else {
            this.competitorAnalysisService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CompetitorAnalysis::getOpportunityId, (Object)primaryOpportunityId)).in(CompetitorAnalysis::getOpportunityId, mergeOpportunityIdList));
        }
    }

    private void mergeContactCharacter(Long checkedCustomerId, Long primaryOpportunityId, List<Long> totalOpportunityIdList) {
        if (ToolUtil.isNotEmpty((Object)checkedCustomerId)) {
            List<ContactCharacterEntity> contactCharacterEntityList = this.contactCharacterService.selectContactCharacter(checkedCustomerId, totalOpportunityIdList);
            this.contactCharacterService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ContactCharacterEntity::getDelFlag, (Object)"1")).in(ContactCharacterEntity::getOpportunityId, totalOpportunityIdList));
            if (CollectionUtil.isNotEmpty(contactCharacterEntityList)) {
                List idList = contactCharacterEntityList.stream().collect(Collectors.groupingBy(ContactCharacterEntity::getContactId)).values().stream().map(list -> list.stream().max(Comparator.comparing(ContactCharacterEntity::getChangeTime)).orElse(null)).filter(Objects::nonNull).map(ContactCharacterEntity::getId).collect(Collectors.toList());
                this.contactCharacterService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ContactCharacterEntity::getDelFlag, (Object)"0")).set(ContactCharacterEntity::getOpportunityId, (Object)primaryOpportunityId)).in(ContactCharacterEntity::getId, idList));
            }
        } else {
            this.contactCharacterService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ContactCharacterEntity::getDelFlag, (Object)"1")).in(ContactCharacterEntity::getOpportunityId, totalOpportunityIdList));
        }
    }

    private void mergeStageRecord(Long primaryOpportunityId, Map<String, List<CheckedPropertyOpportunityInfo>> checkedPropertyOpportunityInfoMap) {
        CheckedPropertyOpportunityInfo customerStageIdInfo = checkedPropertyOpportunityInfoMap.get("customerStageId").get(0);
        if (!primaryOpportunityId.equals(customerStageIdInfo.getOpportunityId())) {
            this.stageRecordService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StageRecord::getDelFlag, (Object)"1")).eq(StageRecord::getOpportunityId, (Object)primaryOpportunityId));
            this.stageRecordService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StageRecord::getOpportunityId, (Object)primaryOpportunityId)).eq(StageRecord::getOpportunityId, (Object)customerStageIdInfo.getOpportunityId()));
        }
    }
}

