/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileImportAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileImportAPIService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dao.RepeatOpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityImportAndExportService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.util.OpportunityUtil;
import com.jxdinfo.crm.core.opportunity.vo.SuspectedOpportunityVo;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ReadLeadsExcelUtil;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OpportunityImportAndExportImpl
extends ServiceImpl<OpportunityMapper, OpportunityEntity>
implements OpportunityImportAndExportService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private RepeatOpportunityMapper repeatOpportunityMapper;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private IDictBoService dictBoService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private IFileImportAPIService fileImportAPIService;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private ICrmBaseConfigBoService iCrmBaseConfigBoService;
    @Resource
    private IProtectionStatusConfigBoService iProtectionStatusConfigBoService;
    @Resource
    private ISysDicRefService sysDicRefService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public String opportunityImport(MultipartFile file) {
        int flag = 0;
        if (file == null) {
            flag = -1;
        }
        if (!file.getOriginalFilename().endsWith("xlsx")) {
            flag = -2;
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        Long deptId = user.getDeptId();
        String deptName = user.getDeptName();
        AttachmentManagerModelVo attachment = null;
        AttachmentManagerModelVo suspectedAttachment = null;
        ArrayList<SuspectedOpportunityVo> suspectedOpportunityList = new ArrayList<SuspectedOpportunityVo>();
        Long fileImportId = Long.valueOf(CommonUtills.generateAssignId());
        ArrayList<OpportunityEntity> addOpportunityList = new ArrayList<OpportunityEntity>();
        int importCount = 0;
        int suspectedCount = 0;
        List<OpportunityEntity> list = ReadLeadsExcelUtil.getExcelInfo(file);
        if (CollectionUtil.isEmpty(list)) {
            throw new BaseException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        for (OpportunityEntity opportunity : list) {
            SysRegion sysRegion;
            CheckRepeat suspectedOpportunity;
            if (StringUtil.isNotBlank((CharSequence)opportunity.getCustomerName()) && (suspectedOpportunity = this.opportunityService.selectSuspectedOpportunityByCustomerName(opportunity.getCustomerName())).getRepeatResult().booleanValue()) {
                String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
                List<SuspectedOpportunityVo> suspectedList = this.repeatOpportunityMapper.importSuspectedOpportunityList(opportunity.getCustomerName(), openPool);
                suspectedList.sort((o1, o2) -> {
                    Collator comparator = Collator.getInstance((ULocale)ULocale.CHINA);
                    return comparator.compare(o1.getSuspectedCustomerName(), o2.getSuspectedCustomerName());
                });
                if (CollectionUtil.isNotEmpty(suspectedList)) {
                    for (SuspectedOpportunityVo suspectedOpportunityVo : suspectedList) {
                        suspectedOpportunityVo.setImportOpportunityName(opportunity.getOpportunityName());
                        suspectedOpportunityVo.setImportCustomerName(opportunity.getCustomerName());
                    }
                }
                suspectedOpportunityList.addAll(suspectedList);
                ++suspectedCount;
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)opportunity.getProcessName())) throw new BaseException("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5546\u673a\u6d41\u7a0b");
            StageProcessEntity processEntity = (StageProcessEntity)this.stageProcessService.getOne((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(StageProcessEntity::getProcessName, (Object)opportunity.getProcessName())).eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getPublishStatus, (Object)"1"));
            if (!ToolUtil.isNotEmpty((Object)processEntity)) throw new BaseException("\u7b2c" + (list.indexOf(opportunity) + 1) + "\u884c\u6570\u636e\u7684\u5546\u673a\u6d41\u7a0b\u540d\u79f0\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u540e\u5bfc\u5165");
            opportunity.setStageProcessId(processEntity.getStageProcessId());
            OpportunityStage opportunityStage = (OpportunityStage)this.opportunityStageService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageProcessId, (Object)opportunity.getStageProcessId())).eq(OpportunityStage::getStageType, (Object)"00")).eq(OpportunityStage::getDelFlag, (Object)"0"));
            if (!ToolUtil.isNotEmpty((Object)opportunityStage)) throw new BaseException("\u7b2c" + (list.indexOf(opportunity) + 1) + "\u884c\u6570\u636e\u7684\u5546\u673a\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u9636\u6bb5\uff0c\u8bf7\u7ef4\u62a4\u540e\u5bfc\u5165");
            if (ToolUtil.isNotEmpty((Object)opportunityStage.getCustomerGroupId())) {
                opportunity.setCustomerGroupId(Long.valueOf(opportunityStage.getCustomerGroupId()));
            }
            opportunity.setCustomerStageId(String.valueOf(opportunityStage.getCustomerStageId()));
            StringBuilder sb = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)opportunity.getOpopportunityFrom())) {
                String origin = this.leadsMapper.selectValueByLabel("opportunity_from", opportunity.getOpopportunityFrom());
                opportunity.setOpopportunityFrom(origin);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getTrade())) {
                String trade = this.leadsMapper.selectValueByLabel("industry", opportunity.getTrade());
                opportunity.setTrade(trade);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getOpportunityWinRate())) {
                List opportunityWinRates = this.dictBoService.getDicValue("opportunity_win_rate", opportunity.getOpportunityWinRate(), null);
                if (opportunityWinRates.size() == 1) {
                    opportunity.setOpportunityWinRate(((DicVo)opportunityWinRates.get(0)).getValue());
                } else {
                    opportunity.setOpportunityWinRate(null);
                }
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getProvince())) {
                String province = this.leadsMapper.selectBaseAreaIdByName(opportunity.getProvince(), "0");
                sysRegion = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)((Object)province));
                if (ToolUtil.isNotEmpty((Object)sysRegion)) {
                    sb.append(sysRegion.getName());
                    opportunity.setRegionLabel(sysRegion.getName());
                }
                opportunity.setProvince(province);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getCity()) && ToolUtil.isNotEmpty((Object)opportunity.getProvince())) {
                String city = this.leadsMapper.selectBaseAreaIdByName(opportunity.getCity(), opportunity.getProvince());
                sysRegion = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)((Object)city));
                if (ToolUtil.isNotEmpty((Object)sysRegion)) {
                    sb.append("/").append(sysRegion.getName());
                    opportunity.setRegionLabel(sb.toString());
                }
                opportunity.setCity(city);
            } else {
                opportunity.setCity(null);
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getCampaignName())) {
                MarketingActivityEntity marketingActivity = (MarketingActivityEntity)this.marketingActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MarketingActivityEntity::getCampaignName, (Object)opportunity.getCampaignName())).eq(MarketingActivityEntity::getDelFlag, (Object)"0"));
                if (ToolUtil.isNotEmpty((Object)marketingActivity)) {
                    opportunity.setCampaignId(marketingActivity.getCampaignId());
                } else {
                    opportunity.setCampaignName(null);
                }
            }
            if (ToolUtil.isNotEmpty((Object)opportunity.getSex())) {
                if ("\u7537".equals(opportunity.getSex())) {
                    opportunity.setSex("1");
                } else if ("\u5973".equals(opportunity.getSex())) {
                    opportunity.setSex("2");
                } else {
                    opportunity.setSex(null);
                }
            }
            if (this.iProtectionStatusConfigBoService.isFenBaoEnable().booleanValue() && ToolUtil.isNotEmpty((Object)opportunity.getSecurityLevelLabel())) {
                String securityLevel = this.leadsMapper.selectValueByLabel("security_level", opportunity.getSecurityLevelLabel());
                if (ToolUtil.isEmpty((Object)securityLevel)) {
                    opportunity.setSecurityLevel(null);
                }
                opportunity.setSecurityLevel(Integer.valueOf(securityLevel));
            }
            opportunity.setState("5");
            opportunity.setCreatePerson(userId);
            opportunity.setCreatePersonName(userName);
            opportunity.setCreateDepartment(deptId);
            opportunity.setCreateDepartmentName(deptName);
            opportunity.setCreateTime(date);
            opportunity.setOwnDepartment(deptId);
            opportunity.setOwnDepartmentName(deptName);
            opportunity.setChangePerson(userId);
            opportunity.setChangePersonName(userName);
            opportunity.setChangeTime(date);
            opportunity.setImportance("1");
            opportunity.setOpportunityAmount("0.00");
            opportunity.setCustomerBudget("0.00");
            opportunity.setDelFlag("0");
            ++importCount;
            addOpportunityList.add(opportunity);
        }
        OpportunityUtil.batchOpportunityNo(addOpportunityList);
        this.opportunityService.saveBatch(addOpportunityList);
        ArrayList<OpportunityProduct> opportunityProductList = new ArrayList<OpportunityProduct>();
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        for (OpportunityEntity opportunity : addOpportunityList) {
            String regex;
            String productName;
            List<String> productNames;
            TeamMeberEntity teamMeber = this.saveTeamMember(user, date, opportunity.getOpportunityId());
            teamMeberEntityList.add(teamMeber);
            OperateRecordAPIVo trackRecord = this.saveTrackRecord(user, date, opportunity.getOpportunityId(), opportunity.getOpportunityName());
            trackRecordList.add(trackRecord);
            if (!ToolUtil.isNotEmpty((Object)opportunity.getProductName()) || !CollectionUtil.isNotEmpty(productNames = Arrays.asList((productName = opportunity.getProductName()).split(regex = "\uff0c|,")))) continue;
            for (String opportunityProductName : productNames) {
                OpportunityProduct opportunityProduct = this.saveOpportunityProduct(user, date, opportunity.getOpportunityId(), opportunity.getOpportunityName(), opportunityProductName);
                if (!ToolUtil.isNotEmpty((Object)opportunityProduct)) continue;
                opportunityProductList.add(opportunityProduct);
            }
        }
        this.teamMeberService.saveBatch(teamMeberEntityList);
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
        this.opportunityProductService.saveBatch(opportunityProductList);
        FileInputStream inputStream = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
            attachment = (AttachmentManagerModelVo)response.getData();
            if (CollectionUtil.isNotEmpty(suspectedOpportunityList)) {
                File file1 = OpportunityUtil.exportExcelPaper(suspectedOpportunityList);
                inputStream = new FileInputStream(file1);
                MockMultipartFile multipartFile = new MockMultipartFile(file1.getName(), file1.getName(), "application/octet-stream", (InputStream)inputStream);
                ApiResponse suspectedResponse = this.attachmentManagerService.uploadFileWithDrag((MultipartFile)multipartFile, null);
                suspectedAttachment = (AttachmentManagerModelVo)suspectedResponse.getData();
                file1.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FileImportAPIDto fileImport = new FileImportAPIDto();
        String sourceFileName = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\uff0c\u81ea\u52a8\u8fc7\u6ee4" + suspectedCount + "\u6761\u7591\u4f3c\u5546\u673a";
        } else {
            fileImport.setSuccessFail("0");
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(sourceFileName);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId(LabelModuleEnum.OPPORTUNITY.getModuleId());
        if (CollectionUtil.isNotEmpty(suspectedOpportunityList)) {
            Long suspectedFileId = suspectedAttachment.getId();
            fileImport.setSuspectedFileId(suspectedFileId);
            fileImport.setSuspectedFileName(suspectedAttachment.getFileName());
        }
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag("0");
        this.fileImportAPIService.save(fileImport);
        return "\u5bfc\u5165\u6210\u529f";
    }

    private TeamMeberEntity saveTeamMember(SecurityUser user, LocalDateTime date, long businessId) {
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberName(user.getUserName());
        teamMeberEntity.setPersonId(user.getUserId());
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType("2");
        teamMeberEntity.setModifyPower("1");
        teamMeberEntity.setIsCharge("0");
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        teamMeberEntity.setMemberRole("7");
        teamMeberEntity.setOwnDepartment(user.getDeptId());
        teamMeberEntity.setOwnDepartmentName(user.getDeptName());
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return teamMeberEntity;
    }

    private OperateRecordAPIVo saveTrackRecord(SecurityUser user, LocalDateTime date, long businessId, String businessName) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
        operateRecordDO.setTypeId(Long.valueOf(businessId));
        operateRecordDO.setBusinessName(businessName);
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName(user.getUserName());
        operateRecordDO.setCreateTime(date);
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(date);
        operateRecordDO.setChangePersonName(user.getUserName());
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        return operateRecordDO;
    }

    private OpportunityProduct saveOpportunityProduct(SecurityUser user, LocalDateTime date, Long businessId, String businessName, String productName) {
        OpportunityProduct opportunityProduct = new OpportunityProduct();
        Product product = (Product)this.productMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getProductName, (Object)productName)).eq(Product::getDelFlag, (Object)"0"));
        if (ToolUtil.isEmpty((Object)product)) {
            return null;
        }
        opportunityProduct.setProductId(product.getProductId());
        opportunityProduct.setProductName(productName);
        opportunityProduct.setOpportunityId(businessId);
        opportunityProduct.setOpportunityName(businessName);
        opportunityProduct.setStandardPrice(product.getProductPrice());
        opportunityProduct.setSellPrice("0.00");
        opportunityProduct.setDiscount("100");
        opportunityProduct.setProductNumber("1");
        opportunityProduct.setProductSubtotal("0.00");
        opportunityProduct.setTotalPrice("0.00");
        opportunityProduct.setProductType(product.getProductType());
        opportunityProduct.setCreatePerson(user.getUserId());
        opportunityProduct.setCreatePersonName(user.getUserName());
        opportunityProduct.setCreateTime(date);
        opportunityProduct.setChangePerson(user.getUserId());
        opportunityProduct.setChangePersonName(user.getUserName());
        opportunityProduct.setChangeTime(date);
        opportunityProduct.setDelFlag("0");
        return opportunityProduct;
    }

    @Override
    public void opportunityImportTemplate(HttpServletResponse response) {
        try {
            XSSFWorkbook leads = new XSSFWorkbook();
            XSSFSheet sheet = leads.createSheet("\u5546\u673a\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
            XSSFCellStyle style = leads.createCellStyle();
            Row row = sheet.createRow(0);
            String defaultStageName = (String)this.stageProcessService.getObj((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getProcessName}).eq(StageProcessEntity::getIsDefault, (Object)"1"), String::valueOf);
            String[] colsName = new String[]{"\u5546\u673a\u540d\u79f0", "\u5546\u673a\u6d41\u7a0b\uff08\u9700\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u6d41\u7a0b\u540d\u79f0\uff1a\u201c" + defaultStageName + "\u201d\uff09", "\u5ba2\u6237\u540d\u79f0", "\u8054\u7cfb\u4eba", "\u8054\u7cfb\u4eba\u90e8\u95e8", "\u6027\u522b", "\u624b\u673a", "\u7535\u8bdd", "\u804c\u52a1", "\u7535\u5b50\u90ae\u7bb1", "\u53d1\u73b0\u65e5\u671f(\u683c\u5f0f\uff1a\u4f8b\uff1a2023/3/3)", "\u5546\u673a\u6765\u6e90", "\u5e02\u573a\u6d3b\u52a8\u6765\u6e90(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5ba2\u6237\u884c\u4e1a", "\u7701\u4efd(\u4f8b\uff1a\u5c71\u4e1c\u7701)", "\u57ce\u5e02(\u4f8b\uff1a\u6d4e\u5357\u5e02\uff0c\u5982\u679c\u76f4\u8f96\u5e02\u8bf7\u586b\u201c\u5e02\u8f96\u533a\u201d)", "\u5ba2\u6237\u9700\u6c42", "\u5546\u673a\u4ea7\u54c1(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5546\u673a\u8d62\u7387(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5907\u6ce8"};
            if (this.iProtectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                colsName = new String[]{"\u5546\u673a\u540d\u79f0", "\u5546\u673a\u6d41\u7a0b\uff08\u9700\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u6d41\u7a0b\u540d\u79f0\uff1a\u201c" + defaultStageName + "\u201d\uff09", "\u5ba2\u6237\u540d\u79f0", "\u8054\u7cfb\u4eba", "\u8054\u7cfb\u4eba\u90e8\u95e8", "\u6027\u522b", "\u624b\u673a", "\u7535\u8bdd", "\u804c\u52a1", "\u7535\u5b50\u90ae\u7bb1", "\u53d1\u73b0\u65e5\u671f(\u683c\u5f0f\uff1a\u4f8b\uff1a2023/3/3)", "\u5546\u673a\u6765\u6e90", "\u5e02\u573a\u6d3b\u52a8\u6765\u6e90(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5ba2\u6237\u884c\u4e1a", "\u7701\u4efd(\u4f8b\uff1a\u5c71\u4e1c\u7701)", "\u57ce\u5e02(\u4f8b\uff1a\u6d4e\u5357\u5e02\uff0c\u5982\u679c\u76f4\u8f96\u5e02\u8bf7\u586b\u201c\u5e02\u8f96\u533a\u201d)", "\u5ba2\u6237\u9700\u6c42", "\u5546\u673a\u4ea7\u54c1(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5546\u673a\u8d62\u7387(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)", "\u5907\u6ce8", "\u5bc6\u7ea7(\u9700\u8981\u4e0e\u7cfb\u7edf\u5185\u540d\u79f0\u4e00\u81f4)"};
            }
            List<String> cols = Arrays.asList(colsName);
            int j = cols.size();
            for (int i = 0; i < j; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(cols.get(i));
                int columnWidth = sheet.getColumnWidth(i) / 256 + 10;
                int length = cols.get(i).getBytes("UTF-8").length + 1;
                if (columnWidth < length + 1) {
                    columnWidth = length + 1;
                }
                sheet.setColumnWidth(i, columnWidth * 256);
            }
            response.reset();
            String fileName = "\u5546\u673a\u4fe1\u606f\u5bfc\u5165\u6a21\u677f";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes(), "iso-8859-1") + ".xlsx");
            leads.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25!" + e.getMessage());
        }
    }
}

