/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.jxdIM.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.jxdIM.dao.CrmTeamImGroupMapper;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamIMGroupDto;
import com.jxdinfo.crm.core.jxdIM.dto.ImContactDto;
import com.jxdinfo.crm.core.jxdIM.dto.ImUser;
import com.jxdinfo.crm.core.jxdIM.model.CrmTeamImGroupEntity;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupService;
import com.jxdinfo.crm.core.jxdIM.util.HttpClientUtil;
import com.jxdinfo.crm.core.jxdIM.util.ImTokenUtil;
import com.jxdinfo.crm.core.jxdIM.vo.ImGroupVo;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service
public class ImGroupServiceImpl
extends HussarServiceImpl<CrmTeamImGroupMapper, CrmTeamImGroupEntity>
implements ImGroupService {
    @Resource
    private CrmTeamImGroupMapper crmTeamImGroupMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonMapper commonMapper;

    @Override
    public ApiResponse<ImGroupVo> createGroup(CrmTeamIMGroupDto dto) {
        SecurityUser user;
        Long userId;
        List<Long> idList;
        CrmTeamImGroupEntity entity = null;
        entity = (CrmTeamImGroupEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamImGroupEntity::getBusinessType, (Object)dto.getBusinessType())).eq(CrmTeamImGroupEntity::getBusinessId, (Object)dto.getBusinessId())));
        if (entity != null) {
            return ApiResponse.fail((String)"\u5df2\u5b58\u5728\u7fa4\u804a");
        }
        List list = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessType, (Object)dto.getBusinessType())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessId, (Object)dto.getBusinessId()));
        Long adminUserId = null;
        for (TeamMeberEntity teamMeber : list) {
            if (!"1".equals(teamMeber.getIsCharge())) continue;
            adminUserId = teamMeber.getPersonId();
            break;
        }
        if (!(idList = list.stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList())).contains(userId = (user = BaseSecurityUtil.getUser()).getUserId())) {
            idList.add(user.getUserId());
        }
        List<SysUsers> sysUsersList = this.commonMapper.getSysUserChar1ByIds(idList);
        ArrayList<ImUser> imUserList = new ArrayList<ImUser>();
        for (SysUsers sysUsers : sysUsersList) {
            ImUser imUser = new ImUser();
            imUser.setUserId(sysUsers.getId().toString());
            imUser.setUserName(sysUsers.getUserName());
            imUserList.add(imUser);
        }
        ImContactDto imContactDto = new ImContactDto();
        imContactDto.setUsers(imUserList);
        String imUrl = this.crmProperties.getEim().getEimUrl();
        StringBuffer url = new StringBuffer(imUrl).append("/im/v2/groups?adminID=").append(adminUserId).append("&userId=").append(userId).append("&groupType=2").append("&roomName=" + UriUtils.encode((String)dto.getImGroupName(), (String)"UTF-8"));
        String jsonBody = JSONObject.toJSONString((Object)imContactDto);
        String groupId = null;
        String imToken = ImTokenUtil.getIMToken();
        Map<String, Object> map = HttpClientUtil.post(url.toString(), jsonBody, imToken, "eim_push");
        groupId = (String)map.get("data");
        if (HussarUtils.isEmpty((Object)groupId)) {
            return ApiResponse.fail((String)"\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25");
        }
        entity = (CrmTeamImGroupEntity)((Object)BeanUtil.copy((Object)dto, CrmTeamImGroupEntity.class));
        if (entity != null) {
            entity.setImGroupId(groupId);
        }
        this.save((BaseEntity)entity);
        ImGroupVo imGroupVo = new ImGroupVo();
        imGroupVo.setImGroupId(groupId);
        imGroupVo.setImGroupName(dto.getImGroupName());
        return ApiResponse.success((Object)imGroupVo);
    }

    @Override
    public ApiResponse<ImGroupVo> getGroupInfo(String businessId, String businessType) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String imUrl = this.crmProperties.getEim().getEimUrl();
        CrmTeamImGroupEntity entity = (CrmTeamImGroupEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamImGroupEntity::getBusinessId, (Object)businessId)).eq(CrmTeamImGroupEntity::getBusinessType, (Object)businessType)));
        if (entity == null) {
            return ApiResponse.success((String)"\u7fa4\u804a\u4e0d\u5b58\u5728");
        }
        ImGroupVo imGroupVo = new ImGroupVo();
        imGroupVo.setImGroupName(entity.getImGroupName());
        imGroupVo.setImGroupId(entity.getImGroupId());
        List<SysUsers> usersList = this.commonMapper.getSysUserChar1ByIds(Collections.singletonList(user.getUserId()));
        StringBuffer url = new StringBuffer(imUrl).append("/im/v2/groups/detail?roomID=").append(entity.getImGroupId()).append("&userId=").append(usersList.get(0).getId());
        String imToken = ImTokenUtil.getIMToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("client-id", "eim_push");
        header.put("Authorization", imToken);
        Map<String, Object> map = HttpClientUtil.get(url.toString(), header);
        ObjectMapper objectMapper = new ObjectMapper();
        imGroupVo.setIsMember(false);
        try {
            if (!((Boolean)map.get("success")).booleanValue() && map.get("code").toString().equals("20001")) {
                this.removeById(entity.getTeamGroupId());
                return ApiResponse.success((String)"\u7fa4\u804a\u4e0d\u5b58\u5728");
            }
            Map dataMap = (Map)objectMapper.readValue(JSONObject.toJSONString((Object)map.get("data")), Map.class);
            try {
                List idList;
                if (dataMap.containsKey("users") && StringUtil.isNotEmpty(dataMap.get("users")) && (idList = JSONObject.parseArray((String)JSONObject.toJSONString(dataMap.get("users")), ImUser.class).stream().map(ImUser::getUserId).map(Long::parseLong).collect(Collectors.toList())).contains(user.getUserId())) {
                    imGroupVo.setIsMember(true);
                }
            }
            catch (Exception e) {
                imGroupVo.setIsMember(false);
            }
            try {
                imGroupVo.setUnreadCount(Long.parseLong(dataMap.get("unreadCount").toString()));
            }
            catch (Exception e) {
                imGroupVo.setUnreadCount(0L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ApiResponse.success((Object)imGroupVo);
    }

    @Override
    public List<ImUser> teamMemberToGroupMember(List<TeamMeberEntity> teamMeberEntityList, Long userId) {
        List<Long> idList = teamMeberEntityList.stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList());
        if (userId != null && !idList.contains(userId)) {
            idList.add(userId);
        }
        List<SysUsers> sysUsersList = this.commonMapper.getSysUserChar1ByIds(idList);
        ArrayList<ImUser> imUserList = new ArrayList<ImUser>();
        for (SysUsers sysUsers : sysUsersList) {
            ImUser imUser = new ImUser();
            imUser.setUserId(sysUsers.getId().toString());
            imUser.setUserName(sysUsers.getUserName());
            imUserList.add(imUser);
        }
        return imUserList;
    }

    @Override
    public Map<String, String> getCharByUserId(List<Long> userIdList) {
        List<SysUsers> sysUsersList = this.commonMapper.getSysUserChar1ByIds(userIdList);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (SysUsers sysUsers : sysUsersList) {
            returnMap.put(sysUsers.getId().toString(), sysUsers.getChar1());
        }
        return returnMap;
    }
}

