/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordViewAPIVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.clientpool.crmcustomerclaimreview.dto.CrmCustomerClaimReviewDto;
import com.jxdinfo.crm.core.crm.clientpool.crmcustomerclaimreview.model.CrmCustomerClaimCustomer;
import com.jxdinfo.crm.core.crm.clientpool.crmcustomerclaimreview.service.CrmCustomerClaimReviewService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.PublicPoolRule;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.WhiteListMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IPublicPoolRuleService;
import com.jxdinfo.crm.core.customer.constant.CustomerPoolEditConstant;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolMemberEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolMemberService;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolService;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.dao.PoolCustomerMapper;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.dto.CustomerClaimDto;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.dto.PoolCustomerAssociativeQueryDto;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.dto.PoolCustomerDto;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.CustomerPoolClaimRule;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.PoolCustomerEntity;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.ICustomerClaimCustomerService;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.ICustomerClaimReviewService;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerAssociativeQueryService;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerService;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.vo.CustomerClaimVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.vo.PoolCustomerVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.vo.ReviewCustomerVo;
import com.jxdinfo.crm.core.leads.model.CrmDeptRegionRelation;
import com.jxdinfo.crm.core.leads.service.CrmDeptRegionRelationService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PoolCustomerServiceImpl
extends ServiceImpl<PoolCustomerMapper, PoolCustomerEntity>
implements IPoolCustomerService {
    @Resource
    private PoolCustomerMapper poolCustomerMapper;
    @Resource
    private ICustomerPoolMemberService customerPoolMemberService;
    @Resource
    private IPoolCustomerAssociativeQueryService poolCustomerAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private ILabelService labelService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private ICustomerClaimCustomerService customerClaimCustomerService;
    @Resource
    private ICustomerClaimReviewService customerClaimReviewService;
    @Resource
    private ICustomerPoolService customerPoolService;
    @Resource
    private IPublicPoolRuleService publicPoolRuleService;
    @Resource
    private CustomerService customerService;
    @Resource
    private CrmDeptRegionRelationService deptRegionRelationService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ContactService contactService;
    @Resource
    private CrmCustomerClaimReviewService crmCustomerClaimReviewService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private CommonMapper commonMapper;

    @Override
    public String operate(Long customerPoolId, Long customerId) {
        if (HussarUtils.isEmpty((Object)customerPoolId) && HussarUtils.isEmpty((Object)customerId)) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String userOperate = this.customerPoolMemberService.getUserCustomerPoolPermission(user, customerPoolId, customerId);
        return userOperate;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(PoolCustomerAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getCustomerScreening();
        }
        IPoolCustomerAssociativeQueryService adapterService = this.poolCustomerAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("jxd_29Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public Page<PoolCustomerVo> customerList(PoolCustomerDto dto) {
        List recordList;
        List labelList;
        Page page = dto.getPage();
        List<Object> canBeClaimedDirectlyId = new ArrayList();
        if ("2".equals(dto.getPoolCustomerView())) {
            SecurityUser user = BaseSecurityUtil.getUser();
            canBeClaimedDirectlyId = this.selectCantBeClaimedDirectly(dto.getCustomerPoolId(), user);
            if (CollectionUtil.isNotEmpty(canBeClaimedDirectlyId) && canBeClaimedDirectlyId.get(0) != null && ((Long)canBeClaimedDirectlyId.get(0)).equals(-1L)) {
                return page;
            }
        }
        String view = dto.getPoolCustomerView();
        ArrayList<PoolCustomerDto> queryDtoList = new ArrayList<PoolCustomerDto>();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long customerView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)customerView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"customerPool");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        PoolCustomerDto queryDto = (PoolCustomerDto)JSONObject.parseObject((String)queryValue, PoolCustomerDto.class);
                        queryDto.setPoolCustomerView(String.valueOf(customerView));
                        queryDtoList.add(this.customerQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.customerQueryCondition(dto));
        PermissionDto permissionDto = new PermissionDto();
        List<PoolCustomerVo> poolCustomerVoList = ((PoolCustomerMapper)this.baseMapper).poolCustomerVoList(page, dto.getTimeOrder(), queryDtoList, canBeClaimedDirectlyId, permissionDto);
        if (CollectionUtil.isNotEmpty(poolCustomerVoList)) {
            labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            poolCustomerVoList.forEach(customer -> customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId())));
            List customerIdList = poolCustomerVoList.stream().map(PoolCustomerVo::getCustomerId).collect(Collectors.toList());
            recordList = this.trackRecordAPIService.getLatestTrackRecordDetailsByTypeIdBatch(customerIdList);
            if (ToolUtil.isNotEmpty((Object)recordList)) {
                for (PoolCustomerVo poolCustomerVo : poolCustomerVoList) {
                    TrackRecordViewAPIVo recordViewAPIVo = recordList.stream().filter(object -> object.getRelationTypeId().equals(poolCustomerVo.getCustomerId())).findFirst().orElse(null);
                    if (!ToolUtil.isNotEmpty((Object)recordViewAPIVo)) continue;
                    poolCustomerVo.setRecordType(recordViewAPIVo.getRecordType());
                    poolCustomerVo.setRecordContent(recordViewAPIVo.getRecordContent());
                    poolCustomerVo.setLastTrackUserId(recordViewAPIVo.getCreatePerson());
                    poolCustomerVo.setLastTrackUserName(recordViewAPIVo.getCreatePersonName());
                }
            }
        }
        if (CollectionUtil.isNotEmpty(poolCustomerVoList)) {
            labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            poolCustomerVoList.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName(labelList, customer.getLabelId()));
                customer.setAiTagsName(CrmLabelUtil.getLabelName(labelList, customer.getAiTags()));
            });
            List customerIds = poolCustomerVoList.stream().map(PoolCustomerVo::getCustomerId).collect(Collectors.toList());
            recordList = this.trackRecordAPIService.getLatestTrackRecordDetailsByTypeIdBatch(customerIds);
            if (ToolUtil.isNotEmpty((Object)recordList)) {
                for (PoolCustomerVo customerVo : poolCustomerVoList) {
                    TrackRecordViewAPIVo recordViewAPIVoList = recordList.stream().filter(object -> object.getRelationTypeId().equals(customerVo.getCustomerId())).findFirst().orElse(null);
                    if (!ToolUtil.isNotEmpty((Object)recordViewAPIVoList)) continue;
                    customerVo.setRecordType(recordViewAPIVoList.getRecordType());
                    customerVo.setRecordContent(recordViewAPIVoList.getRecordContent());
                }
            }
        }
        page.setRecords(poolCustomerVoList);
        return page;
    }

    private PoolCustomerDto customerQueryCondition(PoolCustomerDto dto) {
        DateConvertVo dateConvertVo;
        ArrayList<String> chargePersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String string : dto.getChargePersonIds()) {
                chargePersonIds.add(CommonUtills.translateUserId(string));
            }
            dto.setTransChargePersonIds(chargePersonIds);
        }
        ArrayList<String> creators = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getCreators()) && dto.getCreators().size() > 0) {
            for (String creator : dto.getCreators()) {
                creators.add(CommonUtills.translateUserId(creator));
            }
            dto.setTransCreators(creators);
        }
        List<String> list = dto.getCreateDepartments();
        List<String> oldDepartments = dto.getOldOwnDepartments();
        dto.setTransCreateDepartments(PoolCustomerServiceImpl.getDepts(list));
        dto.setOldOwnDepartments(PoolCustomerServiceImpl.getDepts(oldDepartments));
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        dto.setDelFlag("0");
        if (StringUtil.isEmpty((Object)dto.getPoolCustomerView())) {
            dto.setPoolCustomerView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(dto.getChargePersonIds())) {
            for (String userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getLastJoinTimeFlag()) && !"6".equals(dto.getLastJoinTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getLastJoinTimeFlag())) != null) {
            dto.setLastJoinTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setLastJoinTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    private static List<String> getDepts(List<String> departments) {
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            return odpIds;
        }
        return null;
    }

    private List<Long> selectCantBeClaimedDirectly(Long poolId, SecurityUser user) {
        List customerList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PoolCustomerEntity::getCustomerPoolId, (Object)poolId)).eq(PoolCustomerEntity::getDelFlag, (Object)"0"));
        HashSet<Long> cantClaimDirectlySet = new HashSet<Long>();
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return null;
        }
        CustomerPoolEntity customerPool = (CustomerPoolEntity)this.customerPoolService.getById(poolId);
        PublicPoolRule publicPoolRule = (PublicPoolRule)((Object)this.publicPoolRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getPublicPoolRuleId, (Object)customerPool.getCustomerPoolRuleId())).eq(PublicPoolRule::getDelFlag, (Object)"0")));
        String claimSwitch = publicPoolRule.getPublicPoolRuleClaimSwitch();
        for (PoolCustomerEntity customer : customerList) {
            if (!"1".equals(customer.getClaimApproval())) continue;
            cantClaimDirectlySet.add(customer.getCustomerId());
        }
        if ("1".equals(claimSwitch)) {
            List whiteIdList;
            String publicRuleClaim = publicPoolRule.getPublicPoolRuleClaim();
            if (StringUtil.isEmpty((Object)publicRuleClaim)) {
                throw new HussarException("\u8bbe\u7f6e\u7684\u8ba4\u9886\u89c4\u5219\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            CustomerPoolClaimRule customerPoolClaimRule = (CustomerPoolClaimRule)JSONObject.parseObject((String)publicRuleClaim, CustomerPoolClaimRule.class);
            List<WhiteListMember> whiteListMemberList = customerPoolClaimRule.getWhiteList();
            if (CollectionUtil.isNotEmpty(whiteListMemberList) && (whiteIdList = whiteListMemberList.stream().map(WhiteListMember::getValue).map(Long::parseLong).collect(Collectors.toList())).contains(user.getUserId())) {
                return new ArrayList<Long>(cantClaimDirectlySet);
            }
            DateConvertVo today = CrmDateUtils.getBeginANdEndTimeOfToday();
            if ("1".equals(customerPoolClaimRule.getLimitRule2Switch())) {
                String limitRule2Value = customerPoolClaimRule.getLimitRule2Value();
                long customerToday = 0L;
                try {
                    customerToday = Long.parseLong(limitRule2Value);
                }
                catch (Exception e) {
                    throw new HussarException("\u89c4\u5219\u8bbe\u7f6e\u6709\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                for (PoolCustomerEntity customer : customerList) {
                    LocalDate lastJoinTime;
                    long daysBetween;
                    if (!user.getUserId().equals(customer.getOldChargePerson()) || customer.getLastJoinTime() == null || (daysBetween = ChronoUnit.DAYS.between(lastJoinTime = customer.getLastJoinTime().toLocalDate(), LocalDate.now())) > customerToday) continue;
                    cantClaimDirectlySet.add(customer.getCustomerId());
                }
            }
            boolean reviewRule1 = "1".equals(customerPoolClaimRule.getExamineRule1Switch());
            boolean reviewRule2 = "1".equals(customerPoolClaimRule.getExamineRule2Switch());
            boolean reviewRule3 = "1".equals(customerPoolClaimRule.getExamineRule3Switch());
            boolean reviewRule4 = "1".equals(customerPoolClaimRule.getExamineRule4Switch());
            List deptRegionRelationList = this.deptRegionRelationService.list();
            Map<Object, Object> regionMap = new HashMap();
            if (CollectionUtil.isNotEmpty((Collection)deptRegionRelationList)) {
                regionMap = deptRegionRelationList.stream().collect(Collectors.toMap(CrmDeptRegionRelation::getRegioniId, relation -> {
                    HashSet<Long> deptSet = new HashSet<Long>();
                    deptSet.add(relation.getDeptId());
                    return deptSet;
                }, (existing, replacement) -> {
                    existing.addAll(replacement);
                    return existing;
                }));
            }
            for (PoolCustomerEntity poolCustomer : customerList) {
                if (StringUtil.isNotBlank((CharSequence)poolCustomer.getProvince())) {
                    Set provinceDepartmentIdList = (Set)regionMap.get(Long.valueOf(poolCustomer.getProvince()));
                    if (HussarUtils.isNotEmpty((Object)provinceDepartmentIdList)) {
                        if (provinceDepartmentIdList.contains(user.getDeptId())) {
                            if (!reviewRule1) continue;
                            cantClaimDirectlySet.add(poolCustomer.getCustomerId());
                            continue;
                        }
                        if (!reviewRule4) continue;
                        cantClaimDirectlySet.add(poolCustomer.getCustomerId());
                        continue;
                    }
                    if (!reviewRule2) continue;
                    cantClaimDirectlySet.add(poolCustomer.getCustomerId());
                    continue;
                }
                if (!reviewRule3) continue;
                cantClaimDirectlySet.add(poolCustomer.getCustomerId());
            }
            for (PoolCustomerEntity customer : customerList) {
                if (!"1".equals(customer.getClaimApproval())) continue;
                cantClaimDirectlySet.add(customer.getCustomerId());
            }
            return new ArrayList<Long>(cantClaimDirectlySet);
        }
        return new ArrayList<Long>(cantClaimDirectlySet);
    }

    @Override
    public CustomerClaimVo getCustomerClaimCount(PoolCustomerDto dto) {
        List<Long> roleId;
        SecurityUser user = BaseSecurityUtil.getUser();
        List memberEntityList = this.customerPoolMemberService.list((Wrapper)new LambdaQueryWrapper().eq(CustomerPoolMemberEntity::getCustomerPoolId, (Object)dto.getCustomerPoolId()));
        if (CollectionUtils.isEmpty((Collection)memberEntityList)) {
            return null;
        }
        Set memberSet = memberEntityList.stream().map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toSet());
        List deptId = memberEntityList.stream().filter(customerPoolMemberEntity -> "2".equals(customerPoolMemberEntity.getMemberType())).map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deptId)) {
            deptId = this.organUserBoService.getOrganByParentIdContainsParent(deptId);
            deptId = deptId.stream().distinct().collect(Collectors.toList());
            List userList = this.hussarBaseUserBoService.getStruUserByStruIds(deptId);
            memberSet.addAll(userList.stream().map(SysStruUser::getUserId).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(roleId = memberEntityList.stream().filter(customerPoolMemberEntity -> "3".equals(customerPoolMemberEntity.getMemberType())).map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toList()))) {
            List<Long> userList = this.commonMapper.getUserByRoleIdBatch(roleId);
            memberSet.addAll(userList);
        }
        if (!memberSet.contains(user.getUserId())) {
            throw new HussarException("\u7528\u6237\u65e0\u8ba4\u9886\u6743\u9650");
        }
        List<Long> claimCustomerIdList = dto.getCustomerIdList();
        if (CollectionUtil.isEmpty(claimCustomerIdList)) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        long claimCustomerCount = claimCustomerIdList.size();
        long reviewCustomerCount = 0L;
        ArrayList<Long> reviewCustomerIdList = new ArrayList<Long>();
        List customerList = this.listByIds(claimCustomerIdList);
        if (CollectionUtil.isEmpty((Collection)customerList)) {
            throw new HussarException("\u5ba2\u6237\u5df2\u88ab\u8ba4\u9886\uff0c\u8ba4\u9886\u5931\u8d25");
        }
        if ((long)customerList.size() < claimCustomerCount) {
            throw new HussarException("\u5b58\u5728\u5df2\u88ab\u8ba4\u9886\u5ba2\u6237\uff0c\u8ba4\u9886\u5931\u8d25");
        }
        long claimCount = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PoolCustomerEntity::getCustomerId, claimCustomerIdList)).eq(PoolCustomerEntity::getClaimApproval, (Object)"1"));
        if (claimCount > 0L) {
            throw new HussarException("\u5b58\u5728\u8ba4\u9886\u5ba1\u6279\u4e2d\u6570\u636e\uff0c\u65e0\u6cd5\u8ba4\u9886");
        }
        CustomerPoolEntity customerPool = (CustomerPoolEntity)this.customerPoolService.getById(dto.getCustomerPoolId());
        PublicPoolRule publicPoolRule = (PublicPoolRule)((Object)this.publicPoolRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getPublicPoolRuleId, (Object)customerPool.getCustomerPoolRuleId())).eq(PublicPoolRule::getDelFlag, (Object)"0")));
        String claimSwitch = publicPoolRule.getPublicPoolRuleClaimSwitch();
        HashMap<Long, String> reviewCustomerMap = new HashMap<Long, String>();
        if ("1".equals(claimSwitch)) {
            String publicRuleClaim = publicPoolRule.getPublicPoolRuleClaim();
            if (StringUtil.isEmpty((Object)publicRuleClaim)) {
                throw new HussarException("\u8bbe\u7f6e\u7684\u8ba4\u9886\u89c4\u5219\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            CustomerPoolClaimRule customerPoolClaimRule = (CustomerPoolClaimRule)JSONObject.parseObject((String)publicRuleClaim, CustomerPoolClaimRule.class);
            List<WhiteListMember> whiteListMemberList = customerPoolClaimRule.getWhiteList();
            boolean needReview = false;
            if (CollectionUtil.isNotEmpty(whiteListMemberList)) {
                List whiteIdList = whiteListMemberList.stream().map(WhiteListMember::getValue).map(Long::parseLong).collect(Collectors.toList());
                if (!whiteIdList.contains(user.getUserId())) {
                    needReview = true;
                }
            } else {
                needReview = true;
            }
            if (needReview) {
                DateConvertVo today = CrmDateUtils.getBeginANdEndTimeOfToday();
                if ("1".equals(customerPoolClaimRule.getLimitRule1Switch())) {
                    String limitRule1Value = customerPoolClaimRule.getLimitRule1Value();
                    long customerCountLimit = 0L;
                    try {
                        customerCountLimit = Long.parseLong(limitRule1Value);
                    }
                    catch (Exception e) {
                        throw new HussarException("\u89c4\u5219\u8bbe\u7f6e\u6709\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    long customerCountClaim = this.customerService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(CustomerEntity::getClaimTime, (Object)LocalDate.parse(today.getStartDate()))).lt(CustomerEntity::getClaimTime, (Object)LocalDate.parse(today.getEndDate()))).eq(CustomerEntity::getDelFlag, (Object)"0")).eq(CustomerEntity::getClaimUserId, (Object)user.getUserId())).eq(CustomerEntity::getResourcePoolId, (Object)dto.getCustomerPoolId()));
                    if (customerCountClaim + claimCustomerCount > customerCountLimit) {
                        throw new HussarException("\u4eca\u65e5\u5df2\u8ba4\u9886" + customerCountClaim + "\u6761\uff0c\u6bcf\u65e5\u6700\u591a\u8ba4\u9886" + customerCountLimit + "\u6761");
                    }
                }
                if ("1".equals(customerPoolClaimRule.getLimitRule2Switch())) {
                    String limitRule2Value = customerPoolClaimRule.getLimitRule2Value();
                    long customerToday = 0L;
                    try {
                        customerToday = Long.parseLong(limitRule2Value);
                    }
                    catch (Exception e) {
                        throw new HussarException("\u89c4\u5219\u8bbe\u7f6e\u6709\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    for (PoolCustomerEntity customer : customerList) {
                        LocalDate lastJoinTime;
                        long daysBetween;
                        if (!user.getUserId().equals(customer.getOldChargePerson()) || customer.getLastJoinTime() == null || (daysBetween = ChronoUnit.DAYS.between(lastJoinTime = customer.getLastJoinTime().toLocalDate(), LocalDate.now())) > customerToday) continue;
                        throw new HussarException("\u524d\u8d1f\u8d23\u4eba" + limitRule2Value + "\u5929\u5185\u4e0d\u53ef\u91cd\u590d\u8ba4\u9886");
                    }
                }
                boolean reviewRule1 = "1".equals(customerPoolClaimRule.getExamineRule1Switch());
                boolean reviewRule2 = "1".equals(customerPoolClaimRule.getExamineRule2Switch());
                boolean reviewRule3 = "1".equals(customerPoolClaimRule.getExamineRule3Switch());
                boolean reviewRule4 = "1".equals(customerPoolClaimRule.getExamineRule4Switch());
                List deptRegionRelationList = this.deptRegionRelationService.list();
                Map<Object, Object> regionMap = new HashMap();
                if (CollectionUtil.isNotEmpty((Collection)deptRegionRelationList)) {
                    regionMap = deptRegionRelationList.stream().collect(Collectors.toMap(CrmDeptRegionRelation::getRegioniId, relation -> {
                        HashSet<Long> deptSet = new HashSet<Long>();
                        deptSet.add(relation.getDeptId());
                        return deptSet;
                    }, (existing, replacement) -> {
                        existing.addAll(replacement);
                        return existing;
                    }));
                }
                for (PoolCustomerEntity poolCustomer : customerList) {
                    if (StringUtil.isNotBlank((CharSequence)poolCustomer.getProvince())) {
                        Set provinceDepartmentIdList = (Set)regionMap.get(Long.valueOf(poolCustomer.getProvince()));
                        if (HussarUtils.isNotEmpty((Object)provinceDepartmentIdList)) {
                            if (provinceDepartmentIdList.contains(user.getDeptId())) {
                                if (!reviewRule1) continue;
                                ++reviewCustomerCount;
                                reviewCustomerIdList.add(poolCustomer.getCustomerId());
                                --claimCustomerCount;
                                claimCustomerIdList.remove(poolCustomer.getCustomerId());
                                reviewCustomerMap.put(poolCustomer.getCustomerId(), "\u8ba4\u9886\u4eba\u6240\u5c5e\u90e8\u95e8\u4e0e\u5ba2\u6237\u5730\u5740\u5339\u914d");
                                continue;
                            }
                            if (!reviewRule4) continue;
                            ++reviewCustomerCount;
                            reviewCustomerIdList.add(poolCustomer.getCustomerId());
                            --claimCustomerCount;
                            claimCustomerIdList.remove(poolCustomer.getCustomerId());
                            reviewCustomerMap.put(poolCustomer.getCustomerId(), "\u8ba4\u9886\u4eba\u6240\u5c5e\u90e8\u95e8\u4e0e\u5ba2\u6237\u5730\u5740\u4e0d\u5339\u914d");
                            continue;
                        }
                        if (!reviewRule2) continue;
                        ++reviewCustomerCount;
                        reviewCustomerIdList.add(poolCustomer.getCustomerId());
                        --claimCustomerCount;
                        claimCustomerIdList.remove(poolCustomer.getCustomerId());
                        reviewCustomerMap.put(poolCustomer.getCustomerId(), "\u8ba4\u9886\u5ba2\u6237\u6709\u5730\u5740\u4f46\u672a\u6210\u7acb\u5bf9\u5e94\u90e8\u95e8");
                        continue;
                    }
                    if (!reviewRule3) continue;
                    ++reviewCustomerCount;
                    reviewCustomerIdList.add(poolCustomer.getCustomerId());
                    --claimCustomerCount;
                    claimCustomerIdList.remove(poolCustomer.getCustomerId());
                    reviewCustomerMap.put(poolCustomer.getCustomerId(), "\u8ba4\u9886\u5ba2\u6237\u65e0\u5730\u5740");
                }
            }
        }
        List<ReviewCustomerVo> reviewCustomerList = new ArrayList();
        if (CollectionUtil.isNotEmpty(reviewCustomerIdList)) {
            List reviewList = this.listByIds(reviewCustomerIdList);
            reviewCustomerList = BeanUtil.copy((Collection)reviewList, ReviewCustomerVo.class);
            for (ReviewCustomerVo reviewCustomerVo : reviewCustomerList) {
                String reviewRule = (String)reviewCustomerMap.get(reviewCustomerVo.getCustomerId());
                reviewCustomerVo.setPublicPoolRuleClaim(reviewRule);
            }
        }
        CustomerClaimVo customerClaimVo = new CustomerClaimVo();
        customerClaimVo.setClaimCustomerCount(claimCustomerCount);
        customerClaimVo.setClaimCustomerIdList(claimCustomerIdList);
        customerClaimVo.setReviewCustomerCount(reviewCustomerCount);
        customerClaimVo.setReviewCustomerList(reviewCustomerList);
        return customerClaimVo;
    }

    @Override
    @Transactional
    public String claimNoReview(CustomerClaimDto dto) {
        List<Long> customerIdList = dto.getClaimCustomerIdList();
        Long customerPoolId = dto.getCustomerPoolId();
        PoolCustomerDto pcdto = new PoolCustomerDto();
        pcdto.setCustomerIdList(customerIdList);
        pcdto.setCustomerPoolId(customerPoolId);
        String checkResult = this.claimCheck(customerIdList);
        if (!"ok".equals(checkResult)) {
            throw new HussarException(checkResult);
        }
        return this.directlyClaim(customerIdList, null);
    }

    private String claimCheck(List<Long> customerIdList) {
        List customerList = this.listByIds(customerIdList);
        if (customerList.size() < customerIdList.size()) {
            return "\u5b58\u5728\u5df2\u88ab\u8ba4\u9886\u5ba2\u6237\uff0c\u8ba4\u9886\u5931\u8d25";
        }
        long claimCount = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PoolCustomerEntity::getCustomerId, customerIdList)).eq(PoolCustomerEntity::getClaimApproval, (Object)"1"));
        if (claimCount > 0L) {
            return "\u5b58\u5728\u8ba4\u9886\u5ba1\u6279\u4e2d\u6570\u636e\uff0c\u65e0\u6cd5\u8ba4\u9886";
        }
        return "ok";
    }

    @Override
    public String claimReview(CrmCustomerClaimReviewDto dto) {
        List<Long> customerIdList = dto.getFormdata().getCrmCustomerClaimCustomer().stream().map(CrmCustomerClaimCustomer::getCustomerId).collect(Collectors.toList());
        String checkReview = this.claimCheck(customerIdList);
        if (!"ok".equals(checkReview)) {
            throw new HussarException(checkReview);
        }
        return "\u6210\u529f";
    }

    @Override
    @NotNull
    public String directlyClaim(List<Long> customerIdList, SecurityUser user) {
        CustomerPoolClaimRule customerPoolClaimRule;
        String publicRuleClaim;
        List poolCustomerEntityList = this.listByIds(customerIdList);
        Long customerPoolId = ((PoolCustomerEntity)poolCustomerEntityList.get(0)).getCustomerPoolId();
        if (user == null) {
            user = BaseSecurityUtil.getUser();
        }
        Long userId = user.getUserId();
        String userName = user.getUserName();
        Long deptId = user.getDeptId();
        String deptName = user.getDeptName();
        LocalDateTime dateTime = LocalDateTime.now();
        ArrayList<CustomerEntity> customerEntityList = new ArrayList<CustomerEntity>();
        CustomerPoolEntity customerPoolEntity = (CustomerPoolEntity)this.customerPoolService.getById(customerPoolId);
        for (PoolCustomerEntity poolCustomer : poolCustomerEntityList) {
            CustomerEntity customer2 = (CustomerEntity)BeanUtil.copy((Object)poolCustomer, CustomerEntity.class);
            customer2.setChargePersonId(userId);
            customer2.setChargePersonName(userName);
            customer2.setOwnDepartment(deptId);
            customer2.setOwnDepartmentName(deptName);
            customer2.setClaimTime(dateTime);
            customer2.setClaimUserId(user.getUserId());
            customer2.setClaimUserName(user.getUserName());
            customer2.setResourcePoolId(customerPoolId);
            customer2.setChangePerson(user.getUserId());
            customer2.setChangePersonName(user.getUserName());
            customer2.setChangeTime(dateTime);
            customerEntityList.add(customer2);
        }
        this.customerService.saveOrUpdateBatch(customerEntityList);
        this.removeByIds(customerIdList);
        this.teamMeberService.insertTeamMemberBatch(userName, userId, customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()), "1", "1", dateTime, "1");
        List customerRecordList = poolCustomerEntityList.stream().map(customer -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_ID.getField(), customerPoolId);
            after.put(CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_ID.getField(), userId);
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getField(), customerPoolEntity.getCustomerPoolName());
            after.put(CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getField(), userName);
            field.put("field", CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getField());
            field.put("fieldName", CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getName());
            changeField.add(field);
            return this.customerPoolService.getTrackRecord(customer.getCustomerId(), customer.getCustomerName(), CrmBusinessTypeEnum.CUSTOMER.getId(), dateTime, userId, userName, JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_CLAIM.getId(), null);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(customerRecordList);
        boolean transOpportunityFlag = false;
        PublicPoolRule publicPoolRule = (PublicPoolRule)((Object)this.publicPoolRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getPublicPoolRuleId, (Object)customerPoolEntity.getCustomerPoolRuleId())).eq(PublicPoolRule::getDelFlag, (Object)"0")));
        if ("1".equals(publicPoolRule.getPublicPoolRuleClaimSwitch()) && HussarUtils.isNotEmpty((Object)(publicRuleClaim = publicPoolRule.getPublicPoolRuleClaim())) && "1".equals((customerPoolClaimRule = (CustomerPoolClaimRule)JSONObject.parseObject((String)publicRuleClaim, CustomerPoolClaimRule.class)).getCirculateRule())) {
            transOpportunityFlag = true;
        }
        if (transOpportunityFlag) {
            List contactEntityList;
            List opportunityEntityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerId, customerIdList)).eq(OpportunityEntity::getDelFlag, (Object)"0")).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(OpportunityEntity::getIsUnassigned, (Object)"1")).or()).isNull(OpportunityEntity::getIsUnassigned);
            }));
            if (CollectionUtil.isNotEmpty((Collection)opportunityEntityList)) {
                this.customerPoolService.opportunityTransferBatch(opportunityEntityList, user, dateTime, user, "\u6240\u5c5e\u5ba2\u6237\u5728\u516c\u6d77\u6c60\u4e2d\u88ab\u8ba4\u9886");
            }
            if (CollectionUtil.isNotEmpty((Collection)(contactEntityList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, (Collection)customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()))).eq(ContactEntity::getDelFlag, (Object)"0"))))) {
                this.customerPoolService.contactTransferBatch(contactEntityList, user, dateTime, user, "\u6240\u5c5e\u5ba2\u6237\u5728\u516c\u6d77\u6c60\u4e2d\u88ab\u8ba4\u9886");
            }
        }
        return "\u8ba4\u9886\u6210\u529f";
    }

    @Override
    public int deletePoolCustomer(List<Long> deleteCustomerIdList) {
        return this.poolCustomerMapper.deletePoolCustomer(deleteCustomerIdList);
    }

    @Override
    public int getCustomerStatus(List<Long> customerIdList) {
        return this.poolCustomerMapper.getCustomerStatus(customerIdList);
    }
}

