/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.sj.crmopportunitytask.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.model.CrmOpportunitySysTask;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.service.CrmOpportunitySysTaskService;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.service.CrmOpportunityTaskMasterService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opportunity_reporting")
@HussarDs(value="master")
public class CrmOpportunitySysTaskDataBackFillServiceImpl
implements TaskModelService {
    @Autowired
    private CrmOpportunitySysTaskService crmOpportunitySysTaskService;
    @Autowired
    private CrmOpportunityTaskMasterService crmOpportunityTaskMasterService;

    public boolean changeProcessInfo(ProcessInfoDto processInfoDto) {
        UpdateWrapper updateWrapper = Wrappers.update();
        updateWrapper.eq((Object)"OPPORTUNITY_ID", (Object)processInfoDto.getBusinessId());
        updateWrapper.set((Object)"PROCESS_KEY", (Object)processInfoDto.getProcessKey());
        updateWrapper.set((Object)"PROCESS_STATE", (Object)processInfoDto.getProcessState());
        updateWrapper.set((Object)"PROCESS_INST_ID", (Object)processInfoDto.getProcessInstanceId());
        updateWrapper.set((Object)"START_TIME", (Object)processInfoDto.getStartTime());
        updateWrapper.set((Object)"FINISH_TIME", (Object)processInfoDto.getFinishTime());
        return this.crmOpportunityTaskMasterService.update((Wrapper)updateWrapper);
    }

    public boolean deleteProcess(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (deletedProcessInfoDtos != null && deletedProcessInfoDtos.size() > 0) {
            UpdateWrapper updateWrapper = Wrappers.update();
            for (DeletedProcessInfoDto deletedProcessInfoDto : deletedProcessInfoDtos) {
                ids.add(Long.valueOf(deletedProcessInfoDto.getBusinessId()));
            }
            updateWrapper.in((Object)"OPPORTUNITY_ID", ids);
            DeletedProcessInfoDto deletedProcessInfo = deletedProcessInfoDtos.get(0);
            updateWrapper.set((Object)"PROCESS_STATE", (Object)deletedProcessInfo.getProcessState());
            updateWrapper.set((Object)"FINISH_TIME", (Object)deletedProcessInfo.getFinishTime());
            this.crmOpportunityTaskMasterService.update((Wrapper)updateWrapper);
            return true;
        }
        return false;
    }

    public boolean changeProcessNode(ProcessNodeInfoDto processNodeInfoDto) {
        UpdateWrapper updateWrapper = Wrappers.update();
        updateWrapper.eq((Object)"OPPORTUNITY_ID", (Object)processNodeInfoDto.getBusinessId());
        updateWrapper.set((Object)"PROCESS_NODE", (Object)this.analyzeProcessNode(processNodeInfoDto.getProcessNodeList()));
        this.crmOpportunityTaskMasterService.update((Wrapper)updateWrapper);
        return true;
    }

    private String analyzeProcessNode(List<ProcessNode> nodeList) {
        String processNode = "";
        if (nodeList != null && nodeList.size() > 0) {
            for (ProcessNode node : nodeList) {
                String nodeName = node.getTaskDefinitionName();
                if (node.getChildrenList() != null && node.getChildrenList().size() > 0) {
                    nodeName = nodeName + "(";
                    for (ProcessNode childNode : node.getChildrenList()) {
                        nodeName = nodeName + childNode.getTaskDefinitionName() + "\u3001";
                    }
                    nodeName = nodeName.substring(0, nodeName.length() - 1) + ")";
                }
                if (processNode.length() == 0) {
                    processNode = processNode + nodeName;
                    continue;
                }
                processNode = processNode + "-" + nodeName;
            }
        }
        return processNode;
    }

    public Integer addTaskInfo(TaskInfoDto taskInfoDto) {
        if (taskInfoDto.getUsers() == null || taskInfoDto.getUsers().size() == 0) {
            CrmOpportunitySysTask crmOpportunitySysTask = this.taskInfoDtoToTaskEntity(taskInfoDto);
            return this.crmOpportunitySysTaskService.save(crmOpportunitySysTask) ? 1 : 0;
        }
        ArrayList<CrmOpportunitySysTask> crmOpportunitySysTaskList = new ArrayList<CrmOpportunitySysTask>();
        for (WorkflowUserDto user : taskInfoDto.getUsers()) {
            CrmOpportunitySysTask crmOpportunitySysTask = this.taskInfoDtoToTaskEntity(taskInfoDto);
            crmOpportunitySysTask.setAssignee(user.getUserId());
            crmOpportunitySysTaskList.add(crmOpportunitySysTask);
        }
        return this.crmOpportunitySysTaskService.saveBatch(crmOpportunitySysTaskList, taskInfoDto.getUsers().size()) ? taskInfoDto.getUsers().size() : 0;
    }

    private CrmOpportunitySysTask taskInfoDtoToTaskEntity(TaskInfoDto taskInfoDto) {
        CrmOpportunitySysTask crmOpportunitySysTask = new CrmOpportunitySysTask();
        crmOpportunitySysTask.setBusinessId(taskInfoDto.getBusinessId());
        crmOpportunitySysTask.setTaskId(Long.parseLong(taskInfoDto.getTaskId()));
        crmOpportunitySysTask.setTaskDefKey(taskInfoDto.getTaskDefinitionKey());
        crmOpportunitySysTask.setTaskDefName(taskInfoDto.getTaskDefinitionName());
        crmOpportunitySysTask.setFormKey(taskInfoDto.getFormKey());
        crmOpportunitySysTask.setFormDetailKey(taskInfoDto.getFormDetailKey());
        crmOpportunitySysTask.setTaskCreateTime(taskInfoDto.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        crmOpportunitySysTask.setTaskState(taskInfoDto.getTaskState());
        crmOpportunitySysTask.setTaskType(taskInfoDto.getTaskType());
        return crmOpportunitySysTask;
    }

    public boolean completeTask(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        boolean flag = true;
        for (CompleteTaskInfoDto completeTaskInfoDto : completeTaskInfoDtos) {
            if (completeTaskInfoDto.getTaskId() == null || completeTaskInfoDto.getTaskId().length() <= 0) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TASK_ID", (Object)completeTaskInfoDto.getTaskId());
            queryWrapper.last("limit 1");
            CrmOpportunitySysTask crmOpportunitySysTask = (CrmOpportunitySysTask)this.crmOpportunitySysTaskService.getOne((Wrapper)queryWrapper);
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"TASK_ID", (Object)completeTaskInfoDto.getTaskId());
            this.crmOpportunitySysTaskService.remove((Wrapper)removeWrapper);
            crmOpportunitySysTask.setEndTime(completeTaskInfoDto.getEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            crmOpportunitySysTask.setTaskType(completeTaskInfoDto.getTaskType());
            crmOpportunitySysTask.setTaskState(completeTaskInfoDto.getTaskState());
            crmOpportunitySysTask.setAssignee(completeTaskInfoDto.getAssignee());
            boolean saveFlag = this.crmOpportunitySysTaskService.save(crmOpportunitySysTask);
            if (saveFlag) continue;
            flag = saveFlag;
        }
        return flag;
    }

    public Integer updateTaskUser(List<UpdateTaskUserDto> updateTaskUserDtos) {
        Integer article = 0;
        for (UpdateTaskUserDto updateTaskUserDto : updateTaskUserDtos) {
            if (updateTaskUserDto.getTaskId() == null || updateTaskUserDto.getTaskId().length() <= 0) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TASK_ID", (Object)updateTaskUserDto.getTaskId());
            queryWrapper.last("limit 1");
            CrmOpportunitySysTask crmOpportunitySysTask = (CrmOpportunitySysTask)this.crmOpportunitySysTaskService.getOne((Wrapper)queryWrapper);
            crmOpportunitySysTask.setTaskInfoId(null);
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"TASK_ID", (Object)updateTaskUserDto.getTaskId());
            this.crmOpportunitySysTaskService.remove((Wrapper)removeWrapper);
            if (updateTaskUserDto.getUsers() == null || updateTaskUserDto.getUsers().size() == 0) {
                crmOpportunitySysTask.setAssignee(null);
                boolean saveFlag = this.crmOpportunitySysTaskService.save(crmOpportunitySysTask);
                if (!saveFlag) continue;
                Integer n = article;
                Integer n2 = article = Integer.valueOf(article + 1);
                continue;
            }
            ArrayList<CrmOpportunitySysTask> crmOpportunitySysTaskList = new ArrayList<CrmOpportunitySysTask>();
            for (WorkflowUserDto user : updateTaskUserDto.getUsers()) {
                CrmOpportunitySysTask cloneTaskModelEntity = (CrmOpportunitySysTask)HussarUtils.clone((Object)crmOpportunitySysTask);
                cloneTaskModelEntity.setAssignee(user.getUserId());
                crmOpportunitySysTaskList.add(cloneTaskModelEntity);
            }
            boolean saveBatchFlag = this.crmOpportunitySysTaskService.saveBatch(crmOpportunitySysTaskList, updateTaskUserDto.getUsers().size());
            if (!saveBatchFlag) continue;
            article = article + updateTaskUserDto.getUsers().size();
        }
        return article;
    }

    public boolean deleteTaskInfo(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        QueryWrapper queryWrapper;
        ArrayList taskIdList = new ArrayList();
        ArrayList businessIdList = new ArrayList();
        for (DeletedTaskInfoDto deletedTaskInfoDto : deletedTaskInfoDtos) {
            if (deletedTaskInfoDto.getTaskIdList() != null && deletedTaskInfoDto.getTaskIdList().size() > 0) {
                taskIdList.addAll(deletedTaskInfoDto.getTaskIdList());
                continue;
            }
            businessIdList.addAll(deletedTaskInfoDto.getBusinessIdList());
        }
        if (taskIdList.size() > 0) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"TASK_ID", taskIdList);
            return this.crmOpportunitySysTaskService.remove((Wrapper)queryWrapper);
        }
        if (businessIdList.size() > 0) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"BUSINESS_ID", businessIdList);
            return this.crmOpportunitySysTaskService.remove((Wrapper)queryWrapper);
        }
        return false;
    }
}

