/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.contact.dto.ContactAssociativeQueryDto;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.service.IContactAssociativeQueryService;
import com.jxdinfo.crm.core.contact.vo.ContactAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContactAssociativeQueryServiceImpl
implements IContactAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        ContactAssociativeQueryDto contactAssociativeQueryDto = null;
        if (associativeQueryDto instanceof ContactAssociativeQueryDto) {
            contactAssociativeQueryDto = (ContactAssociativeQueryDto)associativeQueryDto;
        }
        assert (contactAssociativeQueryDto != null);
        ContactDto contactDto = contactAssociativeQueryDto.getDto();
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        if (contactDto != null) {
            ownDepartmentList = contactDto.getOwnDepartments();
            chargePersonIdList = contactDto.getChargePersonIds();
        }
        List selectedOwnDepartments = excludeInfoMap.get("ownDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(ContactAssociativeQueryEnum.CONTACT_OWN_DEPARTMENTS));
        excludeInfoMap.put("ownDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("chargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(ContactAssociativeQueryEnum.CONTACT_CHARGE_PERSON));
        excludeInfoMap.put("chargePersonIds", selectedChargePersonIds);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(ContactAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

