/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.businessprocess.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.businessprocess.dao.BusinessProcessMapper;
import com.jxdinfo.crm.core.businessprocess.dto.BusinessProcessDto;
import com.jxdinfo.crm.core.businessprocess.model.BusinessProcess;
import com.jxdinfo.crm.core.businessprocess.service.IBusinessProcessService;
import com.jxdinfo.crm.core.businessprocess.vo.BusinessProcessInstVo;
import com.jxdinfo.crm.core.businessprocess.vo.BusinessProcessVo;
import com.jxdinfo.crm.core.jxdIM.util.HttpClientUtil;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.HttpUnifyStatisticUtil;
import com.jxdinfo.crm.product.api.producttargetprofile.dto.OpptyTargetProfileApiDto;
import com.jxdinfo.crm.product.api.producttargetprofile.service.IProductTargetProfileApiService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class BusinessProcessServiceImpl
extends ServiceImpl<BusinessProcessMapper, BusinessProcess>
implements IBusinessProcessService {
    @Resource
    private BusinessProcessMapper businessProcessMapper;
    @Resource
    private InstanceEngineApiService instanceEngineApiService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private IProductTargetProfileApiService productTargetProfileApiService;

    @Override
    public Page<BusinessProcessVo> selectBusinessProcessList(BusinessProcessDto dto) {
        Page page = dto.getPage();
        List<BusinessProcessVo> result = this.businessProcessMapper.selectBusinessProcessList(dto, page);
        page.setRecords(result);
        return page;
    }

    @Override
    public BusinessProcessVo selectBusinessProcess(BusinessProcessDto dto) {
        return this.businessProcessMapper.selectBusinessProcess(dto);
    }

    @Override
    public Boolean updateBusinessProcess(BusinessProcess businessProcess) {
        Long count;
        if ("0".equals(businessProcess.getState()) && (count = Long.valueOf(this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)"0")).eq(OpportunityEntity::getProcessState, (Object)"0")))) > 0L) {
            return false;
        }
        this.update(businessProcess, (Wrapper)new LambdaQueryWrapper().eq(BusinessProcess::getProcessKey, (Object)businessProcess.getProcessKey()));
        return true;
    }

    @Override
    public List<BusinessProcessInstVo> selectProcessInfo(ProcessDto dto) {
        List<BusinessProcessInstVo> resultList = this.getProcessInstVos(dto);
        resultList.sort(Comparator.comparing(BusinessProcessInstVo::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
        return resultList;
    }

    @Override
    public List<BusinessProcessInstVo> selectOpportunityProcessInfo(ProcessDto dto) {
        List<BusinessProcessInstVo> resultList = this.getProcessInstVos(dto);
        if (this.crmProperties.getNocode().isEnable()) {
            String appId;
            String formId;
            String preSalesFormQueryUrl;
            String prefixUrl;
            try {
                prefixUrl = this.crmProperties.getNocode().getUrl();
                preSalesFormQueryUrl = this.crmProperties.getNocode().getPreSalesFormQueryUrl();
                formId = this.crmProperties.getNocode().getPreSalesFormId();
                appId = this.crmProperties.getNocode().getPreSalesAppId();
                BusinessProcessServiceImpl.selectProcessInfo(dto, prefixUrl, preSalesFormQueryUrl, appId, formId, resultList, "1");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                prefixUrl = this.crmProperties.getNocode().getUrl();
                preSalesFormQueryUrl = this.crmProperties.getNocode().getPreSalesFormQueryUrl();
                formId = this.crmProperties.getNocode().getLimsQuotationFormId();
                appId = this.crmProperties.getNocode().getLimsQuotationAppId();
                BusinessProcessServiceImpl.selectProcessInfo(dto, prefixUrl, preSalesFormQueryUrl, appId, formId, resultList, "2");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                prefixUrl = this.crmProperties.getNocode().getUrl();
                preSalesFormQueryUrl = this.crmProperties.getNocode().getPreSalesFormQueryUrl();
                formId = this.crmProperties.getNocode().getNewLimsQuotationFormId();
                appId = this.crmProperties.getNocode().getNewLimsQuotationAppId();
                BusinessProcessServiceImpl.selectProcessInfo(dto, prefixUrl, preSalesFormQueryUrl, appId, formId, resultList, "2");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        resultList.sort(Comparator.comparing(BusinessProcessInstVo::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
        return resultList;
    }

    @NotNull
    private List<BusinessProcessInstVo> getProcessInstVos(ProcessDto dto) {
        ArrayList<BusinessProcessInstVo> resultList = new ArrayList<BusinessProcessInstVo>();
        try {
            BpmResponseResult bpmResponseResult = this.instanceEngineApiService.queryProcessInstance(dto);
            BusinessProcessInstVo result = new BusinessProcessInstVo();
            ArrayList list = new ArrayList();
            for (int i = 0; i < bpmResponseResult.getResult().size(); ++i) {
                JSONObject jSONObject = bpmResponseResult.getResult().getJSONObject(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : jSONObject.keySet()) {
                    map.put(key, jSONObject.get((Object)key));
                }
                list.add(map);
            }
            for (Map map : list) {
                result.setBusinessId(Long.valueOf(dto.getBusinessId()));
                result.setProcessKey((String)map.get("processKey"));
                result.setProcessName((String)map.get("processDefinitionName"));
                result.setProcessInstId(Long.valueOf((String)map.get("processInsId")));
                result.setCreatePerson(Long.valueOf((String)map.get("startUser")));
                result.setCreatePersonName((String)map.get("startUserName"));
                result.setCreateTime((Date)map.get("startTime"));
                if (ToolUtil.isEmpty((Object)((List)map.get("todo")))) {
                    result.setProcessInstState("1");
                } else {
                    result.setProcessInstState("0");
                }
                resultList.add(result);
            }
            List<Long> processInsIdList = resultList.stream().map(BusinessProcessInstVo::getProcessInstId).collect(Collectors.toList());
            List<Map<String, Object>> list2 = this.businessProcessMapper.selectProcessInfoByInsIds(processInsIdList);
            block5: for (Map<String, Object> map : list2) {
                Long instId = (Long)map.get("INST_ID");
                String taskDefKey = (String)map.get("TASK_DEF_KEY");
                Long taskId = (Long)map.get("TASK_ID");
                String nodeName = (String)map.get("NODE_NAME");
                for (BusinessProcessInstVo vo : resultList) {
                    if (!instId.equals(vo.getProcessInstId())) continue;
                    vo.setTaskId(taskId);
                    vo.setTaskDefKey(taskDefKey);
                    vo.setProcessNodeName(nodeName);
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultList = new ArrayList();
        }
        return resultList;
    }

    private static void selectProcessInfo(ProcessDto dto, String prefixUrl, String preSalesFormQueryUrl, String appId, String formId, List<BusinessProcessInstVo> resultList, String type) {
        StringBuffer url = new StringBuffer(prefixUrl).append(preSalesFormQueryUrl).append("?appId=").append(appId).append("&formId=").append(formId);
        HashMap<String, Serializable> nodeCodeQueryMap = new HashMap<String, Serializable>();
        nodeCodeQueryMap.put("current", Integer.valueOf(1));
        nodeCodeQueryMap.put("size", Integer.valueOf(500));
        HashMap<String, String> childMap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        if ("1".equals(type)) {
            childMap.put("field", "inputd9bm5vync92");
        } else if ("2".equals(type)) {
            childMap.put("field", "OPPORTUNITY_ID");
        }
        childMap.put("rule", "_eq");
        childMap.put("match", "AND");
        childMap.put("val", dto.getBusinessId());
        list.add(childMap);
        nodeCodeQueryMap.put("superQueryConditionDto", list);
        String jsonBody = JSONObject.toJSONString(nodeCodeQueryMap);
        Map<String, Object> noCodeProcessResultMap = HttpClientUtil.post(url.toString(), jsonBody, null);
        Map dataMap = (Map)noCodeProcessResultMap.get("data");
        if (ToolUtil.isNotEmpty(dataMap.get("data"))) {
            List mapList = (List)dataMap.get("data");
            for (Map tempMap : mapList) {
                BusinessProcessInstVo businessProcessInstVo = new BusinessProcessInstVo();
                businessProcessInstVo.setBusinessId(Long.valueOf((String)tempMap.get("RECORD_ID")));
                businessProcessInstVo.setProcessKey((String)tempMap.get("PROCESS_KEY"));
                businessProcessInstVo.setProcessInstId(Long.valueOf((String)tempMap.get("PROCESS_INST_ID")));
                if (ToolUtil.isNotEmpty(tempMap.get("createUser_user"))) {
                    if (tempMap.get("createUser_user") instanceof Integer) {
                        businessProcessInstVo.setCreatePerson((long)((Integer)tempMap.get("createUser_user")));
                    } else if (tempMap.get("createUser_user") instanceof String) {
                        businessProcessInstVo.setCreatePerson(Long.valueOf((String)tempMap.get("createUser_user")));
                    }
                }
                businessProcessInstVo.setCreatePersonName((String)tempMap.get("createUserName"));
                businessProcessInstVo.setProcessNodeName((String)tempMap.get("PROCESS_NODE"));
                businessProcessInstVo.setProcessInstState((String)tempMap.get("PROCESS_STATE"));
                businessProcessInstVo.setProcessName((String)tempMap.get("title"));
                try {
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = fmt.parse((String)tempMap.get("START_TIME"));
                    businessProcessInstVo.setCreateTime(date);
                }
                catch (Exception e) {
                    businessProcessInstVo.setCreateTime(null);
                }
                businessProcessInstVo.setType(type);
                resultList.add(businessProcessInstVo);
            }
        }
    }

    @Override
    public Boolean updateOpportunityProduct(Map<String, Object> map) {
        Map childMap = (Map)map.get("data");
        String portraitDegree = (String)childMap.get("textareauhmu1575");
        String opportunityId = (String)((Map)childMap.get("linkforms7emb728")).get("id");
        String productId = (String)childMap.get("input6tydzgtd5vl");
        OpportunityProduct opportunityProduct = (OpportunityProduct)this.opportunityProductService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).eq(OpportunityProduct::getProductId, (Object)productId)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        if (ToolUtil.isNotEmpty((Object)opportunityProduct)) {
            opportunityProduct.setPortraitMatchingDegree(portraitDegree);
            this.opportunityProductService.updateById(opportunityProduct);
        }
        return true;
    }

    @Override
    public Long getNoCodeTaskId(Map<String, Object> map) {
        Long userId = null;
        Long taskId = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (this.crmProperties.getNocode().isEnable()) {
            try {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("crmId", user.getUserId());
                String clientToken = HttpUnifyStatisticUtil.getUnifyToken(false);
                if (ToolUtil.isEmpty((Object)clientToken)) {
                    this.log.error(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "\uff0c\u7528\u6237id\uff1a" + user.getUserId() + "\uff0c\u83b7\u53d6\u7edf\u4e00\u95e8\u6237\u8bf7\u6c42token\u5931\u8d25");
                    throw new HussarException();
                }
                ApiResponse taskIdResultMap = HttpUnifyStatisticUtil.request(this.crmProperties.getNocode().getGetNoCodeUserIdUrl(), param, clientToken, true);
                if (ToolUtil.isNotEmpty((Object)taskIdResultMap.getData())) {
                    userId = Long.parseLong((String)taskIdResultMap.getData());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "\uff0c\u7528\u6237id\uff1a" + user.getUserId() + "\uff0c\u83b7\u53d6\u7edf\u4e00\u95e8\u6237\u8bf7\u6c42token\u5931\u8d25");
            }
            String prefixUrl = this.crmProperties.getNocode().getUrl();
            String url = new StringBuffer(prefixUrl).append(this.crmProperties.getNocode().getGetTaskIdUrl()).toString();
            HashMap<String, Object> nodeCodeQueryMap = new HashMap<String, Object>();
            nodeCodeQueryMap.put("businessId", map.get("businessId"));
            nodeCodeQueryMap.put("processInstId", map.get("processInstId"));
            nodeCodeQueryMap.put("userId", userId);
            String jsonBody = JSONObject.toJSONString(nodeCodeQueryMap);
            Map<String, Object> noCodeProcessResultMap = HttpClientUtil.post(url.toString(), jsonBody, null);
            Map tempMap = (Map)noCodeProcessResultMap.get("data");
            if (ToolUtil.isNotEmpty(tempMap.get("taskId"))) {
                taskId = Long.valueOf((String)tempMap.get("taskId"));
            }
        }
        return taskId;
    }

    @Override
    public Boolean updateOpportunityProductProfile(Map<String, Object> map) {
        if (this.crmProperties.getNocode().isEnable()) {
            try {
                Map childMap = (Map)map.get("data");
                Map userMap = (Map)map.get("op_user");
                Long userId = (Long)userMap.get("id");
                String userName = (String)userMap.get("name");
                String opportunityId = (String)childMap.get("inputd9bm5vync92");
                String productId = (String)childMap.get("input6tydzgtd5vl");
                List profileList = (List)childMap.get("tablerl8mky16sb7");
                ArrayList<OpptyTargetProfileApiDto> dtoList = new ArrayList<OpptyTargetProfileApiDto>();
                LocalDateTime date = LocalDateTime.now();
                for (Map stringObjectMap : profileList) {
                    OpptyTargetProfileApiDto dto = new OpptyTargetProfileApiDto();
                    if (stringObjectMap.containsKey("input5bc7kbgsp4h")) {
                        dto.setProfileOpptyRelationId(Long.valueOf(Long.parseLong((String)stringObjectMap.get("input5bc7kbgsp4h"))));
                    } else {
                        dto.setProfileOpptyRelationId(Long.valueOf(Long.parseLong(CommonUtills.generateAssignId())));
                    }
                    dto.setTargetProfileId(Long.valueOf(Long.parseLong((String)stringObjectMap.get("inputbql9vif1rmf"))));
                    dto.setOpportunityId(Long.valueOf(Long.parseLong(opportunityId)));
                    dto.setProductId(Long.valueOf(Long.parseLong(productId)));
                    dto.setIsMatched((String)((Map)stringObjectMap.get("selet1iwoexbssp0")).get("value"));
                    dto.setLastTime(date);
                    dtoList.add(dto);
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("nocodeId", userId);
                String clientToken = HttpUnifyStatisticUtil.getUnifyToken(false);
                if (ToolUtil.isEmpty((Object)clientToken)) {
                    this.log.error(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "\uff0c\u7528\u6237id\uff1a" + userId + "\uff0c\u83b7\u53d6\u7edf\u4e00\u95e8\u6237\u8bf7\u6c42token\u5931\u8d25");
                    throw new HussarException();
                }
                ApiResponse taskIdResultMap = HttpUnifyStatisticUtil.request(this.crmProperties.getNocode().getGetIamCodeUserIdUrl(), param, clientToken, true);
                if (ToolUtil.isNotEmpty((Object)taskIdResultMap.getData())) {
                    String crmUserId = ((Integer)taskIdResultMap.getData()).toString();
                    for (OpptyTargetProfileApiDto dto : dtoList) {
                        dto.setLastEditor(Long.valueOf(Long.parseLong(crmUserId)));
                        dto.setLastEditorName(userName);
                    }
                }
                this.productTargetProfileApiService.updateOpptyTargetProfile(dtoList);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

