/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.core.leads.model.LeadsOrigin;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadLeadsSeasExcelUtil {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;

    public static List<LeadsOrigin> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadLeadsSeasExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadLeadsSeasExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<LeadsOrigin> userList = ReadLeadsSeasExcelUtil.createExcel(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<LeadsOrigin> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<LeadsOrigin> LeadsList = ReadLeadsSeasExcelUtil.readExcelValue((Workbook)wb);
            return LeadsList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<LeadsOrigin> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<LeadsOrigin> LeadsList = new ArrayList<LeadsOrigin>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            LeadsOrigin lead = new LeadsOrigin();
            block24: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setLeadsName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setCompanyName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setSex(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setMobilePhone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setTelephone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setPosition(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setEmail(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 8: {
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            LocalDate findTime = LocalDate.parse((CharSequence)find, df);
                            lead.setFindTime(findTime.atStartOfDay());
                            continue block24;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block24;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        lead.setFindTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block24;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setLeadsOrigin(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 10: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setLevelNew(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setCampaignName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 12: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setTrade(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 13: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if ("".equals(cell.getStringCellValue())) continue block24;
                        lead.setProvince(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 14: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if ("".equals(cell.getStringCellValue())) continue block24;
                        lead.setCity(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 15: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if ("".equals(cell.getStringCellValue())) continue block24;
                        lead.setCounty(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 16: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setRemark(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 17: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setProductName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 18: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setClaimRange(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                    case 19: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if (ToolUtil.isEmpty((Object)cell.getStringCellValue().replaceAll("\\s*|\r|\n", "")) || !cell.getStringCellValue().replaceAll("\\s*|\r|\n", "").matches("-?\\d+(\\.\\d+)?")) {
                            lead.setClaimNum(1);
                            continue block24;
                        }
                        lead.setClaimNum(Integer.valueOf(cell.getStringCellValue().replaceAll("\\s*|\r|\n", "")));
                        continue block24;
                    }
                    case 20: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        lead.setCustomerNeeds(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block24;
                    }
                }
            }
            LeadsList.add(lead);
        }
        return LeadsList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ReadLeadsSeasExcelUtil.isExcel2003(filePath) && !ReadLeadsSeasExcelUtil.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

