/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.dao.OpportunityPoolOppoMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.vo.SuspectedOpportunityVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.File;
import java.util.Date;
import java.util.List;

public class OpportunityUtil {
    private static final String OPPORTUNITY_NO = "SJ";

    public static void singleOpportunityNo(OpportunityEntity opportunityEntity) {
        if (ToolUtil.isEmpty((Object)opportunityEntity)) {
            return;
        }
        String dateStr = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        int initNo = OpportunityUtil.getMaxOpportunityNo(dateStr);
        opportunityEntity.setOpportunityNo(OpportunityUtil.getNewOpportunityNo(initNo + 1, dateStr));
    }

    public static void batchOpportunityNo(List<OpportunityEntity> opportunityList) {
        if (ToolUtil.isEmpty(opportunityList)) {
            return;
        }
        String dateStr = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        int initNo = OpportunityUtil.getMaxOpportunityNo(dateStr);
        for (OpportunityEntity opportunityEntity : opportunityList) {
            opportunityEntity.setOpportunityNo(OpportunityUtil.getNewOpportunityNo(++initNo, dateStr));
        }
    }

    public static void batchOpportunityPoolOppoNo(List<OpportunityPoolOppo> opportunityList) {
        if (ToolUtil.isEmpty(opportunityList)) {
            return;
        }
        String dateStr = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        int initNo = OpportunityUtil.getMaxOpportunityPoolOppoNo(dateStr);
        for (OpportunityPoolOppo opportunityEntity : opportunityList) {
            opportunityEntity.setOpportunityNo(OpportunityUtil.getNewOpportunityNo(++initNo, dateStr));
        }
    }

    private static int getMaxOpportunityNo(String dateStr) {
        OpportunityMapper opportunityMapper = (OpportunityMapper)SpringUtils.getBean(OpportunityMapper.class);
        Long count = opportunityMapper.selectCount((Wrapper)new LambdaQueryWrapper().like(OpportunityEntity::getOpportunityNo, (Object)dateStr));
        return count.intValue();
    }

    private static int getMaxOpportunityPoolOppoNo(String dateStr) {
        OpportunityPoolOppoMapper opportunityMapper = (OpportunityPoolOppoMapper)SpringUtils.getBean(OpportunityPoolOppoMapper.class);
        Long count = opportunityMapper.selectCount((Wrapper)new LambdaQueryWrapper().like(OpportunityPoolOppo::getOpportunityNo, (Object)dateStr));
        return count.intValue();
    }

    private static String getNewOpportunityNo(int initValue, String dateStr) {
        String opportunityNo = "";
        opportunityNo = initValue < 10 ? "00" + initValue : (initValue < 100 ? "0" + initValue : String.valueOf(initValue));
        return OPPORTUNITY_NO + dateStr + opportunityNo;
    }

    public static List<OpportunityEntity> dictionaryTranslate(List<OpportunityEntity> list) {
        OpportunityService opportunityService = (OpportunityService)SpringUtils.getBean(OpportunityService.class);
        return opportunityService.dictionaryTranslate(list);
    }

    public static File exportExcelPaper(List<SuspectedOpportunityVo> list) {
        OpportunityService opportunityService = (OpportunityService)SpringUtils.getBean(OpportunityService.class);
        return opportunityService.exportExcelPaper(list);
    }

    public static void handleDateField(OpportunityEntity opportunity) {
        if ("".equals(opportunity.getEndTime())) {
            opportunity.setEndTime(null);
        }
        if ("".equals(opportunity.getSuccessDate())) {
            opportunity.setSuccessDate(null);
        }
        if ("".equals(opportunity.getLoseDate())) {
            opportunity.setLoseDate(null);
        }
        if ("".equals(opportunity.getTenderDate())) {
            opportunity.setTenderDate(null);
        }
        if ("".equals(opportunity.getPlanSignTime())) {
            opportunity.setPlanSignTime(null);
        }
    }
}

