/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.GlobalOpportunityService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GlobalOpportunityServiceImpl
implements GlobalOpportunityService {
    @Resource
    OpportunityMapper opportunityMapper;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ISysDicRefService sysDicRefService;

    @Override
    public Page<OpportunityEntity> selectCrmOpportunityList(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto permissionDto = new PermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(user);
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        }
        if ("1".equals((dto = this.opportunityQueryCondition(dto)).getExceptEndStageFlag())) {
            StageTypeDto stageTypeDto = new StageTypeDto();
            stageTypeDto.setStageStart(true);
            stageTypeDto.setStageOnGoing(true);
            StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
            ArrayList stages = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)stageSelectDto.getStageStart())) {
                stages.addAll(stageSelectDto.getStageStart());
            }
            if (CollectionUtil.isNotEmpty((Collection)stageSelectDto.getStageOnGoing())) {
                stages.addAll(stageSelectDto.getStageOnGoing());
            }
            dto.setCustomerStageIds(stages.stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getBusinessType()) && CrmBusinessTypeEnum.QUOTATION.getId().equals(dto.getBusinessType())) {
            dto.setOpopportunityType("1");
            CrmBaseConfigVo limsProductCategoryConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("lims_product_category_id");
            if (StringUtil.isNotEmpty((Object)limsProductCategoryConfig.getConfigValue())) {
                List limsProductCategoryIds = null;
                try {
                    limsProductCategoryIds = JSONObject.parseArray((String)limsProductCategoryConfig.getConfigValue(), Long.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (CollectionUtil.isNotEmpty((Collection)limsProductCategoryIds)) {
                    dto.setLimsProductCategoryIds(limsProductCategoryIds);
                    List dicVoList = this.sysDicRefService.getDicListByType("lims_quotation");
                    if (CollectionUtil.isNotEmpty((Collection)dicVoList)) {
                        List<Long> stageIds = dicVoList.stream().map(DicVo::getValue).map(Long::valueOf).collect(Collectors.toList());
                        dto.setLimsOpportunityStageIds(stageIds);
                    }
                }
            }
        }
        Page page = dto.getPage();
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        for (OpportunityDto opportunitydto : dtoList) {
            opportunitydto.setSevenDaysLater(sevenDaysLater);
            opportunitydto.setFifteenDaysLater(fifteenDaysLater);
            opportunitydto.setThirtyDaysLater(thirtyDaysLater);
            opportunitydto.setSearchKeyCustomerProfile(CommonUtills.escapeLike((String)opportunitydto.getSearchKeyCustomerProfile()));
        }
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmOpportunityListPermission(page, user.getUserId(), dtoList, permissionDto, campaignPermissionDto, dto.getTimeOrder(), null, null);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<OpportunityEntity> selectCrmOpportunityListNoPage(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto permissionDto = new PermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(user);
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        }
        dto = this.opportunityQueryCondition(dto);
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        for (OpportunityDto opportunitydto : dtoList) {
            opportunitydto.setSevenDaysLater(sevenDaysLater);
            opportunitydto.setFifteenDaysLater(fifteenDaysLater);
            opportunitydto.setThirtyDaysLater(thirtyDaysLater);
            opportunitydto.setSearchKeyCustomerProfile(CommonUtills.escapeLike((String)opportunitydto.getSearchKeyCustomerProfile()));
        }
        return this.opportunityMapper.selectCrmOpportunityListPermission(null, user.getUserId(), dtoList, permissionDto, campaignPermissionDto, dto.getTimeOrder(), null, null);
    }

    private OpportunityDto opportunityQueryCondition(OpportunityDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"6".equals(dto.getEndTime()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getEndTime())) != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange()) && !"6".equals(dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        dto.setDelFlag("0");
        return dto;
    }

    @Override
    public Long selectCrmOpportunityCount(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto opportunityPermissionDto = new PermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        if (byPermission.booleanValue()) {
            opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        }
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        dto.setDelFlag("0");
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        dto.setSevenDaysLater(sevenDaysLater);
        dto.setFifteenDaysLater(fifteenDaysLater);
        dto.setThirtyDaysLater(thirtyDaysLater);
        dtoList.add(dto);
        return this.opportunityMapper.selectCrmOpportunityCount(user.getUserId(), dtoList, opportunityPermissionDto, campaignPermissionDto);
    }

    @Override
    public Long selectCrmOpportunityCountAgent(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        PermissionDto opportunityPermissionDto = new PermissionDto();
        PermissionDto campaignPermissionDto = new PermissionDto();
        if (byPermission.booleanValue()) {
            opportunityPermissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        }
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        dto.setDelFlag("0");
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        dto.setSevenDaysLater(sevenDaysLater);
        dto.setFifteenDaysLater(fifteenDaysLater);
        dto.setThirtyDaysLater(thirtyDaysLater);
        dtoList.add(dto);
        return this.opportunityMapper.selectCrmOpportunityCountAgent(user.getUserId(), dtoList, opportunityPermissionDto, campaignPermissionDto);
    }

    private PermissionDto opportunityOperate(SecurityUser user) {
        PermissionDto permissionDto = this.opportunityDataRightModuleService.getUserRolePermission(user);
        return permissionDto;
    }
}

