/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.vo.CustomerLastWinAndCreateTime;
import com.jxdinfo.crm.core.job.service.CustomerStageAutoUpdateService;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerStageAutoUpdateServiceImpl
implements CustomerStageAutoUpdateService {
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public ProcessResult updateCustomerStage() {
        List<Long> customerIdList = this.customerMapper.selectCustomerUnchangedStage();
        List opportunityAPIVoList = this.opportunityAPIService.selectOpportunityByCustomerIdList(customerIdList);
        Map<Long, List<OpportunityAPIVo>> opportunityListMap = opportunityAPIVoList.stream().collect(Collectors.groupingBy(OpportunityAPIVo::getCustomerId));
        int silentValue = Integer.parseInt(this.crmBaseConfigBoService.getCrmBaseConfigByKey("silent_threshold").getConfigValue());
        int lostValue = Integer.parseInt(this.crmBaseConfigBoService.getCrmBaseConfigByKey("lost_threshold").getConfigValue());
        ArrayList<Long> winCustomerIdList = new ArrayList<Long>();
        ArrayList<Map<String, String>> updateMap = new ArrayList<Map<String, String>>();
        HashMap<Long, Integer> countWinMap = new HashMap<Long, Integer>();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageConvert(true);
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageAbandon(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageWin = stageSelectDto.getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        List stageLose = stageSelectDto.getStageLose().stream().map(String::valueOf).collect(Collectors.toList());
        List stageConvert = stageSelectDto.getStageConvert().stream().map(String::valueOf).collect(Collectors.toList());
        List stageStart = stageSelectDto.getStageStart().stream().map(String::valueOf).collect(Collectors.toList());
        List stageAbandon = stageSelectDto.getStageAbandon().stream().map(String::valueOf).collect(Collectors.toList());
        for (Long customerId : customerIdList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", customerId.toString());
            if (opportunityListMap.get(customerId) == null) {
                map.put("stage", "1");
                updateMap.add(map);
                continue;
            }
            List<OpportunityAPIVo> opportunityList = opportunityListMap.get(customerId);
            int countWin = 0;
            int countStart = 0;
            int countInProgress = 0;
            for (OpportunityAPIVo vo : opportunityList) {
                String opportunityStageId = vo.getCustomerStageId();
                if (stageWin.contains(opportunityStageId)) {
                    ++countWin;
                    continue;
                }
                if (stageStart.contains(opportunityStageId)) {
                    ++countStart;
                    continue;
                }
                if (stageLose.contains(opportunityStageId) || stageAbandon.contains(opportunityStageId) || stageConvert.contains(opportunityStageId)) continue;
                ++countInProgress;
            }
            if (countWin == 0) {
                if (countStart == 0 && countInProgress == 0) {
                    map.put("stage", "1");
                    updateMap.add(map);
                    continue;
                }
                if (countStart > 0 && countInProgress == 0) {
                    map.put("stage", "2");
                    updateMap.add(map);
                    continue;
                }
                map.put("stage", "3");
                updateMap.add(map);
                continue;
            }
            winCustomerIdList.add(customerId);
            countWinMap.put(customerId, countWin);
        }
        LocalDate dateNow = LocalDate.now();
        if (!CollectionUtils.isEmpty(winCustomerIdList)) {
            List<CustomerLastWinAndCreateTime> customerTimeList = this.customerMapper.selectCustomerOpportunityTime(winCustomerIdList);
            boolean successDateNotExistFlag = false;
            for (CustomerLastWinAndCreateTime customerTime : customerTimeList) {
                if (customerTime.getLastSuccessDate() == null) continue;
                Long customerId = customerTime.getCustomerId();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", customerId.toString());
                LocalDate lastDate = customerTime.getLastCreateDate().isBefore(customerTime.getLastSuccessDate()) ? customerTime.getLastSuccessDate() : customerTime.getLastCreateDate();
                long monthBetween = ChronoUnit.MONTHS.between(lastDate, dateNow);
                if (monthBetween <= (long)silentValue) {
                    if ((Integer)countWinMap.get(customerId) == 1) {
                        map.put("stage", "4");
                    } else {
                        map.put("stage", "5");
                    }
                } else if (monthBetween > (long)silentValue && monthBetween <= (long)lostValue) {
                    map.put("stage", "6");
                } else {
                    map.put("stage", "7");
                }
                updateMap.add(map);
            }
        }
        this.customerMapper.updateCustomerStage(updateMap);
        return new ProcessResult(true);
    }
}

