/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.bid.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.associateQuery.service.ICommonAssociateQueryService;
import com.jxdinfo.crm.core.bid.dto.BidAssociativeQueryDto;
import com.jxdinfo.crm.core.bid.dto.BidDto;
import com.jxdinfo.crm.core.bid.service.IBidAssociativeQueryService;
import com.jxdinfo.crm.core.bid.vo.BidAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BidAssociativeQueryServiceImpl
implements IBidAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private ICommonAssociateQueryService commonAssociateQueryService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        BidAssociativeQueryDto bidAssociativeQueryDto = null;
        if (associativeQueryDto instanceof BidAssociativeQueryDto) {
            bidAssociativeQueryDto = (BidAssociativeQueryDto)associativeQueryDto;
        }
        assert (bidAssociativeQueryDto != null);
        BidDto bidDto = bidAssociativeQueryDto.getDto();
        String createTimeRangeData = null;
        String bidStartTime = null;
        String bidPurchaseEndTime = null;
        String bidSubmitEndTime = null;
        String bidOpenDate = null;
        String createUser = null;
        String bidName = null;
        String customerName = null;
        Object chargePersonName = null;
        List<String> chargePersonList = null;
        List<String> bidStageList = null;
        if (bidDto != null) {
            createTimeRangeData = bidDto.getCreateTimeFlag();
            bidStartTime = bidDto.getBidStartTimeFlag();
            bidPurchaseEndTime = bidDto.getBidPurchaseEndTimeFlag();
            bidSubmitEndTime = bidDto.getBidSubmitEndTimeFlag();
            bidOpenDate = bidDto.getBidOpenDateFlag();
            createUser = bidDto.getCreateUser();
            bidName = bidDto.getBidName();
            customerName = bidDto.getCustomerName();
            chargePersonList = bidDto.getChargePersonList();
            bidStageList = bidDto.getBidStageList();
        }
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonName");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonList, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonName", selectedChargePersonIds);
        List selectedCreateTimeRangeData = excludeInfoMap.get("selectedCreateTimeRangeData");
        selectedCreateTimeRangeData = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimeRangeData, createTimeRangeData, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimeRangeData", selectedCreateTimeRangeData);
        List selectedBidStartTime = excludeInfoMap.get("selectedBidStartTime");
        selectedBidStartTime = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedBidStartTime, bidStartTime, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_START_TIME));
        excludeInfoMap.put("selectedBidStartTime", selectedBidStartTime);
        List selectedBidPurchaseEndTime = excludeInfoMap.get("selectedBidPurchaseEndTime");
        selectedBidPurchaseEndTime = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedBidPurchaseEndTime, bidPurchaseEndTime, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_PURCHASE_END_TIME));
        excludeInfoMap.put("selectedBidPurchaseEndTime", selectedBidPurchaseEndTime);
        List selectedBidSubmitEndTime = excludeInfoMap.get("selectedBidSubmitEndTime");
        selectedBidSubmitEndTime = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedBidSubmitEndTime, bidSubmitEndTime, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_SUBMIT_END_TIME));
        excludeInfoMap.put("selectedBidSubmitEndTime", selectedBidSubmitEndTime);
        List selectedBidOpenDate = excludeInfoMap.get("selectedBidOpenDate");
        selectedBidOpenDate = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedBidOpenDate, bidOpenDate, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_OPEN_DATE));
        excludeInfoMap.put("selectedBidOpenDate", selectedBidOpenDate);
        List<String> selectedBidStage = excludeInfoMap.get("selectedBidStage");
        selectedBidStage = this.commonAssociateQueryService.getOpptyStageProcessAssociativeQuery(associativeQueryVoList, keyword, selectedBidStage, bidStageList, this.getAssociateLabelVoByEnum(BidAssociativeQueryEnum.BID_STAGE));
        excludeInfoMap.put("selectedBidStage", selectedBidStage);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(BidAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

