/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.jxdIM.util;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientUtil {
    private static Logger log = LogManager.getLogger(HttpClientUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> post(String url, String body, String token) {
        Map map = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(url);
            if (StringUtil.isNotEmpty((Object)token)) {
                post.setHeader("Authorization", token);
            }
            StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            map = (Map)JsonUtil.parse((String)result, Map.class);
            if (!"true".equals(map.get("data"))) {
                log.info("post http\u8bf7\u6c42url\uff1a" + url);
                log.info("post http\u8bf7\u6c42body\uff1a" + body);
                log.info("post http\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> post(String url, String body, String token, String clientId) {
        Map map = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(url);
            if (StringUtil.isNotEmpty((Object)token)) {
                post.setHeader("Authorization", token);
            }
            if (StringUtil.isNotEmpty((Object)clientId)) {
                post.setHeader("client-id", clientId);
            }
            StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            map = (Map)JsonUtil.parse((String)result, Map.class);
            if (!"true".equals(map.get("data"))) {
                log.info("post http\u8bf7\u6c42url\uff1a" + url);
                log.info("post http\u8bf7\u6c42body\uff1a" + body);
                log.info("post http\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> get(String url, Map<String, String> header) {
        Map map = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        String result = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpGet get = new HttpGet(url);
            if (CollectionUtil.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!"true".equals((map = (Map)JsonUtil.parse((String)(result = EntityUtils.toString((HttpEntity)(entity = (response = httpClient.execute((HttpUriRequest)get)).getEntity()), (String)"utf-8")), Map.class)).get("data"))) {
                log.info("get http\u8bf7\u6c42url\uff1a" + url);
                log.info("get http\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            }
        }
        catch (Exception e) {
            log.error("get http\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        }
        finally {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

