/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.message.config.AliyunSmsProperty;
import com.jxdinfo.crm.core.message.dao.ShortMessageRecordMapper;
import com.jxdinfo.crm.core.message.dto.ShortMessageDTO;
import com.jxdinfo.crm.core.message.model.DataStatusEnum;
import com.jxdinfo.crm.core.message.model.SendSmsParam;
import com.jxdinfo.crm.core.message.model.ShortMessageRecord;
import com.jxdinfo.crm.core.message.service.ShortMessageRecordService;
import com.jxdinfo.crm.core.message.util.AliyunSmsUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.push.model.CodeEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortMessageRecordServiceImpl
extends ServiceImpl<ShortMessageRecordMapper, ShortMessageRecord>
implements ShortMessageRecordService {
    @Autowired
    private CustomerMapper customerMapper;
    @Resource
    private AliyunSmsProperty aliyunSmsProperty;
    @Resource
    private CustomerService customerService;

    @Override
    public ApiResponse<Boolean> checkVerificationCode(String phoneNumber, String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ShortMessageRecord::getPhoneNumber, (Object)phoneNumber)).eq(ShortMessageRecord::getVerifyCode, (Object)code)).eq(ShortMessageRecord::getDataStatus, (Object)DataStatusEnum.ENABLE.ordinal())).orderByDesc(ShortMessageRecord::getTimestamp);
        List list = this.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return ApiResponse.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        ShortMessageRecord messageRecordDO = (ShortMessageRecord)((Object)list.get(0));
        if (messageRecordDO.getValidTime() == null || Long.parseLong(messageRecordDO.getValidTime()) < System.currentTimeMillis()) {
            return ApiResponse.fail((String)"\u8be5\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        UpdateWrapper shortMessageUpdateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)shortMessageUpdateWrapper.eq((Object)"pk_sms_record", (Object)messageRecordDO.getPkSmsRecord())).set((Object)"data_status", (Object)DataStatusEnum.DISABLE.ordinal())).set((Object)"last_time", (Object)DateUtil.now());
        this.update((Wrapper)shortMessageUpdateWrapper);
        return ApiResponse.success((String)"OK");
    }

    @Override
    public ApiResponse<Boolean> sendShortMsg(String mobilePhone) {
        HashMap result;
        if (!this.aliyunSmsProperty.isEnable()) {
            return ApiResponse.fail((String)"\u672a\u5f00\u542f\u529f\u80fd");
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper1.eq(CustomerEntity::getTelephone, (Object)mobilePhone)).like(CustomerEntity::getCustomerType, (Object)2);
        List list1 = this.customerMapper.selectList((Wrapper)queryWrapper1);
        if (list1.size() == 0) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u5408\u4f5c\u4f19\u4f34");
        }
        ShortMessageDTO shortMessageDTO = new ShortMessageDTO();
        shortMessageDTO.setPhoneNumber(mobilePhone);
        shortMessageDTO.setType(0);
        CodeEnum codeEnum = this.checkShortMessageDTO(shortMessageDTO, this.aliyunSmsProperty.getTemplate().length);
        if (!codeEnum.equals((Object)CodeEnum.SUCCESS)) {
            return ApiResponse.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"PHONE_NUMBER", (Object)shortMessageDTO.getPhoneNumber())).eq((Object)"OPERATE_TYPE", (Object)shortMessageDTO.getType())).ge((Object)"TIMESTAMP", (Object)(System.currentTimeMillis() - (long)this.aliyunSmsProperty.getLimitedTime().intValue()));
        List list = this.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            if (((ShortMessageRecord)((Object)list.get(0))).getTimestamp() + (long)this.aliyunSmsProperty.getTimeInterval().intValue() > System.currentTimeMillis()) {
                return ApiResponse.fail((String)"\u53d1\u9001\u77ed\u4fe1\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            if (list.size() >= this.aliyunSmsProperty.getTimes()) {
                return ApiResponse.fail(null, (String)"\u53d1\u9001\u77ed\u4fe1\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        ShortMessageRecord recordDO = new ShortMessageRecord();
        recordDO.setOperateType(shortMessageDTO.getType());
        recordDO.setValidTime(String.valueOf(System.currentTimeMillis() + (long)this.aliyunSmsProperty.getValidTime().intValue()));
        recordDO.setPhoneNumber(shortMessageDTO.getPhoneNumber());
        recordDO.setPkSmsRecord(IdUtil.randomUUID());
        recordDO.setVerifyCode(IntStream.range(0, 6).mapToObj(i -> String.valueOf(new Random().nextInt(10))).collect(Collectors.joining()));
        recordDO.setDataStatus(DataStatusEnum.ENABLE.ordinal());
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("code", recordDO.getVerifyCode());
        SendSmsParam sendSmsParam = new SendSmsParam();
        sendSmsParam.setPhoneNumbers(recordDO.getPhoneNumber());
        sendSmsParam.setTemplateCode(this.aliyunSmsProperty.getTemplate()[shortMessageDTO.getType()]);
        sendSmsParam.setTemplateParam(JSON.toJSONString(hashMap));
        recordDO.setContent(sendSmsParam.getTemplateParam());
        try {
            result = (HashMap)JSON.parseObject((String)AliyunSmsUtil.sendSms(this.aliyunSmsProperty, sendSmsParam), (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
        }
        catch (ClientException e) {
            this.log.error("\u8c03\u7528\u963f\u91cc\u4e91\u77ed\u4fe1\u670d\u52a1\u5931\u8d25");
            return ApiResponse.fail((String)"\u8c03\u7528\u77ed\u4fe1\u670d\u52a1\u5931\u8d25");
        }
        String code = "Code";
        String succeed = "OK";
        if (!succeed.equals(result.get(code))) {
            if ("isv.BUSINESS_LIMIT_CONTROL".equals(result.get(code))) {
                ApiResponse.fail((String)"\u8be5\u53f7\u7801\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8fc7\u591a");
            }
            this.log.error("\u8c03\u7528\u963f\u91cc\u4e91\u77ed\u4fe1\u670d\u52a1\u6210\u529f,\u8fd4\u56de\u7ed3\u679c\u5931\u8d25");
            return ApiResponse.fail((String)"\u8c03\u7528\u77ed\u4fe1\u670d\u52a1\u5931\u8d25");
        }
        recordDO.setTimestamp(System.currentTimeMillis());
        this.save((Object)recordDO);
        return ApiResponse.success((String)"OK");
    }

    @Override
    public CodeEnum checkShortMessageDTO(ShortMessageDTO shortMessageDTO, int length) {
        if (StrUtil.isEmpty((CharSequence)shortMessageDTO.getPhoneNumber()) || null == shortMessageDTO.getType()) {
            return CodeEnum.MISSING_PARAMETER;
        }
        if (shortMessageDTO.getType() < 0 || shortMessageDTO.getType() >= length) {
            return CodeEnum.PARAMTER_PARSE_ERROR;
        }
        return CodeEnum.SUCCESS;
    }
}

