/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.core.associateQuery.service.ICommonAssociateQueryService;
import com.jxdinfo.crm.core.leads.dto.LeadsAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.leads.service.LeadsAssociativeQueryService;
import com.jxdinfo.crm.core.leads.vo.LeadsAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadsAssociativeQueryServiceImpl
implements LeadsAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private ICommonAssociateQueryService commonAssociateQueryService;
    @Resource
    private IDictBoService dictBoService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        LeadsAssociativeQueryDto leadsAssociativeQueryDto = null;
        if (associativeQueryDto instanceof LeadsAssociativeQueryDto) {
            leadsAssociativeQueryDto = (LeadsAssociativeQueryDto)associativeQueryDto;
        }
        assert (leadsAssociativeQueryDto != null);
        LeadsDto leadsDto = leadsAssociativeQueryDto.getDto();
        List labelIdList = null;
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        String createTimeTage = null;
        List<Long> provinceList = null;
        String overdueFollow = null;
        List<String> fromList = null;
        List<String> productIds = null;
        List<Long> campaignIds = null;
        List<String> createDepartments = null;
        List<String> states = null;
        if (leadsDto != null) {
            ownDepartmentList = leadsDto.getOwnDepartments();
            chargePersonIdList = leadsDto.getChargePersonIds();
            createTimeTage = leadsDto.getCreateTimeFlag();
            provinceList = leadsDto.getProvinces();
            overdueFollow = leadsDto.getOverdueFollow();
            fromList = leadsDto.getLeadsOrigins();
            productIds = leadsDto.getProductIds();
            campaignIds = leadsDto.getCampaignIds();
            createDepartments = leadsDto.getCreateDepartments();
            states = leadsDto.getStates();
        }
        String moduleId = LabelModuleEnum.LEAD.getModuleId();
        List selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryAPIService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelIdList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_OWN_DEPARTMENTS));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List<String> selectedStates = excludeInfoMap.get("selectedStates");
        selectedStates = this.commonAssociateQueryService.getStateAssociativeQuery(associativeQueryVoList, keyword, selectedStates, states, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_STATE));
        excludeInfoMap.put("selectedStates", selectedStates);
        List selectedFroms = excludeInfoMap.get("selectedFroms");
        selectedFroms = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedFroms, fromList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_FROM));
        excludeInfoMap.put("selectedFroms", selectedFroms);
        List<String> selectedCampaignIds = excludeInfoMap.get("selectedCampaignIds");
        selectedCampaignIds = this.commonAssociateQueryService.getCampaignIdAssociativeQuery(associativeQueryVoList, keyword, selectedCampaignIds, campaignIds, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_CAMPAIGN));
        excludeInfoMap.put("selectedCampaignIds", selectedCampaignIds);
        List<String> selectedProducts = excludeInfoMap.get("selectedProducts");
        selectedProducts = this.commonAssociateQueryService.getProductAssociativeQuery(associativeQueryVoList, keyword, selectedProducts, productIds, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_PRODUCT_TYPES));
        excludeInfoMap.put("selectedProducts", selectedProducts);
        List selectedProvinces = excludeInfoMap.get("selectedProvinces");
        selectedProvinces = this.associativeFiledQueryAPIService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinces, provinceList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_PROVINCE));
        excludeInfoMap.put("selectedProvinces", selectedProvinces);
        List selectedCreateDepartments = excludeInfoMap.get("selectedCreateDepartments");
        selectedCreateDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedCreateDepartments, createDepartments, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEADS_CREATE_DEPT));
        excludeInfoMap.put("selectedCreateDepartments", selectedCreateDepartments);
        List<String> selectedOverdues = excludeInfoMap.get("selectedOverdues");
        selectedOverdues = this.commonAssociateQueryService.getOverdueAssociativeQuery(associativeQueryVoList, keyword, selectedOverdues, overdueFollow);
        excludeInfoMap.put("selectedOverdues", selectedOverdues);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

