/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.fileinfo.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.core.api.fileinfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FileInfoAPIServiceImpl
implements IFileInfoAPIService {
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FileInfoService fileInfoService;

    public int insertFileInfo(FileInfoAPIDto fileInfoDto) {
        List ids = fileInfoDto.getIds();
        String businessId = fileInfoDto.getBusinessId();
        if (ids == null || ids.size() == 0) {
            return -1;
        }
        ArrayList<String> idTemp = new ArrayList<String>();
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            idTemp.add(id);
        }
        if (idTemp.size() == 0) {
            return -1;
        }
        List<Long> lids = idTemp.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.fileInfoMapper.updateBusinessIdByIds(lids, Long.valueOf(businessId));
    }

    public void deleteHighSecurityLevelFileInfo(Long businessId, Integer securityLevel) {
        List fileInfoList;
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, new Object[]{businessId})).ne(FileInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)securityLevel)) {
            fileInfoQueryWrapper.gt(FileInfo::getSecurityLevel, (Object)securityLevel);
        }
        if (HussarUtils.isNotEmpty((Object)(fileInfoList = this.fileInfoMapper.selectList((Wrapper)fileInfoQueryWrapper)))) {
            List<Long> lids = fileInfoList.stream().map(FileInfo::getId).collect(Collectors.toList());
            this.fileInfoMapper.deleteFileInfoByIds(lids, null, "1");
        }
    }

    public void updateTrackFileInfoSecurityLevel(Long businessId, Integer securityLevel) {
        List trackRecordIds = this.trackRecordAPIService.selectTrackRecordIdByBusinessId(businessId);
        if (CollectionUtils.isNotEmpty((Collection)trackRecordIds)) {
            this.fileInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getBusinessId, (Collection)trackRecordIds)).eq(FileInfo::getDelFlag, (Object)"0")).set(FileInfo::getSecurityLevel, (Object)securityLevel));
        }
    }
}

