/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.customer.service.ICustomerDataRightModuleService;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.customer.dao.CustomerPermissionMapper;
import com.jxdinfo.crm.core.customer.service.ICustomerPermissionService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerPermissionServiceImpl
implements ICustomerPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CustomerPermissionMapper customerPermissionMapper;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private ICustomerDataRightModuleService customerDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;

    @Override
    public List<Long> getCustomerIdListByPermission(Long userId) {
        PermissionDto campaignPermissionDto;
        PermissionDto customerPermissionDto;
        if (userId == null) {
            customerPermissionDto = this.customerDataRightModuleService.getCurrentUserRolePermissions();
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getCurrentUserRolePermissions();
        } else {
            customerPermissionDto = this.customerDataRightModuleService.getUserRolePermissionsByUserId(userId);
            campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermissionsByUserId(userId);
        }
        if (customerPermissionDto.getPermissionDeptIds() == null && customerPermissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> customerIdList = this.customerPermissionMapper.getCustomerIdList(customerPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isEmpty(customerIdList)) {
            customerIdList.add(-1L);
        }
        return customerIdList;
    }
}

