/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.core.utills.ExcelHeader;
import com.jxdinfo.crm.core.utills.ExcelStyle;
import com.jxdinfo.crm.core.utills.entity.ExcelRegionDto;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class WriteExcel {
    public void writeBigExcel(HttpServletResponse response, List<?> dataList, String fileName, Class clazz) {
        this.writeBigExcel(response, dataList, fileName, clazz, null, null);
    }

    public void writeBigExcel(HttpServletResponse response, List<?> dataList, String fileName, Class clazz, List<ExcelRegionDto> regionList) {
        this.writeBigExcel(response, dataList, fileName, clazz, null, regionList);
    }

    public void writeBigExcel(HttpServletResponse response, List<?> dataList, String fileName, Class clazz, List<List<String>> dynamicHead, List<ExcelRegionDto> regionList) {
        ArrayList<String> property = new ArrayList<String>();
        ArrayList<Integer> cellWith = new ArrayList<Integer>();
        int cellHeight = 30;
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<List<Object>> titleNameList = new ArrayList<List<Object>>();
        for (Field field : fields) {
            String[] value;
            ExcelHeader annotation = field.getAnnotation(ExcelHeader.class);
            if (annotation == null || annotation.value().length == 0 || "".equals((value = annotation.value())[0])) continue;
            property.add(field.getName());
            for (int i = 0; i < value.length; ++i) {
                if (titleNameList.size() <= i) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value[i]);
                    titleNameList.add(list);
                    continue;
                }
                ((List)titleNameList.get(i)).add(value[i]);
            }
            int width = annotation.width();
            cellWith.add(width);
        }
        if (null != dynamicHead) {
            for (int i = 0; i < dynamicHead.size(); ++i) {
                titleNameList.add(i, dynamicHead.get(i));
            }
        }
        try {
            int row;
            HSSFWorkbook workbook = new HSSFWorkbook();
            String lastFileName = fileName + ".xls";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            int sheetNum = 0;
            int colNumCount = ((List)titleNameList.get(0)).size();
            int rowNumCount = titleNameList.size();
            int totalWidth = 0;
            Iterator iterator = cellWith.iterator();
            while (iterator.hasNext()) {
                int len = (Integer)iterator.next();
                totalWidth += len;
            }
            String sheetName = "sheet";
            HSSFSheet sheet = workbook.createSheet(sheetName + (sheetNum + 1));
            CellStyle columnStyle = ExcelStyle.getColumnStyle((Workbook)workbook);
            for (row = 0; row < rowNumCount; ++row) {
                HSSFRow titleNameRow = workbook.getSheet(sheetName + (sheetNum + 1)).createRow(row);
                titleNameRow.setHeightInPoints((float)cellHeight);
                for (int col = 0; col < colNumCount; ++col) {
                    Cell cell = titleNameRow.createCell(col);
                    cell.setCellValue((String)((List)titleNameList.get(row)).get(col));
                    sheet.setColumnWidth(col, (Integer)cellWith.get(col) * 256);
                    cell.setCellStyle(columnStyle);
                }
            }
            for (row = 0; row < titleNameList.size(); ++row) {
                List rowList = (List)titleNameList.get(row);
                CellRangeAddress region = new CellRangeAddress(0, 0, 0, 0);
                region.setFirstRow(row);
                region.setLastRow(row);
                boolean saveStart = false;
                boolean saveEnd = false;
                int rowLen = rowList.size();
                for (int col = 0; col < rowLen; ++col) {
                    int before = col - 1;
                    if (col == 0) continue;
                    boolean eqBef = ((String)rowList.get(col)).equals(rowList.get(before));
                    if (!saveStart && eqBef) {
                        region.setFirstColumn(before);
                        saveStart = true;
                    }
                    if (saveStart && !eqBef) {
                        region.setLastColumn(before);
                        saveEnd = true;
                    } else if (saveStart && col == rowLen - 1) {
                        region.setLastColumn(col);
                        saveEnd = true;
                    }
                    if (!saveStart || !saveEnd) continue;
                    sheet.addMergedRegion(region);
                    saveStart = false;
                    saveEnd = false;
                }
            }
            for (int col = 0; col < ((List)titleNameList.get(0)).size(); ++col) {
                CellRangeAddress region = new CellRangeAddress(0, 0, 0, 0);
                region.setFirstColumn(col);
                region.setLastColumn(col);
                boolean saveStart = false;
                boolean saveEnd = false;
                int colLen = titleNameList.size();
                for (int row2 = 0; row2 < colLen; ++row2) {
                    int up = row2 - 1;
                    if (row2 == 0) continue;
                    boolean eqBef = ((String)((List)titleNameList.get(row2)).get(col)).equals(((List)titleNameList.get(up)).get(col));
                    if (!saveStart && eqBef) {
                        region.setFirstRow(up);
                        saveStart = true;
                    }
                    if (saveStart && !eqBef) {
                        region.setLastRow(up);
                        saveEnd = true;
                    } else if (saveStart && row2 == colLen - 1) {
                        region.setLastRow(row2);
                        saveEnd = true;
                    }
                    if (!saveStart || !saveEnd) continue;
                    sheet.addMergedRegion(region);
                    saveStart = false;
                    saveEnd = false;
                }
            }
            int maxLine = 0x100000;
            String floatDecimal = "0.00";
            String doubleDecimal = "0.00";
            Object colFormula = null;
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            if (dataList != null && dataList.size() > 0) {
                if (property.size() > 0) {
                    for (int index = 0; index < dataList.size(); ++index) {
                        int rowIndex = index < maxLine ? index + rowNumCount : index - maxLine * (index / maxLine) + rowNumCount;
                        HSSFRow dataRow = workbook.getSheet(sheetName + (sheetNum + 1)).createRow(rowIndex);
                        Object obj = dataList.get(index);
                        Class<?> currentClazz = obj.getClass();
                        CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
                        for (int columnIndex = 0; columnIndex < property.size(); ++columnIndex) {
                            String title = ((String)property.get(columnIndex)).trim();
                            if ("".equals(title)) continue;
                            String uTitle = Character.toUpperCase(title.charAt(0)) + title.substring(1, title.length());
                            String methodName = "get" + uTitle;
                            Method method = currentClazz.getDeclaredMethod(methodName, new Class[0]);
                            String returnType = method.getReturnType().getName();
                            Object object = method.invoke(obj, new Object[0]);
                            String data = method.invoke(obj, new Object[0]) == null ? "" : object.toString();
                            Cell cell = dataRow.createCell(columnIndex);
                            if ("java.lang.Double".equals(returnType)) {
                                style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
                                cell.setCellType(CellType.NUMERIC);
                            }
                            cell.setCellStyle(style);
                            if (data != null && !"".equals(data)) {
                                if ("int".equals(returnType)) {
                                    cell.setCellValue((double)Integer.parseInt(data));
                                    continue;
                                }
                                if ("long".equals(returnType)) {
                                    cell.setCellValue((double)Long.parseLong(data));
                                    continue;
                                }
                                if ("float".equals(returnType)) {
                                    cell.setCellValue(new DecimalFormat("0.00").format(Float.parseFloat(data)));
                                    continue;
                                }
                                if ("double".equals(returnType) || "java.lang.Double".equals(returnType)) {
                                    cell.setCellValue(Double.parseDouble(data));
                                    continue;
                                }
                                if (Date.class.getName().equals(returnType)) {
                                    cell.setCellValue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(object));
                                    continue;
                                }
                                if (returnType.contains("Timestamp")) {
                                    cell.setCellValue(fmt.format(object));
                                    continue;
                                }
                                if (LocalDateTime.class.getName().equals(returnType)) {
                                    cell.setCellValue(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format((LocalDateTime)object));
                                    continue;
                                }
                                cell.setCellValue(data);
                                continue;
                            }
                            if (colFormula == null) continue;
                            String sixBuf = colFormula[columnIndex].replace("@", rowIndex + 1 + "");
                            cell = dataRow.createCell(columnIndex);
                            cell.setCellFormula(sixBuf);
                        }
                    }
                }
                if (CollectionUtil.isNotEmpty(regionList)) {
                    for (ExcelRegionDto excelRegionDto : regionList) {
                        int firstRow = excelRegionDto.getFirstRow() + rowNumCount;
                        int lastRow = excelRegionDto.getLastRow() + rowNumCount;
                        int firstCol = excelRegionDto.getFirstCol();
                        int lastCol = excelRegionDto.getLastCol();
                        CellRangeAddress thisRegion = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
                        sheet.addMergedRegion(thisRegion);
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

