/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadCustomerExcelUtil {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;

    public static List<CustomerEntity> getExcelInfoCustomer(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadCustomerExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadCustomerExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<CustomerEntity> list = ReadCustomerExcelUtil.createExcelCustomer(mFile.getInputStream(), isExcel2003);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<CustomerEntity> createExcelCustomer(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<CustomerEntity> customerEntities = ReadCustomerExcelUtil.readExcelValueCustomer((Workbook)wb);
            return customerEntities;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<CustomerEntity> readExcelValueCustomer(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<CustomerEntity> customerEntityList = new ArrayList<CustomerEntity>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            CustomerEntity customer = new CustomerEntity();
            block21: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerReferredName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerType(cell.getStringCellValue());
                        continue block21;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setSuperiorCustomerName(cell.getStringCellValue());
                        continue block21;
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustLevel(cell.getStringCellValue());
                        continue block21;
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setTrade(cell.getStringCellValue());
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setOtherTrade(cell.getStringCellValue());
                        continue block21;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerAttribute(cell.getStringCellValue());
                        continue block21;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerStage(cell.getStringCellValue());
                        continue block21;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setTelephone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 10: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerOrigin(cell.getStringCellValue());
                        continue block21;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCampaignName(cell.getStringCellValue());
                        continue block21;
                    }
                    case 12: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setAgentName(cell.getStringCellValue());
                        continue block21;
                    }
                    case 13: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCorporateScale(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 14: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCorporateImpact(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 15: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setListingStatus(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 16: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setCustomerRelation(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block21;
                    }
                    case 17: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        customer.setRemark(cell.getStringCellValue());
                        continue block21;
                    }
                }
            }
            customerEntityList.add(customer);
        }
        return customerEntityList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ReadCustomerExcelUtil.isExcel2003(filePath) && !ReadCustomerExcelUtil.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

