/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkTemplate(MultipartFile file, String[] expectedHeaders) {
        Object object;
        if (file.isEmpty()) {
            return "\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a";
        }
        String fileName = file.getOriginalFilename();
        Object workbook = null;
        try {
            InputStream inputStream = file.getInputStream();
            object = null;
            try {
                workbook = fileName.endsWith(".xlsx") ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);
                Sheet sheet = workbook.getSheetAt(0);
                if (sheet == null) {
                    String string = "Excel\u6587\u4ef6\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868";
                    return string;
                }
                Row headerRow = sheet.getRow(0);
                if (headerRow == null) {
                    String string = "Excel\u6587\u4ef6\u7b2c\u4e00\u884c\u4e3a\u7a7a";
                    return string;
                }
                ArrayList<String> actualHeaders = new ArrayList<String>();
                int i = 0;
                while (i < expectedHeaders.length) {
                    Cell cell = headerRow.getCell(i);
                    String cellValue = ExcelImportUtil.getCellValue(cell);
                    actualHeaders.add(cellValue);
                    if (!expectedHeaders[i].equals(cellValue)) {
                        String string = "\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e\uff01";
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            object = "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25";
            return object;
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                double value = cell.getNumericCellValue();
                if (value == (double)((long)value)) {
                    return String.valueOf((long)value);
                }
                return String.valueOf(value);
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
        }
        return "";
    }
}

