/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CommonUtills {
    private static IdentifierGenerator identifierGenerator = new DefaultIdentifierGenerator();

    public static DateConvertVo getWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CommonUtills.dateResultMap(weekBegin, weekEnd);
    }

    public static DateConvertVo getLastWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CommonUtills.dateResultMap(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CommonUtills.dateResultMap(DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(monthStart, monthEnd);
    }

    public static DateConvertVo getLastMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 0);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getNextYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getLastYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, -1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CommonUtills.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getYesterday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, -1);
        String yesterday = format.format(cale.getTime());
        return CommonUtills.dateResultMap(yesterday, yesterday);
    }

    public static DateConvertVo getToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, 0);
        String today = format.format(cale.getTime());
        return CommonUtills.dateResultMap(today, today);
    }

    public static String generateAssignId() {
        String id = identifierGenerator.nextId(new Object()).toString();
        return id;
    }

    public static String translateUserId(String userId) {
        String translateUserId = null;
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        if (ToolUtil.isNotEmpty((Object)userId)) {
            translateUserId = userId.matches("[0-9]+") ? userId : customerMapper.translateUserId(userId);
        }
        return translateUserId;
    }

    public static String translateDepId(String depId) {
        String translateDepId = null;
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        if (ToolUtil.isNotEmpty((Object)depId)) {
            translateDepId = depId.matches("[0-9]+") ? depId : customerMapper.translateDepId(depId);
        }
        return translateDepId;
    }

    public static List<String> selectOpportunityTissueTreeUserId(String orgId, List<String> ids) {
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        List<Map<String, Object>> organIds = customerMapper.selectDep(orgId);
        if (ToolUtil.isNotEmpty(organIds) && organIds.size() > 0) {
            for (Map<String, Object> organId : organIds) {
                String id = organId.get("id").toString();
                if (id == orgId) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public static PersonWithDepInfo selectDepIdName(String newChargePersonId) {
        PersonWithDepInfo personWithDepInfo = new PersonWithDepInfo();
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        if (ToolUtil.isNotEmpty((Object)newChargePersonId)) {
            personWithDepInfo = customerMapper.selectDepIdName(newChargePersonId);
            assert (personWithDepInfo != null);
        }
        return personWithDepInfo;
    }

    public static List<Map<String, Object>> selectDepByUserId(String userId) {
        List<Map<String, Object>> depId = null;
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        if (ToolUtil.isNotEmpty((Object)userId)) {
            depId = customerMapper.selectDepByUserId(userId);
        }
        return depId;
    }

    public static void updateCustomerTrackTime(LocalDateTime trackTime, Long customerId) {
        CustomerMapper customerMapper = (CustomerMapper)SpringUtils.getBean(CustomerMapper.class);
        customerMapper.updateCustomerTrackTime(trackTime, customerId);
    }

    private static DateConvertVo dateResultMap(String startDate, String endDate) {
        DateConvertVo date = new DateConvertVo();
        date.setStartDate(startDate);
        date.setEndDate(endDate);
        return date;
    }

    public static void inviteLeadsOverdueFollowTime(LeadsDto dto, LocalDateTime date) {
        if (HussarUtils.isNotEmpty((Object)dto.getOverdueFollow())) {
            switch (dto.getOverdueFollow()) {
                case "1": {
                    dto.setOverdueFollowStartTime(date.plusDays(-15L));
                    dto.setOverdueFollowEndTime(date.plusDays(-7L));
                    break;
                }
                case "2": {
                    dto.setOverdueFollowStartTime(date.plusDays(-30L));
                    dto.setOverdueFollowEndTime(date.plusDays(-15L));
                    break;
                }
                case "3": {
                    dto.setOverdueFollowEndTime(date.plusDays(-30L));
                    break;
                }
                default: {
                    dto.setOverdueFollow("");
                }
            }
        }
    }

    public static DateConvertVo getQuarter() {
        LocalDate now = LocalDate.now();
        int startMonth = (now.getMonthValue() - 1) / 3 * 3 + 1;
        String startTime = LocalDate.of(now.getYear(), startMonth, 1).toString();
        int endMonth = ((now.getMonthValue() - 1) / 3 + 1) * 3;
        LocalDate endDate = LocalDate.of(now.getYear(), endMonth, 1);
        String endTime = endDate.withDayOfMonth(endDate.lengthOfMonth()).toString();
        return CommonUtills.dateResultMap(startTime, endTime);
    }
}

