/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.unify.util;

import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.service.SysMessageService;
import com.jxdinfo.crm.core.utills.NoticeUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.notice.dto.AddSysMessageDto;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class UnifyUtil {
    public static Long specialRoleId = 862695903377760256L;

    public static SalesStatisticsDto currentUserProvince(SalesStatisticsDto dto) {
        IUserBoService userBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
        SecurityUser user = HussarUtils.isNotEmpty((Object)dto.getCurrentUserId()) ? userBoService.selectSecurityByUserId(dto.getCurrentUserId()) : BaseSecurityUtil.getUser();
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        ArrayList<Long> provinceStruIdList = new ArrayList<Long>();
        List<Long> provinceIdList = commonMapper.selectAllProvinceStruId();
        IDataRightBoService dataRightBoService = (IDataRightBoService)SpringUtils.getBean(IDataRightBoService.class);
        List permissionDeptIds = dataRightBoService.getChargeDepartment(user.getUserId());
        if (CollectionUtil.isEmpty((Collection)permissionDeptIds)) {
            provinceStruIdList.addAll(provinceIdList);
        } else {
            permissionDeptIds.retainAll(provinceIdList);
            provinceStruIdList.addAll(permissionDeptIds);
        }
        dto.setPermissionDeptIds(provinceStruIdList);
        return dto;
    }

    public static List<Long> selectDeptIdParentId(List<Long> parentIds) {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<Long> deptIds = commonMapper.selectDeptIdParentId(parentIds);
        return deptIds;
    }

    public static List<Long> selectDeptIdRecurvePids(List<Long> parentIds) {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<Long> deptIds = commonMapper.selectDeptIdRecurvePids(parentIds);
        return deptIds;
    }

    public static void sendMessage(AddSysMessageType addSysMessageType) {
        CompletableFuture.runAsync(() -> {
            try {
                SysMessageService sysMessageService = (SysMessageService)SpringUtils.getBean(SysMessageService.class);
                sysMessageService.addSysMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                UnifyUtil.sendCrmMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void sendCrmMessage(AddSysMessageType addSysMessageType) {
        AddSysMessageDto addSysMessageDto = new AddSysMessageDto();
        addSysMessageDto.setMessageTypeId(addSysMessageType.getMessageTypeId());
        addSysMessageDto.setMessageTitle(addSysMessageType.getMessageContent());
        addSysMessageDto.setReleaseDate(LocalDateTime.parse(addSysMessageType.getReleaseDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageDto.setMessageContent(addSysMessageType.getMessageContent());
        addSysMessageDto.setDepartmentId(addSysMessageType.getDepartmentId());
        addSysMessageDto.setRoleId(addSysMessageType.getRoleId());
        addSysMessageDto.setUserId(addSysMessageType.getUserId());
        if (HussarUtils.isNotEmpty((Object)addSysMessageType.getCreatoeDepartmentId())) {
            addSysMessageDto.setCreatoeDepartmentId(Long.valueOf(Long.parseLong(addSysMessageType.getCreatoeDepartmentId())));
        }
        addSysMessageDto.setMessageIssue(addSysMessageType.getMessageIssue());
        addSysMessageDto.setCreator(addSysMessageType.getCreator());
        addSysMessageDto.setLastEditor(addSysMessageType.getLastEditor());
        addSysMessageDto.setReadFlag(addSysMessageDto.getReadFlag());
        addSysMessageDto.setDelFlag(addSysMessageDto.getDelFlag());
        addSysMessageDto.setBusinessAddress(addSysMessageType.getBusinessAddress());
        addSysMessageDto.setOpenWay("0");
        NoticeUtil.sendMessage(addSysMessageDto);
    }

    public static void defaultMessage(AddSysMessageType addSysMessageType, String messageContent, LocalDateTime date, SecurityUser user, String userId, String messageIssue, String businessAddress, String mobileBusinessAddress) {
        addSysMessageType.setMessageContent(messageContent);
        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
        addSysMessageType.setUserId(userId);
        if (user.getDeptId() != null) {
            addSysMessageType.setCreatoeDepartmentId(String.valueOf(user.getDeptId()));
        }
        addSysMessageType.setMessageIssue(messageIssue);
        addSysMessageType.setCreator(user.getUserId());
        addSysMessageType.setLastEditor(user.getUserId());
        addSysMessageType.setBusinessAddress(businessAddress);
        addSysMessageType.setMobileBusinessAddress(mobileBusinessAddress);
        addSysMessageType.setOpenWay("1");
    }
}

