/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.successcase.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.successcase.dao.OpportunitySuccessCaseMapper;
import com.jxdinfo.crm.core.successcase.model.OpportunitySuccessCase;
import com.jxdinfo.crm.core.successcase.service.OpportunitySuccessCaseService;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunitySuccessCaseServiceImpl
extends ServiceImpl<OpportunitySuccessCaseMapper, OpportunitySuccessCase>
implements OpportunitySuccessCaseService {
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private FileInfoService fileInfoService;

    @Override
    @Transactional
    public Boolean insertCrmOpportunitySuccessCase(OpportunitySuccessCase opportunitySuccessCase) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        Long deptId = user.getDeptId();
        String deptName = user.getDeptName();
        Long caseId = Long.valueOf(CommonUtills.generateAssignId());
        if (CollectionUtil.isNotEmpty(opportunitySuccessCase.getFileIds())) {
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setBusinessId(String.valueOf(caseId));
            fileInfoDto.setIds(opportunitySuccessCase.getFileIds());
            this.fileInfoService.insertFileInfo(fileInfoDto);
        }
        opportunitySuccessCase.setCaseId(caseId);
        opportunitySuccessCase.setCreatePerson(userId);
        opportunitySuccessCase.setCreatePersonName(userName);
        opportunitySuccessCase.setCreateTime(date);
        opportunitySuccessCase.setOwnDepartment(deptId);
        opportunitySuccessCase.setOwnDepartmentName(deptName);
        opportunitySuccessCase.setChangePerson(userId);
        opportunitySuccessCase.setChangePersonName(userName);
        opportunitySuccessCase.setChangeTime(date);
        opportunitySuccessCase.setDelFlag("0");
        this.save(opportunitySuccessCase);
        this.teamMeberService.insertTeamMember(userName, userId, caseId, "1", "1", date, "13");
        return true;
    }
}

