/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.product.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.docbase.service.DocbaseService;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.index.dao.CrmIndexMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.index.vo.SalesOpportunityProductCountVo;
import com.jxdinfo.crm.core.index.vo.SalesProductVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.dto.ProductAssociativeQueryDto;
import com.jxdinfo.crm.core.product.dto.PruductDto;
import com.jxdinfo.crm.core.product.dto.YyzcProductDto;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.IProductAssociativeQueryService;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.product.sync.SyncProductCallable;
import com.jxdinfo.crm.core.product.vo.ProductAnalysisAccountVo;
import com.jxdinfo.crm.core.product.vo.ProductCategorySearchVo;
import com.jxdinfo.crm.core.product.vo.ProductCategoryTreeVo;
import com.jxdinfo.crm.core.product.vo.ProductVo;
import com.jxdinfo.crm.core.product.vo.YyzcProductVo;
import com.jxdinfo.crm.core.productprice.dao.ProductPriceMapper;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.InitUnitDataUtill;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.crm.product.model.ProductCategory;
import com.jxdinfo.crm.product.model.ProductTargetProfileEntity;
import com.jxdinfo.crm.product.service.IProductTargetProfileService;
import com.jxdinfo.crm.product.service.ProductCategoryService;
import com.jxdinfo.crm.product.service.impl.ProductCategoryServiceImpl;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductMapper, Product>
implements ProductService {
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private ProductPriceMapper productPriceMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private CrmIndexMapper indexMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysStruService struService;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private DocbaseService docbaseService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IProductAssociativeQueryService productAssociativeQueryService;
    @Resource
    private IProductTargetProfileService productTargetProfileService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    private UnifyProperties unifyProperties;
    @Resource
    private ProductCategoryService productCategoryService;
    @Resource
    private FileInfoService fileInfoService;

    @Override
    public Page<Product> queryProductList(PruductDto pruductDto) {
        ProductCategoryService productCategoryService;
        String marketView;
        Page page = pruductDto.getPage();
        if (ToolUtil.isNotEmpty((Object)pruductDto.getMarketScreening())) {
            pruductDto.setMarketScreening(pruductDto.getMarketScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(pruductDto.getChargePersonIds()) && pruductDto.getChargePersonIds().size() > 0) {
            for (String userId : pruductDto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
        }
        InitUnitDataUtill.initForProduct(pruductDto);
        List<String> departments = pruductDto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> Ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
        }
        if ("2".equals(marketView = pruductDto.getMarketView())) {
            pruductDto.setMarketView(null);
        }
        if ("3".equals(marketView)) {
            pruductDto.setMarketView(null);
            pruductDto.setIsSubsidy("1");
        }
        pruductDto.setDelFlag("0");
        pruductDto.setCustomSearch(this.trackRecordAPIService.queryAnalize(pruductDto.getSearchId()));
        List<String> productTypes = pruductDto.getProductTypes();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        pruductDto.setWinStateIds(stageWin);
        List<Long> childrenList = null;
        if (ToolUtil.isNotEmpty(pruductDto.getProductCategoryIds()) && ToolUtil.isEmpty(childrenList = this.productMapper.getAllCategoryChildren(pruductDto.getProductCategoryIds()))) {
            childrenList.addAll(pruductDto.getProductCategoryIds());
        }
        List<Long> categoryOrderList = null;
        if (pruductDto.getTimeOrder() == null || pruductDto.getTimeOrder().isEmpty() || "13".equals(pruductDto.getTimeOrder())) {
            productCategoryService = (ProductCategoryService)SpringUtils.getBean(ProductCategoryServiceImpl.class);
            List categoryList = productCategoryService.treeProductCategory();
            categoryOrderList = this.extractProductIdsInOrder(categoryList);
        } else if ("14".equals(pruductDto.getTimeOrder())) {
            productCategoryService = (ProductCategoryService)SpringUtils.getBean(ProductCategoryServiceImpl.class);
            List categoryList = productCategoryService.treeProductCategory();
            categoryOrderList = this.extractProductIdsInOrder(categoryList);
            Collections.reverse(categoryOrderList);
        }
        pruductDto.setUserSecurityLevel(BaseSecurityUtil.getUser().getSecurityLevel());
        List<Product> list = this.productMapper.queryProductList(pruductDto, page, productTypes, userIds, odpIds, childrenList, categoryOrderList);
        page.setRecords(list);
        return page;
    }

    public List<Long> extractProductIdsInOrder(List<JSTreeModel> productCategory) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (productCategory == null) {
            return result;
        }
        for (JSTreeModel product : productCategory) {
            this.extractIdsRecursively(product, result);
        }
        return result;
    }

    private void extractIdsRecursively(JSTreeModel productCategory, List<Long> result) {
        if (productCategory == null) {
            return;
        }
        result.add(productCategory.getId());
        if (productCategory.getChildrenList() != null && !productCategory.getChildrenList().isEmpty()) {
            for (JSTreeModel child : productCategory.getChildrenList()) {
                this.extractIdsRecursively(child, result);
            }
        }
    }

    @Override
    public String exportProductList(HttpServletResponse response, PruductDto pruductDto) {
        List categoryList;
        ProductCategoryService productCategoryService;
        String marketView;
        Page page = pruductDto.getPage();
        if (ToolUtil.isNotEmpty((Object)pruductDto.getMarketScreening())) {
            pruductDto.setMarketScreening(pruductDto.getMarketScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(pruductDto.getChargePersonIds()) && pruductDto.getChargePersonIds().size() > 0) {
            for (String userId : pruductDto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
        }
        InitUnitDataUtill.initForProduct(pruductDto);
        List<String> departments = pruductDto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> Ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
        }
        if ("2".equals(marketView = pruductDto.getMarketView())) {
            pruductDto.setMarketView(null);
        }
        if ("3".equals(marketView)) {
            pruductDto.setMarketView(null);
            pruductDto.setIsSubsidy("1");
        }
        pruductDto.setDelFlag("0");
        pruductDto.setCustomSearch(this.trackRecordAPIService.queryAnalize(pruductDto.getSearchId()));
        List<String> productTypes = pruductDto.getProductTypes();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        pruductDto.setWinStateIds(stageWin);
        List<Long> childrenList = null;
        if (ToolUtil.isNotEmpty(pruductDto.getProductCategoryIds()) && ToolUtil.isEmpty(childrenList = this.productMapper.getAllCategoryChildren(pruductDto.getProductCategoryIds()))) {
            childrenList.addAll(pruductDto.getProductCategoryIds());
        }
        List<Long> categoryOrderList = null;
        if (pruductDto.getTimeOrder() == null || pruductDto.getTimeOrder().isEmpty() || "13".equals(pruductDto.getTimeOrder())) {
            productCategoryService = (ProductCategoryService)SpringUtils.getBean(ProductCategoryServiceImpl.class);
            categoryList = productCategoryService.treeProductCategory();
            categoryOrderList = this.extractProductIdsInOrder(categoryList);
        } else if ("14".equals(pruductDto.getTimeOrder())) {
            productCategoryService = (ProductCategoryService)SpringUtils.getBean(ProductCategoryServiceImpl.class);
            categoryList = productCategoryService.treeProductCategory();
            categoryOrderList = this.extractProductIdsInOrder(categoryList);
            Collections.reverse(categoryOrderList);
        }
        pruductDto.setUserSecurityLevel(BaseSecurityUtil.getUser().getSecurityLevel());
        List<Product> list = this.productMapper.queryProductList(pruductDto, page, productTypes, userIds, odpIds, childrenList, categoryOrderList);
        this.tranDictData(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u8054\u7cfb\u4eba\u5217\u8868", Product.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    private void tranDictData(List<Product> list) {
        Map<String, String> yesNoDict = this.sysDicRefService.getDicListByType("yes_no").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        Map<String, String> securityLevelDic = this.sysDicRefService.getDicListByType("security_level").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        Map<String, String> productTypeDic = this.sysDicRefService.getDicListByType("product_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        Map<String, String> saleUnitDic = this.sysDicRefService.getDicListByType("sale_unit").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        list.stream().forEach(one -> {
            one.setIsSubsidy((String)yesNoDict.get(one.getIsSubsidy()));
            one.setProductType((String)productTypeDic.get(one.getProductType()));
            one.setSecurityLevelLabel((String)securityLevelDic.get(one.getSecurityLevel() + ""));
            one.setMeasure((String)saleUnitDic.get(one.getMeasure()));
        });
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(ProductAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getMarketScreening();
        }
        IProductAssociativeQueryService adapterService = this.productAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public Product queryProductDetails(PruductDto pruductDto) {
        String fileInfoAmount = "0";
        pruductDto.setDelFlag("0");
        Product product = this.productMapper.queryProductDetails(pruductDto);
        if (ToolUtil.isNotEmpty((Object)product)) {
            long businessId = Long.parseLong(pruductDto.getProductId());
            List trackRecordList = this.trackRecordAPIService.queryTrackRecordList(Long.valueOf(businessId));
            ArrayList<Long> lids = new ArrayList<Long>();
            lids.add(businessId);
            for (TrackRecordAPIVo trackRecord : trackRecordList) {
                if (!ToolUtil.isNotEmpty((Object)trackRecord)) continue;
                lids.add(trackRecord.getRecordId());
            }
            if (null != lids && lids.size() != 0) {
                LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, lids)).ne(FileInfo::getDelFlag, (Object)"1");
                Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
                if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
                    fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)userSecurityLevel);
                }
                fileInfoAmount = this.fileInfoService.count((Wrapper)fileInfoQueryWrapper) + "";
            }
        }
        product.setFileInfoAmount(Long.valueOf(fileInfoAmount));
        product.setProductManagerAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)Long.parseLong(pruductDto.getProductId()))).eq(TeamMeberEntity::getBusinessType, (Object)"10")).eq(TeamMeberEntity::getDelFlag, (Object)"0")));
        product.setMemberAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)pruductDto.getProductId())).eq(TeamMeberEntity::getBusinessType, (Object)"10")).eq(TeamMeberEntity::getDelFlag, (Object)"0")));
        product.setTaskAmount(this.taskAPIService.selectTaskCount("10", Long.valueOf(pruductDto.getProductId())));
        if ("1".equals(product.getTargetProfileSwitch())) {
            List profileEntityList = this.productTargetProfileService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProductTargetProfileEntity::getDelFlag, (Object)"0")).eq(ProductTargetProfileEntity::getProductId, (Object)pruductDto.getProductId()));
            List industryList = this.sysDicRefService.getDictByType("industry");
            List attributeList = this.sysDicRefService.getDictByType("customer_type");
            for (ProductTargetProfileEntity entity : profileEntityList) {
                ArrayList<String> dictLabels;
                String[] valueList;
                if ("1".equals(entity.getProfileType())) {
                    valueList = entity.getProfileValue().split(",");
                    entity.setDictLabel(entity.getProfileValue());
                    dictLabels = new ArrayList<String>();
                    block2: for (String value : valueList) {
                        for (DicSingle dicSingle : industryList) {
                            if (!dicSingle.getValue().equals(value)) continue;
                            dictLabels.add(dicSingle.getLabel());
                            continue block2;
                        }
                    }
                    if (dictLabels.isEmpty()) continue;
                    entity.setDictLabel(StringUtils.join(dictLabels, (String)","));
                    continue;
                }
                if (!"2".equals(entity.getProfileType())) continue;
                valueList = entity.getProfileValue().split(",");
                entity.setDictLabel(entity.getProfileValue());
                dictLabels = new ArrayList();
                block4: for (String value : valueList) {
                    for (DicSingle dicSingle : attributeList) {
                        if (!dicSingle.getValue().equals(value)) continue;
                        dictLabels.add(dicSingle.getLabel());
                        continue block4;
                    }
                }
                if (dictLabels.isEmpty()) continue;
                entity.setDictLabel(StringUtils.join(dictLabels, (String)","));
            }
            product.setProductTargetProfileList(profileEntityList);
        }
        return product;
    }

    @Override
    @Transactional
    public boolean deleteProduct(List<String> productIds) {
        SecurityUser user = BaseSecurityUtil.getUser();
        JSONObject tokenObject = this.docbaseService.getToken(user.getUserName(), user.getUserName());
        String accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
        Long optCount = this.opportunityProductService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityProduct::getProductId, productIds)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
        if (optCount > 0L) {
            throw new BaseException("\u4ea7\u54c1\u5df2\u5173\u8054\u5230\u5546\u673a\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List products = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Product::getProductId, productIds)).eq(Product::getDelFlag, (Object)"0"));
        List fileInfos = this.fileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getBusinessId, productIds)).eq(FileInfo::getDelFlag, (Object)"0"));
        String docbaseFileIds = fileInfos.stream().map(FileInfo::getDocbaseFileId).collect(Collectors.joining(","));
        this.productMapper.deleteProduct(productIds, "1");
        this.productPriceMapper.deleteProductPriceByProductIds(productIds, "1");
        List<Long> lids = productIds.stream().map(Long::parseLong).collect(Collectors.toList());
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        String folderIds = products.stream().map(Product::getFolderId).collect(Collectors.joining(","));
        this.docbaseService.deleteFile(user.getUserName(), user.getUserName(), accessToken, docbaseFileIds);
        this.docbaseService.deleteFolder(user.getUserName(), user.getUserName(), accessToken, folderIds, "1", "1");
        return true;
    }

    @Override
    public Page<Product> selectProductByPriceManual(PruductDto pruductDto) {
        Page page = pruductDto.getPage();
        List<Product> list = this.productMapper.selectProductByPriceManual(pruductDto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public ProductAnalysisAccountVo analysisAccount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        List stageProcessIds = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
            stageProcessIds = this.stageProcessService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getStageProcessId}).eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getPublishStatus, (Object)"1"), s -> Long.valueOf(s.toString()));
            stageProcessIds.addAll(stageProcessIds);
        } else {
            stageProcessIds.add(dto.getStageProcessId());
        }
        List ongoingStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).in(OpportunityStage::getStageType, Arrays.asList("00", "10"))).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        List successStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        dto.setOngoingStageIds(ongoingStageIds);
        dto.setSuccessStageIds(successStageIds);
        ArrayList<Long> stageIds = new ArrayList<Long>();
        stageIds.addAll(ongoingStageIds);
        stageIds.addAll(successStageIds);
        dto.setStageIds(stageIds);
        ArrayList<String> states = new ArrayList<String>();
        states.add("2");
        states.add("8");
        dto.setStates(states);
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            ArrayList<Long> allDeptIds = new ArrayList<Long>();
            for (Long deptId : dto.getDeptIds()) {
                if ("100001".equals(deptId.toString())) break;
                SysStru sysStru = (SysStru)this.struService.getById((Serializable)deptId);
                if (sysStru == null) continue;
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(deptId.toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List deptIdList = deptIds.stream().map(Long::parseLong).collect(Collectors.toList());
                allDeptIds.addAll(deptIdList);
            }
            dto.setDeptIds(allDeptIds);
        }
        IndexUtil.getCurrentTimeRange(dto);
        PermissionDto pdto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        BeanUtil.copyProperties((Object)pdto, (Object)dto);
        List<SalesProductVo> productList = this.indexMapper.getProductStatisticsList(dto);
        List<SalesOpportunityProductCountVo> productCount = this.indexMapper.getOpportunityProductCount(dto);
        if (productList == null) {
            return null;
        }
        int unfinishCount = 0;
        int unfinishProductCount = 0;
        int winCount = 0;
        int winProductCount = 0;
        double unfinishAmount = 0.0;
        double winAmount = 0.0;
        if (CollectionUtil.isNotEmpty(productCount)) {
            for (SalesProductVo productVo : productList) {
                boolean winFlag = false;
                boolean unfinishFlag = false;
                productVo.setUnfinishCount(0);
                productVo.setWinAmount(0.0);
                productVo.setWinCount(0);
                productVo.setWinAmount(0.0);
                for (SalesOpportunityProductCountVo countVo : productCount) {
                    if (productVo.getProductId().toString().equals(countVo.getProductId().toString()) && ongoingStageIds.contains(countVo.getStageId())) {
                        unfinishFlag = true;
                        productVo.setUnfinishCount(productVo.getUnfinishCount() + countVo.getProductCount());
                        productVo.setWinAmount(productVo.getWinAmount() + countVo.getProductAmount());
                        unfinishCount += countVo.getProductCount().intValue();
                        ++unfinishProductCount;
                        continue;
                    }
                    if (!productVo.getProductId().toString().equals(countVo.getProductId().toString()) || !successStageIds.contains(countVo.getStageId())) continue;
                    winFlag = true;
                    productVo.setWinCount(productVo.getWinCount() + countVo.getProductCount());
                    productVo.setWinAmount(productVo.getWinAmount() + countVo.getProductAmount());
                    winCount += countVo.getProductCount().intValue();
                    ++winProductCount;
                }
            }
        }
        for (SalesOpportunityProductCountVo countVo : productCount) {
            if ("1".equals(countVo.getStageId().toString())) {
                unfinishAmount += countVo.getProductAmount().doubleValue();
                continue;
            }
            if (!successStageIds.contains(countVo.getStageId())) continue;
            winAmount += countVo.getProductAmount().doubleValue();
        }
        ProductAnalysisAccountVo analysisAccountVo = new ProductAnalysisAccountVo();
        analysisAccountVo.setList(productList.stream().sorted(Comparator.comparing(SalesProductVo::getUnfinishCount).reversed()).collect(Collectors.toList()));
        analysisAccountVo.setUnfinishCount(unfinishCount);
        analysisAccountVo.setUnfinishProductCount(unfinishProductCount);
        analysisAccountVo.setWinCount(winCount);
        analysisAccountVo.setWinProductCount(winProductCount);
        DecimalFormat df = new DecimalFormat("0");
        String unfinishOppporunityAmount = df.format(unfinishAmount);
        analysisAccountVo.setUnfinishOppporunityAmount(unfinishOppporunityAmount);
        String winOppporunityAmount = df.format(winAmount);
        analysisAccountVo.setWinOppporunityAmount(winOppporunityAmount);
        return analysisAccountVo;
    }

    @Override
    public Page<OpportunityEntityVo> analysisList(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        ArrayList<Long> stageIds = new ArrayList<Long>();
        List stageProcessIds = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
            stageProcessIds = this.stageProcessService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getStageProcessId}).eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getPublishStatus, (Object)"1"), s -> Long.valueOf(s.toString()));
            stageProcessIds.addAll(stageProcessIds);
        } else {
            stageProcessIds.add(dto.getStageProcessId());
        }
        List ongoingStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).in(OpportunityStage::getStageType, Arrays.asList("00", "10"))).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        List successStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        stageIds.addAll(ongoingStageIds);
        stageIds.addAll(successStageIds);
        dto.setOngoingStageIds(ongoingStageIds);
        dto.setSuccessStageIds(successStageIds);
        dto.setStageIds(stageIds);
        ArrayList<String> states = new ArrayList<String>();
        states.add("2");
        states.add("8");
        dto.setStates(states);
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            ArrayList<Long> allDeptIds = new ArrayList<Long>();
            for (Long deptId : dto.getDeptIds()) {
                if ("100001".equals(deptId.toString())) break;
                SysStru sysStru = (SysStru)this.struService.getById((Serializable)deptId);
                if (sysStru == null) continue;
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(deptId.toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List deptIdList = deptIds.stream().map(Long::parseLong).collect(Collectors.toList());
                allDeptIds.addAll(deptIdList);
            }
            dto.setDeptIds(allDeptIds);
        }
        IndexUtil.getCurrentTimeRange(dto);
        PermissionDto pdto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        BeanUtil.copyProperties((Object)pdto, (Object)dto);
        List dicSingles = this.sysDicRefService.getDictByType("salesProcess_StageList");
        List<String> stageNames = dicSingles.stream().sorted(Comparator.comparingInt(DicSingle::getSort)).map(DicSingle::getLabel).collect(Collectors.toList());
        dto.setStageNames(stageNames);
        List<OpportunityEntityVo> list = this.productMapper.productAnalysisList(dto, (Page<OpportunityEntityVo>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public String productExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u4ea7\u54c1\u6a21\u677f", Product.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public int productReadExcel(MultipartFile file, Integer dynamicRows) {
        try {
            List<Product> productList = ReadExcel.readExcel(file, Product.class, dynamicRows);
            for (Product product1 : productList) {
                if (product1.getProductId() == null) {
                    product1.setProductId(Long.valueOf(CommonUtills.generateAssignId()));
                    this.save(product1);
                    continue;
                }
                this.save(product1);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 1;
    }

    @Override
    public void productWriteExcel(PruductDto pruductDto, HttpServletResponse response) {
        String marketView = pruductDto.getMarketView();
        DateConvertVo dateConvertVo = null;
        if ("1".equals(marketView)) {
            dateConvertVo = CommonUtills.getWeekDate();
            pruductDto.setStartDate(dateConvertVo.getStartDate());
            pruductDto.setEndDate(dateConvertVo.getEndDate());
        }
        if ("2".equals(marketView)) {
            pruductDto.setChargePersonId("");
        }
        pruductDto.setDelFlag("0");
        pruductDto.setCustomSearch(this.trackRecordAPIService.queryAnalize(pruductDto.getSearchId()));
        List<Product> list = this.productMapper.queryProductListExport(pruductDto, null);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u4ea7\u54c1\u5217\u8868", Product.class);
    }

    @Override
    @Transactional
    public String syncCatlogue() {
        String parentId = this.crmProperties.getDocbase().getProductDataFolderId();
        List products = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0")).isNull(Product::getFolderId));
        if (CollectionUtil.isNotEmpty((Collection)products)) {
            try {
                for (Product product : products) {
                    if (!ToolUtil.isEmpty((Object)product.getFolderId())) continue;
                    SyncProductCallable callable = new SyncProductCallable();
                    callable.setUserName(product.getProductManagerName());
                    callable.setAccessToken("");
                    callable.setProductName(product.getProductName());
                    callable.setParentId(parentId);
                    callable.setProductId(product.getProductId().toString());
                    callable.call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "1";
    }

    @Override
    public OperateVo isOperate(Long productId) {
        OperateVo operateVo = new OperateVo();
        if (productId == null) {
            return operateVo;
        }
        Product product = (Product)this.getById(productId);
        if (product == null) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < product.getSecurityLevel()) {
            return operateVo;
        }
        operateVo.setViewOperate(Boolean.valueOf(true));
        operateVo.setEditOperate(Integer.valueOf(0));
        this.teamMemberApiService.teamMemberOperate(productId, user, operateVo, "10");
        return operateVo;
    }

    @Override
    public List<ProductVo> getAllProductUrl() {
        return this.productMapper.getAllProductUrl();
    }

    @Override
    public Page<YyzcProductVo> selectProductListYyzc(YyzcProductDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        page.setMaxLimit(Long.valueOf(-1L));
        List<YyzcProductVo> list = this.productMapper.selectProductListYyzc(dto, (Page<YyzcProductVo>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<ProductVo> productListWithSpecification(PruductDto dto) {
        List<ProductVo> voList;
        if (ToolUtil.isNotEmpty((Object)dto.getProductNameScreening())) {
            dto.setProductNameScreening(dto.getProductNameScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        Page resultPage = new Page();
        dto.setUserSecurityLevel(BaseSecurityUtil.getUser().getSecurityLevel());
        if ("1".equals(dto.getSearchSpecification())) {
            Page queryPage = dto.getPage();
            voList = this.productMapper.selectProductListWithSpec(queryPage, dto);
            resultPage.setTotal(queryPage.getTotal());
            resultPage.setCurrent(queryPage.getCurrent());
            resultPage.setSize(queryPage.getSize());
        } else {
            voList = this.productMapper.selectProductListWithoutSpec(dto);
            resultPage.setTotal((long)voList.size());
        }
        resultPage.setRecords(voList);
        return resultPage;
    }

    @Override
    public List<Product> selectProductForPortal() {
        List<Product> list = this.productMapper.selectProductForPortal();
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(product -> product.setCrmProduct11ProductId(product.getProductId()));
        }
        return list;
    }

    @Override
    public List<ProductCategoryTreeVo> categoryTreeList(Long categoryId, boolean lazy) {
        List<ProductCategoryTreeVo> listTemp = this.productMapper.getCategoryTreeList();
        List<ProductCategoryTreeVo> treeList = ProductServiceImpl.categoryTreeMerge(listTemp);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(Product::getDelFlag, (Object)"0")).orderByDesc(Product::getOrderNumber);
        if (lazy) {
            if (categoryId != null) {
                lambdaQueryWrapper.eq(Product::getProductCategoryId, (Object)categoryId);
            } else {
                lambdaQueryWrapper.isNull(Product::getProductCategoryId);
            }
        }
        List productList = this.list((Wrapper)lambdaQueryWrapper);
        Map<Long, List<Product>> categoryProductMap = productList.stream().collect(Collectors.groupingBy(p -> Optional.ofNullable(p.getProductCategoryId()).orElse(-100L)));
        this.setCategoryProductTreeChildren(treeList, categoryProductMap, null, false);
        List<Product> noCategoryList = categoryProductMap.get(-100L);
        if (noCategoryList != null) {
            for (int i = 0; i < noCategoryList.size(); ++i) {
                ProductCategoryTreeVo childrenVo = new ProductCategoryTreeVo();
                childrenVo.setType("2");
                childrenVo.setId(noCategoryList.get(i).getProductId());
                childrenVo.setSeq(i);
                childrenVo.setText(noCategoryList.get(i).getShortName());
                treeList.add(childrenVo);
            }
        }
        return treeList;
    }

    @NotNull
    private static List<ProductCategoryTreeVo> categoryTreeMerge(List<ProductCategoryTreeVo> list) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<ProductCategoryTreeVo> resultList = new ArrayList<ProductCategoryTreeVo>();
        if (HussarUtils.isNotEmpty(list)) {
            LinkedHashMap<Long, ProductCategoryTreeVo> map = new LinkedHashMap<Long, ProductCategoryTreeVo>();
            for (ProductCategoryTreeVo item : list) {
                map.put(item.getId(), item);
            }
            for (ProductCategoryTreeVo item : list) {
                ProductCategoryTreeVo temp = (ProductCategoryTreeVo)map.get(item.getParentId());
                if (temp != null) {
                    temp.getChildrenList().add(item);
                    continue;
                }
                parentIds.add(item.getId());
            }
            for (Long productCategoryId : parentIds) {
                ProductCategoryTreeVo temp = (ProductCategoryTreeVo)map.get(productCategoryId);
                if (!HussarUtils.isNotEmpty((Object)temp)) continue;
                resultList.add(temp);
            }
        }
        return resultList;
    }

    private void setCategoryProductTreeChildren(List<ProductCategoryTreeVo> treeList, Map<Long, List<Product>> productMap, String parentLabel, boolean getLabel) {
        for (ProductCategoryTreeVo treeVo : treeList) {
            List<Product> productList;
            if (getLabel) {
                if (parentLabel == null) {
                    treeVo.setLabel(treeVo.getText());
                } else {
                    treeVo.setLabel(parentLabel + "/" + treeVo.getText());
                }
            }
            if (CollectionUtil.isNotEmpty(treeVo.getChildrenList())) {
                this.setCategoryProductTreeChildren(treeVo.getChildrenList(), productMap, treeVo.getLabel(), getLabel);
            }
            if ((productList = productMap.get(treeVo.getId())) == null) continue;
            int seq = treeVo.getChildrenList().size() + 1;
            ArrayList<ProductCategoryTreeVo> childrenList = new ArrayList<ProductCategoryTreeVo>();
            for (int i = 0; i < productList.size(); ++i) {
                ProductCategoryTreeVo childrenVo = new ProductCategoryTreeVo();
                childrenVo.setType("2");
                childrenVo.setId(productList.get(i).getProductId());
                childrenVo.setParentId(treeVo.getId());
                childrenVo.setSeq(i + seq);
                childrenVo.setText(productList.get(i).getShortName());
                if (getLabel) {
                    childrenVo.setLabel(treeVo.getLabel() + "/" + childrenVo.getText());
                }
                childrenList.add(childrenVo);
            }
            if (CollectionUtil.isEmpty(treeVo.getChildrenList())) {
                treeVo.setChildrenList(childrenList);
                continue;
            }
            treeVo.getChildrenList().addAll(childrenList);
        }
    }

    @Override
    public List<ProductCategorySearchVo> searchCategoryList(String keyword) {
        keyword = keyword.replaceAll("%", "/%").replaceAll("_", "/_");
        ArrayList<ProductCategorySearchVo> categorySearchVoList = new ArrayList<ProductCategorySearchVo>();
        if (HussarUtils.isEmpty((Object)keyword)) {
            return new ArrayList<ProductCategorySearchVo>();
        }
        List<ProductCategoryTreeVo> listTemp = this.productMapper.getCategoryTreeList();
        List<ProductCategoryTreeVo> treeList = ProductServiceImpl.categoryTreeMerge(listTemp);
        String finalKeyword = keyword;
        List productList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0")).and(e -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(Product::getProductName, (Object)finalKeyword)).or()).like(Product::getShortName, (Object)finalKeyword);
        })).orderByDesc(Product::getOrderNumber));
        Map<Long, List<Product>> categoryProductMap = productList.stream().collect(Collectors.groupingBy(p -> Optional.ofNullable(p.getProductCategoryId()).orElse(-100L)));
        this.setCategoryProductTreeChildren(treeList, categoryProductMap, null, true);
        this.searchKeyword(keyword, treeList, categorySearchVoList);
        ArrayList<ProductCategorySearchVo> resultList = new ArrayList<ProductCategorySearchVo>();
        if (categoryProductMap.get(-100L) != null) {
            for (Product product : categoryProductMap.get(-100L)) {
                ProductCategorySearchVo vo = new ProductCategorySearchVo();
                vo.setType("2");
                vo.setId(product.getProductId());
                vo.setLabel(product.getShortName());
                vo.setSeq(0);
                vo.setText(product.getShortName());
                resultList.add(vo);
            }
        }
        resultList.addAll(categorySearchVoList);
        return resultList;
    }

    private void searchKeyword(String keyword, List<ProductCategoryTreeVo> treeList, List<ProductCategorySearchVo> resultList) {
        for (ProductCategoryTreeVo treeVo : treeList) {
            if (!treeVo.getText().contains(keyword)) continue;
            ProductCategorySearchVo vo = new ProductCategorySearchVo();
            vo.setId(treeVo.getId());
            vo.setLabel(treeVo.getLabel());
            vo.setText(treeVo.getText());
            vo.setType(treeVo.getType());
            vo.setIsLeaf(treeVo.getIsLeaf());
            vo.setParentId(treeVo.getParentId());
            vo.setSeq(treeVo.getSeq());
            resultList.add(vo);
        }
        for (ProductCategoryTreeVo treeVo : treeList) {
            if (!CollectionUtil.isNotEmpty(treeVo.getChildrenList())) continue;
            this.searchKeyword(keyword, treeVo.getChildrenList(), resultList);
        }
    }

    @Override
    public ApiResponse<String> updateProduct(Product product) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Product oldProduct = (Product)this.getById(product.getProductId());
        SecurityUser chargePerson = this.userBoService.selectSecurityByUserId(Long.valueOf(product.getProductManager()));
        LocalDateTime date = LocalDateTime.now();
        product.setChangePersonId(user.getUserId());
        product.setChangePersonName(user.getUserName());
        product.setChangeTime(date);
        this.updateById(product);
        if (!product.getProductManager().equals(oldProduct.getProductManager())) {
            this.teamMeberMapper.deleteChargePerson(oldProduct.getProductManager(), product.getProductId(), "1");
            ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(product.getProductId());
            teamMeberDto.setPersonId(chargePerson.getUserId());
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
            List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
            if (CollectionUtil.isNotEmpty(existTeamMemberList) && existTeamMemberList.get(0).get("BUSINESS_ID").equals(product.getProductId())) {
                this.teamMeberMapper.updateIsCharge(String.valueOf(chargePerson.getUserId()), product.getProductId(), "1", null, "1");
            } else {
                this.teamMeberService.insertTeamMember(chargePerson.getUserName(), chargePerson.getUserId(), product.getProductId(), "1", "1", date, "10");
            }
            Long recordId = Long.valueOf(CommonUtills.generateAssignId());
            String productType = RecordProductTypeEnum.PRODUCE_TRANSFER.getId();
            ArrayList insertTrackRecordList = new ArrayList();
            this.operateRecordAPIService.addInsertOperateLogList(insertTrackRecordList, CrmBusinessTypeEnum.PRODUCT, productType, chargePerson.getUserId(), chargePerson.getUserName(), user.getUserId(), oldProduct.getProductManagerName(), recordId, product.getProductId(), product.getProductName(), date);
            if (CollectionUtil.isNotEmpty(insertTrackRecordList)) {
                this.operateRecordAPIService.saveOperateLogBatch(insertTrackRecordList);
            }
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public List<Long> selectAllProductIdByCategory(List<Long> categoryIdList) {
        List allCategoryIdList = this.productCategoryService.selectAllChildrenCategoryByCategoryIdList(categoryIdList);
        List productIdLIst = this.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId}).in(Product::getProductCategoryId, (Collection)allCategoryIdList)).eq(Product::getDelFlag, (Object)"0"), s -> (Long)s);
        return productIdLIst;
    }

    private void getCategoryAllChildId(List<Long> childCategoryIds, List<ProductCategory> categoryList, Long categoryId) {
        for (ProductCategory pc : categoryList) {
            if (!Objects.equals(pc.getParentId(), categoryId)) continue;
            childCategoryIds.add(pc.getCategoryId());
            this.getCategoryAllChildId(childCategoryIds, categoryList, pc.getCategoryId());
        }
    }
}

