/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.product.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.product.dto.ProductAssociativeQueryDto;
import com.jxdinfo.crm.core.product.dto.PruductDto;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.IProductAssociativeQueryService;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.product.vo.ProductAnalysisAccountVo;
import com.jxdinfo.crm.core.product.vo.ProductCategorySearchVo;
import com.jxdinfo.crm.core.product.vo.ProductCategoryTreeVo;
import com.jxdinfo.crm.core.product.vo.ProductVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4ea7\u54c1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/product"})
public class ProductController {
    @Resource
    private ProductService productService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IProductAssociativeQueryService productAssociativeQueryService;

    @PostMapping(value={"/queryProductList"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<Product>> queryProductList(@RequestBody @ApiParam(value="\u4ea7\u54c1dto") PruductDto pruductDto) {
        Page<Product> productList = this.productService.queryProductList(pruductDto);
        return ApiResponse.success(productList);
    }

    @PostMapping(value={"/exportProductList"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String exportProductList(HttpServletResponse response, @RequestBody @ApiParam(value="\u4ea7\u54c1dto") PruductDto pruductDto) {
        return this.productService.exportProductList(response, pruductDto);
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u4ea7\u54c1\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u4ea7\u54c1\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u4ea7\u54c1dto") ProductAssociativeQueryDto dto) {
        return ApiResponse.success(this.productService.associativeQuery(dto));
    }

    @PostMapping(value={"/queryProductDetails"})
    @ApiOperation(value="\u4ea7\u54c1\u8be6\u60c5\u67e5\u8be2\uff08\u79fb\u52a8\u7aef\uff09", notes="\u4ea7\u54c1\u8be6\u60c5\u67e5\u8be2\uff08\u79fb\u52a8\u7aef\uff09")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Product> queryProductDetails(@RequestBody @ApiParam(value="\u4ea7\u54c1dto") PruductDto pruductDto) {
        Product productList = this.productService.queryProductDetails(pruductDto);
        return ApiResponse.success((Object)productList);
    }

    @PostMapping(value={"/deleteProduct"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteProduct(@RequestBody @ApiParam(value="\u4ea7\u54c1dto") PruductDto dto) {
        return ApiResponse.success((Object)this.productService.deleteProduct(dto.getProductIds()));
    }

    @PostMapping(value={"/selectByPriceManual"})
    @ApiOperation(value="\u6839\u636e\u4ef7\u683c\u624b\u518c\u67e5\u8be2\u4ea7\u54c1", notes="\u6839\u636e\u4ef7\u683c\u624b\u518c\u67e5\u8be2\u4ea7\u54c1")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectProductByPriceManual(@RequestBody @ApiParam(value="\u4ea7\u54c1dto") PruductDto pruductDto) {
        Page<Product> productPage = this.productService.selectProductByPriceManual(pruductDto);
        return ApiResponse.success(productPage);
    }

    @RequestMapping(value={"/productexportTemplate"})
    public String productActivityExportTemplate(HttpServletResponse response) {
        String msg = this.productService.productExportTemplate(response);
        return msg;
    }

    @PostMapping(value={"/productReadExcel"})
    public ApiResponse productReadExcel(MultipartFile file) {
        Integer dynamicRows = 0;
        int i = this.productService.productReadExcel(file, dynamicRows);
        if (i > 0) {
            return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
    }

    @GetMapping(value={"/productWriteExcel"})
    public void productWriteExcel(HttpServletResponse response, @RequestParam(value="marketView") String marketView, @RequestParam(value="marketScreening") String marketScreening) {
        PruductDto pruductDto = new PruductDto();
        pruductDto.setMarketScreening(marketScreening);
        pruductDto.setMarketView(marketView);
        this.productService.productWriteExcel(pruductDto, response);
    }

    @PostMapping(value={"analysis/account"})
    @ApiOperation(value="", notes="")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ProductAnalysisAccountVo> analysisAccount(@RequestBody @ApiParam(value="\u6743\u9650dto") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.productService.analysisAccount(dto));
    }

    @PostMapping(value={"analysis/list"})
    @ApiOperation(value="\u4ea7\u54c1\u9500\u552e\u60c5\u51b5\u5217\u8868\u67e5\u8be2", notes="\u4ea7\u54c1\u9500\u552e\u60c5\u51b5\u5217\u8868\u67e5\u8be2")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntityVo>> analysisList(@RequestBody @ApiParam(value="\u6743\u9650dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.productService.analysisList(dto));
    }

    @GetMapping(value={"/syncCatalogue"})
    @ApiOperation(value="\u4ea7\u54c1\u76ee\u5f55\u540c\u6b65", notes="\u4ea7\u54c1\u76ee\u5f55\u540c\u6b65")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<String> syncCatalogue() {
        return ApiResponse.success((String)this.productService.syncCatlogue());
    }

    @GetMapping(value={"/operate"})
    @ApiOperation(value="\u4ea7\u54c1\u6743\u9650", notes="\u4ea7\u54c1\u6743\u9650")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OperateVo> isOperate(@RequestParam(value="productId") @ApiParam(value="\u4ea7\u54c1id") Long productId) {
        return ApiResponse.success((Object)this.productService.isOperate(productId));
    }

    @PostMapping(value={"/productListWithSpecification"})
    @ApiOperation(value="\u65b0\u7248\u9009\u62e9\u4ea7\u54c1\u67e5\u8be2\u4ea7\u54c1\u5217\u8868\uff08\u5e26\u89c4\u683c/\u4e0d\u5e26\u89c4\u683c\uff09", notes="\u65b0\u7248\u9009\u62e9\u4ea7\u54c1\u67e5\u8be2\u4ea7\u54c1\u5217\u8868\uff08\u5e26\u89c4\u683c/\u4e0d\u5e26\u89c4\u683c\uff09")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ProductVo>> productListWithSpecification(@RequestBody PruductDto dto) {
        return ApiResponse.success(this.productService.productListWithSpecification(dto));
    }

    @GetMapping(value={"/categoryTreeList"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811", notes="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ProductCategoryTreeVo>> categoryTreeList() {
        return ApiResponse.success(this.productService.categoryTreeList(null, false));
    }

    @GetMapping(value={"/lazyCategoryTreeList"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811\uff08\u61d2\u52a0\u8f7d\uff09", notes="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811\uff08\u61d2\u52a0\u8f7d\uff09")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ProductCategoryTreeVo>> lazyCategoryTreeList(@RequestParam(value="categoryId") Long categoryId) {
        return ApiResponse.success(this.productService.categoryTreeList(categoryId, true));
    }

    @GetMapping(value={"/searchCategoryList"})
    @ApiOperation(value="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811\u641c\u7d22", notes="\u4ea7\u54c1\u5206\u7c7b\u9009\u62e9\u6811\u641c\u7d22")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ProductCategorySearchVo>> searchCategoryList(@RequestParam(value="keyword") String keyword) {
        return ApiResponse.success(this.productService.searchCategoryList(keyword));
    }

    @PostMapping(value={"/updateProduct"})
    @ApiOperation(value="\u4ea7\u54c1\u4fee\u6539", notes="\u4ea7\u54c1\u4fee\u6539")
    @AuditLog(moduleName="\u4ea7\u54c1\u7ba1\u7406", eventDesc="\u4ea7\u54c1\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateProduct(@RequestBody Product product) {
        return this.productService.updateProduct(product);
    }
}

