/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.postprocessor;

import com.jxdinfo.crm.core.postprocessor.dao.WorkstationTemplateMapper;
import com.jxdinfo.crm.core.postprocessor.model.WorkstationTemplate;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateBoService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WorkstationTemplatePostprocessor
implements ISysWorkstationTemplateBoService {
    @Resource
    WorkstationTemplateMapper mapper;

    public Long getExtraTemplateId(String applicationScenario) {
        String permissionTypes;
        Map<String, List<WorkstationTemplate>> permissionTypeMap;
        WorkstationTemplate workstationTemplate;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            return null;
        }
        List rolesList = user.getRolesList();
        Long deptId = user.getDeptId();
        List<WorkstationTemplate> workstationTemplateList = this.mapper.getWorkStationTemplateList(user.getUserId(), rolesList, deptId);
        if (CollectionUtil.isNotEmpty(workstationTemplateList) && (workstationTemplate = this.getWorkstationTemplateByPriority(permissionTypeMap = workstationTemplateList.stream().collect(Collectors.groupingBy(WorkstationTemplate::getPermissionTypes)), permissionTypes = "3")) != null) {
            return workstationTemplate.getWorkstationTemplateId();
        }
        return null;
    }

    private WorkstationTemplate getWorkstationTemplateByPriority(Map<String, List<WorkstationTemplate>> permissionTypeMap, String permissionTypes) {
        List<WorkstationTemplate> workstationTemplateList = permissionTypeMap.get(permissionTypes);
        if (CollectionUtil.isNotEmpty(workstationTemplateList)) {
            if (workstationTemplateList.size() > 1) {
                CollectionUtil.sort(workstationTemplateList, Comparator.comparingInt(WorkstationTemplate::getPriority));
            }
            return workstationTemplateList.get(0);
        }
        if ("999".equals(permissionTypes)) {
            return null;
        }
        switch (permissionTypes) {
            case "3": {
                permissionTypes = "1";
                break;
            }
            case "1": {
                permissionTypes = "2";
                break;
            }
            case "2": {
                permissionTypes = "0";
                break;
            }
            case "0": {
                permissionTypes = "999";
            }
        }
        WorkstationTemplate template = this.getWorkstationTemplateByPriority(permissionTypeMap, permissionTypes);
        return template;
    }
}

