/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityStatisticsDto;
import com.jxdinfo.crm.core.api.opportunity.dto.StageRecordDto;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityConversionVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageConversionVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageRecordVo;
import com.jxdinfo.crm.core.opportunity.dao.OpportunitySuccessRateMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRate;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRateConfig;
import com.jxdinfo.crm.core.opportunity.model.SuccessRateDic;
import com.jxdinfo.crm.core.opportunity.model.SuccessRateModelOne;
import com.jxdinfo.crm.core.opportunity.model.SuccessRateModelTwo;
import com.jxdinfo.crm.core.opportunity.service.IOpportunitySelectService;
import com.jxdinfo.crm.core.opportunity.service.IOpportunitySuccessRateService;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunitySuccessRateServiceImpl
extends HussarServiceImpl<OpportunitySuccessRateMapper, OpportunitySuccessRate>
implements IOpportunitySuccessRateService {
    @Resource
    private IStageRecordService stageRecordService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ProductService productService;
    @Resource
    private OpportunitySuccessRateMapper opportunitySuccessRateMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOpportunitySelectService opportunitySelectService;
    @Resource
    private OpportunityService opportunityService;

    @Override
    @Transactional
    public int initSuccessRateInfo() {
        ArrayList<Object> opportunitySuccessRateList = new ArrayList<Object>();
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config");
        OpportunitySuccessRateConfig config = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)configVo.getConfigValue(), OpportunitySuccessRateConfig.class);
        SuccessRateModelOne modelOne = null;
        if (config.getModelsInUse().contains("1")) {
            modelOne = config.getModelOneConfig();
        }
        List<String> excludedStage = Arrays.asList("21", "22", "23");
        this.opportunitySuccessRateMapper.delete((Wrapper)new LambdaQueryWrapper());
        if (modelOne != null) {
            if ("1".equals(modelOne.getType())) {
                List opportunityStageList = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0"));
                List osrList = opportunityStageList.stream().filter(os -> !excludedStage.contains(os.getStageType())).map(os -> {
                    OpportunitySuccessRate opportunitySuccessRate = new OpportunitySuccessRate();
                    opportunitySuccessRate.setStageId(os.getCustomerStageId());
                    opportunitySuccessRate.setStageProcessId(os.getStageProcessId());
                    opportunitySuccessRate.setStageName(os.getCustomerStageName());
                    opportunitySuccessRate.setSuccessRate(os.getSuccessRate() + "%");
                    opportunitySuccessRate.setOrderNumber(Integer.valueOf(os.getOrderNumber()));
                    return opportunitySuccessRate;
                }).collect(Collectors.toList());
                opportunitySuccessRateList.addAll(osrList);
            } else if ("2".equals(modelOne.getType())) {
                StageRecordDto stageRecordDto = (StageRecordDto)BeanUtil.copyProperties((Object)config.getModelOneConfig(), StageRecordDto.class);
                if (HussarUtils.isNotEmpty((Object)modelOne.getHistoryOpportunityFrom())) {
                    stageRecordDto.setOpportunityFroms(Arrays.stream(modelOne.getHistoryOpportunityFrom().split(",")).collect(Collectors.toList()));
                }
                if (HussarUtils.isNotEmpty((Object)modelOne.getHistoryOpportunityType())) {
                    stageRecordDto.setOpportunityTypes(Arrays.stream(modelOne.getHistoryOpportunityType().split(",")).collect(Collectors.toList()));
                }
                Integer leastNum = null;
                if (modelOne != null) {
                    leastNum = modelOne.getHistoryDataNum();
                }
                List opportunityStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).notIn(OpportunityStage::getStageType, excludedStage));
                Map<Long, List<OpportunityStage>> mapOS = opportunityStageList.stream().collect(Collectors.groupingBy(OpportunityStage::getStageProcessId));
                List productList = this.productService.list((Wrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0"));
                for (Map.Entry<Long, List<OpportunityStage>> entry : mapOS.entrySet()) {
                    stageRecordDto.setProcessId(entry.getKey());
                    List<OpportunityStageRecordVo> stageRecordListAll = this.stageRecordService.getStageRecordList(stageRecordDto, null);
                    List<OpportunityStageRecordVo> stageRecordProductListAll = this.stageRecordService.getStageRecordListByProduct(stageRecordDto);
                    List stageIds = entry.getValue().stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
                    long opportunityNum = stageRecordListAll.stream().filter(e -> stageIds.contains(e.getAfterStageId()) || stageIds.contains(e.getBeforeStageId())).map(OpportunityStageRecordVo::getOpportunityId).distinct().count();
                    if (leastNum == null || opportunityNum > (long)leastNum.intValue()) {
                        Map<Long, String> successRateMap = new HashMap<Long, String>();
                        if (CollectionUtil.isNotEmpty((Collection)entry.getValue())) {
                            List<OpportunitySuccessRate> successRateList = this.getProductSuccessRateList(entry.getValue(), stageRecordListAll, stageRecordDto, null, successRateMap);
                            successRateMap = successRateList.stream().collect(Collectors.toMap(OpportunitySuccessRate::getStageId, OpportunitySuccessRate::getSuccessRate));
                            opportunitySuccessRateList.addAll(successRateList);
                        }
                        if (!CollectionUtil.isNotEmpty(stageRecordProductListAll) || !CollectionUtil.isNotEmpty((Collection)productList)) continue;
                        for (Product product : productList) {
                            long count = stageRecordProductListAll.stream().filter(o -> o.getProductId().equals(product.getProductId())).map(OpportunityStageRecordVo::getOpportunityId).distinct().count();
                            if (leastNum == null || count > (long)leastNum.intValue()) {
                                opportunitySuccessRateList.addAll(this.getProductSuccessRateList(entry.getValue(), stageRecordProductListAll, stageRecordDto, product, successRateMap));
                                continue;
                            }
                            List osrList = entry.getValue().stream().map(os -> {
                                OpportunitySuccessRate opportunitySuccessRate = new OpportunitySuccessRate();
                                opportunitySuccessRate.setStageId(os.getCustomerStageId());
                                opportunitySuccessRate.setStageProcessId(os.getStageProcessId());
                                opportunitySuccessRate.setStageName(os.getCustomerStageName());
                                opportunitySuccessRate.setSuccessRate(os.getSuccessRate() + "%");
                                opportunitySuccessRate.setOrderNumber(Integer.valueOf(os.getOrderNumber()));
                                opportunitySuccessRate.setProductId(product.getProductId());
                                opportunitySuccessRate.setProductName(product.getProductName());
                                opportunitySuccessRate.setShortName(product.getShortName());
                                return opportunitySuccessRate;
                            }).collect(Collectors.toList());
                            opportunitySuccessRateList.addAll(osrList);
                        }
                        continue;
                    }
                    List osrList = entry.getValue().stream().map(os -> {
                        OpportunitySuccessRate opportunitySuccessRate = new OpportunitySuccessRate();
                        opportunitySuccessRate.setStageId(os.getCustomerStageId());
                        opportunitySuccessRate.setStageProcessId(os.getStageProcessId());
                        opportunitySuccessRate.setStageName(os.getCustomerStageName());
                        opportunitySuccessRate.setSuccessRate(os.getSuccessRate() + "%");
                        opportunitySuccessRate.setOrderNumber(Integer.valueOf(os.getOrderNumber()));
                        return opportunitySuccessRate;
                    }).collect(Collectors.toList());
                    List stageRecordProductList = stageRecordProductListAll.stream().filter(o -> stageIds.contains(o.getBeforeStageId())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(stageRecordProductList) && CollectionUtil.isNotEmpty((Collection)productList)) {
                        for (Product product : productList) {
                            List osrListProduct = entry.getValue().stream().map(os -> {
                                OpportunitySuccessRate opportunitySuccessRate = new OpportunitySuccessRate();
                                opportunitySuccessRate.setStageId(os.getCustomerStageId());
                                opportunitySuccessRate.setStageProcessId(os.getStageProcessId());
                                opportunitySuccessRate.setStageName(os.getCustomerStageName());
                                opportunitySuccessRate.setSuccessRate(os.getSuccessRate() + "%");
                                opportunitySuccessRate.setOrderNumber(Integer.valueOf(os.getOrderNumber()));
                                opportunitySuccessRate.setProductId(product.getProductId());
                                opportunitySuccessRate.setProductName(product.getProductName());
                                opportunitySuccessRate.setShortName(product.getShortName());
                                return opportunitySuccessRate;
                            }).collect(Collectors.toList());
                            opportunitySuccessRateList.addAll(osrListProduct);
                        }
                    }
                    opportunitySuccessRateList.addAll(osrList);
                }
            }
        }
        this.saveBatch(opportunitySuccessRateList);
        return 1;
    }

    @Override
    public OpportunityConversionVo getConversionInfo(StageRecordDto stageRecordDto) {
        List<OpportunityStageRecordVo> recordVoList = this.stageRecordService.getStageRecordList(stageRecordDto, null);
        List opportunityStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).eq(OpportunityStage::getStageProcessId, (Object)stageRecordDto.getProcessId()));
        Long winStage = null;
        for (OpportunityStage os : opportunityStageList) {
            if (!"20".equals(os.getStageType())) continue;
            winStage = os.getCustomerStageId();
        }
        OpportunityConversionVo opportunityConversionVo = new OpportunityConversionVo();
        if (CollectionUtil.isNotEmpty((Collection)opportunityStageList)) {
            List<OpportunityStageConversionVo> opportunityStageConversionVoList = this.getOpportunityConversionInfo(opportunityStageList, recordVoList, stageRecordDto);
            if (CollectionUtil.isNotEmpty(opportunityStageConversionVoList)) {
                opportunityConversionVo.setOpportunityStageConversionVoList(opportunityStageConversionVoList);
            }
            OpportunityStatisticsDto opportunityStatisticsDto = new OpportunityStatisticsDto();
            BeanUtil.copyProperties((Object)stageRecordDto, (Object)opportunityStatisticsDto);
            opportunityStatisticsDto.setCurrentStageId(winStage);
            List<OpportunityEntity> opportunityEntityList = this.opportunitySelectService.selectListIfNullAllSimplify(stageRecordDto.getOpportunityIdList(), opportunityStatisticsDto);
            if (CollectionUtil.isEmpty(opportunityEntityList)) {
                opportunityConversionVo.setSuccessTimeAvg("--");
                opportunityConversionVo.setSuccessAmountAvg("--");
                return opportunityConversionVo;
            }
            Long nowSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            long sumCrateTime = opportunityEntityList.stream().mapToLong(opportunityEntity -> {
                LocalDate createTime;
                LocalDate localDate = createTime = opportunityEntity.getCreateTime() == null ? null : opportunityEntity.getCreateTime().toLocalDate();
                if (createTime == null) {
                    return nowSecond;
                }
                return createTime.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
            }).sum();
            long sumSuccessTime = opportunityEntityList.stream().mapToLong(opportunityEntity -> {
                LocalDate successDate;
                LocalDate localDate = successDate = opportunityEntity.getSuccessDate() == null ? null : LocalDate.parse(opportunityEntity.getSuccessDate());
                if (successDate == null) {
                    return nowSecond;
                }
                return successDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
            }).sum();
            long successCount = opportunityEntityList.size();
            opportunityConversionVo.setSuccessTimeAvg(CrmDateUtils.secondToDay((Long)((sumSuccessTime - sumCrateTime) / successCount), (String)"day").replace(CrmDateUtils.TIME_DAY_SHOW, ""));
            Double successAmount = opportunityEntityList.stream().mapToDouble(opportunityEntity -> Double.parseDouble(opportunityEntity.getOpportunityAmount())).sum();
            opportunityConversionVo.setSuccessAmountAvg(CommonUtills.transferAmount((Double)(successAmount / (double)successCount)));
        }
        return opportunityConversionVo;
    }

    @Override
    public List<OpportunityStageConversionVo> getOpportunityConversionInfo(List<OpportunityStage> opportunityStageList, List<OpportunityStageRecordVo> recordVoList, StageRecordDto stageRecordDto) {
        HashMap<Long, String> successRateMap = new HashMap<Long, String>();
        List<OpportunityStageConversionVo> stageConversionVoList = this.getSuccessRateByStage(opportunityStageList, recordVoList, stageRecordDto, null, successRateMap);
        if (CollectionUtil.isNotEmpty(stageConversionVoList)) {
            stageConversionVoList.sort(Comparator.comparing(OpportunityStageConversionVo::getOrderNumber));
        }
        return stageConversionVoList;
    }

    @Override
    public List<OpportunitySuccessRate> getProductSuccessRateList(List<OpportunityStage> opportunityStageList, List<OpportunityStageRecordVo> recordVoList, StageRecordDto stageRecordDto, Product product, Map<Long, String> successRateMap) {
        List stageWinIds = opportunityStageList.stream().filter(s -> "20".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).map(String::valueOf).collect(Collectors.toList());
        if (product != null) {
            recordVoList = recordVoList.stream().filter(opportunityStageRecordVo -> product.getProductId().equals(opportunityStageRecordVo.getProductId())).collect(Collectors.toList());
        }
        List<OpportunityStageConversionVo> opportunityStageConversionVoList = this.getSuccessRateByStage(opportunityStageList, recordVoList, stageRecordDto, product, successRateMap);
        ArrayList<OpportunitySuccessRate> successRateList = new ArrayList<OpportunitySuccessRate>();
        for (OpportunityStageConversionVo stageConversionVo : opportunityStageConversionVoList) {
            OpportunitySuccessRate opportunitySuccessRate = new OpportunitySuccessRate();
            if (product != null) {
                opportunitySuccessRate.setProductId(product.getProductId());
                opportunitySuccessRate.setProductName(product.getProductName());
                opportunitySuccessRate.setShortName(product.getShortName());
            }
            if (stageWinIds.contains(stageConversionVo.getStageId().toString())) {
                opportunitySuccessRate.setSuccessRate("100%");
            } else {
                opportunitySuccessRate.setSuccessRate(stageConversionVo.getSuccessRate());
            }
            opportunitySuccessRate.setStageId(stageConversionVo.getStageId());
            opportunitySuccessRate.setStageProcessId(stageConversionVo.getStageProcessId());
            opportunitySuccessRate.setStageName(stageConversionVo.getStageName());
            opportunitySuccessRate.setOrderNumber(stageConversionVo.getOrderNumber());
            successRateList.add(opportunitySuccessRate);
            successRateList.sort(Comparator.comparing(OpportunitySuccessRate::getOrderNumber));
        }
        return successRateList;
    }

    @Override
    public ApiResponse<String> saveConfig(OpportunitySuccessRateConfig config) {
        this.crmBaseConfigBoService.updateConfigValue(JsonUtil.toJson((Object)config), "success_rate_config");
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<SuccessRateDic>> getSuccessRateDic() {
        String configStr = this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue();
        return ApiResponse.success(((OpportunitySuccessRateConfig)HussarUtils.readJson((String)configStr, OpportunitySuccessRateConfig.class)).getModelTwoConfig().getSuccessRateDic());
    }

    @Override
    public ApiResponse<String> select() {
        String configStr = this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue();
        return ApiResponse.success((Object)configStr, (String)"");
    }

    @Override
    public ApiResponse<List> getSuccessRateModel() {
        String configStr = this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue();
        OpportunitySuccessRateConfig config = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)configStr, OpportunitySuccessRateConfig.class);
        SuccessRateModelOne modelOne = null;
        SuccessRateModelTwo modelTwo = null;
        if (config.getModelsInUse().contains("1")) {
            modelOne = config.getModelOneConfig();
        }
        if (config.getModelsInUse().contains("2")) {
            modelTwo = config.getModelTwoConfig();
        }
        ArrayList list = new ArrayList();
        if (modelOne != null) {
            HashMap<String, Object> configOne = new HashMap<String, Object>();
            configOne.put("modelId", 1);
            if ("1".equals(config.getDefaultModel())) {
                configOne.put("isDefault", 1);
            } else {
                configOne.put("isDefault", 0);
            }
            configOne.put("historyDataNum", modelOne.getHistoryDataNum());
            configOne.put("includeWin", modelOne.getIncludeWin());
            configOne.put("prompt", modelOne.getPrompt());
            configOne.put("formula", modelOne.getFormula());
            list.add(configOne);
        }
        if (modelTwo != null) {
            HashMap<String, Object> configTwo = new HashMap<String, Object>();
            configTwo.put("modelId", 2);
            if ("2".equals(config.getDefaultModel())) {
                configTwo.put("isDefault", 1);
            } else {
                configTwo.put("isDefault", 0);
            }
            configTwo.put("includeWin", modelTwo.getIncludeWin());
            configTwo.put("formula", modelTwo.getFormula());
            configTwo.put("successRateList", modelTwo.getSuccessRateDic());
            list.add(configTwo);
        }
        return ApiResponse.success(list);
    }

    private List<OpportunityStageConversionVo> getSuccessRateByStage(List<OpportunityStage> opportunityStageList, List<OpportunityStageRecordVo> stageRecordList, StageRecordDto stageRecordDto, Product product, Map<Long, String> successRateMap) {
        ArrayList<String> winStage = new ArrayList<String>();
        ArrayList<String> loseStage = new ArrayList<String>();
        ArrayList<String> convertStage = new ArrayList<String>();
        ArrayList<String> abandonStage = new ArrayList<String>();
        for (OpportunityStage os : opportunityStageList) {
            if ("20".equals(os.getStageType())) {
                winStage.add(os.getCustomerStageId().toString());
                continue;
            }
            if ("21".equals(os.getStageType())) {
                loseStage.add(os.getCustomerStageId().toString());
                continue;
            }
            if ("22".equals(os.getStageType())) {
                abandonStage.add(os.getCustomerStageId().toString());
                continue;
            }
            if (!"23".equals(os.getStageType())) continue;
            convertStage.add(os.getCustomerStageId().toString());
        }
        ArrayList<OpportunityStageConversionVo> opportunityStageConversionVoList = new ArrayList<OpportunityStageConversionVo>();
        if (CollectionUtil.isNotEmpty(stageRecordList)) {
            stageRecordList = stageRecordList.stream().filter(opportunityStageRecordVo -> opportunityStageRecordVo.getAfterStageId() != null).collect(Collectors.toList());
        }
        Long nowSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        int firstStageCount = 0;
        Map<Object, Object> defaultSuccessMap = new HashMap();
        for (OpportunityStage opportunityStage : opportunityStageList) {
            String stageType = opportunityStage.getStageType();
            Long stageId = opportunityStage.getCustomerStageId();
            if ("21".equals(stageType) || "22".equals(stageType) || "23".equals(stageType)) continue;
            OpportunityStageConversionVo opportunityStageConversionVo = new OpportunityStageConversionVo();
            opportunityStageConversionVo.setStageId(stageId);
            opportunityStageConversionVo.setStageProcessId(opportunityStage.getStageProcessId());
            opportunityStageConversionVo.setStageName(opportunityStage.getCustomerStageName());
            opportunityStageConversionVo.setOrderNumber(Integer.valueOf(Integer.parseInt(opportunityStage.getOrderNumber())));
            this.initStageConversion(opportunityStageConversionVo);
            long sumEntryTime = 0L;
            int stageCount = 0;
            String defaultSuccessRate = successRateMap.get(stageId);
            if (StringUtil.isEmpty((Object)defaultSuccessRate)) {
                defaultSuccessRate = "0.00%";
            }
            List leaveStageRecord = null;
            leaveStageRecord = stageRecordList.stream().filter(stageRecordVo -> stageId.equals(stageRecordVo.getBeforeStageId())).collect(Collectors.toList());
            if ("00".equals(stageType)) {
                List<OpportunityEntity> opportunityEntityList;
                ArrayList<Long> productIdList = new ArrayList<Long>();
                OpportunityStatisticsDto opportunityStatisticsDto = new OpportunityStatisticsDto();
                BeanUtil.copyProperties((Object)stageRecordDto, (Object)opportunityStatisticsDto);
                if (product != null) {
                    productIdList.add(product.getProductId());
                    opportunityStatisticsDto.setProductIds(productIdList);
                }
                if (CollectionUtil.isEmpty(opportunityEntityList = this.opportunitySelectService.selectListIfNullAllSimplify(stageRecordDto.getOpportunityIdList(), opportunityStatisticsDto))) {
                    opportunityStageConversionVo.setSuccessRate(defaultSuccessRate);
                    opportunityStageConversionVoList.add(opportunityStageConversionVo);
                    continue;
                }
                firstStageCount = stageCount = opportunityEntityList.size();
                opportunityStageConversionVo.setCount(Integer.valueOf(stageCount));
                Double sumAmount = opportunityEntityList.stream().mapToDouble(opportunityEntity -> Double.parseDouble(opportunityEntity.getOpportunityAmount())).sum();
                opportunityStageConversionVo.setAmount(CommonUtills.transferAmount((Double)sumAmount));
                sumEntryTime = opportunityEntityList.stream().mapToLong(opportunityEntity -> {
                    LocalDate createTime;
                    LocalDate localDate = createTime = opportunityEntity.getCreateTime() == null ? null : opportunityEntity.getCreateTime().toLocalDate();
                    if (createTime == null) {
                        return nowSecond;
                    }
                    return createTime.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
                }).sum();
                long sumLeaveTime = 0L;
                if (CollectionUtil.isNotEmpty(leaveStageRecord)) {
                    sumLeaveTime = leaveStageRecord.stream().mapToLong(stageRecordVo -> {
                        LocalDate leaveTime;
                        LocalDate localDate = leaveTime = stageRecordVo.getEntryTime() == null ? null : stageRecordVo.getEntryTime().toLocalDate();
                        if (leaveTime == null) {
                            return nowSecond;
                        }
                        return leaveTime.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
                    }).sum();
                }
                long noLeaveTime = nowSecond * (long)(stageCount - leaveStageRecord.size());
                opportunityStageConversionVo.setStopTimeAvg(CrmDateUtils.secondToDay((Long)((noLeaveTime + sumLeaveTime - sumEntryTime) / (long)stageCount)));
                List successEntityList = opportunityEntityList.stream().filter(entity -> winStage.contains(entity.getCustomerStageId())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(successEntityList)) {
                    opportunityStageConversionVo.setSuccessRate(defaultSuccessRate);
                    defaultSuccessMap = successRateMap;
                } else {
                    opportunityStageConversionVo.setSuccessRate(CommonUtills.calculatePercent((int)successEntityList.size(), (int)stageCount));
                }
            } else {
                List entryStageRecord;
                String thisDefaultSuccessRate = (String)defaultSuccessMap.get(stageId);
                if (StringUtil.isEmpty((Object)thisDefaultSuccessRate)) {
                    thisDefaultSuccessRate = "0.00%";
                }
                opportunityStageConversionVo.setSuccessRate(thisDefaultSuccessRate);
                if (CollectionUtil.isNotEmpty(stageRecordList) && CollectionUtil.isNotEmpty(entryStageRecord = stageRecordList.stream().filter(stageRecordVo -> stageId.equals(stageRecordVo.getAfterStageId())).collect(Collectors.toList()))) {
                    List opportunityIdList;
                    if (!"20".equals(stageType)) {
                        opportunityIdList = entryStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                        opportunityIdList = opportunityIdList.stream().distinct().collect(Collectors.toList());
                        stageCount = opportunityIdList.size();
                        opportunityStageConversionVo.setCount(Integer.valueOf(stageCount));
                        Double sumAmount = 0.0;
                        HashSet<Long> opportunityIdSet = new HashSet<Long>();
                        for (OpportunityStageRecordVo opportunityStageRecordVo2 : entryStageRecord) {
                            if (!opportunityIdSet.add(opportunityStageRecordVo2.getOpportunityId())) continue;
                            sumAmount = sumAmount + (opportunityStageRecordVo2.getOpportunityAmount() == null ? 0.0 : opportunityStageRecordVo2.getOpportunityAmount());
                        }
                        opportunityStageConversionVo.setAmount(CommonUtills.transferAmount((Double)sumAmount));
                        sumEntryTime = entryStageRecord.stream().mapToLong(stageRecordVo -> {
                            LocalDate entryTime;
                            LocalDate localDate = entryTime = stageRecordVo.getEntryTime() == null ? null : stageRecordVo.getEntryTime().toLocalDate();
                            if (entryTime == null) {
                                return nowSecond;
                            }
                            return entryTime.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
                        }).sum();
                        long sumLeaveTime = 0L;
                        sumLeaveTime = entryStageRecord.stream().mapToLong(stageRecordVo -> {
                            LocalDate leaveTime;
                            LocalDate localDate = leaveTime = stageRecordVo.getLeaveTime() == null ? null : stageRecordVo.getLeaveTime().toLocalDate();
                            if (leaveTime == null) {
                                return nowSecond;
                            }
                            return leaveTime.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli() / 1000L;
                        }).sum();
                        opportunityStageConversionVo.setStopTimeAvg(CrmDateUtils.secondToDay((Long)((sumLeaveTime - sumEntryTime) / (long)stageCount)));
                        List successStageRecord = entryStageRecord.stream().filter(stageRecordVo -> winStage.contains(HussarUtils.toStr((Object)stageRecordVo.getCurrentStageId()))).collect(Collectors.toList());
                        if (CollectionUtil.isNotEmpty(successStageRecord)) {
                            List successOpportunitIdList = successStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                            if (CollectionUtil.isNotEmpty(successOpportunitIdList)) {
                                successOpportunitIdList = successOpportunitIdList.stream().distinct().collect(Collectors.toList());
                            }
                            opportunityStageConversionVo.setSuccessRate(CommonUtills.calculatePercent((int)successOpportunitIdList.size(), (int)stageCount));
                        }
                    } else {
                        opportunityIdList = entryStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                        opportunityIdList = opportunityIdList.stream().distinct().collect(Collectors.toList());
                        List winOpportunityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, opportunityIdList)).in(OpportunityEntity::getCustomerStageId, winStage)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
                        stageCount = winOpportunityList.size();
                        opportunityStageConversionVo.setCount(Integer.valueOf(stageCount));
                        Double sumAmount = 0.0;
                        for (OpportunityEntity opportunity : winOpportunityList) {
                            if (!HussarUtils.isNotEmpty((Object)opportunity.getOpportunityAmount())) continue;
                            sumAmount = sumAmount + Double.parseDouble(opportunity.getOpportunityAmount());
                        }
                        opportunityStageConversionVo.setAmount(CommonUtills.transferAmount((Double)sumAmount));
                        opportunityStageConversionVo.setAbandonCount("--");
                        opportunityStageConversionVo.setAbandonRate("--");
                        opportunityStageConversionVo.setCloseCount("--");
                        opportunityStageConversionVo.setStopTimeAvg("--");
                        opportunityStageConversionVo.setSuccessRate("--");
                    }
                    opportunityStageConversionVo.setConversionRate(CommonUtills.calculatePercent((int)stageCount, (int)firstStageCount));
                }
            }
            if (CollectionUtil.isNotEmpty(leaveStageRecord) && !"20".equals(stageType)) {
                List loseStageRecord = leaveStageRecord.stream().filter(stageRecordVo -> loseStage.contains(stageRecordVo.getAfterStageId().toString()) && loseStage.contains(HussarUtils.toStr((Object)stageRecordVo.getCurrentStageId()))).collect(Collectors.toList());
                List abandonStageRecord = leaveStageRecord.stream().filter(stageRecordVo -> abandonStage.contains(stageRecordVo.getAfterStageId().toString()) && abandonStage.contains(HussarUtils.toStr((Object)stageRecordVo.getCurrentStageId()))).collect(Collectors.toList());
                List closeStageRecord = leaveStageRecord.stream().filter(stageRecordVo -> convertStage.contains(stageRecordVo.getAfterStageId().toString()) && convertStage.contains(HussarUtils.toStr((Object)stageRecordVo.getCurrentStageId()))).collect(Collectors.toList());
                int lossCount = 0;
                if (CollectionUtil.isNotEmpty(loseStageRecord)) {
                    List opportunityIdList = loseStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                    opportunityIdList = opportunityIdList.stream().distinct().collect(Collectors.toList());
                    opportunityStageConversionVo.setLoseCount(String.valueOf(opportunityIdList.size()));
                    opportunityStageConversionVo.setLoseRate(CommonUtills.calculatePercent((int)opportunityIdList.size(), (int)stageCount));
                    lossCount += opportunityIdList.size();
                }
                if (CollectionUtil.isNotEmpty(abandonStageRecord)) {
                    List opportunityIdList = abandonStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                    opportunityIdList = opportunityIdList.stream().distinct().collect(Collectors.toList());
                    opportunityStageConversionVo.setAbandonCount(String.valueOf(opportunityIdList.size()));
                    opportunityStageConversionVo.setAbandonRate(CommonUtills.calculatePercent((int)opportunityIdList.size(), (int)stageCount));
                    lossCount += opportunityIdList.size();
                }
                if (CollectionUtil.isNotEmpty(closeStageRecord)) {
                    List opportunityIdList = closeStageRecord.stream().map(OpportunityStageRecordVo::getOpportunityId).collect(Collectors.toList());
                    opportunityIdList = opportunityIdList.stream().distinct().collect(Collectors.toList());
                    opportunityStageConversionVo.setCloseCount(String.valueOf(opportunityIdList.size()));
                    lossCount += opportunityIdList.size();
                }
                opportunityStageConversionVo.setLossCount(String.valueOf(lossCount));
                opportunityStageConversionVo.setLossRate(CommonUtills.calculatePercent((int)lossCount, (int)stageCount));
            }
            if ("20".equals(stageType)) {
                opportunityStageConversionVo.setLossRate("--");
                opportunityStageConversionVo.setLossCount("--");
                opportunityStageConversionVo.setLoseCount("--");
                opportunityStageConversionVo.setLoseRate("--");
            }
            opportunityStageConversionVoList.add(opportunityStageConversionVo);
        }
        return opportunityStageConversionVoList;
    }

    private void initStageConversion(OpportunityStageConversionVo opportunityStageConversionVo) {
        opportunityStageConversionVo.setConversionRate("--");
        opportunityStageConversionVo.setCount(Integer.valueOf(0));
        opportunityStageConversionVo.setAmount("0.00");
        opportunityStageConversionVo.setStopTimeAvg("0\u5929");
        opportunityStageConversionVo.setLossCount("0");
        opportunityStageConversionVo.setLossRate("0.00%");
        opportunityStageConversionVo.setLoseCount("0");
        opportunityStageConversionVo.setLoseRate("0.00%");
        opportunityStageConversionVo.setAbandonCount("0");
        opportunityStageConversionVo.setAbandonRate("0.00%");
        opportunityStageConversionVo.setCloseCount("0");
    }
}

