/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityStatisticsDto;
import com.jxdinfo.crm.core.opportunity.dao.OpportunitySelectMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.IOpportunitySelectService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunitySelectServiceImpl
implements IOpportunitySelectService {
    @Resource
    private OpportunitySelectMapper opportunitySelectMapper;

    @Override
    public List<OpportunityEntity> selectListIfNullAll(List<Long> ids, OpportunityStatisticsDto dto) {
        dto = this.updateParameter(dto);
        return this.opportunitySelectMapper.selectList(ids, dto);
    }

    @Override
    public List<OpportunityEntity> selectListIfNullAllSimplify(List<Long> ids, OpportunityStatisticsDto dto) {
        dto = this.updateParameter(dto);
        return this.opportunitySelectMapper.selectListSimplify(ids, dto);
    }

    @Override
    public Page<OpportunityEntity> selectListIfNullAll(List<Long> ids, OpportunityStatisticsDto dto, Page<OpportunityEntity> page) {
        dto = this.updateParameter(dto);
        return this.opportunitySelectMapper.selectList(ids, dto, page);
    }

    private OpportunityStatisticsDto updateParameter(OpportunityStatisticsDto dto) {
        DateConvertVo dateConvertVo;
        String stageFinishTimeFlag;
        DateConvertVo dateConvertVo2;
        String successTimeFlag;
        DateConvertVo dateConvertVo3;
        String endTimeFlag;
        DateConvertVo dateConvertVo4;
        String createTimeFlag = dto.getCreateTimeFlag();
        if (StringUtil.isNotEmpty((Object)createTimeFlag) && !"6".equals(createTimeFlag) && (dateConvertVo4 = CrmDateUtils.getCurrentTime((String)createTimeFlag)) != null) {
            dto.setCreateTimeStart(LocalDate.parse(dateConvertVo4.getStartDate()));
            dto.setCreateTimeEnd(LocalDate.parse(dateConvertVo4.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(endTimeFlag = dto.getEndTimeFlag())) && !"6".equals(endTimeFlag) && (dateConvertVo3 = CrmDateUtils.getCurrentTime((String)endTimeFlag)) != null) {
            dto.setEndTimeStart(LocalDate.parse(dateConvertVo3.getStartDate()));
            dto.setEndTimeEnd(LocalDate.parse(dateConvertVo3.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(successTimeFlag = dto.getSuccessTimeFlag())) && !"6".equals(successTimeFlag) && (dateConvertVo2 = CrmDateUtils.getCurrentTime((String)successTimeFlag)) != null) {
            dto.setSuccessTimeStart(LocalDate.parse(dateConvertVo2.getStartDate()));
            dto.setSuccessTimeStart(LocalDate.parse(dateConvertVo2.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(stageFinishTimeFlag = dto.getStageFinishTimeFlag())) && !"6".equals(stageFinishTimeFlag) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)stageFinishTimeFlag)) != null) {
            dto.setStageFinishTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setStageFinishTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        dto.setSearchKey(CommonUtills.escapeLike((String)dto.getSearchKey()));
        return dto;
    }
}

