/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.fileinfo.model.FileImport;
import com.jxdinfo.crm.core.fileinfo.service.FileImportService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dao.RepeatOpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityImportAndExportService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.util.OpportunityUtil;
import com.jxdinfo.crm.core.opportunity.vo.SuspectedOpportunityVo;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ReadLeadsExcelUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OpportunityImportAndExportImpl
extends ServiceImpl<OpportunityMapper, OpportunityEntity>
implements OpportunityImportAndExportService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private RepeatOpportunityMapper repeatOpportunityMapper;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private IDictBoService dictBoService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FileImportService fileImportService;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private ICrmBaseConfigBoService iCrmBaseConfigBoService;

    @Override
    @Transactional
    public String opportunityImport(MultipartFile file) {
        int flag = 0;
        if (file == null) {
            flag = -1;
        }
        if (!file.getOriginalFilename().endsWith("xlsx")) {
            flag = -2;
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        Long deptId = user.getDeptId();
        String deptName = user.getDeptName();
        AttachmentManagerModelVo attachment = null;
        AttachmentManagerModelVo suspectedAttachment = null;
        ArrayList<SuspectedOpportunityVo> suspectedOpportunityList = new ArrayList<SuspectedOpportunityVo>();
        Long fileImportId = Long.valueOf(CommonUtills.generateAssignId());
        ArrayList<OpportunityEntity> addOpportunityList = new ArrayList<OpportunityEntity>();
        int importCount = 0;
        int suspectedCount = 0;
        List<OpportunityEntity> list = ReadLeadsExcelUtil.getExcelInfo(file);
        if (CollectionUtil.isEmpty(list)) {
            throw new BaseException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        for (OpportunityEntity opportunity : list) {
            CheckRepeat suspectedOpportunity;
            if (!OpportunityImportAndExportImpl.isValidNumber(opportunity.getOpportunityAmount())) {
                throw new HussarException(opportunity.getOpportunityName() + "\u7684\u5546\u673a\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
            }
            if (StringUtil.isNotBlank((CharSequence)opportunity.getCustomerName()) && (suspectedOpportunity = this.opportunityService.selectSuspectedOpportunityByCustomerName(opportunity.getCustomerName())).getRepeatResult().booleanValue()) {
                String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
                List<SuspectedOpportunityVo> suspectedList = this.repeatOpportunityMapper.importSuspectedOpportunityList(opportunity.getCustomerName(), openPool);
                suspectedList.sort((o1, o2) -> {
                    Collator comparator = Collator.getInstance((ULocale)ULocale.CHINA);
                    return comparator.compare(o1.getSuspectedCustomerName(), o2.getSuspectedCustomerName());
                });
                if (CollectionUtil.isNotEmpty(suspectedList)) {
                    for (SuspectedOpportunityVo suspectedOpportunityVo : suspectedList) {
                        suspectedOpportunityVo.setImportOpportunityName(opportunity.getOpportunityName());
                        suspectedOpportunityVo.setImportCustomerName(opportunity.getCustomerName());
                    }
                }
                suspectedOpportunityList.addAll(suspectedList);
                ++suspectedCount;
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)opportunity.getSecurityLevelLabel())) {
                String securityLevel = this.leadsMapper.selectValueByLabel("security_level", opportunity.getSecurityLevelLabel());
                if (ToolUtil.isEmpty((Object)securityLevel)) {
                    opportunity.setSecurityLevel(null);
                } else {
                    opportunity.setSecurityLevel(Integer.valueOf(securityLevel));
                }
            }
            opportunity.setState("5");
            opportunity.setCreatePerson(userId);
            opportunity.setCreatePersonName(userName);
            opportunity.setCreateDepartment(deptId);
            opportunity.setCreateDepartmentName(deptName);
            opportunity.setCreateTime(date);
            opportunity.setOwnDepartment(deptId);
            opportunity.setOwnDepartmentName(deptName);
            opportunity.setChangePerson(userId);
            opportunity.setChangePersonName(userName);
            opportunity.setChangeTime(date);
            opportunity.setImportance("1");
            opportunity.setCustomerBudget("0.00");
            opportunity.setDelFlag("0");
            ++importCount;
            addOpportunityList.add(opportunity);
        }
        OpportunityUtil.batchOpportunityNo(addOpportunityList);
        this.opportunityService.saveBatch(addOpportunityList);
        ArrayList<OpportunityProduct> opportunityProductList = new ArrayList<OpportunityProduct>();
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        for (OpportunityEntity opportunity : addOpportunityList) {
            String regex;
            String productName;
            List<String> productNames;
            TeamMeberEntity teamMeber = this.saveTeamMember(user, date, opportunity.getOpportunityId());
            teamMeberEntityList.add(teamMeber);
            OperateRecordAPIVo trackRecord = this.saveTrackRecord(user, date, opportunity.getOpportunityId(), opportunity.getOpportunityName());
            trackRecordList.add(trackRecord);
            if (!ToolUtil.isNotEmpty((Object)opportunity.getProductName()) || !CollectionUtil.isNotEmpty(productNames = Arrays.asList((productName = opportunity.getProductName()).split(regex = "\uff0c|,")))) continue;
            for (String opportunityProductName : productNames) {
                OpportunityProduct opportunityProduct = this.saveOpportunityProduct(user, date, opportunity.getOpportunityId(), opportunity.getOpportunityName(), opportunityProductName);
                if (!ToolUtil.isNotEmpty((Object)opportunityProduct)) continue;
                opportunityProductList.add(opportunityProduct);
            }
        }
        this.teamMeberService.saveBatch(teamMeberEntityList);
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
        this.opportunityProductService.saveBatch(opportunityProductList);
        FileInputStream inputStream = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
            attachment = (AttachmentManagerModelVo)response.getData();
            if (CollectionUtil.isNotEmpty(suspectedOpportunityList)) {
                File file1 = OpportunityUtil.exportExcelPaper(suspectedOpportunityList);
                inputStream = new FileInputStream(file1);
                MockMultipartFile multipartFile = new MockMultipartFile(file1.getName(), file1.getName(), "application/octet-stream", (InputStream)inputStream);
                ApiResponse suspectedResponse = this.attachmentManagerService.uploadFileWithDrag((MultipartFile)multipartFile, null);
                suspectedAttachment = (AttachmentManagerModelVo)suspectedResponse.getData();
                file1.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FileImport fileImport = new FileImport();
        String sourceFileName = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\uff0c\u81ea\u52a8\u8fc7\u6ee4" + suspectedCount + "\u6761\u7591\u4f3c\u5546\u673a";
        } else {
            fileImport.setSuccessFail("0");
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(sourceFileName);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId(LabelModuleEnum.OPPORTUNITY.getModuleId());
        if (CollectionUtil.isNotEmpty(suspectedOpportunityList)) {
            Long suspectedFileId = suspectedAttachment.getId();
            fileImport.setSuspectedFileId(suspectedFileId);
            fileImport.setSuspectedFileName(suspectedAttachment.getFileName());
        }
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag("0");
        this.fileImportService.save((Object)fileImport);
        return "\u5bfc\u5165\u6210\u529f";
    }

    private TeamMeberEntity saveTeamMember(SecurityUser user, LocalDateTime date, long businessId) {
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberName(user.getUserName());
        teamMeberEntity.setPersonId(user.getUserId());
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType("2");
        teamMeberEntity.setModifyPower("1");
        teamMeberEntity.setIsCharge("0");
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        teamMeberEntity.setMemberRole("7");
        teamMeberEntity.setOwnDepartment(user.getDeptId());
        teamMeberEntity.setOwnDepartmentName(user.getDeptName());
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return teamMeberEntity;
    }

    private OperateRecordAPIVo saveTrackRecord(SecurityUser user, LocalDateTime date, long businessId, String businessName) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
        operateRecordDO.setTypeId(Long.valueOf(businessId));
        operateRecordDO.setBusinessName(businessName);
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName(user.getUserName());
        operateRecordDO.setCreateTime(date);
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(date);
        operateRecordDO.setChangePersonName(user.getUserName());
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        return operateRecordDO;
    }

    private OpportunityProduct saveOpportunityProduct(SecurityUser user, LocalDateTime date, Long businessId, String businessName, String productName) {
        OpportunityProduct opportunityProduct = new OpportunityProduct();
        Product product = (Product)this.productMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getProductName, (Object)productName)).eq(Product::getDelFlag, (Object)"0"));
        if (ToolUtil.isEmpty((Object)product)) {
            return null;
        }
        opportunityProduct.setProductId(product.getProductId());
        opportunityProduct.setProductName(productName);
        opportunityProduct.setOpportunityId(businessId);
        opportunityProduct.setOpportunityName(businessName);
        opportunityProduct.setStandardPrice(product.getProductPrice());
        opportunityProduct.setSellPrice("0.00");
        opportunityProduct.setDiscount("100");
        opportunityProduct.setProductNumber("1");
        opportunityProduct.setProductSubtotal("0.00");
        opportunityProduct.setTotalPrice("0.00");
        opportunityProduct.setProductType(product.getProductType());
        opportunityProduct.setCreatePerson(user.getUserId());
        opportunityProduct.setCreatePersonName(user.getUserName());
        opportunityProduct.setCreateTime(date);
        opportunityProduct.setChangePerson(user.getUserId());
        opportunityProduct.setChangePersonName(user.getUserName());
        opportunityProduct.setChangeTime(date);
        opportunityProduct.setDelFlag("0");
        return opportunityProduct;
    }

    @Override
    public void opportunityImportTemplate(HttpServletResponse response) {
        try {
            XSSFWorkbook leads = new XSSFWorkbook();
            XSSFSheet sheet = leads.createSheet("\u5546\u673a\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
            XSSFCellStyle style = leads.createCellStyle();
            Row row = sheet.createRow(0);
            String defaultStageName = (String)this.stageProcessService.getObj((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getProcessName}).eq(StageProcessEntity::getIsDefault, (Object)"1"), String::valueOf);
            String[] colsName = new String[]{"\u5546\u673a\u540d\u79f0", "\u5ba2\u6237\u540d\u79f0", "\u5546\u673a\u91d1\u989d", "\u5546\u673a\u65e5\u671f(\u683c\u5f0f\uff1a\u4f8b\uff1a2023/3/3)", "\u6570\u636e\u5bc6\u7ea7"};
            List<String> cols = Arrays.asList(colsName);
            int j = cols.size();
            for (int i = 0; i < j; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(cols.get(i));
                int columnWidth = sheet.getColumnWidth(i) / 256 + 10;
                int length = cols.get(i).getBytes("UTF-8").length + 1;
                if (columnWidth < length + 1) {
                    columnWidth = length + 1;
                }
                sheet.setColumnWidth(i, columnWidth * 256);
            }
            response.reset();
            String fileName = "\u5546\u673a\u4fe1\u606f\u5bfc\u5165\u6a21\u677f";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes(), "iso-8859-1") + ".xlsx");
            leads.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25!" + e.getMessage());
        }
    }

    private static boolean isValidNumber(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

