/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.core.opportunity.dao.CrmOpportunityStatusMapper;
import com.jxdinfo.crm.core.opportunity.dto.CrmOpportunityStatusPageDto;
import com.jxdinfo.crm.core.opportunity.model.CrmOpportunityStatus;
import com.jxdinfo.crm.core.opportunity.service.CrmOpportunityStatusService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract.crmopportunitystatus.CrmOpportunityStatusServiceImpl")
@HussarTokenDs
public class CrmOpportunityStatusServiceImpl
extends HussarServiceImpl<CrmOpportunityStatusMapper, CrmOpportunityStatus>
implements CrmOpportunityStatusService {
    private static final Logger logger = LoggerFactory.getLogger(CrmOpportunityStatusServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Autowired
    private CrmOpportunityStatusMapper statusMapper;

    public List<CrmOpportunityStatus> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmOpportunityStatus.class)));
    }

    @Override
    public ApiResponse saveStatus(CrmOpportunityStatus entity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SysStru unit = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        entity.setCreateId(user.getId().toString());
        entity.setCreateName(user.getUserName());
        entity.setCreateDepartment(user.getDeptId().toString());
        entity.setCreateDepartmentName(user.getDeptName());
        entity.setCreateUnit(unit.getId().toString());
        entity.setCreateUnitName(unit.getOrganAlias());
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(LocalDateTime.now());
        }
        this.save(entity);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse updateStatus(CrmOpportunityStatus entity) {
        this.updateById(entity);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse deleteStatus(CrmOpportunityStatus entity) {
        if (CollectionUtil.isNotEmpty(entity.getStatusList())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CrmOpportunityStatus::getDelFlag, (Object)"1")).in(CrmOpportunityStatus::getId, entity.getStatusList()));
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
    }

    @Override
    public Page<CrmOpportunityStatus> listPage(CrmOpportunityStatusPageDto pageDto) {
        Page page = pageDto.getPage();
        List<CrmOpportunityStatus> list = this.statusMapper.listPage(page, pageDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse statusInfo(Long id) {
        return ApiResponse.success((Object)this.statusMapper.selectById(id));
    }
}

