/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.external.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.core.api.opportunity.dto.QueryDateDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.leads.external.dao.LeadSalesKPIMapper;
import com.jxdinfo.crm.core.leads.external.service.ILeadSalesKPIService;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.opportunity.external.dto.SalesKPIDto;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadSalesKPIServiceImpl
implements ILeadSalesKPIService {
    @Resource
    private LeadSalesKPIMapper leadSalesKPIMapper;
    @Resource
    private IOrganUserBoService organUserBoService;

    @Override
    public Page<Leads> selectLeadList(SalesKPIDto dto) {
        Page<Leads> page = this.pageHandling(dto);
        SalesKPIDto salesStatisticsDto = this.salesStatisticsDtoHandling(dto);
        List<Leads> list = this.leadSalesKPIMapper.selectLeadList(salesStatisticsDto, page);
        page.setRecords(list);
        return page;
    }

    private Page<Leads> pageHandling(SalesKPIDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    private SalesKPIDto salesStatisticsDtoHandling(SalesKPIDto dto) {
        DateConvertVo dateConverVo;
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty(dto.getCreateTimeList())) {
            for (QueryDateDto dateDto : dto.getCreateTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getEndTimeList())) {
            for (QueryDateDto dateDto : dto.getEndTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getSuccessTimeList())) {
            for (QueryDateDto dateDto : dto.getSuccessTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        if (ToolUtil.isNotEmpty(dto.getCreateDepartmentList())) {
            dto.setCreateDepartmentList(this.organUserBoService.getOrganByParentIdContainsParent(dto.getCreateDepartmentList()));
        }
        return dto;
    }
}

