/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.job.dao.RecordCountMapper;
import com.jxdinfo.crm.core.job.model.RecordCount;
import com.jxdinfo.crm.core.job.service.RecordCountService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.task.dao.TaskMapper;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.unify.dao.UnifyPortalMapper;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.notice.service.ISysMessageService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RecordCountServiceImpl
implements RecordCountService {
    @Resource
    private RecordCountMapper recordCountMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ISysMessageService sysMessageService;
    @Resource
    private UnifyPortalMapper unifyPortalMapper;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public ProcessResult selectRecordCount() {
        List<TaskEntity> taskEntityList;
        AddSysMessageType addSysMessageType;
        LocalDateTime dateNow = LocalDateTime.now();
        List<RecordCount> recordCountList = this.recordCountMapper.selectRecordCount(dateNow);
        if (CollectionUtil.isNotEmpty(recordCountList)) {
            for (RecordCount rec : recordCountList) {
                String title = "\u4eca\u65e5\u6709" + rec.getCountRecord() + "\u9879\u5f85\u8ddf\u8fdb\u4e8b\u5b9c";
                String content = "\u8bf7\u767b\u5f55CRM\u4e86\u89e3\u8be6\u60c5";
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sy/yddsy", "", Arrays.asList(String.valueOf(rec.getCreatePerson())));
                String contentUnify = "\u3010\u8ddf\u8fdb\u63d0\u9192\u3011\u4eca\u65e5\u60a8\u6709" + rec.getCountRecord() + "\u9879\u5f85\u8ddf\u8fdb\u4e8b\u5b9c\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setMessageContent(contentUnify);
                addSysMessageType.setReleaseDate(dateNow.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setUserId(String.valueOf(rec.getCreatePerson()));
                addSysMessageType.setCreator(CommonConstant.SUPER_ADMIN);
                addSysMessageType.setLastEditor(CommonConstant.SUPER_ADMIN);
                addSysMessageType.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setMobileBusinessAddress("");
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        if (CollectionUtil.isNotEmpty(taskEntityList = this.taskMapper.selectOverTaskList("1", "0", dateNow))) {
            for (TaskEntity task : taskEntityList) {
                String title = "\u60a8\u7684\u4efb\u52a1\u5df2\u903e\u671f\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
                String content = "\u4efb\u52a1\u63cf\u8ff0\uff1a" + task.getContent() + "\n\u622a\u6b62\u65f6\u95f4\uff1a" + DateTimeUtil.DATETIME_FORMAT.format(task.getLastTime());
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/rw/rwxq", String.valueOf(task.getTaskId()), Arrays.asList(String.valueOf(task.getChargePerson())));
                addSysMessageType = new AddSysMessageType();
                String contentUnify = "\u3010\u4efb\u52a1\u63d0\u9192\u3011\u60a8\u7684\u4efb\u52a1\u5df2\u903e\u671f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u4efb\u52a1\u63cf\u8ff0\uff1a" + task.getContent() + "\u3002\u622a\u6b62\u65f6\u95f4\uff1a" + DateTimeUtil.DATETIME_FORMAT.format(task.getLastTime()) + "\u3002";
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/rw/todoTask";
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setMessageContent(contentUnify);
                addSysMessageType.setReleaseDate(dateNow.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setUserId(String.valueOf(task.getChargePerson()));
                addSysMessageType.setCreator(CommonConstant.SUPER_ADMIN);
                addSysMessageType.setLastEditor(CommonConstant.SUPER_ADMIN);
                addSysMessageType.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setMobileBusinessAddress("");
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        return new ProcessResult(true);
    }

    @Override
    public ProcessResult NotFollowTrack() {
        LocalDateTime dateNow = LocalDateTime.now();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWinLose(true);
        List stageWinLose = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWinLose();
        LocalDate sevenDay = dateNow.toLocalDate().minusDays(7L);
        LocalDate fifteenDay = dateNow.toLocalDate().minusDays(15L);
        LocalDate thirtyDay = dateNow.toLocalDate().minusDays(30L);
        List<Map<String, Object>> list = this.unifyPortalMapper.selectUserRecordCount(stageWinLose, sevenDay, fifteenDay, thirtyDay);
        for (Map<String, Object> map : list) {
            String contentUnify;
            String content;
            String title;
            String jqxTitle;
            String unFollowCount = "0";
            String fifteenCount = "0";
            String thirtyCount = "0";
            if (map.get("UNFOLLOW_COUNT") != null) {
                unFollowCount = String.valueOf(map.get("UNFOLLOW_COUNT"));
            }
            if (map.get("FIFTEEN_COUNT") != null) {
                fifteenCount = String.valueOf(map.get("FIFTEEN_COUNT"));
            }
            if (map.get("THIRTY_COUNT") != null) {
                thirtyCount = String.valueOf(map.get("THIRTY_COUNT"));
            }
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
            addSysMessageType.setReleaseDate(dateNow.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            addSysMessageType.setUserId(String.valueOf(map.get("CHARGE_PERSON_ID")));
            addSysMessageType.setCreator(CommonConstant.SUPER_ADMIN);
            addSysMessageType.setLastEditor(CommonConstant.SUPER_ADMIN);
            addSysMessageType.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
            addSysMessageType.setMobileBusinessAddress("");
            addSysMessageType.setOpenWay("1");
            if (Long.parseLong(unFollowCount) > 0L) {
                jqxTitle = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011";
                title = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011\u672a\u8ddf\u8fdb\u5546\u673a" + unFollowCount + "\u4e2a";
                content = "\u672a\u8ddf\u8fdb\u5546\u673a" + unFollowCount + "\u4e2a\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
                contentUnify = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011\u60a8\u6709" + unFollowCount + "\u4e2a\u5546\u673a\u672a\u8ddf\u8fdb\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
                addSysMessageType.setMessageContent(contentUnify);
                EimPushUtil.pushJqxArticleMessage(jqxTitle, content, "/crm/sj/sjxq/xxzl", "", Arrays.asList(ObjectUtil.toString((Object)map.get("CHARGE_PERSON_ID"))));
                UnifyUtil.sendMessage(addSysMessageType);
            }
            if (Long.parseLong(fifteenCount) > 0L) {
                jqxTitle = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011";
                title = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011[7,15)\u5929\u672a\u8ddf\u8fdb\u5546\u673a" + fifteenCount + "\u4e2a";
                content = "[7,15)\u5929\u672a\u8ddf\u8fdb\u5546\u673a" + fifteenCount + "\u4e2a\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
                contentUnify = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011\u60a8\u6709" + fifteenCount + "\u4e2a\u5546\u673a\u8ddd\u79bb\u4e0a\u6b21\u8ddf\u8fdb\u65f6\u95f4\u8d85\u8fc77\u5929\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
                addSysMessageType.setMessageContent(contentUnify);
                EimPushUtil.pushJqxArticleMessage(jqxTitle, content, "/crm/sj/sjxq/xxzl", "", Arrays.asList(ObjectUtil.toString((Object)map.get("CHARGE_PERSON_ID"))));
                UnifyUtil.sendMessage(addSysMessageType);
            }
            if (Long.parseLong(thirtyCount) <= 0L) continue;
            jqxTitle = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011";
            title = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011[15,30)\u5929\u672a\u8ddf\u8fdb\u5546\u673a" + thirtyCount + "\u4e2a";
            content = "[15,30)\u5929\u672a\u8ddf\u8fdb\u5546\u673a" + thirtyCount + "\u4e2a\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            contentUnify = "\u3010\u5546\u673a\u8ddf\u8fdb\u63d0\u9192\u3011\u60a8\u6709" + thirtyCount + "\u4e2a\u5546\u673a\u8ddd\u79bb\u4e0a\u6b21\u8ddf\u8fdb\u65f6\u95f4\u8d85\u8fc715\u5929\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            addSysMessageType.setMessageContent(contentUnify);
            EimPushUtil.pushJqxArticleMessage(jqxTitle, content, "/crm/sj/sjxq/xxzl", "", Arrays.asList(ObjectUtil.toString((Object)map.get("CHARGE_PERSON_ID"))));
            UnifyUtil.sendMessage(addSysMessageType);
        }
        return new ProcessResult(true);
    }
}

