/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.sysCalendar.dto.DayTypeDto;
import com.jxdinfo.crm.common.api.sysCalendar.dto.RecycleReasonDate;
import com.jxdinfo.crm.common.api.sysCalendar.service.ISysCalendarBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordRelationAPIService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolEditConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.dao.OpportunityPoolRuleMapper;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.RuleRecycle;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.WhiteListMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IPublicPoolRuleService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRecycleMessageVo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OppoRuleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.OpportunityPoolMemberVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.vo.RuleRecycleVO;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.job.model.OpportunityRecycleReason;
import com.jxdinfo.crm.core.job.service.OpportunityRecycleService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpportunityRecycleServiceImpl
implements OpportunityRecycleService {
    @Resource
    private IPublicPoolRuleService poolRuleService;
    @Resource
    private ICrmBaseConfigBoService baseConfigBoService;
    @Resource
    private OpportunityPoolRuleMapper opportunityPoolRuleMapper;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ISysCalendarBoService calendarBoService;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ITrackRecordRelationAPIService trackRecordRelationAPIService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private TaskService taskService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IMessageTemplateService messageTemplateService;

    @Override
    @Transactional
    public ProcessResult opportunityRecycle() {
        LocalDate dateNow = LocalDate.now();
        LocalDateTime dateTimeNow = LocalDateTime.now();
        HashMap<Long, RuleRecycleVO> ruleVoMap = new HashMap<Long, RuleRecycleVO>();
        HashMap opportunityRecycleReasonMap = new HashMap();
        CrmBaseConfigVo configVo = this.baseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OLD_POOL_FIRST);
        boolean oldPoolFirst = "1".equals(configVo.getConfigValue());
        List<OppoRuleVO> ruleList = this.opportunityPoolRuleMapper.selectAllRecyclePoolRule();
        Map<Object, Object> poolIdRuleMap = new HashMap();
        poolIdRuleMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        ruleList.forEach(oppoRuleVO -> oppoRuleVO.setRuleRecycle((RuleRecycle)JSON.parseObject((String)oppoRuleVO.getPublicPoolRuleRecycle(), RuleRecycle.class)));
        ruleList.removeIf(oppoRuleVO -> oppoRuleVO.getRuleRecycle().getCondition().isEmpty());
        HashMap<Long, Object> poolIdOpportunityListMap = new HashMap<Long, Object>();
        List noTrackDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoTrackDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoTrackDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains("rule1")) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noTrackDateList = this.calendarBoService.getStartDate(noTrackDtoList, dateNow);
        List noWinDtoList = ruleList.stream().map(oppoRuleVO -> {
            DayTypeDto dto = new DayTypeDto();
            if (oppoRuleVO.getRuleRecycle().getNoWinDay() != null) {
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoWinDay())));
            }
            dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
            if (oppoRuleVO.getRuleRecycle().getCondition() == null || !oppoRuleVO.getRuleRecycle().getCondition().contains("rule2")) {
                dto.setSwitchFlag("-1");
            } else {
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
            }
            return dto;
        }).collect(Collectors.toList());
        List noWinDateList = this.calendarBoService.getStartDate(noWinDtoList, dateNow);
        Map<String, List<OpportunityStage>> stageNameMap = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).stream().collect(Collectors.groupingBy(OpportunityStage::getStageNameValue));
        for (int i = 0; i < ruleList.size(); ++i) {
            List memberList = ruleList.get(i).getMemberVOList().stream().filter(o -> OpportunityPoolConstant.POOL_MEMBER_ROLE_NORMAL.equals(o.getMemberRole())).collect(Collectors.toList());
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList deptIdList = new ArrayList();
            RuleRecycle ruleRecycle = ruleList.get(i).getRuleRecycle();
            Iterator iterator = memberList.iterator();
            while (iterator.hasNext()) {
                OpportunityPoolMemberVO memberVO = (OpportunityPoolMemberVO)iterator.next();
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_USER.equals(memberVO.getMemberType())) {
                    arrayList.add(memberVO.getMemberId());
                    continue;
                }
                if (OpportunityPoolConstant.POOL_MEMBER_TYPE_ROLE.equals(memberVO.getMemberType())) {
                    List<String> userIds = this.commonMapper.getUserByRoleId(memberVO.getMemberId());
                    arrayList.addAll(userIds.stream().map(userId -> Long.parseLong(userId)).collect(Collectors.toList()));
                    continue;
                }
                if (!OpportunityPoolConstant.POOL_MEMBER_TYPE_STRU.equals(memberVO.getMemberType())) continue;
                deptIdList.add(memberVO.getMemberId());
            }
            List userVos = this.organUserBoService.getUserListByDepartmentId((List)deptIdList);
            arrayList.addAll(userVos.stream().map(UserVo::getId).collect(Collectors.toList()));
            List list = arrayList.stream().distinct().collect(Collectors.toList());
            List<WhiteListMember> whiteList = ruleRecycle.getWhite();
            List whitePersonId = whiteList.stream().map(whiteListMember -> Long.parseLong(whiteListMember.getValue())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(list)) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            List<String> stageNameValue = ruleRecycle.getRange();
            ArrayList stageIds = new ArrayList();
            for (String value2 : stageNameValue) {
                if (stageNameMap.get(value2) == null) continue;
                stageIds.addAll(stageNameMap.get(value2).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()));
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(OpportunityEntity::getChargePersonId, list)).eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getCustomerStageId, stageIds);
            if (CollectionUtil.isNotEmpty(whitePersonId)) {
                queryWrapper.notIn(OpportunityEntity::getChargePersonId, whitePersonId);
            }
            List opportunityEntityList = this.opportunityService.list((Wrapper)queryWrapper);
            List oppoReason = opportunityEntityList.stream().map(opportunityEntity -> {
                OpportunityRecycleReason opportunityRecycleReason = new OpportunityRecycleReason();
                opportunityRecycleReason.setOpportunityId(opportunityEntity.getOpportunityId());
                opportunityRecycleReason.setResourcePoolId(opportunityEntity.getResourcePoolId());
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getClaimTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getClaimTime());
                } else if (HussarUtils.isNotEmpty((Object)opportunityEntity.getAllocateTime())) {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getAllocateTime());
                } else {
                    opportunityRecycleReason.setNoWinDate(opportunityEntity.getCreateTime());
                }
                if (HussarUtils.isNotEmpty((Object)opportunityEntity.getTrackTime())) {
                    opportunityRecycleReason.setNoTrackDate(opportunityEntity.getTrackTime());
                } else {
                    opportunityRecycleReason.setNoTrackDate(opportunityRecycleReason.getNoWinDate());
                }
                opportunityRecycleReasonMap.put(opportunityEntity.getOpportunityId(), opportunityRecycleReason);
                return opportunityRecycleReason;
            }).collect(Collectors.toList());
            poolIdOpportunityListMap.put(ruleList.get(i).getOppoPoolId(), oppoReason);
            RuleRecycleVO ruleRecycleVO2 = new RuleRecycleVO();
            ruleRecycleVO2.setOppoPoolId(ruleList.get(i).getOppoPoolId());
            ruleRecycleVO2.setNoWinDate((LocalDate)noWinDateList.get(i));
            ruleRecycleVO2.setNoTrackDate((LocalDate)noTrackDateList.get(i));
            ruleRecycleVO2.setOppoPoolOrder(ruleList.get(i).getOppoPoolOrder());
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay())) {
                ruleRecycleVO2.setNoTrackNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
            }
            if (HussarUtils.isNotEmpty((Object)((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay())) {
                ruleRecycleVO2.setNoWinNum(Integer.valueOf(((OppoRuleVO)poolIdRuleMap.get(ruleRecycleVO2.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
            }
            ruleVoMap.put(ruleRecycleVO2.getOppoPoolId(), ruleRecycleVO2);
        }
        HashMap oppoIdAndPoolRuleMap = new HashMap();
        for (Map.Entry entry : poolIdOpportunityListMap.entrySet()) {
            for (OpportunityRecycleReason oppo : (List)entry.getValue()) {
                if (HussarUtils.isEmpty(oppoIdAndPoolRuleMap.get(oppo.getOpportunityId()))) {
                    ArrayList poolRule = new ArrayList();
                    poolRule.add(ruleVoMap.get(entry.getKey()));
                    oppoIdAndPoolRuleMap.put(oppo.getOpportunityId(), poolRule);
                    continue;
                }
                ((List)oppoIdAndPoolRuleMap.get(oppo.getOpportunityId())).add(ruleVoMap.get(entry.getKey()));
            }
        }
        ArrayList opportunityIdList = new ArrayList(oppoIdAndPoolRuleMap.keySet());
        Map<Long, OpportunityEntity> map = this.opportunityService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, opportunityIdList)).stream().collect(Collectors.toMap(OpportunityEntity::getOpportunityId, opportunityEntity -> opportunityEntity));
        ArrayList delOpportunityIdList = new ArrayList();
        ArrayList<OpportunityPoolOppo> addPoolOppoList = new ArrayList<OpportunityPoolOppo>();
        HashMap oppoIdDateTypeMapNoTrack = new HashMap();
        HashMap oppoIdDateTypeMapNoWin = new HashMap();
        HashMap dateNoWinMap = new HashMap();
        HashMap dateNoTrackMap = new HashMap();
        Map<Long, OppoRuleVO> poolIdRuleVOMap = ruleList.stream().collect(Collectors.toMap(OppoRuleVO::getOppoPoolId, oppoRuleVO -> oppoRuleVO));
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        HashMap<String, OppoRecycleMessageVo> oppoRecycleMessageVoMap = new HashMap<String, OppoRecycleMessageVo>();
        for (Map.Entry listEntry : oppoIdAndPoolRuleMap.entrySet()) {
            OpportunityPoolOppo oppo;
            boolean oldPoolExist;
            LocalDateTime claimTime = map.get(listEntry.getKey()).getClaimTime();
            LocalDateTime allocateTime = map.get(listEntry.getKey()).getAllocateTime();
            LocalDateTime localDateTime = map.get(listEntry.getKey()).getTrackTime();
            if (claimTime != null) {
                dateNoWinMap.put(listEntry.getKey(), claimTime.toLocalDate());
            } else if (allocateTime != null) {
                dateNoWinMap.put(listEntry.getKey(), allocateTime.toLocalDate());
            } else {
                dateNoWinMap.put(listEntry.getKey(), map.get(listEntry.getKey()).getCreateTime().toLocalDate());
            }
            if (localDateTime != null) {
                dateNoTrackMap.put(listEntry.getKey(), localDateTime.toLocalDate());
            } else {
                dateNoTrackMap.put(listEntry.getKey(), (LocalDate)dateNoWinMap.get(listEntry.getKey()));
            }
            List recycleVOList = (List)listEntry.getValue();
            recycleVOList.sort(Comparator.comparing(RuleRecycleVO::getOppoPoolOrder));
            OpportunityRecycleReason reason = (OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey());
            String reasonStr = "";
            StringBuilder reasonStrTemp = new StringBuilder();
            boolean oldPoolRuleMatched = false;
            Long poolId = null;
            boolean bl = oldPoolExist = oldPoolFirst && recycleVOList.stream().map(RuleRecycleVO::getOppoPoolId).collect(Collectors.toList()).contains(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey())).getResourcePoolId());
            if (oldPoolExist) {
                RuleRecycleVO vo = (RuleRecycleVO)recycleVOList.stream().filter(ruleRecycleVO -> ruleRecycleVO.getOppoPoolId().equals(((OpportunityRecycleReason)opportunityRecycleReasonMap.get(listEntry.getKey())).getResourcePoolId())).collect(Collectors.toList()).get(0);
                if (vo.getNoTrackDate() != null && !vo.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                }
                if (vo.getNoWinDate() != null && !vo.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate())) && reasonStrTemp.length() == 0) {
                    reasonStrTemp.append("\u8d85").append(vo.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                }
                if (reasonStrTemp.length() > 0) {
                    reasonStr = reasonStrTemp.toString();
                    poolId = vo.getOppoPoolId();
                    oldPoolRuleMatched = true;
                }
            }
            if (!oldPoolRuleMatched) {
                for (RuleRecycleVO ruleRecycleVO3 : recycleVOList) {
                    reasonStrTemp = new StringBuilder();
                    if (ruleRecycleVO3.getNoTrackDate() != null && !ruleRecycleVO3.getNoTrackDate().isBefore(LocalDate.from(reason.getNoTrackDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoTrackNum()).append("\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                    }
                    if (reasonStrTemp.length() == 0 && ruleRecycleVO3.getNoWinDate() != null && !ruleRecycleVO3.getNoWinDate().isBefore(LocalDate.from(reason.getNoWinDate()))) {
                        reasonStrTemp.append("\u8d85").append(ruleRecycleVO3.getNoWinNum()).append("\u5929\u672a\u8d62\u5355");
                    }
                    if (reasonStrTemp.length() <= 0 || oldPoolExist) continue;
                    reasonStr = reasonStrTemp.toString();
                    poolId = ruleRecycleVO3.getOppoPoolId();
                    break;
                }
            }
            if ((oppo = (OpportunityPoolOppo)BeanUtil.copy((Object)map.get(listEntry.getKey()), OpportunityPoolOppo.class)) == null) continue;
            if (!reasonStr.isEmpty()) {
                HashMap<String, String> field = new HashMap<String, String>();
                ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), oppo.getOldChargerPerson());
                after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), poolId);
                before.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), oppo.getChangePersonName());
                after.put(OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), poolIdRuleVOMap.get(poolId).getOppoPoolName());
                field.put("field", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField());
                field.put("fieldName", OpportunityPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getName());
                changeField.add(field);
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_POOL_AUTO_RECYCLE.getId());
                operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
                operateRecordDO.setTypeId(oppo.getOpportunityId());
                operateRecordDO.setBusinessName(oppo.getOpportunityName());
                operateRecordDO.setChangeBefore(JSON.toJSONString(before));
                operateRecordDO.setChangeAfter(JSON.toJSONString(after));
                operateRecordDO.setChangeField(JSON.toJSONString(changeField));
                operateRecordDO.setCreateTime(dateTimeNow);
                operateRecordDO.setChangeTime(dateTimeNow);
                operateRecordDO.setRecordContent(reasonStr);
                operateRecordDO.setDelflag("0");
                operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
                operateRecordDOList.add(operateRecordDO);
                oppo.setOppoPoolId(poolId);
                oppo.setOldChargerPerson(oppo.getChargePersonId());
                oppo.setOldChargerPersonName(oppo.getChargePersonName());
                oppo.setLastJoinTime(dateTimeNow);
                oppo.setLastJoinReason(reasonStr);
                oppo.setLastJoinType(OpportunityPoolConstant.JOIN_TYPE_AUTO);
                oppo.setChangeTime(dateTimeNow);
                oppo.setChangePerson(null);
                oppo.setChangePersonName("\u7cfb\u7edf");
                oppo.setLastJoinUser(null);
                oppo.setLastJoinUserName("\u7cfb\u7edf");
                oppo.setChargePersonId(null);
                oppo.setChargePersonName(null);
                oppo.setOwnDepartment(null);
                oppo.setOwnDepartmentName(null);
                delOpportunityIdList.add(listEntry.getKey());
                addPoolOppoList.add(oppo);
                String personPoolId = oppo.getOldChargerPerson() + "," + poolIdRuleVOMap.get(oppo.getOppoPoolId()).getOppoPoolName();
                if (!oppoRecycleMessageVoMap.containsKey(personPoolId)) {
                    OppoRecycleMessageVo vo = new OppoRecycleMessageVo();
                    vo.setCountNoTrack(0);
                    vo.setCountNoWin(0);
                    if (oppo.getLastJoinReason().contains("\u8ddf\u8fdb")) {
                        vo.setCountNoTrack(vo.getCountNoTrack() + 1);
                        vo.setNoTrackDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoTrackDay()));
                    } else if (oppo.getLastJoinReason().contains("\u8d62\u5355")) {
                        vo.setCountNoWin(vo.getCountNoWin() + 1);
                        vo.setNoWinDayNum(Integer.parseInt(((OppoRuleVO)poolIdRuleMap.get(oppo.getOppoPoolId())).getRuleRecycle().getNoWinDay()));
                    }
                    oppoRecycleMessageVoMap.put(personPoolId, vo);
                    continue;
                }
                if (oppo.getLastJoinReason().contains("\u8ddf\u8fdb")) {
                    int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getCountNoTrack();
                    ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setCountNoTrack(count + 1);
                    continue;
                }
                if (!oppo.getLastJoinReason().contains("\u8d62\u5355")) continue;
                int count = ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).getCountNoWin();
                ((OppoRecycleMessageVo)oppoRecycleMessageVoMap.get(personPoolId)).setCountNoWin(count + 1);
                continue;
            }
            List<Object> dayTypeDtoListNoTrack = new ArrayList();
            List<Object> dayTypeDtoListNoWin = new ArrayList();
            String finalReasonStr = reasonStr;
            dayTypeDtoListNoTrack = recycleVOList.stream().map(ruleRecycleVO -> {
                DayTypeDto dto = new DayTypeDto();
                OppoRuleVO oppoRuleVO = (OppoRuleVO)poolIdRuleVOMap.get(ruleRecycleVO.getOppoPoolId());
                if (!oppoRuleVO.getRuleRecycle().getCondition().contains("rule1")) {
                    return null;
                }
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoTrackDay())));
                dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
                dto.setReason(finalReasonStr);
                return dto;
            }).collect(Collectors.toList());
            dayTypeDtoListNoTrack.removeIf(Objects::isNull);
            dayTypeDtoListNoTrack = new ArrayList<DayTypeDto>(dayTypeDtoListNoTrack.stream().collect(Collectors.toMap(DayTypeDto::getDateType, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(DayTypeDto::getDay)))).values());
            if (CollectionUtil.isNotEmpty(dayTypeDtoListNoTrack)) {
                oppoIdDateTypeMapNoTrack.put(listEntry.getKey(), dayTypeDtoListNoTrack);
            }
            dayTypeDtoListNoWin = recycleVOList.stream().map(ruleRecycleVO -> {
                DayTypeDto dto = new DayTypeDto();
                OppoRuleVO oppoRuleVO = (OppoRuleVO)poolIdRuleVOMap.get(ruleRecycleVO.getOppoPoolId());
                if (!oppoRuleVO.getRuleRecycle().getCondition().contains("rule2")) {
                    return null;
                }
                dto.setDay(Integer.valueOf(Integer.parseInt(oppoRuleVO.getRuleRecycle().getNoWinDay())));
                dto.setDateType(oppoRuleVO.getRuleRecycle().getTime());
                dto.setSwitchFlag(oppoRuleVO.getPublicPoolRuleRecycleSwitch());
                dto.setReason(finalReasonStr);
                return dto;
            }).collect(Collectors.toList());
            dayTypeDtoListNoWin.removeIf(Objects::isNull);
            if (!CollectionUtil.isNotEmpty(dayTypeDtoListNoWin = new ArrayList<DayTypeDto>(dayTypeDtoListNoWin.stream().collect(Collectors.toMap(DayTypeDto::getDateType, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(DayTypeDto::getDay)))).values()))) continue;
            oppoIdDateTypeMapNoWin.put(listEntry.getKey(), dayTypeDtoListNoWin);
        }
        if (CollectionUtil.isNotEmpty(oppoIdDateTypeMapNoWin) || CollectionUtil.isNotEmpty(oppoIdDateTypeMapNoTrack)) {
            Map noWinRecycle = this.calendarBoService.getRecycleTime(oppoIdDateTypeMapNoWin, dateNoWinMap);
            Map noTrackRecycle = this.calendarBoService.getRecycleTime(oppoIdDateTypeMapNoTrack, dateNoTrackMap);
            noWinRecycle.forEach((key, value) -> noTrackRecycle.merge(key, value, (date1, date2) -> date1.getDate().isBefore(date2.getDate()) ? date1 : date2));
            ArrayList<OpportunityEntity> updateRecycleTimeList = new ArrayList<OpportunityEntity>();
            for (Map.Entry entry : noTrackRecycle.entrySet()) {
                OpportunityEntity oppo = new OpportunityEntity();
                oppo.setOpportunityId((Long)entry.getKey());
                oppo.setRecycleTime(((RecycleReasonDate)entry.getValue()).getDate().atStartOfDay());
                if (((RecycleReasonDate)noTrackRecycle.get(entry.getKey())).getDate() == ((RecycleReasonDate)entry.getValue()).getDate()) {
                    oppo.setAbandonedReason("\u8d85" + ((RecycleReasonDate)entry.getValue()).getDay() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                } else {
                    oppo.setAbandonedReason("\u8d85" + ((RecycleReasonDate)entry.getValue()).getDay() + "\u5929\u672a\u8d62\u5355");
                }
                updateRecycleTimeList.add(oppo);
            }
            this.opportunityMapper.updateRecycleTimeBatch(updateRecycleTimeList);
            LocalDate sevenDay = LocalDate.now().plusDays(7L);
            Map<LocalDate, List<OpportunityEntity>> map2 = updateRecycleTimeList.stream().collect(Collectors.groupingBy(opportunityEntity -> opportunityEntity.getRecycleTime().toLocalDate()));
            for (Map.Entry<LocalDate, List<OpportunityEntity>> entry : map2.entrySet()) {
                List<OpportunityEntity> opportunityEntityList = entry.getValue();
                HashMap<Long, Integer> chargePersonNoTrackCount = new HashMap<Long, Integer>();
                HashMap<Long, Integer> chargePersonNoWinCount = new HashMap<Long, Integer>();
                for (OpportunityEntity opportunity : opportunityEntityList) {
                    OpportunityEntity opportunityEntity2;
                    Long chargePersonId;
                    if (!sevenDay.atStartOfDay().isAfter(opportunity.getRecycleTime()) || (chargePersonId = (opportunityEntity2 = map.get(opportunity.getOpportunityId())).getChargePersonId()) == null) continue;
                    if (opportunity.getAbandonedReason().contains("\u8ddf\u8fdb")) {
                        if (chargePersonNoTrackCount.containsKey(chargePersonId)) {
                            chargePersonNoTrackCount.put(chargePersonId, (Integer)chargePersonNoTrackCount.get(chargePersonId) + 1);
                            continue;
                        }
                        chargePersonNoTrackCount.put(chargePersonId, 1);
                        continue;
                    }
                    if (chargePersonNoWinCount.containsKey(chargePersonId)) {
                        chargePersonNoWinCount.put(chargePersonId, (Integer)chargePersonNoWinCount.get(chargePersonId) + 1);
                        continue;
                    }
                    chargePersonNoWinCount.put(chargePersonId, 1);
                }
                this.sendWarningMessage(entry, chargePersonNoTrackCount, chargePersonNoWinCount, dateTimeNow);
            }
        }
        if (CollectionUtil.isNotEmpty(delOpportunityIdList)) {
            this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessType, (Object)"2")).in(TeamMeberEntity::getBusinessId, delOpportunityIdList)).set(TeamMeberEntity::getDelFlag, (Object)"1"));
            this.opportunityService.removeByIds(delOpportunityIdList);
            this.taskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskEntity::getBusinessType, (Object)"2")).in(TaskEntity::getBusinessId, delOpportunityIdList)).ne(TaskEntity::getState, (Object)"2")).set(TaskEntity::getState, (Object)"3")).set(TaskEntity::getLastTime, (Object)dateTimeNow));
            this.opportunityPoolOppoService.saveBatch(addPoolOppoList);
        }
        if (CollectionUtil.isNotEmpty(operateRecordDOList)) {
            this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
        }
        this.sendRecycleMessage(oppoRecycleMessageVoMap, dateTimeNow);
        return new ProcessResult(true);
    }

    private void sendRecycleMessage(Map<String, OppoRecycleMessageVo> oppoRecycleMessageVoMap, LocalDateTime dateTimeNow) {
        List messagePushList = this.messageTemplateService.getMessagePushList("4");
        MessagePushVo pushToWeb = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        for (Map.Entry<String, OppoRecycleMessageVo> entry : oppoRecycleMessageVoMap.entrySet()) {
            String[] idList = entry.getKey().split(",");
            if (idList.length < 2 || "null".equals(idList[0])) continue;
            Long personId = Long.parseLong(idList[0]);
            String poolName = idList[1];
            int countNoTrack = entry.getValue().getCountNoTrack();
            int countNoWin = entry.getValue().getCountNoWin();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("opportunityCount", String.valueOf(countNoWin));
            params.put("poolName", poolName);
            if (countNoTrack > 0) {
                params.put("recycleReason", "\u8d85" + entry.getValue().getNoTrackDayNum() + "\u5929\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
                this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
                this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            }
            if (countNoWin <= 0) continue;
            params.put("recycleReason", "\u8d85" + entry.getValue().getNoWinDayNum() + "\u5929\u672a\u8d62\u5355");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(personId));
        }
    }

    private void sendWarningMessage(Map.Entry<LocalDate, List<OpportunityEntity>> entry, Map<Long, Integer> chargePersonNoTrackCount, Map<Long, Integer> chargePersonNoWinCount, LocalDateTime dateTimeNow) {
        HashMap<String, String> params;
        List messagePushList = this.messageTemplateService.getMessagePushList("5");
        MessagePushVo pushToWeb = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        for (Map.Entry<Long, Integer> countEntry : chargePersonNoTrackCount.entrySet()) {
            params = new HashMap<String, String>();
            params.put("recycleDate", entry.getKey().toString());
            params.put("opportunityCount", String.valueOf(countEntry.getValue()));
            params.put("recycleReason", "\u8d85\u671f\u65e0\u8ddf\u8fdb\u8bb0\u5f55");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
        }
        for (Map.Entry<Long, Integer> countEntry : chargePersonNoWinCount.entrySet()) {
            params = new HashMap();
            params.put("recycleDate", entry.getKey().toString());
            params.put("opportunityCount", String.valueOf(countEntry.getValue()));
            params.put("recycleReason", "\u8d85\u671f\u672a\u8d62\u5355");
            this.messagePushService.pushMessageByUser(pushToWeb, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
            this.messagePushService.pushMessageByUser(pushToMobile, null, "/crm/sy/yddsy", dateTimeNow, params, Collections.singletonList(countEntry.getKey()));
        }
    }
}

