/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.StageRecord;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OpportunityStagePromoteProcessor
implements BasicProcessor {
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private IStageRecordService stageRecordService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        try {
            ArrayList<StageRecord> oppoStagePromoteList = this.stageRecordService.list((Wrapper)new LambdaQueryWrapper().eq(StageRecord::getDelFlag, (Object)"0"));
            if (CollectionUtil.isNotEmpty((Collection)oppoStagePromoteList)) {
                return new ProcessResult(false, "\u5546\u673a\u9636\u6bb5\u4e2d\u6709\u6570\u636e\u5219\u4e0d\u6267\u884c\u6b64\u64cd\u4f5c");
            }
            StageTypeDto stageTypeDto = new StageTypeDto();
            stageTypeDto.setStageWin(true);
            stageTypeDto.setStageLose(true);
            stageTypeDto.setStageConvert(true);
            StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
            List stageWin = stageSelectDto.getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
            List stageLose = stageSelectDto.getStageLose().stream().map(String::valueOf).collect(Collectors.toList());
            List stageConvert = stageSelectDto.getStageConvert().stream().map(String::valueOf).collect(Collectors.toList());
            ArrayList<String> productTypeList = new ArrayList<String>();
            productTypeList.add(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId());
            productTypeList.add(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
            productTypeList.add(RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId());
            List operateRecordAPIVoList = this.operateRecordAPIService.list(productTypeList);
            if (CollectionUtil.isNotEmpty((Collection)operateRecordAPIVoList)) {
                List opportunityStageList = this.opportunityStageService.list();
                if (CollectionUtil.isEmpty((Collection)opportunityStageList)) {
                    return new ProcessResult(false, "\u8bf7\u5148\u7ef4\u62a4\u5546\u673a\u9636\u6bb5\u4fe1\u606f");
                }
                Map<String, Long> opportunityStageMap = opportunityStageList.stream().collect(Collectors.toMap(OpportunityStage::getCustomerStageName, OpportunityStage::getCustomerStageId));
                Map<Long, List<OperateRecordAPIVo>> opportunityOperateRecordMap = operateRecordAPIVoList.stream().collect(Collectors.groupingBy(OperateRecordAPIVo::getTypeId));
                oppoStagePromoteList = new ArrayList<StageRecord>();
                ArrayList<OpportunityEntity> updateOpportunityList = new ArrayList<OpportunityEntity>();
                for (Long opportunityId : opportunityOperateRecordMap.keySet()) {
                    List<OperateRecordAPIVo> opportunityOperateRecorList = opportunityOperateRecordMap.get(opportunityId);
                    if (CollectionUtil.isEmpty(opportunityOperateRecorList)) continue;
                    HashMap<String, LocalDateTime> leaveTimeMap = new HashMap<String, LocalDateTime>();
                    HashSet<Long> finishOpportunityIdSet = new HashSet<Long>();
                    for (OperateRecordAPIVo operateRecordAPIVo : opportunityOperateRecorList) {
                        OpportunityEntity opportunityEntity;
                        String beforeStageName = null;
                        String afterStageName = null;
                        if (RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId().equals(operateRecordAPIVo.getProduceType())) {
                            beforeStageName = operateRecordAPIVo.getContactName();
                            afterStageName = operateRecordAPIVo.getRecordContent();
                            if (afterStageName.equals("\u8d62\u5355") && stageWin.contains(operateRecordAPIVo.getCustomerStageId()) && finishOpportunityIdSet.add(opportunityId)) {
                                opportunityEntity = new OpportunityEntity();
                                opportunityEntity.setOpportunityId(opportunityId);
                                opportunityEntity.setStageFinishTime(operateRecordAPIVo.getCreateTime());
                                updateOpportunityList.add(opportunityEntity);
                            }
                            if (afterStageName.equals("\u8f93\u5355") && stageLose.contains(operateRecordAPIVo.getCustomerStageId()) && finishOpportunityIdSet.add(opportunityId)) {
                                opportunityEntity = new OpportunityEntity();
                                opportunityEntity.setOpportunityId(opportunityId);
                                opportunityEntity.setStageFinishTime(operateRecordAPIVo.getCreateTime());
                                updateOpportunityList.add(opportunityEntity);
                            }
                        }
                        if (RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId().equals(operateRecordAPIVo.getProduceType()) && stageConvert.contains(operateRecordAPIVo.getCustomerStageId())) {
                            beforeStageName = "\u53d1\u73b0\u5546\u673a";
                            afterStageName = "\u53ea\u8f6c\u5ba2\u6237";
                            if (finishOpportunityIdSet.add(opportunityId)) {
                                opportunityEntity = new OpportunityEntity();
                                opportunityEntity.setOpportunityId(opportunityId);
                                opportunityEntity.setStageFinishTime(operateRecordAPIVo.getCreateTime());
                                updateOpportunityList.add(opportunityEntity);
                            }
                        }
                        if (RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId().equals(operateRecordAPIVo.getProduceType())) {
                            List recordAPIVoList = opportunityOperateRecorList.stream().filter(recordVo -> RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId().equals(recordVo.getProduceType())).filter(recordVo -> recordVo.getCreateTime().isBefore(operateRecordAPIVo.getCreateTime())).collect(Collectors.toList());
                            if (CollectionUtil.isEmpty(recordAPIVoList)) {
                                beforeStageName = "\u53d1\u73b0\u5546\u673a";
                            } else {
                                recordAPIVoList.sort(Comparator.comparing(OperateRecordAPIVo::getCreateTime).reversed());
                                beforeStageName = ((OperateRecordAPIVo)recordAPIVoList.get(0)).getRecordContent();
                            }
                            afterStageName = "\u5e9f\u5f03";
                            if (finishOpportunityIdSet.add(opportunityId)) {
                                OpportunityEntity opportunityEntity2 = new OpportunityEntity();
                                opportunityEntity2.setOpportunityId(opportunityId);
                                opportunityEntity2.setStageFinishTime(operateRecordAPIVo.getCreateTime());
                                updateOpportunityList.add(opportunityEntity2);
                            }
                        }
                        if (StringUtil.isEmpty((Object)beforeStageName) && StringUtil.isEmpty((Object)afterStageName)) continue;
                        leaveTimeMap.put(beforeStageName, operateRecordAPIVo.getCreateTime());
                        StageRecord oppoStagePromote = new StageRecord();
                        oppoStagePromote.setOpportunityId(operateRecordAPIVo.getTypeId());
                        oppoStagePromote.setBeforeStageId(opportunityStageMap.get(beforeStageName));
                        oppoStagePromote.setBeforeStageName(beforeStageName);
                        oppoStagePromote.setAfterStageId(opportunityStageMap.get(afterStageName));
                        oppoStagePromote.setAfterStageName(afterStageName);
                        oppoStagePromote.setEntryTime(operateRecordAPIVo.getCreateTime());
                        oppoStagePromote.setLeaveTime((LocalDateTime)leaveTimeMap.get(afterStageName));
                        oppoStagePromote.setDelFlag("0");
                        oppoStagePromoteList.add(oppoStagePromote);
                    }
                }
                this.stageRecordService.saveBatch(oppoStagePromoteList);
                this.opportunityService.updateBatchById(updateOpportunityList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ProcessResult(true);
    }
}

