/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.BackfillInfoVo;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CustomerAddressFillBlankProcessor
implements BasicProcessor {
    @Resource
    private CommonService commonService;
    @Resource
    private CustomerService customerService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        List customerEntityList = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).isNull(CustomerEntity::getProvince));
        int endIndex = Math.min(customerEntityList.size(), 100);
        if (!CollectionUtil.isEmpty(customerEntityList = customerEntityList.subList(0, endIndex))) {
            for (CustomerEntity customer : customerEntityList) {
                BackfillInfoVo backfillInfoVo = this.commonService.getBackfillInfoByName(customer.getCustomerName());
                if (backfillInfoVo == null) continue;
                customer.setProvince(String.valueOf(backfillInfoVo.getProvinceId()));
                customer.setCity(String.valueOf(backfillInfoVo.getCityId()));
                customer.setCounty(String.valueOf(backfillInfoVo.getDistrictId()));
                customer.setAddressDetail(backfillInfoVo.getRegLocation());
            }
            this.customerService.updateBatchById(customerEntityList);
        }
        return new ProcessResult(true);
    }
}

