/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customerpool.customerpool.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.core.customerpool.customerpool.dao.CustomerPoolMemberMapper;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolMemberEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolMemberService;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.CustomerPoolMemberVo;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerPoolMemberServiceImpl
extends ServiceImpl<CustomerPoolMemberMapper, CustomerPoolMemberEntity>
implements ICustomerPoolMemberService {
    @Resource
    private IOrganUserBoService organUserBoService;

    @Override
    public List<Map<String, Long>> getCountByCustomerPoolId(List<Long> customerPoolIdList) {
        return ((CustomerPoolMemberMapper)this.baseMapper).getCountByCustomerPoolId(customerPoolIdList);
    }

    @Override
    public String getUserCustomerPoolPermission(SecurityUser user, Long customerPoolId, Long customerId) {
        List<CustomerPoolMemberVo> customerPoolMemberVoList;
        ArrayList<Long> deptIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)user.getDeptId())) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        ArrayList<Long> customerPoolIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)customerPoolId)) {
            customerPoolIds = Collections.singletonList(customerPoolId);
        }
        ArrayList<Long> customerIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)customerId)) {
            customerIds = Collections.singletonList(customerId);
        }
        if (CollectionUtil.isEmpty(customerPoolMemberVoList = ((CustomerPoolMemberMapper)this.baseMapper).getUserCustomerPermission(user.getUserId(), user.getRolesList(), deptIds, customerIds, customerPoolIds))) {
            return "noPermission";
        }
        String memberRole = "noPermission";
        for (CustomerPoolMemberVo customerPoolMemberVo : customerPoolMemberVoList) {
            if ("1".equals(customerPoolMemberVo.getMemberRole())) {
                memberRole = "isNormal";
                continue;
            }
            if (!"2".equals(customerPoolMemberVo.getMemberRole())) continue;
            return "isManage";
        }
        return memberRole;
    }

    @Override
    public List<Long> getCustomerPoolIdByUser(SecurityUser user) {
        List<Long> poolIdList;
        ArrayList<Long> deptIds = new ArrayList();
        if (user.getDeptId() != null) {
            deptIds = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        }
        if (CollectionUtil.isEmpty(poolIdList = ((CustomerPoolMemberMapper)this.baseMapper).getCustomerPoolIdByUser(user.getUserId(), user.getRolesList(), deptIds))) {
            return Collections.singletonList(-1L);
        }
        return poolIdList;
    }
}

