/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.sj.crmopportunitytask.service.impl;

import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.service.ICustomOpportunityTaskService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomOpportunityTaskServiceImpl
implements ICustomOpportunityTaskService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private InstanceEngineApiService instanceEngineApiService;

    @Override
    @Transactional
    public Boolean deleteOpportunityProcess(List<String> opportunityIds) {
        String delOpportunityIds = String.join((CharSequence)",", opportunityIds);
        for (String opportunityId : opportunityIds) {
            Map<String, Object> map = this.opportunityService.isOperateProcessState(Long.parseLong(opportunityId));
            Integer permission = (Integer)map.get("permission");
            if (!permission.equals(CommonConstant.PROCESS_NO_PERMISSION)) continue;
            throw new HussarException("\u65e0\u6cd5\u5220\u9664\u5546\u673a");
        }
        this.opportunityService.updateDelFlagByIds(opportunityIds);
        this.instanceEngineApiService.deleteProcessInstanceByBusinessKeyList(delOpportunityIds, false);
        return true;
    }

    @Override
    @Transactional
    public Boolean deleteProcessInstanceByBusinessKeyList(List<String> BusinessIds) {
        String delBusinessIdsIds = String.join((CharSequence)",", BusinessIds);
        this.instanceEngineApiService.deleteProcessInstanceByBusinessKeyList(delBusinessIdsIds, false);
        return true;
    }
}

