/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.label.dto.SaveLabelDto;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.operateRecord.DataCompareUtils;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dao.CrmOpportunity2Mapper;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dto.CrmOpportunity2Crmopportunity2dataset1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dto.CrmOpportunity2Crmopportunity2dataset2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.model.CrmOpportunity2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.vo.CrmOpportunity2PageVO;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="crm.datasourcefolder.customer.crmopportunity2.CrmOpportunity2ServiceImpl")
@HussarDs(value="master")
public class CrmOpportunity2ServiceImpl
extends HussarServiceImpl<CrmOpportunity2Mapper, CrmOpportunity2>
implements CrmOpportunity2Service {
    private static final Logger logger = LoggerFactory.getLogger(CrmOpportunity2ServiceImpl.class);
    private static final String RETURN_CODE = "0";
    @Autowired
    private CrmOpportunity2Mapper crmOpportunity2Mapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private LeadsService leadsService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ILabelService labelService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;

    @Override
    @DSTransactional
    public ApiResponse<String> insertOrUpdate(CrmOpportunity2 crmOpportunity2) {
        SaveLabelDto saveLabelDto;
        List<String> productManagerIds;
        List<String> focusId;
        List<String> userIds;
        StageProcessEntity stageProcess;
        boolean labelFlag = true;
        if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getOpportunityId())) {
            labelFlag = false;
            crmOpportunity2.setState(null);
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmOpportunity2 opportunity = (CrmOpportunity2)this.getById(crmOpportunity2.getOpportunityId());
        if (crmOpportunity2.getStageProcessId() != null && !opportunity.getStageProcessId().equals(crmOpportunity2.getStageProcessId()) && ((stageProcess = (StageProcessEntity)this.stageProcessService.getById(crmOpportunity2.getStageProcessId())) == null || Objects.equals(stageProcess.getDelFlag(), "1"))) {
            throw new HussarException("\u6240\u9009\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        crmOpportunity2.setTrackTime(null);
        String oldAmount = String.valueOf(opportunity.getOpportunityAmount());
        String newAmount = String.valueOf(crmOpportunity2.getOpportunityAmount());
        String oldDate = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)opportunity.getEndTime())) {
            oldDate = String.valueOf(opportunity.getEndTime()).substring(0, 10);
        }
        String newDate = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)crmOpportunity2.getEndTime())) {
            newDate = String.valueOf(crmOpportunity2.getEndTime()).substring(0, 10);
        }
        if (!oldAmount.equals(newAmount)) {
            Double oldOpportunityAmount = opportunity.getOpportunityAmount() == null ? 0.0 : opportunity.getOpportunityAmount() / 10000.0;
            Double newOpportunityAmount = crmOpportunity2.getOpportunityAmount() == null ? 0.0 : crmOpportunity2.getOpportunityAmount() / 10000.0;
            DecimalFormat df = new DecimalFormat("#,##0.00");
            df.setRoundingMode(RoundingMode.HALF_UP);
            String oldOppAmount = df.format(oldOpportunityAmount);
            String newOppAmount = df.format(newOpportunityAmount);
            List<String> focusId2 = this.focusMapper.selectCreateId("2", crmOpportunity2.getOpportunityId());
            List<String> productManagerIds2 = this.opportunityMapper.opportunityProductManagerList(crmOpportunity2.getOpportunityId(), RETURN_CODE, null);
            List<String> userIds2 = Stream.of(focusId2, productManagerIds2).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(userIds2)) {
                String title = "\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u53d8\u5316";
                String content = "\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(crmOpportunity2.getOpportunityId()), userIds2);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(userIds2, (String)",");
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + crmOpportunity2.getOpportunityId() + "\"";
                String contentUnify = "\u3010\u5546\u673a\u52a8\u6001\u3011\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        if (!oldDate.equals(newDate) && CollectionUtil.isNotEmpty(userIds = Stream.of(focusId = this.focusMapper.selectCreateId("2", crmOpportunity2.getOpportunityId()), productManagerIds = this.opportunityMapper.opportunityProductManagerList(crmOpportunity2.getOpportunityId(), RETURN_CODE, null)).flatMap(Collection::stream).collect(Collectors.toList()))) {
            String title = "\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u53d8\u5316";
            String content = "\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u7531" + oldDate + "\u8c03\u6574\u4e3a" + newDate;
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(crmOpportunity2.getOpportunityId()), userIds);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String userIdToString = StringUtil.join(userIds, (String)",");
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + crmOpportunity2.getOpportunityId() + "\"";
            String contentUnify = "\u3010\u5546\u673a\u52a8\u6001\u3011\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u7531" + oldDate + "\u8c03\u6574\u4e3a" + newDate;
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (crmOpportunity2.getOpportunityAmount() == null) {
            crmOpportunity2.setOpportunityAmount(0.0);
        }
        if (crmOpportunity2.getCustomerBudget() == null) {
            crmOpportunity2.setCustomerBudget(0.0);
        }
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getProvince())) {
            crmOpportunity2.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getCity())) {
            crmOpportunity2.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getCounty())) {
            crmOpportunity2.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        crmOpportunity2.setRegionLabel(sb.toString());
        LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
        lambdaUpdate.eq(CrmOpportunity2::getOpportunityId, (Object)crmOpportunity2.getOpportunityId());
        if (crmOpportunity2.getAgentId() == null) {
            lambdaUpdate.set(CrmOpportunity2::getAgentId, null);
        }
        this.saveOrUpdate(crmOpportunity2, (Wrapper)lambdaUpdate);
        if (labelFlag && HussarUtils.isNotEmpty((Object)(saveLabelDto = crmOpportunity2.getSaveLabelDto())) && HussarUtils.isNotEmpty((Object)saveLabelDto.getBusinessId())) {
            saveLabelDto.setChooseBatch(Boolean.valueOf(false));
            saveLabelDto.setModuleId("opportunity");
            this.labelService.userSaveLabel(saveLabelDto);
        }
        CrmOpportunity2 opportunityForOperateRecord = (CrmOpportunity2)this.getById(crmOpportunity2.getOpportunityId());
        this.opportunitySaveTrackRecord(opportunity, opportunityForOperateRecord);
        this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(crmOpportunity2.getOpportunityId(), crmOpportunity2.getSecurityLevel());
        this.taskAPIService.updateTaskSecurityLevel(crmOpportunity2.getOpportunityId(), crmOpportunity2.getSecurityLevel());
        this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(crmOpportunity2.getOpportunityId(), crmOpportunity2.getSecurityLevel());
        return ApiResponse.success((Object)String.valueOf(crmOpportunity2.getOpportunityId()), (String)"");
    }

    @Override
    public void opportunitySaveTrackRecord(CrmOpportunity2 oldOpportunity, CrmOpportunity2 newOpportunity) {
        Map map = DataCompareUtils.getRecordInfo((Object)oldOpportunity, (Object)newOpportunity);
        if (((String)map.get("changeFlag")).equals("true")) {
            OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
            trackRecord.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.OPPORTUNITY, Long.valueOf(oldOpportunity.getOpportunityId()), oldOpportunity.getOpportunityName(), LocalDateTime.now(), false, null);
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2> formQuery(String id) {
        try {
            CrmOpportunity2 crmOpportunity2 = (CrmOpportunity2)this.getById((Serializable)((Object)id));
            if (ToolUtil.isNotEmpty((Object)crmOpportunity2.getCustomerId())) {
                CustomerIncludePool customer = (CustomerIncludePool)this.customerIncludePoolService.getById(crmOpportunity2.getCustomerId());
                crmOpportunity2.setCustomerName(customer.getCustomerName());
            }
            if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getAgentId())) {
                AgentApiVo agentApiVo = this.agentApiService.getById((Serializable)crmOpportunity2.getAgentId());
                if (!"1".equals(agentApiVo.getDelFlag())) {
                    crmOpportunity2.setAgentName(agentApiVo.getAgentName());
                } else {
                    crmOpportunity2.setAgentName("");
                }
            }
            if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getStageProcessId())) {
                StageProcessEntity stageProcess = (StageProcessEntity)this.stageProcessService.getById(crmOpportunity2.getStageProcessId());
                crmOpportunity2.setProcessName(stageProcess.getProcessName());
            }
            return ApiResponse.success((Object)crmOpportunity2);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuerycrmOpportunity2Condition_1(CrmOpportunity2Crmopportunity2dataset1 crmopportunity2dataset1) {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List<CrmOpportunity2> list = this.crmOpportunity2Mapper.hussarQuerycrmOpportunity2Condition_1(crmopportunity2dataset1);
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty(list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuery() {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List list = this.list();
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty((Object)list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuerycrmOpportunity2Condition_2(CrmOpportunity2Crmopportunity2dataset2 crmopportunity2dataset2) {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List<CrmOpportunity2> list = this.crmOpportunity2Mapper.hussarQuerycrmOpportunity2Condition_2(crmopportunity2dataset2);
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty(list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public OperateRecordAPIVo initializeOperateLog(String produceType, String changeBefore, String changeAfter, String changeField) {
        OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
        trackRecord.setProduceType(produceType);
        trackRecord.setChangeBefore(changeBefore);
        trackRecord.setChangeAfter(changeAfter);
        trackRecord.setChangeField(changeField);
        return trackRecord;
    }
}

