/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.competitor.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.competitor.dto.CompetitorAssociativeQueryDto;
import com.jxdinfo.crm.core.competitor.dto.CompetitorDto;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitor.vo.CompetitorVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"competitor"})
public class CompetitorController {
    @Resource
    private CompetitorService competitorService;

    @PostMapping(value={"/select"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectById(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624bdto") CompetitorDto dto) {
        Page<Competitor> page = this.competitorService.selectCrmCompetitorList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u7ade\u4e89\u5bf9\u624b\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u7ade\u4e89\u5bf9\u624b\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624bdto") CompetitorAssociativeQueryDto dto) {
        return ApiResponse.success(this.competitorService.associativeQuery(dto));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u7ade\u4e89\u5bf9\u624b\u5220\u9664", notes="\u7ade\u4e89\u5bf9\u624b\u5220\u9664")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteByids(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624bdto") CompetitorDto dto) {
        return ApiResponse.success((Object)this.competitorService.updateDelFlagByIds(dto));
    }

    @RequestMapping(value={"/export"})
    public String marketingActivityExport(HttpServletResponse response, @RequestParam(value="competitorView") String competitorView, @RequestParam(value="competitorScreening") String competitorScreening) {
        CompetitorDto dto = new CompetitorDto();
        dto.setCompetitorScreening(competitorScreening);
        dto.setCompetitorView(competitorView);
        String msg = this.competitorService.competitorExport(response, dto);
        return msg;
    }

    @RequestMapping(value={"/exportTemplate"})
    public String marketingActivityExportTemplate(HttpServletResponse response) {
        return this.competitorService.competitorExportTemplate(response);
    }

    @PostMapping(value={"/import"})
    public ApiResponse<Page> marketingActivityImport(@RequestBody MultipartFile file) {
        int i = this.competitorService.competitorImport(file);
        if (i > 0) {
            return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\uff0c\u5171\u5bfc\u5165" + i + "\u6761\u6570\u636e"));
        }
        return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7ade\u4e89\u5bf9\u624b\u8be6\u60c5", notes="\u6839\u636eid\u67e5\u8be2\u7ade\u4e89\u5bf9\u624b\u8be6\u60c5")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CompetitorVo> details(@RequestParam(value="competitorId") @ApiParam(value="\u7ade\u4e89\u5bf9\u624bid") Long competitorId) {
        return ApiResponse.success((Object)this.competitorService.selectCompetitorDetails(competitorId));
    }

    @PostMapping(value={"/saveCompetitor"})
    @ApiOperation(value="\u65b0\u589e\u7ade\u4e89\u5bf9\u624b", notes="\u65b0\u589e\u7ade\u4e89\u5bf9\u624b")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> saveCompetitor(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624b\u5b9e\u4f53") Competitor competitor) {
        return ApiResponse.success((Object)this.competitorService.saveCompetitor(competitor));
    }

    @GetMapping(value={"/operate"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OperateVo> isOperate(@RequestParam(value="competitorId") @ApiParam(value="\u7ade\u4e89\u5bf9\u624bid") Long competitorId) {
        return ApiResponse.success((Object)this.competitorService.isOperate(competitorId));
    }

    @PostMapping(value={"/repeat"})
    @ApiOperation(value="\u7ade\u4e89\u5bf9\u624b\u67e5\u91cd", notes="\u7ade\u4e89\u5bf9\u624b\u67e5\u91cd")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Competitor> selectRepeatCompetitor(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624bdto") CompetitorDto dto) {
        return ApiResponse.success((Object)this.competitorService.selectRepeatCompetitor(dto));
    }

    @PostMapping(value={"/competitorTransfer"})
    @ApiOperation(value="\u7ade\u4e89\u5bf9\u624b\u8f6c\u79fb", notes="\u7ade\u4e89\u5bf9\u624b\u8f6c\u79fb")
    @AuditLog(moduleName="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventDesc="\u7ade\u4e89\u5bf9\u624b\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<TransferBatchResultVo> agentTransfer(@RequestBody @ApiParam(value="\u7ade\u4e89\u5bf9\u624b\u96c6\u5408") List<CompetitorDto> dto) {
        return ApiResponse.success((Object)this.competitorService.competitorTransferBatch(dto));
    }
}

