/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.associateQuery.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.associateQuery.service.ICommonAssociateQueryService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.product.api.service.IAssociateProductAPIService;
import com.jxdinfo.crm.product.api.vo.AssociateProductVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CommonAssociateQueryServiceImpl
implements ICommonAssociateQueryService {
    @Resource
    private IAssociateProductAPIService associateProductAPIService;
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private CommonService commonService;
    @Resource
    private IStruUserAPIService struUserBoService;
    @Resource
    private IDictBoService dictBoService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private ISysStruService struService;
    @Resource
    private CompetitorService competitorService;

    @Override
    public List<String> getProductAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedProducts, List<String> productIds, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> products = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(productIds)) {
            products.addAll(productIds);
        }
        if (CollectionUtil.isEmpty(selectedProducts)) {
            selectedProducts = new ArrayList<String>();
        }
        products.addAll(selectedProducts);
        List productList = this.associateProductAPIService.getProductList(keyword, products);
        if (ToolUtil.isNotEmpty((Object)productList)) {
            for (AssociateProductVo product : productList) {
                AssociativeQueryVo productAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, product.getProductName(), String.valueOf(product.getProductId()));
                associativeQueryVoList.add(productAssociative);
                selectedProducts.add(String.valueOf(product.getProductId()));
            }
        }
        return selectedProducts;
    }

    @Override
    public List<String> getOpptyStageProcessAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOpptyStageProcesses, List<String> stageProcessIds, AssociativeLabelVo associativeLabelVo) {
        if (ToolUtil.isEmpty(stageProcessIds)) {
            stageProcessIds = new ArrayList<String>();
        }
        if (ToolUtil.isNotEmpty(selectedOpptyStageProcesses)) {
            stageProcessIds.addAll(selectedOpptyStageProcesses);
        } else {
            selectedOpptyStageProcesses = new ArrayList<String>();
        }
        List<StageProcessEntity> stageProcessList = this.commonService.getStageProcessAssociateQuery(keyword, stageProcessIds);
        if (ToolUtil.isNotEmpty(stageProcessList)) {
            for (StageProcessEntity stageProcess : stageProcessList) {
                AssociativeQueryVo processAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, stageProcess.getProcessName(), String.valueOf(stageProcess.getStageProcessId()));
                associativeQueryVoList.add(processAssociative);
                selectedOpptyStageProcesses.add(String.valueOf(stageProcess.getStageProcessId()));
            }
        }
        return selectedOpptyStageProcesses;
    }

    @Override
    public List<String> getCampaignIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCampaignIds, List<Long> campaignIds, AssociativeLabelVo associativeLabelVo) {
        if (ToolUtil.isNotEmpty(campaignIds)) {
            campaignIds.addAll(campaignIds);
        }
        if (CollectionUtil.isEmpty(selectedCampaignIds)) {
            selectedCampaignIds = new ArrayList<String>();
        } else {
            List selectedCampaignIdList = selectedCampaignIds.stream().map(Long::parseLong).collect(Collectors.toList());
            campaignIds.addAll(selectedCampaignIdList);
        }
        List<MarketingActivityAPIVo> activityList = this.marketingActivityService.getMarketingActivityList(keyword, campaignIds);
        if (ToolUtil.isNotEmpty(activityList)) {
            for (MarketingActivityAPIVo marketingActivityAPIVo : activityList) {
                AssociativeQueryVo activityAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, marketingActivityAPIVo.getCampaignName(), String.valueOf(marketingActivityAPIVo.getCampaignId()));
                associativeQueryVoList.add(activityAssociative);
                selectedCampaignIds.add(String.valueOf(marketingActivityAPIVo.getCampaignId()));
            }
        }
        return selectedCampaignIds;
    }

    @Override
    public List<String> getOverdueAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOverdues, String overdueFollow) {
        List dicVoList;
        if (CollectionUtil.isEmpty(selectedOverdues)) {
            selectedOverdues = new ArrayList<String>();
        }
        ArrayList<String> overdues = new ArrayList<String>(selectedOverdues);
        if (StringUtil.isEmpty((Object)overdueFollow) && ToolUtil.isNotEmpty((Object)(dicVoList = this.dictBoService.getDicValue("overdue_follow", keyword, overdues)))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo overdueAssociative = new AssociativeQueryVo();
                overdueAssociative.setLabelName("\u903e\u671f\u672a\u8ddf\u8fdb\uff1a");
                overdueAssociative.setDataName("overdueFollow");
                overdueAssociative.setMultiOption(Boolean.valueOf(false));
                overdueAssociative.setTips("\u903e\u671f\u672a\u8ddf\u8fdb\uff1a " + dicVo.getLabel());
                overdueAssociative.setOptionName(dicVo.getLabel());
                overdueAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(overdueAssociative);
                selectedOverdues.add(dicVo.getValue());
            }
        }
        return selectedOverdues;
    }

    @Override
    public List<String> getOpportunityWinRatesAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOpportunityWinRates, List<String> opportunityWinRates, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> rates = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(opportunityWinRates)) {
            rates.addAll(opportunityWinRates);
        }
        if (CollectionUtil.isEmpty(selectedOpportunityWinRates)) {
            selectedOpportunityWinRates = new ArrayList<String>();
        }
        rates.addAll(selectedOpportunityWinRates);
        List rateDicVoList = this.dictBoService.getDicValue("opportunity_win_rate", keyword, rates);
        if (ToolUtil.isNotEmpty((Object)rateDicVoList)) {
            for (DicVo dicVo : rateDicVoList) {
                AssociativeQueryVo stateAssociative = new AssociativeQueryVo();
                stateAssociative.setLabelName("\u5546\u673a\u8d62\u7387\uff1a");
                stateAssociative.setDataName("hussar_75SelectShowData");
                stateAssociative.setMultiOption(Boolean.valueOf(true));
                stateAssociative.setTips("\u5546\u673a\u8d62\u7387\uff1a " + dicVo.getLabel());
                stateAssociative.setOptionName(dicVo.getLabel());
                stateAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(stateAssociative);
                selectedOpportunityWinRates.add(dicVo.getValue());
            }
        }
        return selectedOpportunityWinRates;
    }

    @Override
    public List<String> getCustomerStageIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStageId, List<String> customerStageIds, List<String> stageProcessIds, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> customerStageIdsFinal = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedStageId)) {
            selectedStageId = new ArrayList<String>();
        }
        if (CollectionUtil.isNotEmpty(customerStageIds)) {
            for (String s : customerStageIds) {
                List<String> stageTempList = Arrays.asList(s.split(","));
                customerStageIdsFinal.addAll(stageTempList);
            }
        }
        customerStageIdsFinal.addAll(selectedStageId);
        List<Object> stageList = new ArrayList();
        stageList = ToolUtil.isNotEmpty(stageProcessIds) ? this.commonService.getOpportunityStageList(keyword, customerStageIdsFinal, stageProcessIds) : this.commonService.getOpportunityStageList(keyword, customerStageIdsFinal, null);
        Map<String, List<OpportunityStage>> stageListMap = stageList.stream().collect(Collectors.groupingBy(OpportunityStage::getCustomerStageName));
        ArrayList<String> stageNameList = new ArrayList<String>(stageListMap.keySet());
        if (ToolUtil.isNotEmpty(stageNameList)) {
            for (String stageName : stageNameList) {
                List stageIds = stageListMap.get(stageName).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
                String idsString = StringUtil.join(stageIds, (String)",");
                AssociativeQueryVo stageIdAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, stageName, idsString);
                associativeQueryVoList.add(stageIdAssociative);
                selectedStageId.add(idsString);
            }
        }
        return selectedStageId;
    }

    @Override
    public List<String> getStateAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStates, List<String> states, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> excludeStates = new ArrayList<String>(Arrays.asList("6", "7", "8", "9"));
        if (ToolUtil.isNotEmpty(states)) {
            excludeStates.addAll(states);
        }
        if (CollectionUtil.isEmpty(selectedStates)) {
            selectedStates = new ArrayList<String>();
        }
        excludeStates.addAll(selectedStates);
        List stateDicVoList = this.dictBoService.getDicValue("leads_state", keyword, excludeStates);
        if (ToolUtil.isNotEmpty((Object)stateDicVoList)) {
            for (DicVo dicVo : stateDicVoList) {
                AssociativeQueryVo stateAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, dicVo.getLabel(), dicVo.getValue());
                associativeQueryVoList.add(stateAssociative);
                selectedStates.add(dicVo.getValue());
            }
        }
        return selectedStates;
    }

    @Override
    public List<String> getCompetitorAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCompetitors, List<String> excludeCompetitorIds, AssociativeLabelVo associateLabelVoByEnum) {
        List competitorList;
        ArrayList<String> competitors = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(excludeCompetitorIds)) {
            competitors.addAll(excludeCompetitorIds);
        }
        if (CollectionUtil.isEmpty(selectedCompetitors)) {
            selectedCompetitors = new ArrayList<String>();
        }
        competitors.addAll(selectedCompetitors);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Competitor::getDelFlag, (Object)"0");
        if (HussarUtils.isNotEmpty((Object)keyword)) {
            queryWrapper.like(Competitor::getCompetitorName, (Object)keyword);
        }
        if (CollectionUtil.isNotEmpty(competitors)) {
            queryWrapper.notIn(Competitor::getCompetitorId, competitors);
        }
        if (ToolUtil.isNotEmpty((Object)(competitorList = this.competitorService.list((Wrapper)queryWrapper)))) {
            for (Competitor competitor : competitorList) {
                AssociativeQueryVo associativeQueryVo = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVoByEnum, competitor.getCompetitorName(), String.valueOf(competitor.getCompetitorId()));
                associativeQueryVoList.add(associativeQueryVo);
                selectedCompetitors.add(String.valueOf(competitor.getCompetitorId()));
            }
        }
        return selectedCompetitors;
    }

    @Override
    public List<String> getModelNameAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedModelNames, String modelName, AssociativeLabelVo associateLabelVo) {
        List<Leads> leadsList;
        ArrayList<String> modelNamesList = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedModelNames)) {
            selectedModelNames = new ArrayList<String>();
            modelNamesList.addAll(selectedModelNames);
        }
        if (StringUtils.isNotBlank((CharSequence)modelName)) {
            modelNamesList.add(modelName);
        }
        if (ToolUtil.isNotEmpty(leadsList = this.commonService.getLeadsByModelName(keyword, modelNamesList))) {
            for (Leads one : leadsList) {
                AssociativeQueryVo modelNameAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVo, one.getModelName(), String.valueOf(one.getLeadsId()));
                associativeQueryVoList.add(modelNameAssociative);
                selectedModelNames.add(one.getModelName());
            }
        }
        return selectedModelNames;
    }
}

