/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.yyzc.client;

import com.jxdinfo.crm.core.yyzc.client.conf.OsApiConf;
import com.jxdinfo.crm.core.yyzc.client.request.OsApiRequest;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.os.sdk.DefaultOsClient;
import com.jxdinfo.os.sdk.common.utils.OsJwtUtil;
import com.jxdinfo.os.sdk.common.utils.StringUtil;
import com.jxdinfo.os.sdk.request.OsRequest;
import com.jxdinfo.os.sdk.request.oauth2.OsAccessTokenRequest;
import com.jxdinfo.os.sdk.response.oauth2.OsAccessTokenResponse;
import com.jxdinfo.os.sdk.response.oauth2.OsResourceResponse;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OsApiClient {
    private static final Logger log = LoggerFactory.getLogger(OsApiClient.class);
    private static DefaultOsClient osClient;
    @Resource
    private OsApiConf osApiConf;
    @Value(value="${spring.profiles.active}")
    private String active;
    @Resource
    private SysUsersMapper sysUsersMapper;
    private String accessToken = "";
    private String apiServerUrl = "";

    public OsApiClient() {
    }

    public OsApiClient(String apiServerUrl, String accessToken) {
        this.accessToken = accessToken;
        this.apiServerUrl = apiServerUrl;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessToken(String account, String password) {
        this.accessToken = this.getAccessToken(account, password);
    }

    public String getApiServerUrl() {
        String serverUrl = this.osApiConf.getOsServerUrl();
        this.apiServerUrl = this.apiServerUrl.length() == 0 ? this.osApiConf.getOsServerUrl() : this.apiServerUrl;
        return this.apiServerUrl;
    }

    public void setApiServerUrl(String apiServerUrl) {
        this.apiServerUrl = apiServerUrl;
    }

    public String getAccessToken() {
        try {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("account", "\u5de5\u4f5c\u53f0");
            user.put("password", "57AD2E4BB784A00543F6E7C757A07CF2");
            if (StringUtil.isEmpty((String)this.accessToken)) {
                this.setAccessToken((String)user.get("account"), (String)user.get("password"));
            } else if (OsJwtUtil.parseToken((String)this.accessToken).size() == 0) {
                this.setAccessToken((String)user.get("account"), (String)user.get("password"));
            }
        }
        catch (Exception e) {
            log.error("\u5f53\u524d\u64cd\u4f5c\u65e0\u7528\u6237\u72b6\u6001...");
        }
        return this.accessToken;
    }

    public String getAccessToken(String account, String password) {
        String serverUrl = this.osApiConf.getOauthServerUrl();
        osClient = new DefaultOsClient(serverUrl);
        OsAccessTokenRequest request = new OsAccessTokenRequest();
        password = "dev".equals(this.active) ? "57AD2E4BB784A00543F6E7C757A07CF2" : password;
        request.setUserSecret(password);
        request.setUsername(account);
        try {
            OsAccessTokenResponse rep = (OsAccessTokenResponse)osClient.execute((OsRequest)request);
            this.accessToken = rep.getAccessToken();
        }
        catch (Exception e) {
            log.error("\u6388\u6743\u670d\u52a1: \u672a\u627e\u5230\u4e0e{}\u76f8\u5173\u7684\u7528\u6237\u4fe1\u606f\uff0c\u6388\u6743\u5931\u8d25", (Object)account);
        }
        return this.accessToken;
    }

    public OsResourceResponse execute(OsApiRequest request) throws Exception {
        OsResourceResponse rep = new OsResourceResponse();
        try {
            this.apiServerUrl = this.getApiServerUrl();
            this.accessToken = this.getAccessToken();
            osClient = new DefaultOsClient(this.apiServerUrl, this.accessToken);
            rep = (OsResourceResponse)osClient.execute((OsRequest)request);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                System.out.printf("\u001b[34m%s/%s%s: {code: %s, msg: %s}\u001b[0m%n", this.getApiServerUrl(), this.formatStr(request.getOsApiRequestMapping()), this.formatStr(request.getOsApiService()), rep.getCode(), rep.getMsg());
                throw throwable;
            }
        }
        System.out.printf("\u001b[34m%s/%s%s: {code: %s, msg: %s}\u001b[0m%n", this.getApiServerUrl(), this.formatStr(request.getOsApiRequestMapping()), this.formatStr(request.getOsApiService()), rep.getCode(), rep.getMsg());
        return rep;
    }

    private String formatStr(String str) {
        if (StringUtil.isEmpty((String)str)) {
            str = "";
        }
        return str;
    }
}

