/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.marketingactivity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.marketingactivity.dao.MarketingActivityMapper;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityAssociativeQueryDto;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityDto;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.IMarketingActivityAssociativeQueryService;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.marketingactivity.vo.MarketingActivityEntityVo;
import com.jxdinfo.crm.core.marketingactivity.vo.OpportunityCampaignVo;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.DictUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MarketingActivityServiceImpl
extends ServiceImpl<MarketingActivityMapper, MarketingActivityEntity>
implements MarketingActivityService {
    @Resource
    private MarketingActivityMapper marketingActivityMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private BaseArea1Service area1Service;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private LeadsService leadsService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private IMarketingActivityAssociativeQueryService marketingActivityAssociativeQueryService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ProductService productService;
    @Resource
    private ISysStruService sysStruService;

    @Override
    public Page<MarketingActivityEntity> selectCrmCampaignList(MarketingActivityDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getMarketView())) {
            dto.setMarketView("0");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if ("1".equals(dto.getMarketView())) {
            IndexUtil.currentUserRolePermissionsNew(permissionDto, this.crmProperties, "selectCrmCampaignList", user.getUserId(), user.getDeptId(), user.getRolesList());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getMarketScreening())) {
            dto.setMarketScreening(dto.getMarketScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        Page page = dto.getPage();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String marketView = dto.getMarketView();
        if ("2".equals(marketView)) {
            dto.setChargePersonId(userId);
        }
        if ("3".equals(marketView)) {
            dto.setUserId(userId);
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String id : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(id));
            }
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                odpIds.addAll(idsTemp);
            }
        }
        dto.setDelFlag("0");
        List<String> states = dto.getStates();
        List<String> campaignTypes = dto.getCampaignTypes();
        if (ToolUtil.isNotEmpty((Object)dto.getBeginActivityFlag()) && !dto.getBeginActivityFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getBeginActivityFlag())))) {
            dto.setBeginActivityStart(dateConvertVo.getStartDate());
            dto.setBeginActivityEnd(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getFinishActivityFlag()) && !dto.getFinishActivityFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getFinishActivityFlag())))) {
            dto.setFinishActivityStart(dateConvertVo.getStartDate());
            dto.setFinishActivityEnd(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !dto.getCreateTimeFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag())))) {
            dto.setCreateStartDate(dateConvertVo.getStartDate());
            dto.setCreateEndDate(dateConvertVo.getEndDate());
        }
        List<MarketingActivityEntity> list = this.marketingActivityMapper.selectCrmCampaignList(dto, page, userIds, odpIds, states, campaignTypes, permissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(MarketingActivityAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getMarketScreening();
        }
        IMarketingActivityAssociativeQueryService adapterService = this.marketingActivityAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_6Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    @Transactional
    public Long insertMarketingActivity(MarketingActivityEntity dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (dto.getCampaignId() == null) {
            dto.setCampaignId(Long.valueOf(CommonUtills.generateAssignId()));
            dto.setDelFlag("0");
            dto.setCreatePerson(String.valueOf(user.getUserId()));
            dto.setCreatePersonName(user.getUserName());
            dto.setCreateTime(date);
            dto.setChargePersonId(user.getUserId());
            dto.setChargePersonName(user.getUserName());
            dto.setOwnDepartment(user.getDeptId());
            dto.setOwnDepartmentName(user.getDeptName());
            dto.setCreateDepartment(user.getDeptId());
            dto.setCreateDepartmentName(user.getDeptName());
            dto.setChangePerson(user.getUserId());
            dto.setChangePersonName(user.getUserName());
            dto.setChangeTime(date);
        }
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)dto.getProvince())) {
            dto.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCity())) {
            dto.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCounty())) {
            dto.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        dto.setRegionLabel(sb.toString());
        this.save(dto);
        Long campaignId = dto.getCampaignId();
        this.teamMeberService.insertTeamMember(dto.getChargePersonName(), dto.getChargePersonId(), campaignId, "1", "1", date, "5");
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CAMPAIGN, campaignId, dto.getCampaignName(), date, false, Arrays.asList(campaignId));
        return campaignId;
    }

    @Override
    public MarketingActivityEntityVo getContactDetailById(Long campaignId) {
        int i;
        StringBuilder sb;
        MarketingActivityEntity entity = (MarketingActivityEntity)this.getById(campaignId);
        if (entity == null) {
            return null;
        }
        if (HussarUtils.isNotEmpty((Object)entity.getProductsOnDisplay())) {
            List productIds = Arrays.stream(entity.getProductsOnDisplay().split(",")).map(Long::parseLong).collect(Collectors.toList());
            Map<Long, String> productNameMap = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0")).in(Product::getProductId, productIds)).stream().collect(Collectors.toMap(Product::getProductId, Product::getProductName));
            sb = new StringBuilder();
            for (i = 0; i < productIds.size(); ++i) {
                sb.append(productNameMap.get(productIds.get(i)));
                if (i == productIds.size() - 1) continue;
                sb.append("\uff0c");
            }
            entity.setProductsOnDisplay(sb.toString());
        }
        if (HussarUtils.isNotEmpty((Object)entity.getDeptApplication())) {
            List deptIds = Arrays.stream(entity.getDeptApplication().split(",")).map(Long::parseLong).collect(Collectors.toList());
            Map<Long, String> deptNameMap = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarDelflagEntity::getDelFlag, (Object)"0")).in(SysStru::getId, deptIds)).stream().collect(Collectors.toMap(SysStru::getId, SysStru::getOrganAlias));
            sb = new StringBuilder();
            for (i = 0; i < deptIds.size(); ++i) {
                sb.append(deptNameMap.get(deptIds.get(i)));
                if (i == deptIds.size() - 1) continue;
                sb.append("\uff0c");
            }
            entity.setDeptApplication(sb.toString());
        }
        if (HussarUtils.isNotEmpty((Object)entity.getParticipationFormat())) {
            List pids = Arrays.stream(entity.getParticipationFormat().split(",")).collect(Collectors.toList());
            Map<String, String> participationFormatMap = this.sysDicRefService.getDictByType("participation_format").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            sb = new StringBuilder();
            for (i = 0; i < pids.size(); ++i) {
                sb.append(participationFormatMap.get(pids.get(i)));
                if (i == pids.size() - 1) continue;
                sb.append("\uff0c");
            }
            entity.setParticipationFormat(sb.toString());
        }
        MarketingActivityEntityVo entityVo = (MarketingActivityEntityVo)BeanUtil.copy((Object)entity, MarketingActivityEntityVo.class);
        assert (entityVo != null);
        this.setMarketDic(entityVo);
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(String.valueOf(entityVo.getCampaignId())), null, null, "0");
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(entityVo.getCampaignId());
        if (CollectionUtil.isNotEmpty((Collection)recordList)) {
            for (TrackRecordAPIVo record : recordList) {
                businessIds.add(record.getRecordId());
            }
        }
        entityVo.setFileCount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        entityVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)entityVo.getCampaignId())).eq(TeamMeberEntity::getBusinessType, (Object)"5")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        MarketingActivityEntityVo entityVo2 = this.markActivityEffect(String.valueOf(campaignId));
        entityVo.setLeadsNumber(entityVo2.getLeadsNumber());
        entityVo.setOpportunityNumber(entityVo2.getOpportunityNumber());
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        CustomerDto customerDto = new CustomerDto();
        customerDto.setCampaignId(campaignId.toString());
        customerDto.setDelFlag("0");
        Page<CustomerEntity> page = this.customerService.selectCustomerListNoPermission(customerDto);
        entityVo.setCustomerNumber(page.getTotal());
        entityVo.setAmount(entityVo2.getAmount());
        entityVo.setWinQuantity(entityVo2.getWinQuantity());
        entityVo.setWinAmount(entityVo2.getWinAmount());
        entityVo.setTaskAmount(this.taskAPIService.selectTaskCount(CrmBusinessTypeEnum.CAMPAIGN.getId(), campaignId));
        return entityVo;
    }

    private void setMarketDic(MarketingActivityEntityVo entityVo) {
        if (StringUtil.isNotBlank((CharSequence)entityVo.getState())) {
            entityVo.setState(this.sysDicRefService.getDictLabel("active_state", entityVo.getState()));
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getCampaignType())) {
            entityVo.setCampaignType(this.sysDicRefService.getDictLabel("active_type", entityVo.getCampaignType()));
        }
    }

    @Override
    public String deleteCrmCampaignByCampaignIds(List<String> campaignIds) {
        int flag = 0;
        for (String campaignId : campaignIds) {
            Long opportunityCount = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getCampaignId, (Object)campaignId)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
            Long leadCount = this.leadsService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Leads::getCampaignId, (Object)campaignId)).eq(Leads::getDelFlag, (Object)"0"));
            flag = (int)((long)flag + opportunityCount);
            flag = (int)((long)flag + leadCount);
        }
        if (flag > 0) {
            return "0";
        }
        Integer num = this.marketingActivityMapper.deleteCrmCampaignByCampaignIds(campaignIds, "1");
        return "1";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer marketActivityTransfer(List<MarketingActivityDto> dtos) {
        int nums = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        for (MarketingActivityDto dto : dtos) {
            String keepFlag = dto.getKeepFlag();
            SecurityUser user = BaseSecurityUtil.getUser();
            String userId = user.getId().toString();
            String userName = user.getUserName();
            LocalDateTime date = LocalDateTime.now();
            String oldChargePersonName = dto.getOldChargePersonName();
            String oldChargePersonId = dto.getOldChargePersonId();
            String newChargePersonId = CommonUtills.translateUserId(dto.getNewChargePersonId());
            dto.setNewChargePersonId(newChargePersonId);
            String newChargePersonName = dto.getNewChargePersonName();
            String campaignName = dto.getCampaignName();
            PersonWithDepInfo personWithDepInfo = CommonUtills.selectDepIdName(newChargePersonId);
            Long newOwnDepartment = personWithDepInfo.getDepartmentId();
            String newOwnDepartmentName = personWithDepInfo.getDepartmentName();
            Long campaignId = dto.getCampaignId();
            if (newChargePersonId.equals(oldChargePersonId) && newChargePersonName.equals(oldChargePersonName) && dtos.size() == 1) {
                throw new BaseException("\u5df2\u7ecf\u662f\u8d1f\u8d23\u4eba");
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            Integer num = this.marketingActivityMapper.updateChargePersonName(dto);
            nums += num.intValue();
            if ("0".equals(keepFlag)) {
                this.teamMeberMapper.deleteChargePerson(oldChargePersonId, campaignId, "1");
            } else if ("1".equals(keepFlag)) {
                this.teamMeberMapper.updateIsCharge(oldChargePersonId, campaignId, "0", "6", null);
            }
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(campaignId);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            List<TeamMeberEntity> list = this.teamMeberMapper.selectTeamMeberList(null, teamMeberDto);
            if (list.size() == 0) {
                this.teamMeberService.insertTeamMember(newChargePersonName, Long.parseLong(newChargePersonId), campaignId, "1", "1", date, "5");
            } else {
                this.teamMeberMapper.updateIsCharge(newChargePersonId, campaignId, "1", null, "1");
            }
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.CAMPAIGN, campaignId, campaignName, date, false, Arrays.asList(campaignId));
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("5");
            crmTeamAdminInfoDto.setBusinessId(campaignId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return nums;
    }

    @Override
    public MarketingActivityEntityVo markActivityEffect(String campaignId) {
        MarketingActivityEntityVo entityVo = new MarketingActivityEntityVo();
        double amount = 0.0;
        double winAmount = 0.0;
        double loseAmount = 0.0;
        entityVo.setLeadsNumber(this.leadsService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Leads::getDelFlag, (Object)"0")).eq(Leads::getCampaignId, (Object)campaignId)));
        entityVo.setCustomerNumber(this.customerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).eq(CustomerEntity::getCampaignId, (Object)campaignId)));
        List opportunityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)"0")).eq(OpportunityEntity::getCampaignId, (Object)campaignId)).eq(OpportunityEntity::getProcessState, (Object)"1"));
        int winQuantity = 0;
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageWin = stageSelectDto.getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        for (OpportunityEntity opportunity : opportunityList) {
            if (opportunity.getOpportunityAmount() == null) continue;
            Double opAmount = Double.parseDouble(opportunity.getOpportunityAmount());
            amount += opAmount.doubleValue();
            if (!stageWin.contains(opportunity.getCustomerStageId())) continue;
            winAmount += opAmount.doubleValue();
            ++winQuantity;
        }
        entityVo.setOpportunityNumber(opportunityList.size());
        entityVo.setAmount(amount);
        entityVo.setWinQuantity(winQuantity);
        entityVo.setWinAmount(winAmount);
        return entityVo;
    }

    @Override
    public Integer isOperate(Long campaignId) {
        Long parentId;
        List<String> deptIds;
        List<Map<String, Long>> struList;
        if (campaignId == null) {
            return CommonConstant.noPermission;
        }
        MarketingActivityEntity marketingActivity = (MarketingActivityEntity)this.getById(campaignId);
        if (marketingActivity == null) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds2 = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(marketingActivity.getOwnDepartment() == null ? "" : marketingActivity.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()))) && deptIds.contains(marketingActivity.getOwnDepartment() == null ? "" : marketingActivity.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(marketingActivity.getOwnDepartment() == null ? "" : marketingActivity.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(marketingActivity.getOwnDepartment() == null ? "" : marketingActivity.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(marketingActivity.getChargePersonId() == null ? "" : marketingActivity.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)marketingActivity.getCampaignId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"5"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        return CommonConstant.readOnly;
    }

    @Override
    public List<MarketingActivityEntity> selectAllCampaignByCustomerId(Long customerId) {
        return this.marketingActivityMapper.selectAllCampaignByCustomerId(customerId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String marketActivityExport(HttpServletResponse response, MarketingActivityDto dto) {
        DateConvertVo dateConvertVo;
        LocalDate date = LocalDate.now();
        if (StringUtil.isEmpty((Object)dto.getMarketView())) {
            dto.setMarketView("0");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if ("1".equals(dto.getMarketView())) {
            IndexUtil.currentUserRolePermissionsNew(permissionDto, this.crmProperties, "selectCrmCampaignList", user.getUserId(), user.getDeptId(), user.getRolesList());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getMarketScreening())) {
            dto.setMarketScreening(dto.getMarketScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String userId = user.getId().toString();
        String marketView = dto.getMarketView();
        if ("2".equals(marketView)) {
            dto.setChargePersonId(userId);
        }
        if ("3".equals(marketView)) {
            dto.setUserId(userId);
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String id : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(id));
            }
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                odpIds.addAll(idsTemp);
            }
        }
        dto.setDelFlag("0");
        List<String> states = dto.getStates();
        List<String> campaignTypes = dto.getCampaignTypes();
        if (ToolUtil.isNotEmpty((Object)dto.getBeginActivityFlag()) && !dto.getBeginActivityFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getBeginActivityFlag())))) {
            dto.setBeginActivityStart(dateConvertVo.getStartDate());
            dto.setBeginActivityEnd(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getFinishActivityFlag()) && !dto.getFinishActivityFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getFinishActivityFlag())))) {
            dto.setFinishActivityStart(dateConvertVo.getStartDate());
            dto.setFinishActivityEnd(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !dto.getCreateTimeFlag().equals("6") && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag())))) {
            dto.setCreateStartDate(dateConvertVo.getStartDate());
            dto.setCreateEndDate(dateConvertVo.getEndDate());
        }
        List<MarketingActivityEntity> list = this.marketingActivityMapper.selectCrmCampaignList(dto, null, userIds, odpIds, states, campaignTypes, permissionDto);
        List<Long> campaignIdList = list.stream().map(MarketingActivityEntity::getCampaignId).collect(Collectors.toList());
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("campaign_export_stage");
        String[] stageValues = configVo.getConfigValue().split(",");
        ArrayList<String> stageNames = new ArrayList<String>();
        Map<String, String> dicMap = this.sysDicRefService.getDictByType("salesProcess_StageList").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        for (String stage : stageValues) {
            stageNames.add(dicMap.get(stage));
        }
        ServletOutputStream out = null;
        try {
            int j;
            int i;
            void var38_50;
            out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode("\u5e02\u573a\u6d3b\u52a8.xlsx", "UTF-8"));
            List<OpportunityCampaignVo> exportVoList = this.marketingActivityMapper.selectOpportunityInfoByCampaignId(campaignIdList);
            List<Map<String, Long>> customerCountList = this.marketingActivityMapper.selectCampaignCustomerNum(campaignIdList);
            Map<Long, String> productNameMap = this.productService.list((Wrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0")).stream().collect(Collectors.toMap(Product::getProductId, Product::getProductName));
            Map<Long, String> deptNameMap = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().eq(HussarDelflagEntity::getDelFlag, (Object)"0")).stream().collect(Collectors.toMap(SysStru::getId, SysStru::getOrganAlias));
            Map<String, String> participationFormatMap = this.sysDicRefService.getDictByType("participation_format").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            list.forEach(m -> {
                int i;
                StringBuilder sb;
                if (HussarUtils.isNotEmpty((Object)m.getProductsOnDisplay())) {
                    List productIds = Arrays.stream(m.getProductsOnDisplay().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    sb = new StringBuilder();
                    for (i = 0; i < productIds.size(); ++i) {
                        sb.append((String)productNameMap.get(productIds.get(i)));
                        if (i == productIds.size() - 1) continue;
                        sb.append(",");
                    }
                    m.setProductsOnDisplay(sb.toString());
                }
                if (HussarUtils.isNotEmpty((Object)m.getDeptApplication())) {
                    List deptIds = Arrays.stream(m.getDeptApplication().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    sb = new StringBuilder();
                    for (i = 0; i < deptIds.size(); ++i) {
                        sb.append((String)deptNameMap.get(deptIds.get(i)));
                        if (i == deptIds.size() - 1) continue;
                        sb.append(",");
                    }
                    m.setDeptApplication(sb.toString());
                }
                if (HussarUtils.isNotEmpty((Object)m.getParticipationFormat())) {
                    List pids = Arrays.stream(m.getParticipationFormat().split(",")).collect(Collectors.toList());
                    sb = new StringBuilder();
                    for (i = 0; i < pids.size(); ++i) {
                        sb.append((String)participationFormatMap.get(pids.get(i)));
                        if (i == pids.size() - 1) continue;
                        sb.append(",");
                    }
                    m.setParticipationFormat(sb.toString());
                }
            });
            Map<Long, Map> campaignCountMap = customerCountList.stream().collect(Collectors.toMap(m -> (Long)m.get("CAMPAIGN_ID"), m -> m));
            Map<Long, List<OpportunityCampaignVo>> exportMap = exportVoList.stream().collect(Collectors.groupingBy(OpportunityCampaignVo::getCampaignId));
            HashMap<String, Long> stageCountMap = new HashMap<String, Long>();
            HashMap<String, Double> stageAmountMap = new HashMap<String, Double>();
            for (String stageNameValue : stageValues) {
                for (Map.Entry<Long, List<OpportunityCampaignVo>> entry : exportMap.entrySet()) {
                    Long count = 0L;
                    Double amount = 0.0;
                    for (OpportunityCampaignVo opportunityCampaignVo : entry.getValue()) {
                        if (!stageNameValue.equals(opportunityCampaignVo.getStageNameValue())) continue;
                        Long l = count;
                        Long l2 = count = Long.valueOf(count + 1L);
                        if (opportunityCampaignVo.getOpportunityAmount() == null) continue;
                        amount = amount + opportunityCampaignVo.getOpportunityAmount();
                    }
                    stageCountMap.put(stageNameValue + entry.getKey(), count);
                    stageAmountMap.put(stageNameValue + entry.getKey(), amount);
                }
            }
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("\u5e02\u573a\u6d3b\u52a8");
            XSSFCellStyle style = MarketingActivityServiceImpl.createCellStyle(wb);
            int rowNum = 0;
            XSSFRow row0 = sheet.createRow(rowNum++);
            row0.setHeight((short)600);
            int stageNum = stageValues.length;
            int stageColNum = stageNum * 2;
            ArrayList<String> header1 = new ArrayList<String>(Arrays.asList("\u5e8f\u53f7", "\u6d3b\u52a8\u540d\u79f0", "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", "\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", "\u7533\u8bf7\u90e8\u95e8", "\u5c55\u51fa\u4ea7\u54c1", "\u53c2\u4f1a\u5f62\u5f0f", "\u8d39\u7528/\u5143", "\u5b9e\u9645\u603b\u652f\u51fa/\u5143", "\u6d3b\u52a8\u76ee\u6807", "\u5546\u673a\u6570", "\u5ba2\u6237\u6570"));
            int stageStartCol = header1.size();
            for (String stageName : stageNames) {
                header1.add(stageName);
                header1.add("");
            }
            header1.addAll(Arrays.asList("\u5546\u673a\u8ddf\u8fdb\u901f\u5ea6", "\u5546\u673a\u8ddf\u8fdb\u9891\u7387", "\u4f1a\u8bae\u7ed3\u675f4\u5468\u672a\u8ddf\u8fdb\u5546\u673a\u6570", "\u4e3b\u529e\u65b9"));
            boolean bl = false;
            while (var38_50 < header1.size()) {
                XSSFCell c00 = row0.createCell((int)var38_50);
                c00.setCellValue((String)header1.get((int)var38_50));
                c00.setCellStyle((CellStyle)style);
                ++var38_50;
            }
            XSSFRow xSSFRow = sheet.createRow(rowNum++);
            xSSFRow.setHeight((short)700);
            ArrayList<String> header2 = new ArrayList<String>(Arrays.asList("", "", "", "", "", "", "", "", "", "", "", ""));
            for (i = 0; i < stageNum; ++i) {
                header2.add("\u5546\u673a\u6570");
                header2.add("\u5546\u673a\u91d1\u989d/\u4e07\u5143");
            }
            header2.addAll(Arrays.asList("", "", "", ""));
            for (i = 0; i < header2.size(); ++i) {
                XSSFCell tempCell = xSSFRow.createCell(i);
                tempCell.setCellValue((String)header2.get(i));
                tempCell.setCellStyle((CellStyle)style);
            }
            for (i = 0; i < stageStartCol; ++i) {
                sheet.addMergedRegion(new CellRangeAddress(0, 1, i, i));
            }
            for (i = stageStartCol; i < stageStartCol + stageColNum; i += 2) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, i, i + 1));
            }
            for (i = stageStartCol + stageColNum; i < header1.size(); ++i) {
                sheet.addMergedRegion(new CellRangeAddress(0, 1, i, i));
            }
            for (i = 0; i < header1.size(); ++i) {
                int maxColumnWidth = 2560;
                for (j = 0; j <= sheet.getLastRowNum(); ++j) {
                    int cellWidth;
                    XSSFCell cell;
                    XSSFRow row = sheet.getRow(j);
                    if (row == null || (cell = row.getCell(i)) == null || (cellWidth = cell.toString().getBytes("GBK").length * 256) <= maxColumnWidth) continue;
                    maxColumnWidth = cellWidth;
                }
                sheet.setColumnWidth(i, maxColumnWidth);
            }
            for (i = 0; i < list.size(); ++i) {
                XSSFRow tempRow = sheet.createRow(rowNum++);
                tempRow.setHeight((short)500);
                for (j = 0; j < header1.size(); ++j) {
                    XSSFCell tempCell = tempRow.createCell(j);
                    tempCell.setCellStyle((CellStyle)style);
                    String tempValue = "";
                    switch (j) {
                        case 0: {
                            tempValue = String.valueOf(i + 1);
                            break;
                        }
                        case 1: {
                            tempValue = list.get(i).getCampaignName();
                            break;
                        }
                        case 2: {
                            tempValue = list.get(i).getStartDate();
                            break;
                        }
                        case 3: {
                            tempValue = list.get(i).getEndDate();
                            break;
                        }
                        case 4: {
                            tempValue = list.get(i).getDeptApplication();
                            break;
                        }
                        case 5: {
                            tempValue = list.get(i).getProductsOnDisplay();
                            break;
                        }
                        case 6: {
                            tempValue = list.get(i).getParticipationFormat();
                            break;
                        }
                        case 7: {
                            tempValue = list.get(i).getConferenceExpenses();
                            break;
                        }
                        case 8: {
                            tempValue = list.get(i).getActualCost();
                            break;
                        }
                        case 9: {
                            tempValue = list.get(i).getRemark();
                            break;
                        }
                        case 10: {
                            tempValue = String.valueOf(campaignCountMap.get(list.get(i).getCampaignId()).get("OPPORTUNITY_COUNT"));
                            break;
                        }
                        case 11: {
                            tempValue = String.valueOf(campaignCountMap.get(list.get(i).getCampaignId()).get("CUSTOMER_COUNT"));
                        }
                    }
                    if (stageStartCol <= j && j < stageStartCol + stageColNum) {
                        Double amount;
                        Long temp;
                        tempValue = (j - stageStartCol) % 2 == 0 ? ((temp = (Long)stageCountMap.get(stageValues[(j - stageStartCol) / 2] + list.get(i).getCampaignId())) != null ? String.valueOf(temp) : "0") : ((amount = (Double)stageAmountMap.get(stageValues[(j - stageStartCol) / 2] + list.get(i).getCampaignId())) != null ? String.format("%.2f", amount / 10000.0) : "0.00");
                    }
                    if (j >= stageStartCol + stageColNum) {
                        List<OpportunityCampaignVo> tempList = exportMap.get(list.get(i).getCampaignId());
                        if (j == stageStartCol + stageColNum) {
                            Double s = 0.0;
                            int count = 0;
                            if (tempList != null) {
                                for (OpportunityCampaignVo vo : tempList) {
                                    if (vo.getFirstDayFollow() == null) continue;
                                    ++count;
                                    s = s + (double)(vo.getFirstDayFollow().toEpochDay() - vo.getCreateTime().toEpochDay());
                                }
                            }
                            tempValue = count > 0 ? String.format("%.2f", s / (double)count) : "";
                        } else if (j == stageStartCol + stageColNum + 1) {
                            Double frequency = 0.0;
                            if (tempList != null) {
                                int num = 0;
                                for (OpportunityCampaignVo vo : tempList) {
                                    if (vo.getCountRecord() == null) continue;
                                    Double countTemp = (double)vo.getCountRecord();
                                    frequency = frequency + countTemp / (double)vo.getMonths().intValue();
                                    ++num;
                                }
                                if (num > 0) {
                                    tempValue = String.format("%.2f", frequency / (double)num);
                                }
                            } else {
                                tempValue = "";
                            }
                        } else if (j == stageStartCol + stageColNum + 2) {
                            int count = 0;
                            if (tempList != null) {
                                for (OpportunityCampaignVo vo : tempList) {
                                    long dayPass = 0L;
                                    dayPass = vo.getFirstDayFollow() == null ? date.toEpochDay() - vo.getEndDate().toEpochDay() : vo.getFirstDayFollow().toEpochDay() - vo.getEndDate().toEpochDay();
                                    if (dayPass <= 28L) continue;
                                    ++count;
                                }
                            }
                            tempValue = String.valueOf(count);
                        } else if (j == stageStartCol + stageColNum + 3) {
                            tempValue = list.get(i).getSponsor();
                        }
                    }
                    if (tempValue == null) {
                        tempValue = "";
                    }
                    tempCell.setCellValue(tempValue);
                }
            }
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            return "\u5bfc\u51fa\u6210\u529f";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static XSSFCellStyle createCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        XSSFCellStyle style = wb.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor((short)0);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor((short)0);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor((short)0);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor((short)0);
        style.setFont((Font)font);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    @Override
    public String marketActivityExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u5e02\u573a\u6d3b\u52a8\u6a21\u677f", MarketingActivityEntity.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public String marketActivityImport(MultipartFile file) {
        boolean flag = false;
        ReadExcel readExcel = new ReadExcel();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        try {
            List<MarketingActivityEntity> list = ReadExcel.readExcel(file, MarketingActivityEntity.class);
            if (list.size() == 0) {
                return "\u672a\u83b7\u53d6\u5230\u8981\u5bfc\u5165\u7684\u6570\u636e";
            }
            List stateDictSingleList = this.sysDicRefService.getDictByType("active_state");
            List campaignTypeDictSingleList = this.sysDicRefService.getDictByType("active_type");
            List sysUserList = this.sysUsersService.list();
            for (MarketingActivityEntity marketingActivityEntity : list) {
                List sysUsersList1;
                String chargePersonName;
                if (!StringUtils.isEmpty((Object)marketingActivityEntity.getState())) {
                    marketingActivityEntity.setState(DictUtil.getInstance().getDictValue(stateDictSingleList, marketingActivityEntity.getState()));
                }
                if (!StringUtils.isEmpty((Object)marketingActivityEntity.getCampaignType())) {
                    marketingActivityEntity.setCampaignType(DictUtil.getInstance().getDictValue(campaignTypeDictSingleList, marketingActivityEntity.getCampaignType()));
                }
                if (!StringUtils.isEmpty((Object)(chargePersonName = marketingActivityEntity.getChargePersonName())) && (sysUsersList1 = sysUserList.stream().filter(sysUser -> chargePersonName.equals(sysUser.getUserName())).collect(Collectors.toList())).size() > 0) {
                    marketingActivityEntity.setChargePersonId(((SysUsers)sysUsersList1.get(0)).getEmployeeId());
                }
                marketingActivityEntity.setDelFlag("0");
                marketingActivityEntity.setCreatePerson(userId);
                marketingActivityEntity.setCreatePersonName(userName);
                marketingActivityEntity.setCreateTime(date);
                marketingActivityEntity.setOwnDepartment(null);
                marketingActivityEntity.setOwnDepartmentName(null);
            }
            if (!this.saveBatch(list, 500)) {
                return "\u5bfc\u5165\u5931\u8d25";
            }
            return "\u5bfc\u5165\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u5bfc\u5165\u5931\u8d25";
        }
    }

    @Override
    public List<MarketingActivityAPIVo> getMarketingActivityList(String activityName, List<Long> excludeIds) {
        return this.marketingActivityMapper.getMarketingActivityList(activityName, excludeIds);
    }
}

