/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.marketingactivity.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityAssociativeQueryDto;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityDto;
import com.jxdinfo.crm.core.marketingactivity.service.IMarketingActivityAssociativeQueryService;
import com.jxdinfo.crm.core.marketingactivity.vo.MarketingActivityAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MarketingActivityAssociativeQueryServiceImpl
implements IMarketingActivityAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryService;
    @Resource
    private CommonService commonService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        MarketingActivityAssociativeQueryDto marketingActivityAssociativeQueryDto = null;
        if (associativeQueryDto instanceof MarketingActivityAssociativeQueryDto) {
            marketingActivityAssociativeQueryDto = (MarketingActivityAssociativeQueryDto)associativeQueryDto;
        }
        assert (marketingActivityAssociativeQueryDto != null);
        MarketingActivityDto marketingActivityDto = marketingActivityAssociativeQueryDto.getDto();
        List<String> statesList = null;
        List<String> campaignTypeList = null;
        String beginActivityFlag = null;
        String finishActivityFlag = null;
        List<String> chargePersonIdList = null;
        List<String> ownDepartmentList = null;
        String createTimeFlag = null;
        if (marketingActivityDto != null) {
            statesList = marketingActivityDto.getStates();
            campaignTypeList = marketingActivityDto.getCampaignTypes();
            beginActivityFlag = marketingActivityDto.getBeginActivityFlag();
            finishActivityFlag = marketingActivityDto.getFinishActivityFlag();
            chargePersonIdList = marketingActivityDto.getChargePersonIds();
            ownDepartmentList = marketingActivityDto.getOwnDepartments();
            createTimeFlag = marketingActivityDto.getCreateTimeFlag();
        }
        List selectedStates = excludeInfoMap.get("selectedStates");
        selectedStates = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedStates, statesList, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_STATES));
        excludeInfoMap.put("selectedStates", selectedStates);
        List selectedCampaignTypeS = excludeInfoMap.get("selectedCampaignTypeS");
        selectedCampaignTypeS = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCampaignTypeS, campaignTypeList, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_TYPES));
        excludeInfoMap.put("selectedCampaignTypeS", selectedCampaignTypeS);
        List selectedBeginFlags = excludeInfoMap.get("selectedBeginFlags");
        selectedBeginFlags = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedBeginFlags, beginActivityFlag, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_START_TIME));
        excludeInfoMap.put("selectedBeginFlags", selectedBeginFlags);
        List selectedFinishFlags = excludeInfoMap.get("selectedFinishFlags");
        selectedFinishFlags = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedFinishFlags, finishActivityFlag, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_FINISH_TIME));
        excludeInfoMap.put("selectedFinishFlags", selectedFinishFlags);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_OWN_DEPARTMENTS));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedCreateFlags = excludeInfoMap.get("selectedCreateFlags");
        selectedCreateFlags = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateFlags, createTimeFlag, this.getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum.MARKETING_ACTIVITY_CREATE_TIME));
        excludeInfoMap.put("selectedCreateFlags", selectedCreateFlags);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(MarketingActivityAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

