/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.marketingactivity.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityAssociativeQueryDto;
import com.jxdinfo.crm.core.marketingactivity.dto.MarketingActivityDto;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.marketingactivity.vo.MarketingActivityEntityVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406"})
@RestController
public class MarketingActivityController {
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private CustomerService customerService;

    @PostMapping(value={"/MarketingActivity/selectCrmCampaignList"})
    @ApiOperation(value="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u5217\u8868", notes="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u5217\u8868")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page> selectCrmCampaignList(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8dto") MarketingActivityDto dto) {
        Page<MarketingActivityEntity> page = this.marketingActivityService.selectCrmCampaignList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/MarketingActivity/selectCustomerListByCampaign"})
    @ApiOperation(value="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u4e0b\u5ba2\u6237\u5217\u8868", notes="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u4e0b\u5ba2\u6237\u5217\u8868")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomerEntity>> selectCustomerListByCampaign(@RequestBody @ApiParam(value="\u5ba2\u6237dto") CustomerDto dto) {
        Page<CustomerEntity> page = this.customerService.selectCustomerListNoPermission(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/MarketingActivity/associativeQuery"})
    @ApiOperation(value="\u5e02\u573a\u6d3b\u52a8\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u5e02\u573a\u6d3b\u52a8\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8dto") MarketingActivityAssociativeQueryDto dto) {
        return ApiResponse.success(this.marketingActivityService.associativeQuery(dto));
    }

    @PostMapping(value={"/MarketingActivity/insertMarketingActivity"})
    @ApiOperation(value="\u5e02\u573a\u6d3b\u52a8\u65b0\u589e", notes="\u5e02\u573a\u6d3b\u52a8\u65b0\u589e")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Long> insertMarketingActivity(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8\u5b9e\u4f53") MarketingActivityEntity dto) {
        return ApiResponse.success((Object)this.marketingActivityService.insertMarketingActivity(dto));
    }

    @GetMapping(value={"/MarketingActivity/getContactDetailById"})
    @ApiOperation(value="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u8be6\u60c5", notes="\u67e5\u8be2\u5e02\u573a\u6d3b\u52a8\u8be6\u60c5")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<MarketingActivityEntityVo> getContactDetailById(@RequestParam @ApiParam(value="\u5e02\u573a\u6d3b\u52a8id") Long campaignId) {
        return ApiResponse.success((Object)this.marketingActivityService.getContactDetailById(campaignId));
    }

    @PostMapping(value={"/MarketingActivity/deleteCrmCampaignByCampaignIds"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e02\u573a\u6d3b\u52a8(\u903b\u8f91\u5220\u9664)", notes="\u6279\u91cf\u5220\u9664\u5e02\u573a\u6d3b\u52a8(\u903b\u8f91\u5220\u9664)")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> deleteCrmCampaignByCampaignIds(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8dto") MarketingActivityDto dto) {
        List<String> campaignIds = dto.getCampaignIds();
        String msg = this.marketingActivityService.deleteCrmCampaignByCampaignIds(campaignIds);
        return ApiResponse.success((String)msg);
    }

    @PostMapping(value={"/MarketingActivity/marketActivityTransfer"})
    @ApiOperation(value="\u5e02\u573a\u6d3b\u52a8\u8f6c\u79fb", notes="\u5e02\u573a\u6d3b\u52a8\u8f6c\u79fb")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Object> marketActivityTransfer(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8dto\u96c6\u5408") List<MarketingActivityDto> dto) {
        Integer num = this.marketingActivityService.marketActivityTransfer(dto);
        if (num > 0) {
            return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u8f6c\u79fb\u5931\u8d25");
    }

    @PostMapping(value={"/MarketingActivity/markActivityEffect"})
    @ApiOperation(value="\u8ba1\u7b97\u6d3b\u52a8\u6210\u6548", notes="\u8ba1\u7b97\u6d3b\u52a8\u6210\u6548")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<MarketingActivityEntityVo> markActivityEffect(@RequestBody @ApiParam(value="\u5e02\u573a\u6d3b\u52a8id") Map<String, String> map) {
        String campaignId = map.get("campaignId");
        return ApiResponse.success((Object)this.marketingActivityService.markActivityEffect(campaignId));
    }

    @PostMapping(value={"/MarketingActivity/export"})
    public String marketingActivityExport(HttpServletResponse response, @RequestBody MarketingActivityDto dto) {
        String msg = this.marketingActivityService.marketActivityExport(response, dto);
        return msg;
    }

    @RequestMapping(value={"/MarketingActivity/exportTemplate"})
    public String marketingActivityExportTemplate(HttpServletResponse response) {
        String msg = this.marketingActivityService.marketActivityExportTemplate(response);
        return msg;
    }

    @PostMapping(value={"/MarketingActivity/import"})
    public ApiResponse<Page> marketingActivityImport(@RequestBody MultipartFile file) {
        String msg = this.marketingActivityService.marketActivityImport(file);
        return ApiResponse.success((String)msg);
    }

    @GetMapping(value={"/MarketingActivity/operate"})
    @ApiOperation(value="\u5224\u65ad\u5e02\u573a\u6d3b\u52a8\u6743\u9650", notes="\u5224\u65ad\u5e02\u573a\u6d3b\u52a8\u6743\u9650")
    @AuditLog(moduleName="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventDesc="\u5e02\u573a\u6d3b\u52a8\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> isOperate(@RequestParam(value="campaignId") Long campaignId) {
        return ApiResponse.success((Object)this.marketingActivityService.isOperate(campaignId));
    }
}

